/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.Instant;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexCommit;
import org.gnit.lucenekmp.index.IndexDeletionPolicy;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfos;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.gnit.lucenekmp.util.FileDeleter;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0007\b\u0000\u0018\u0000 72\u00060\u0001j\u0002`\u0002:\u000267BU\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010!\u001a\u00020\u0012H\u0002J\u0006\u0010\"\u001a\u00020#J\b\u0010%\u001a\u00020#H\u0002J\u0006\u0010&\u001a\u00020#J\b\u0010'\u001a\u00020#H\u0016J\u0014\u0010(\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0006\u0010)\u001a\u00020#J\u0016\u0010*\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0012J\u0018\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0016\u00100\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0012J\u0014\u00100\u001a\u00020#2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000501J\u0014\u00102\u001a\u00020#2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000501J\u000e\u00102\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0005J\u0014\u00105\u001a\u00020#2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000501R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001d\u00a8\u00068"}, d2={"Lorg/gnit/lucenekmp/index/IndexFileDeleter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "files", "", "", "directoryOrig", "Lorg/gnit/lucenekmp/store/Directory;", "directory", "policy", "Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;", "segmentInfos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "writer", "Lorg/gnit/lucenekmp/index/IndexWriter;", "initialIndexExists", "", "isReaderInit", "<init>", "([Ljava/lang/String;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;Lorg/gnit/lucenekmp/index/SegmentInfos;Lorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/index/IndexWriter;ZZ)V", "commits", "", "Lorg/gnit/lucenekmp/index/IndexFileDeleter$CommitPoint;", "lastFiles", "commitsToDelete", "startingCommitDeleted", "getStartingCommitDeleted", "()Z", "lastSegmentInfos", "fileDeleter", "Lorg/gnit/lucenekmp/util/FileDeleter;", "locked", "ensureOpen", "", "isClosed", "deleteCommits", "refresh", "close", "assertCommitsAreNotDeleted", "revisitPolicy", "checkpoint", "isCommit", "logInfo", "msgType", "Lorg/gnit/lucenekmp/util/FileDeleter$MsgType;", "msg", "incRef", "", "decRef", "exists", "fileName", "deleteNewFiles", "CommitPoint", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIndexFileDeleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexFileDeleter.kt\norg/gnit/lucenekmp/index/IndexFileDeleter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,669:1\n1#2:670\n3#3,8:671\n3#3,8:680\n8#3,2:689\n3#3,8:691\n3#3,8:700\n3#3,8:709\n3#3,8:718\n3#3,8:727\n3#3,8:736\n3#3,8:745\n3#3,8:754\n3#3,8:763\n3#3,8:772\n10#4:679\n10#4:688\n10#4:699\n10#4:708\n10#4:717\n10#4:726\n10#4:735\n10#4:744\n10#4:753\n10#4:762\n10#4:771\n10#4:780\n*S KotlinDebug\n*F\n+ 1 IndexFileDeleter.kt\norg/gnit/lucenekmp/index/IndexFileDeleter\n*L\n316#1:671,8\n343#1:680,8\n356#1:689,2\n368#1:691,8\n374#1:700,8\n402#1:709,8\n428#1:718,8\n466#1:727,8\n475#1:736,8\n482#1:745,8\n488#1:754,8\n493#1:763,8\n500#1:772,8\n316#1:679\n343#1:688\n368#1:699\n374#1:708\n402#1:717\n428#1:726\n466#1:735\n475#1:744\n482#1:753\n488#1:762\n493#1:771\n500#1:780\n*E\n"})
public final class IndexFileDeleter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InfoStream infoStream;
    @NotNull
    private final IndexWriter writer;
    @NotNull
    private final List<CommitPoint> commits;
    @NotNull
    private final List<String> lastFiles;
    @NotNull
    private final List<CommitPoint> commitsToDelete;
    @NotNull
    private final Directory directoryOrig;
    @NotNull
    private final Directory directory;
    @NotNull
    private final IndexDeletionPolicy policy;
    private final boolean startingCommitDeleted;
    @Nullable
    private SegmentInfos lastSegmentInfos;
    @NotNull
    private final FileDeleter fileDeleter;

    public IndexFileDeleter(@NotNull String[] files, @NotNull Directory directoryOrig, @NotNull Directory directory, @NotNull IndexDeletionPolicy policy, @NotNull SegmentInfos segmentInfos, @NotNull InfoStream infoStream, @NotNull IndexWriter writer, boolean initialIndexExists, boolean isReaderInit) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)directoryOrig, (String)"directoryOrig");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)segmentInfos, (String)"segmentInfos");
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.infoStream = infoStream;
        this.writer = writer;
        this.commits = new ArrayList();
        this.lastFiles = new ArrayList();
        this.commitsToDelete = new ArrayList();
        String currentSegmentsFile = segmentInfos.getSegmentsFileName();
        if (this.infoStream.isEnabled("IFD")) {
            this.infoStream.message("IFD", "init: current segments file is \"" + currentSegmentsFile + "\"; deletionPolicy=" + policy);
        }
        this.policy = policy;
        this.directoryOrig = directoryOrig;
        this.directory = directory;
        this.fileDeleter = new FileDeleter(directory, (Function2<? super FileDeleter.MsgType, ? super String, Unit>)((Function2)(arg_0, arg_1) -> IndexFileDeleter._init_$lambda$0(this, arg_0, arg_1)));
        CommitPoint currentCommitPoint = null;
        if (currentSegmentsFile != null) {
            for (String fileName : files) {
                if (StringsKt.endsWith$default((String)fileName, (String)"write.lock", (boolean)false, (int)2, null) || !IndexFileNames.INSTANCE.getCODEC_FILE_PATTERN().matches((CharSequence)fileName) && !StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fileName, (String)"pending_segments", (boolean)false, (int)2, null)) continue;
                this.fileDeleter.initRefCount(fileName);
                if (!StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null)) continue;
                if (this.infoStream.isEnabled("IFD")) {
                    this.infoStream.message("IFD", "init: load commit \"" + fileName + "\"");
                }
                SegmentInfos sis = SegmentInfos.Companion.readCommit$default(SegmentInfos.Companion, directoryOrig, fileName, 0, 4, null);
                CommitPoint commitPoint = new CommitPoint((Collection<CommitPoint>)this.commitsToDelete, directoryOrig, sis);
                if (sis.getGeneration() == segmentInfos.getGeneration()) {
                    currentCommitPoint = commitPoint;
                }
                this.commits.add(commitPoint);
                this.incRef(sis, true);
                if (this.lastSegmentInfos != null) {
                    long l = sis.getGeneration();
                    SegmentInfos segmentInfos2 = this.lastSegmentInfos;
                    Intrinsics.checkNotNull((Object)segmentInfos2);
                    if (l <= segmentInfos2.getGeneration()) continue;
                }
                this.lastSegmentInfos = sis;
            }
        }
        if (currentCommitPoint == null && currentSegmentsFile != null && initialIndexExists) {
            SegmentInfos sis = null;
            try {
                sis = SegmentInfos.Companion.readCommit$default(SegmentInfos.Companion, directoryOrig, currentSegmentsFile, 0, 4, null);
            }
            catch (IOException e) {
                throw new CorruptIndexException("unable to read current segments_N file", currentSegmentsFile, (Throwable)e);
            }
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "forced open of current segments file " + segmentInfos.getSegmentsFileName());
            }
            currentCommitPoint = new CommitPoint((Collection<CommitPoint>)this.commitsToDelete, directoryOrig, sis);
            this.commits.add(currentCommitPoint);
            this.incRef(sis, true);
        }
        if (isReaderInit) {
            this.checkpoint(segmentInfos, false);
        }
        CollectionUtil.INSTANCE.timSort(this.commits);
        Collection relevantFiles = new HashSet(this.fileDeleter.getAllFiles());
        Set<String> pendingDeletions = directoryOrig.getPendingDeletions();
        if (!pendingDeletions.isEmpty()) {
            relevantFiles.addAll((Collection)pendingDeletions);
        }
        Companion.inflateGens(segmentInfos, relevantFiles, this.infoStream);
        Set<String> toDelete = this.fileDeleter.getUnrefedFiles();
        for (String fileName : toDelete) {
            if (!(!StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string = "file \"" + fileName + "\" has refCount=0, which should never happen on init";
                throw new IllegalStateException(string.toString());
            }
            if (!this.infoStream.isEnabled("IFD")) continue;
            this.infoStream.message("IFD", "init: removing unreferenced file \"" + fileName + "\"");
        }
        this.fileDeleter.deleteFilesIfNoRef((Collection<String>)toDelete);
        policy.onInit(this.commits);
        this.checkpoint(segmentInfos, false);
        CommitPoint commitPoint = currentCommitPoint;
        this.startingCommitDeleted = commitPoint != null ? commitPoint.isDeleted() : false;
        this.deleteCommits();
    }

    public final boolean getStartingCommitDeleted() {
        return this.startingCommitDeleted;
    }

    private final boolean locked() {
        return true;
    }

    public final void ensureOpen() throws AlreadyClosedException {
        this.writer.ensureOpen(false);
        if (this.writer.getTragicException() != null) {
            throw new AlreadyClosedException("refusing to delete any files: this IndexWriter hit an unrecoverable exception", this.writer.getTragicException());
        }
    }

    public final boolean isClosed() {
        try {
            this.ensureOpen();
            return false;
        }
        catch (AlreadyClosedException ace) {
            return true;
        }
    }

    private final void deleteCommits() throws IOException {
        int size2 = this.commitsToDelete.size();
        if (size2 > 0) {
            CommitPoint commit2;
            Throwable firstThrowable = null;
            int n = size2;
            for (int i = 0; i < n; ++i) {
                commit2 = this.commitsToDelete.get(i);
                if (this.infoStream.isEnabled("IFD")) {
                    this.infoStream.message("IFD", "deleteCommits: now decRef commit \"" + commit2.getSegmentsFileName() + "\"");
                }
                try {
                    this.decRef(commit2.getFileNames());
                    continue;
                }
                catch (Throwable t) {
                    firstThrowable = IOUtils.INSTANCE.useOrSuppress(firstThrowable, t);
                }
            }
            this.commitsToDelete.clear();
            size2 = this.commits.size();
            int writeTo = 0;
            for (int readFrom = 0; readFrom < size2; ++readFrom) {
                commit2 = this.commits.get(readFrom);
                if (commit2.isDeleted()) continue;
                if (writeTo != readFrom) {
                    this.commits.set(writeTo, this.commits.get(readFrom));
                }
                ++writeTo;
            }
            while (size2 > writeTo) {
                this.commits.remove(size2 - 1);
                --size2;
            }
            if (firstThrowable != null) {
                IOUtils.INSTANCE.rethrowAlways(firstThrowable);
                throw new KotlinNothingValueException();
            }
        }
    }

    public final void refresh() throws IOException {
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        Set toDelete = new HashSet();
        for (String fileName : this.directory.listAll()) {
            if (StringsKt.endsWith$default((String)fileName, (String)"write.lock", (boolean)false, (int)2, null) || this.fileDeleter.exists(fileName) || !IndexFileNames.INSTANCE.getCODEC_FILE_PATTERN().matches((CharSequence)fileName) && !StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fileName, (String)"pending_segments", (boolean)false, (int)2, null)) continue;
            if (this.infoStream.isEnabled("IFD")) {
                this.infoStream.message("IFD", "refresh: removing newly created unreferenced file \"" + fileName + "\"");
            }
            toDelete.add(fileName);
        }
        this.fileDeleter.deleteFilesIfNoRef(toDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!this.lastFiles.isEmpty()) {
            try {
                this.decRef((Collection<String>)this.lastFiles);
            }
            finally {
                this.lastFiles.clear();
            }
        }
    }

    public final boolean assertCommitsAreNotDeleted(@NotNull List<CommitPoint> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        for (CommitPoint commit2 : commits) {
            boolean condition$iv = !commit2.isDeleted();
            boolean $i$f$assert = false;
            if (!_Assertions.ENABLED || condition$iv) continue;
            boolean bl = false;
            String string = "Commit [" + commit2 + "] was deleted already";
            throw new AssertionError((Object)string);
        }
        return true;
    }

    public final void revisitPolicy() throws IOException {
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        if (this.infoStream.isEnabled("IFD")) {
            this.infoStream.message("IFD", "now revisitPolicy");
        }
        if (!((Collection)this.commits).isEmpty()) {
            condition$iv = this.assertCommitsAreNotDeleted(this.commits);
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkpoint(@NotNull SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)segmentInfos, (String)"segmentInfos");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        Instant t0 = Clock.System.INSTANCE.now();
        if (this.infoStream.isEnabled("IFD")) {
            this.infoStream.message("IFD", "now checkpoint \"" + this.writer.segString(this.writer.toLiveInfos(segmentInfos)) + "\" [" + segmentInfos.size() + " segments ; isCommit = " + isCommit + "]");
        }
        this.incRef(segmentInfos, isCommit);
        if (isCommit) {
            this.commits.add(new CommitPoint((Collection<CommitPoint>)this.commitsToDelete, this.directoryOrig, segmentInfos));
            boolean condition$iv2 = this.assertCommitsAreNotDeleted(this.commits);
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        } else {
            try {
                this.decRef((Collection<String>)this.lastFiles);
            }
            finally {
                this.lastFiles.clear();
            }
            this.lastFiles.addAll(segmentInfos.files(false));
        }
        if (this.infoStream.isEnabled("IFD")) {
            Instant t1 = Clock.System.INSTANCE.now();
            this.infoStream.message("IFD", Duration.toString-impl((long)t1.minus-UwyO8pc(t0)) + " ms to checkpoint");
        }
    }

    private final void logInfo(FileDeleter.MsgType msgType, String msg) {
        if (msgType != FileDeleter.MsgType.REF && this.infoStream.isEnabled("IFD")) {
            this.infoStream.message("IFD", msg);
        }
    }

    public final void incRef(@NotNull SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        Intrinsics.checkNotNullParameter((Object)segmentInfos, (String)"segmentInfos");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        for (String fileName : segmentInfos.files(isCommit)) {
            this.fileDeleter.incRef(fileName);
        }
    }

    public final void incRef(@NotNull Collection<String> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.fileDeleter.incRef(files);
    }

    public final void decRef(@NotNull Collection<String> files) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.fileDeleter.decRef(files);
    }

    public final void decRef(@NotNull SegmentInfos segmentInfos) throws IOException {
        Intrinsics.checkNotNullParameter((Object)segmentInfos, (String)"segmentInfos");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.decRef(segmentInfos.files(false));
    }

    public final boolean exists(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.fileDeleter.exists(fileName);
    }

    public final void deleteNewFiles(@NotNull Collection<String> files) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean condition$iv = this.locked();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.fileDeleter.deleteFilesIfNoRef(files);
    }

    private static final Unit _init_$lambda$0(IndexFileDeleter this$0, FileDeleter.MsgType msgType, String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)msgType), (String)"msgType");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this$0.logInfo(msgType, msg);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010.\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u000202H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000f\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/index/IndexFileDeleter$CommitPoint;", "Lorg/gnit/lucenekmp/index/IndexCommit;", "commitsToDelete", "", "directoryOrig", "Lorg/gnit/lucenekmp/store/Directory;", "segmentInfos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "<init>", "(Ljava/util/Collection;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfos;)V", "getCommitsToDelete", "()Ljava/util/Collection;", "setCommitsToDelete", "(Ljava/util/Collection;)V", "getDirectoryOrig", "()Lorg/gnit/lucenekmp/store/Directory;", "setDirectoryOrig", "(Lorg/gnit/lucenekmp/store/Directory;)V", "fileNames", "", "getFileNames", "setFileNames", "segmentsFileName", "getSegmentsFileName", "()Ljava/lang/String;", "setSegmentsFileName", "(Ljava/lang/String;)V", "isDeleted", "", "()Z", "setDeleted", "(Z)V", "generation", "", "getGeneration", "()J", "setGeneration", "(J)V", "userData", "", "getUserData", "()Ljava/util/Map;", "segmentCount", "", "getSegmentCount", "()I", "toString", "directory", "getDirectory", "delete", "", "core"})
    public static final class CommitPoint
    extends IndexCommit {
        @NotNull
        private Collection<CommitPoint> commitsToDelete;
        @NotNull
        private Directory directoryOrig;
        @NotNull
        private Collection<String> fileNames;
        @NotNull
        private String segmentsFileName;
        private boolean isDeleted;
        private long generation;
        @NotNull
        private final Map<String, String> userData;
        private final int segmentCount;

        public CommitPoint(@NotNull Collection<CommitPoint> commitsToDelete, @NotNull Directory directoryOrig, @NotNull SegmentInfos segmentInfos) {
            Intrinsics.checkNotNullParameter(commitsToDelete, (String)"commitsToDelete");
            Intrinsics.checkNotNullParameter((Object)directoryOrig, (String)"directoryOrig");
            Intrinsics.checkNotNullParameter((Object)segmentInfos, (String)"segmentInfos");
            this.commitsToDelete = commitsToDelete;
            this.directoryOrig = directoryOrig;
            this.fileNames = CollectionsKt.toMutableList(segmentInfos.files(true));
            String string = segmentInfos.getSegmentsFileName();
            Intrinsics.checkNotNull((Object)string);
            this.segmentsFileName = string;
            this.generation = segmentInfos.getGeneration();
            this.userData = segmentInfos.getUserData();
            this.segmentCount = segmentInfos.size();
        }

        @NotNull
        public final Collection<CommitPoint> getCommitsToDelete() {
            return this.commitsToDelete;
        }

        public final void setCommitsToDelete(@NotNull Collection<CommitPoint> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.commitsToDelete = collection;
        }

        @NotNull
        public final Directory getDirectoryOrig() {
            return this.directoryOrig;
        }

        public final void setDirectoryOrig(@NotNull Directory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"<set-?>");
            this.directoryOrig = directory;
        }

        @Override
        @NotNull
        public Collection<String> getFileNames() {
            return this.fileNames;
        }

        public void setFileNames(@NotNull Collection<String> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.fileNames = collection;
        }

        @Override
        @NotNull
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public void setSegmentsFileName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.segmentsFileName = string;
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }

        public void setDeleted(boolean bl) {
            this.isDeleted = bl;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        public void setGeneration(long l) {
            this.generation = l;
        }

        @Override
        @NotNull
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @NotNull
        public String toString() {
            return "IndexFileDeleter.CommitPoint(" + this.getSegmentsFileName() + ")";
        }

        @Override
        @NotNull
        public Directory getDirectory() {
            return this.directoryOrig;
        }

        @Override
        public void delete() {
            if (!this.isDeleted()) {
                this.setDeleted(true);
                this.commitsToDelete.add(this);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/index/IndexFileDeleter$Companion;", "", "<init>", "()V", "inflateGens", "", "infos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "files", "", "", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexFileDeleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexFileDeleter.kt\norg/gnit/lucenekmp/index/IndexFileDeleter$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,669:1\n8#2,2:670\n*S KotlinDebug\n*F\n+ 1 IndexFileDeleter.kt\norg/gnit/lucenekmp/index/IndexFileDeleter$Companion\n*L\n582#1:670,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void inflateGens(@NotNull SegmentInfos infos, @NotNull Collection<String> files, @NotNull InfoStream infoStream) {
            Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long maxSegmentGen = Long.MIN_VALUE;
            long maxSegmentName = Long.MIN_VALUE;
            Map maxPerSegmentGen = new HashMap();
            for (String fileName : files) {
                if (Intrinsics.areEqual((Object)fileName, (Object)"write.lock")) continue;
                if (StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null)) {
                    try {
                        maxSegmentGen = Math.max(SegmentInfos.Companion.generationFromSegmentsFileName(fileName), maxSegmentGen);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (StringsKt.startsWith$default((String)fileName, (String)"pending_segments", (boolean)false, (int)2, null)) {
                    try {
                        String string = fileName.substring(8);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        maxSegmentGen = Math.max(SegmentInfos.Companion.generationFromSegmentsFileName(string), maxSegmentGen);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                String segmentName = IndexFileNames.INSTANCE.parseSegmentName(fileName);
                boolean condition$iv = StringsKt.startsWith$default((String)segmentName, (String)"_", (boolean)false, (int)2, null);
                boolean $i$f$assert22 = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "wtf file=" + fileName;
                    throw new AssertionError((Object)string);
                }
                String string = fileName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (StringsKt.endsWith$default((String)string, (String)".tmp", (boolean)false, (int)2, null)) continue;
                String string2 = segmentName.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                maxSegmentName = Math.max(maxSegmentName, Long.parseLong(string2, CharsKt.checkRadix((int)36)));
                Long curGen = (Long)maxPerSegmentGen.get(segmentName);
                if (curGen == null) {
                    curGen = 0L;
                }
                try {
                    curGen = Math.max(curGen, IndexFileNames.INSTANCE.parseGeneration(fileName));
                }
                catch (NumberFormatException $i$f$assert22) {
                    // empty catch block
                }
                maxPerSegmentGen.put(segmentName, curGen);
            }
            infos.setNextWriteGeneration(Math.max(infos.getGeneration(), maxSegmentGen));
            if (infos.getCounter() < 1L + maxSegmentName) {
                if (infoStream.isEnabled("IFD")) {
                    infoStream.message("IFD", "init: inflate infos.counter to " + (1L + maxSegmentName) + " vs current=" + infos.getCounter());
                }
                infos.setCounter(1L + maxSegmentName);
            }
            for (SegmentCommitInfo info : infos) {
                long gen;
                Object v = maxPerSegmentGen.get(info.getInfo().getName());
                if (v == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                long genLong = gen = ((Number)v).longValue();
                if (info.getNextWriteDelGen() < genLong + 1L) {
                    if (infoStream.isEnabled("IFD")) {
                        infoStream.message("IFD", "init: seg=" + info.getInfo().getName() + " set nextWriteDelGen=" + (genLong + 1L) + " vs current=" + info.getNextWriteDelGen());
                    }
                    info.setNextWriteDelGen(genLong + 1L);
                }
                if (info.getNextWriteFieldInfosGen() < genLong + 1L) {
                    if (infoStream.isEnabled("IFD")) {
                        infoStream.message("IFD", "init: seg=" + info.getInfo().getName() + " set nextWriteFieldInfosGen=" + (genLong + 1L) + " vs current=" + info.getNextWriteFieldInfosGen());
                    }
                    info.setNextWriteFieldInfosGen(genLong + 1L);
                }
                if (info.getNextWriteDocValuesGen() >= genLong + 1L) continue;
                if (infoStream.isEnabled("IFD")) {
                    infoStream.message("IFD", "init: seg=" + info.getInfo().getName() + " set nextWriteDocValuesGen=" + (genLong + 1L) + " vs current=" + info.getNextWriteDocValuesGen());
                }
                info.setNextWriteDocValuesGen(genLong + 1L);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

