/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/index/IndexFileNames;", "", "<init>", "()V", "SEGMENTS", "", "PENDING_SEGMENTS", "fileNameFromGeneration", "base", "ext", "gen", "", "segmentFileName", "segmentName", "segmentSuffix", "matchesExtension", "", "filename", "indexOfSegmentName", "", "stripSegmentName", "parseGeneration", "parseSegmentName", "stripExtension", "getExtension", "CODEC_FILE_PATTERN", "Lkotlin/text/Regex;", "getCODEC_FILE_PATTERN", "()Lkotlin/text/Regex;", "core"})
@SourceDebugExtension(value={"SMAP\nIndexFileNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexFileNames.kt\norg/gnit/lucenekmp/index/IndexFileNames\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,191:1\n739#2,9:192\n37#3:201\n36#3,3:202\n*S KotlinDebug\n*F\n+ 1 IndexFileNames.kt\norg/gnit/lucenekmp/index/IndexFileNames\n*L\n131#1:192,9\n131#1:201\n131#1:202,3\n*E\n"})
public final class IndexFileNames {
    @NotNull
    public static final IndexFileNames INSTANCE = new IndexFileNames();
    @NotNull
    public static final String SEGMENTS = "segments";
    @NotNull
    public static final String PENDING_SEGMENTS = "pending_segments";
    @NotNull
    private static final Regex CODEC_FILE_PATTERN = new Regex("_[a-z0-9]+(_.*)?\\..*");

    private IndexFileNames() {
    }

    @Nullable
    public final String fileNameFromGeneration(@NotNull String base, @NotNull String ext, long gen) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        if (gen == -1L) {
            return null;
        }
        if (gen == 0L) {
            return this.segmentFileName(base, "", ext);
        }
        if (!(gen > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        StringBuilder stringBuilder = new StringBuilder(base.length() + 6 + ext.length()).append(base).append('_');
        String string = Long.toString(gen, CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder res = stringBuilder2;
        if (((CharSequence)ext).length() > 0) {
            res.append('.').append(ext);
        }
        return res.toString();
    }

    @NotNull
    public final String segmentFileName(@NotNull String segmentName, @NotNull String segmentSuffix, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)segmentName, (String)"segmentName");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        if (((CharSequence)ext).length() > 0 || ((CharSequence)segmentSuffix).length() > 0) {
            if (!(!StringsKt.startsWith$default((String)ext, (String)".", (boolean)false, (int)2, null))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            StringBuilder sb = new StringBuilder(segmentName.length() + 2 + segmentSuffix.length() + ext.length());
            sb.append(segmentName);
            if (((CharSequence)segmentSuffix).length() > 0) {
                sb.append('_').append(segmentSuffix);
            }
            if (((CharSequence)ext).length() > 0) {
                sb.append('.').append(ext);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return segmentName;
    }

    public final boolean matchesExtension(@NotNull String filename, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        return StringsKt.endsWith$default((String)filename, (String)("." + ext), (boolean)false, (int)2, null);
    }

    private final int indexOfSegmentName(String filename) {
        int idx = StringsKt.indexOf$default((CharSequence)filename, (char)'_', (int)1, (boolean)false, (int)4, null);
        if (idx == -1) {
            idx = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        }
        return idx;
    }

    @NotNull
    public final String stripSegmentName(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String filename2 = filename;
        int idx = this.indexOfSegmentName(filename2);
        if (idx != -1) {
            String string = filename2.substring(idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            filename2 = string;
        }
        return filename2;
    }

    public final long parseGeneration(@NotNull String filename) {
        List list;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        if (!StringsKt.startsWith$default((String)filename, (String)"_", (boolean)false, (int)2, null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = this.stripExtension(filename).substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("_");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        return parts.length == 2 || parts.length == 4 ? Long.parseLong(parts[1], CharsKt.checkRadix((int)36)) : 0L;
    }

    @NotNull
    public final String parseSegmentName(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String filename2 = filename;
        int idx = this.indexOfSegmentName(filename2);
        if (idx != -1) {
            String string = filename2.substring(0, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            filename2 = string;
        }
        return filename2;
    }

    @NotNull
    public final String stripExtension(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String filename2 = filename;
        int idx = StringsKt.indexOf$default((CharSequence)filename2, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (idx != -1) {
            String string = filename2.substring(0, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            filename2 = string;
        }
        return filename2;
    }

    @Nullable
    public final String getExtension(@NotNull String filename) {
        String string;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        int idx = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (idx == -1) {
            string = null;
        } else {
            String string2 = filename.substring(idx + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    @NotNull
    public final Regex getCODEC_FILE_PATTERN() {
        return CODEC_FILE_PATTERN;
    }
}

