/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.analysis.standard.StandardAnalyzer;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.index.FlushPolicy;
import org.gnit.lucenekmp.index.IndexCommit;
import org.gnit.lucenekmp.index.IndexDeletionPolicy;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.IndexWriterEventListener;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LiveIndexWriterConfig;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.MergeScheduler;
import org.gnit.lucenekmp.jdkport.PrintStream;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.PrintStreamInfoStream;
import org.gnit.lucenekmp.util.SetOnce;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \\2\u00020\u0001:\u0002[\\B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u00100\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u000fJ\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u000e\u00101\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u000fH\u0016J\u0010\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020'H\u0016J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020'J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020JJ\u001e\u0010K\u001a\u00020\u00002\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020N0Mj\b\u0012\u0004\u0012\u00020N`OJ\b\u0010P\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020'H\u0016J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020QJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020XJ\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010Z\u001a\u00020QR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010+\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006]"}, d2={"Lorg/gnit/lucenekmp/index/IndexWriterConfig;", "Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "<init>", "(Lorg/gnit/lucenekmp/analysis/Analyzer;)V", "writer", "Lorg/gnit/lucenekmp/util/SetOnce;", "Lorg/gnit/lucenekmp/index/IndexWriter;", "setIndexWriter", "setOpenMode", "openMode", "Lorg/gnit/lucenekmp/index/IndexWriterConfig$OpenMode;", "setIndexCreatedVersionMajor", "indexCreatedVersionMajor", "", "setIndexDeletionPolicy", "delPolicy", "Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;", "indexDeletionPolicy", "getIndexDeletionPolicy", "()Lorg/gnit/lucenekmp/index/IndexDeletionPolicy;", "setIndexCommit", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "indexCommit", "getIndexCommit", "()Lorg/gnit/lucenekmp/index/IndexCommit;", "setSimilarity", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "setMergeScheduler", "mergeScheduler", "Lorg/gnit/lucenekmp/index/MergeScheduler;", "setCodec", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "setReaderPooling", "readerPooling", "", "setFlushPolicy", "flushPolicy", "Lorg/gnit/lucenekmp/index/FlushPolicy;", "perThreadHardLimitMB", "getPerThreadHardLimitMB", "()I", "setPerThreadHardLimitMB", "(I)V", "setRAMPerThreadHardLimitMB", "setInfoStream", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "printStream", "Lorg/gnit/lucenekmp/jdkport/PrintStream;", "setMergePolicy", "mergePolicy", "Lorg/gnit/lucenekmp/index/MergePolicy;", "setMaxBufferedDocs", "maxBufferedDocs", "setMergedSegmentWarmer", "mergeSegmentWarmer", "Lorg/gnit/lucenekmp/index/IndexWriter$IndexReaderWarmer;", "setRAMBufferSizeMB", "ramBufferSizeMB", "", "setUseCompoundFile", "useCompoundFile", "setCommitOnClose", "commitOnClose", "setMaxFullFlushMergeWaitMillis", "maxFullFlushMergeWaitMillis", "", "setIndexSort", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "setLeafSorter", "leafSorter", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/index/LeafReader;", "Lkotlin/Comparator;", "toString", "", "setCheckPendingFlushUpdate", "checkPendingFlushOnUpdate", "setSoftDeletesField", "softDeletesField", "setIndexWriterEventListener", "eventListener", "Lorg/gnit/lucenekmp/index/IndexWriterEventListener;", "setParentField", "parentField", "OpenMode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIndexWriterConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexWriterConfig.kt\norg/gnit/lucenekmp/index/IndexWriterConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,452:1\n1#2:453\n11228#3:454\n11563#3,3:455\n*S KotlinDebug\n*F\n+ 1 IndexWriterConfig.kt\norg/gnit/lucenekmp/index/IndexWriterConfig\n*L\n331#1:454\n331#1:455,3\n*E\n"})
public final class IndexWriterConfig
extends LiveIndexWriterConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SetOnce<IndexWriter> writer;
    private int perThreadHardLimitMB;
    public static final int DISABLE_AUTO_FLUSH = -1;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = -1;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = -1;
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    public static final boolean DEFAULT_READER_POOLING = true;
    public static final int DEFAULT_RAM_PER_THREAD_HARD_LIMIT_MB = 1945;
    public static final boolean DEFAULT_USE_COMPOUND_FILE_SYSTEM = true;
    public static final boolean DEFAULT_COMMIT_ON_CLOSE = true;
    public static final long DEFAULT_MAX_FULL_FLUSH_MERGE_WAIT_MILLIS = 500L;

    public IndexWriterConfig(@NotNull Analyzer analyzer) {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        super(analyzer);
        this.writer = new SetOnce();
        this.perThreadHardLimitMB = 1945;
    }

    public /* synthetic */ IndexWriterConfig(Analyzer analyzer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            analyzer = new StandardAnalyzer();
        }
        this(analyzer);
    }

    @NotNull
    public final IndexWriterConfig setIndexWriter(@NotNull IndexWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (!(this.writer.get() == null)) {
            boolean bl = false;
            String string = "do not share IndexWriterConfig instances across IndexWriters";
            throw new IllegalStateException(string.toString());
        }
        this.writer.set(writer);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setOpenMode(@NotNull OpenMode openMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)openMode), (String)"openMode");
        this.setOpenMode(openMode);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setIndexCreatedVersionMajor(int indexCreatedVersionMajor) {
        if (!(indexCreatedVersionMajor <= Version.Companion.getLATEST().getMajor())) {
            boolean $i$a$-require-IndexWriterConfig$setIndexCreatedVersionMajor$32 = false;
            String $i$a$-require-IndexWriterConfig$setIndexCreatedVersionMajor$32 = "indexCreatedVersionMajor may not be in the future: current major version is " + Version.Companion.getLATEST().getMajor() + ", but got: " + indexCreatedVersionMajor;
            throw new IllegalArgumentException($i$a$-require-IndexWriterConfig$setIndexCreatedVersionMajor$32.toString());
        }
        if (!(indexCreatedVersionMajor >= Version.Companion.getLATEST().getMajor() - 1)) {
            boolean bl = false;
            String string = "indexCreatedVersionMajor may not be less than the minimum supported version: " + (Version.Companion.getLATEST().getMajor() - 1) + ", but got: " + indexCreatedVersionMajor;
            throw new IllegalArgumentException(string.toString());
        }
        this.setCreatedVersionMajor(indexCreatedVersionMajor);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setIndexDeletionPolicy(@NotNull IndexDeletionPolicy delPolicy) {
        Intrinsics.checkNotNullParameter((Object)delPolicy, (String)"delPolicy");
        this.setDelPolicy(delPolicy);
        return this;
    }

    @Override
    @NotNull
    public IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.getDelPolicy();
    }

    @NotNull
    public final IndexWriterConfig setIndexCommit(@NotNull IndexCommit commit2) {
        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
        this.setCommit(commit2);
        return this;
    }

    @Override
    @Nullable
    public IndexCommit getIndexCommit() {
        return this.getCommit();
    }

    @NotNull
    public final IndexWriterConfig setSimilarity(@NotNull Similarity similarity) {
        Intrinsics.checkNotNullParameter((Object)similarity, (String)"similarity");
        this.setSimilarity(similarity);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setMergeScheduler(@NotNull MergeScheduler mergeScheduler) {
        Intrinsics.checkNotNullParameter((Object)mergeScheduler, (String)"mergeScheduler");
        this.setMergeScheduler(mergeScheduler);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setCodec(@NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setCodec(codec);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setReaderPooling(boolean readerPooling) {
        this.setReaderPooling(readerPooling);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setFlushPolicy(@NotNull FlushPolicy flushPolicy) {
        Intrinsics.checkNotNullParameter((Object)flushPolicy, (String)"flushPolicy");
        this.setFlushPolicy(flushPolicy);
        return this;
    }

    public final int getPerThreadHardLimitMB() {
        return this.perThreadHardLimitMB;
    }

    public final void setPerThreadHardLimitMB(int n) {
        this.perThreadHardLimitMB = n;
    }

    @NotNull
    public final IndexWriterConfig setRAMPerThreadHardLimitMB(int perThreadHardLimitMB) {
        if (!(perThreadHardLimitMB > 0 && perThreadHardLimitMB < 2048)) {
            boolean bl = false;
            String string = "PerThreadHardLimit must be greater than 0 and less than 2048MB";
            throw new IllegalArgumentException(string.toString());
        }
        this.perThreadHardLimitMB = perThreadHardLimitMB;
        return this;
    }

    @NotNull
    public final IndexWriterConfig setInfoStream(@NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this.setInfoStream(infoStream);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setInfoStream(@NotNull PrintStream printStream) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        return this.setInfoStream(new PrintStreamInfoStream(printStream, 0, 2, null));
    }

    @Override
    @NotNull
    public IndexWriterConfig setMergePolicy(@NotNull MergePolicy mergePolicy) {
        Intrinsics.checkNotNullParameter((Object)mergePolicy, (String)"mergePolicy");
        LiveIndexWriterConfig liveIndexWriterConfig = super.setMergePolicy(mergePolicy);
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.IndexWriterConfig");
        return (IndexWriterConfig)liveIndexWriterConfig;
    }

    @Override
    @NotNull
    public IndexWriterConfig setMaxBufferedDocs(int maxBufferedDocs) {
        LiveIndexWriterConfig liveIndexWriterConfig = super.setMaxBufferedDocs(maxBufferedDocs);
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.IndexWriterConfig");
        return (IndexWriterConfig)liveIndexWriterConfig;
    }

    @Override
    @NotNull
    public IndexWriterConfig setMergedSegmentWarmer(@NotNull IndexWriter.IndexReaderWarmer mergeSegmentWarmer) {
        Intrinsics.checkNotNullParameter((Object)mergeSegmentWarmer, (String)"mergeSegmentWarmer");
        LiveIndexWriterConfig liveIndexWriterConfig = super.setMergedSegmentWarmer(mergeSegmentWarmer);
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.IndexWriterConfig");
        return (IndexWriterConfig)liveIndexWriterConfig;
    }

    @Override
    @NotNull
    public IndexWriterConfig setRAMBufferSizeMB(double ramBufferSizeMB) {
        LiveIndexWriterConfig liveIndexWriterConfig = super.setRAMBufferSizeMB(ramBufferSizeMB);
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.IndexWriterConfig");
        return (IndexWriterConfig)liveIndexWriterConfig;
    }

    @Override
    @NotNull
    public IndexWriterConfig setUseCompoundFile(boolean useCompoundFile) {
        LiveIndexWriterConfig liveIndexWriterConfig = super.setUseCompoundFile(useCompoundFile);
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.IndexWriterConfig");
        return (IndexWriterConfig)liveIndexWriterConfig;
    }

    @NotNull
    public final IndexWriterConfig setCommitOnClose(boolean commitOnClose) {
        this.setCommitOnClose(commitOnClose);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setMaxFullFlushMergeWaitMillis(long maxFullFlushMergeWaitMillis) {
        this.setMaxFullFlushMergeWaitMillis(maxFullFlushMergeWaitMillis);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexWriterConfig setIndexSort(@NotNull Sort sort2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        for (SortField sortField : sort2.getSort()) {
            if (sortField.getIndexSorter() != null) continue;
            boolean bl = false;
            String string = "Cannot sort index with sort field " + sortField;
            throw new IllegalArgumentException(string.toString());
        }
        this.setIndexSort(sort2);
        SortField[] sortFieldArray = sort2.getSort();
        IndexWriterConfig indexWriterConfig = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getField());
        }
        indexWriterConfig.setIndexSortFields(CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv)));
        return this;
    }

    @NotNull
    public final IndexWriterConfig setLeafSorter(@NotNull Comparator<LeafReader> leafSorter) {
        Intrinsics.checkNotNullParameter(leafSorter, (String)"leafSorter");
        this.setLeafSorter(leafSorter);
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("writer=").append(this.writer.get()).append("\n");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public IndexWriterConfig setCheckPendingFlushUpdate(boolean checkPendingFlushOnUpdate) {
        LiveIndexWriterConfig liveIndexWriterConfig = super.setCheckPendingFlushUpdate(checkPendingFlushOnUpdate);
        Intrinsics.checkNotNull((Object)liveIndexWriterConfig, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.IndexWriterConfig");
        return (IndexWriterConfig)liveIndexWriterConfig;
    }

    @NotNull
    public final IndexWriterConfig setSoftDeletesField(@NotNull String softDeletesField) {
        Intrinsics.checkNotNullParameter((Object)softDeletesField, (String)"softDeletesField");
        this.setSoftDeletesField(softDeletesField);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setIndexWriterEventListener(@NotNull IndexWriterEventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.setEventListener(eventListener);
        return this;
    }

    @NotNull
    public final IndexWriterConfig setParentField(@NotNull String parentField) {
        Intrinsics.checkNotNullParameter((Object)parentField, (String)"parentField");
        this.setParentField(parentField);
        return this;
    }

    public IndexWriterConfig() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/IndexWriterConfig$Companion;", "", "<init>", "()V", "DISABLE_AUTO_FLUSH", "", "DEFAULT_MAX_BUFFERED_DELETE_TERMS", "DEFAULT_MAX_BUFFERED_DOCS", "DEFAULT_RAM_BUFFER_SIZE_MB", "", "DEFAULT_READER_POOLING", "", "DEFAULT_RAM_PER_THREAD_HARD_LIMIT_MB", "DEFAULT_USE_COMPOUND_FILE_SYSTEM", "DEFAULT_COMMIT_ON_CLOSE", "DEFAULT_MAX_FULL_FLUSH_MERGE_WAIT_MILLIS", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/index/IndexWriterConfig$OpenMode;", "", "<init>", "(Ljava/lang/String;I)V", "CREATE", "APPEND", "CREATE_OR_APPEND", "core"})
    public static final class OpenMode
    extends Enum<OpenMode> {
        public static final /* enum */ OpenMode CREATE = new OpenMode();
        public static final /* enum */ OpenMode APPEND = new OpenMode();
        public static final /* enum */ OpenMode CREATE_OR_APPEND = new OpenMode();
        private static final /* synthetic */ OpenMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OpenMode[] values() {
            return (OpenMode[])$VALUES.clone();
        }

        public static OpenMode valueOf(String value) {
            return Enum.valueOf(OpenMode.class, value);
        }

        @NotNull
        public static EnumEntries<OpenMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = openModeArray = new OpenMode[]{OpenMode.CREATE, OpenMode.APPEND, OpenMode.CREATE_OR_APPEND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

