/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionIncrementAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermFrequencyAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermToBytesRefAttribute;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesFormat;
import org.gnit.lucenekmp.codecs.KnnFieldVectorsWriter;
import org.gnit.lucenekmp.codecs.NormsConsumer;
import org.gnit.lucenekmp.codecs.NormsFormat;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PointsFormat;
import org.gnit.lucenekmp.codecs.PointsWriter;
import org.gnit.lucenekmp.document.InvertableType;
import org.gnit.lucenekmp.document.KnnByteVectorField;
import org.gnit.lucenekmp.document.KnnFloatVectorField;
import org.gnit.lucenekmp.document.StoredValue;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.BinaryDocValuesWriter;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesLeafReader;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.DocValuesWriter;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FieldInvertState;
import org.gnit.lucenekmp.index.FreqProxTermsWriter;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexSorter;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LiveIndexWriterConfig;
import org.gnit.lucenekmp.index.NormValuesWriter;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.NumericDocValuesWriter;
import org.gnit.lucenekmp.index.PointValuesWriter;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedDocValuesWriter;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValuesWriter;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValuesWriter;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.SortingStoredFieldsConsumer;
import org.gnit.lucenekmp.index.SortingTermVectorsConsumer;
import org.gnit.lucenekmp.index.StoredFieldsConsumer;
import org.gnit.lucenekmp.index.TermVectorsConsumer;
import org.gnit.lucenekmp.index.TermsHash;
import org.gnit.lucenekmp.index.TermsHashPerField;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.index.VectorValuesConsumer;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 z2\u00020\u0001:\u0005vwxyzBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000eH\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020FJ\u001a\u0010H\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020F2\b\u0010I\u001a\u0004\u0018\u00010DH\u0002J\u001a\u0010J\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020F2\b\u0010I\u001a\u0004\u0018\u00010DH\u0002J\u001a\u0010K\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020F2\b\u0010I\u001a\u0004\u0018\u00010DH\u0002J\u0006\u0010L\u001a\u00020\u000fJ\b\u0010M\u001a\u00020\u000fH\u0002J\u0010\u0010N\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020\u0003H\u0002J\b\u0010P\u001a\u00020\u000fH\u0002J\u001e\u0010Q\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020\u00032\u000e\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020T0SJ\b\u0010U\u001a\u00020\u000fH\u0002J\u0014\u0010V\u001a\u00020\u000f2\n\u0010W\u001a\u00060/R\u00020\u0000H\u0002J$\u0010X\u001a\u00020<2\u0006\u0010O\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020T2\n\u0010W\u001a\u00060/R\u00020\u0000H\u0002J\u001c\u0010Z\u001a\u00060/R\u00020\u00002\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020<H\u0002J \u0010^\u001a\u00020\u000f2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020\\2\u0006\u0010b\u001a\u00020cH\u0002J,\u0010d\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020\u00032\n\u0010e\u001a\u00060/R\u00020\u00002\u0006\u0010b\u001a\u00020c2\u0006\u0010Y\u001a\u00020TH\u0002J,\u0010f\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020\u00032\n\u0010W\u001a\u00060/R\u00020\u00002\u0006\u0010g\u001a\u00020h2\u0006\u0010Y\u001a\u00020TH\u0002J\u0014\u0010i\u001a\u00060/R\u00020\u00002\u0006\u0010j\u001a\u00020\\H\u0002J\b\u0010k\u001a\u000204H\u0016J\u0010\u0010p\u001a\u0004\u0018\u00010q2\u0006\u0010Y\u001a\u00020\\J#\u0010r\u001a\b\u0012\u0004\u0012\u0002Ht0s\"\b\b\u0000\u0010t*\u00020T2\u0006\u0010Y\u001a\u0002Ht\u00a2\u0006\u0002\u0010uR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001c\u0010-\u001a\u000e\u0012\n\u0012\b\u0018\u00010/R\u00020\u00000.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00100R\u000e\u00101\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\f\u0012\b\u0012\u00060/R\u00020\u00000.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00100R\u001c\u00106\u001a\u000e\u0012\n\u0012\b\u0018\u00010/R\u00020\u00000.X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00100R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\u00020@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00010m8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bn\u0010o\u00a8\u0006{"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain;", "Lorg/gnit/lucenekmp/util/Accountable;", "indexCreatedVersionMajor", "", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos$Builder;", "indexWriterConfig", "Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;", "abortingExceptionConsumer", "Lkotlin/Function1;", "", "", "<init>", "(ILorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/FieldInfos$Builder;Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;Lkotlin/jvm/functions/Function1;)V", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "getBytesUsed", "()Lorg/gnit/lucenekmp/util/Counter;", "fieldInfosBuilder", "getFieldInfosBuilder", "()Lorg/gnit/lucenekmp/index/FieldInfos$Builder;", "termsHash", "Lorg/gnit/lucenekmp/index/TermsHash;", "getTermsHash", "()Lorg/gnit/lucenekmp/index/TermsHash;", "docValuesBytePool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "getDocValuesBytePool", "()Lorg/gnit/lucenekmp/util/ByteBlockPool;", "storedFieldsConsumer", "Lorg/gnit/lucenekmp/index/StoredFieldsConsumer;", "getStoredFieldsConsumer", "()Lorg/gnit/lucenekmp/index/StoredFieldsConsumer;", "vectorValuesConsumer", "Lorg/gnit/lucenekmp/index/VectorValuesConsumer;", "getVectorValuesConsumer", "()Lorg/gnit/lucenekmp/index/VectorValuesConsumer;", "termVectorsWriter", "Lorg/gnit/lucenekmp/index/TermVectorsConsumer;", "getTermVectorsWriter", "()Lorg/gnit/lucenekmp/index/TermVectorsConsumer;", "fieldHash", "", "Lorg/gnit/lucenekmp/index/IndexingChain$PerField;", "[Lorg/gnit/lucenekmp/index/IndexingChain$PerField;", "hashMask", "totalFieldCount", "nextFieldGen", "", "fields", "docFields", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "byteBlockAllocator", "Lorg/gnit/lucenekmp/util/ByteBlockPool$DirectTrackingAllocator;", "hasHitAbortingException", "", "onAbortingException", "th", "docValuesLeafReader", "Lorg/gnit/lucenekmp/index/LeafReader;", "getDocValuesLeafReader", "()Lorg/gnit/lucenekmp/index/LeafReader;", "maybeSortSegment", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "flush", "writePoints", "sortMap", "writeDocValues", "writeNorms", "abort", "rehash", "startStoredFields", "docID", "finishStoredFields", "processDocument", "document", "", "Lorg/gnit/lucenekmp/index/IndexableField;", "oversizeDocFields", "initializeFieldInfo", "pf", "processField", "field", "getOrAddPerField", "fieldName", "", "reserved", "validateIndexSortDVType", "indexSort", "Lorg/gnit/lucenekmp/search/Sort;", "fieldToValidate", "dvType", "Lorg/gnit/lucenekmp/index/DocValuesType;", "indexDocValue", "fp", "indexVectorValue", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "getPerField", "name", "ramBytesUsed", "childResources", "", "getChildResources", "()Ljava/util/Collection;", "getHasDocValues", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "markAsReserved", "Lorg/gnit/lucenekmp/index/IndexingChain$ReservedField;", "T", "(Lorg/gnit/lucenekmp/index/IndexableField;)Lorg/gnit/lucenekmp/index/IndexingChain$ReservedField;", "PerField", "IntBlockAllocator", "FieldSchema", "ReservedField", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIndexingChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingChain.kt\norg/gnit/lucenekmp/index/IndexingChain\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1654:1\n3#2,8:1655\n3#2,8:1669\n10#3:1663\n10#3:1677\n37#4:1664\n36#4,3:1665\n1#5:1668\n*S KotlinDebug\n*F\n+ 1 IndexingChain.kt\norg/gnit/lucenekmp/index/IndexingChain\n*L\n90#1:1655,8\n551#1:1669,8\n90#1:1663\n551#1:1677\n262#1:1664\n262#1:1665,3\n*E\n"})
public final class IndexingChain
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int indexCreatedVersionMajor;
    @NotNull
    private final Counter bytesUsed;
    @NotNull
    private final FieldInfos.Builder fieldInfosBuilder;
    @NotNull
    private final TermsHash termsHash;
    @NotNull
    private final ByteBlockPool docValuesBytePool;
    @NotNull
    private final StoredFieldsConsumer storedFieldsConsumer;
    @NotNull
    private final VectorValuesConsumer vectorValuesConsumer;
    @NotNull
    private final TermVectorsConsumer termVectorsWriter;
    @NotNull
    private PerField[] fieldHash;
    private int hashMask;
    private int totalFieldCount;
    private long nextFieldGen;
    @NotNull
    private PerField[] fields;
    @NotNull
    private PerField[] docFields;
    @NotNull
    private final InfoStream infoStream;
    @NotNull
    private final ByteBlockPool.DirectTrackingAllocator byteBlockAllocator;
    @NotNull
    private final LiveIndexWriterConfig indexWriterConfig;
    @NotNull
    private final Function1<Throwable, Unit> abortingExceptionConsumer;
    private boolean hasHitAbortingException;

    public IndexingChain(int indexCreatedVersionMajor, @NotNull SegmentInfo segmentInfo, @NotNull Directory directory, @NotNull FieldInfos.Builder fieldInfos, @NotNull LiveIndexWriterConfig indexWriterConfig, @NotNull Function1<? super Throwable, Unit> abortingExceptionConsumer) {
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fieldInfos, (String)"fieldInfos");
        Intrinsics.checkNotNullParameter((Object)indexWriterConfig, (String)"indexWriterConfig");
        Intrinsics.checkNotNullParameter(abortingExceptionConsumer, (String)"abortingExceptionConsumer");
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.bytesUsed = Counter.Companion.newCounter$default(Counter.Companion, false, 1, null);
        this.fieldHash = new PerField[2];
        this.hashMask = 1;
        this.fields = new PerField[1];
        this.docFields = new PerField[2];
        this.byteBlockAllocator = new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed);
        IntBlockPool.Allocator intBlockAllocator = new IntBlockAllocator(this.bytesUsed);
        this.indexWriterConfig = indexWriterConfig;
        boolean condition$iv = segmentInfo.getIndexSort() == indexWriterConfig.getIndexSort();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.fieldInfosBuilder = fieldInfos;
        this.infoStream = indexWriterConfig.getInfoStream();
        this.abortingExceptionConsumer = abortingExceptionConsumer;
        this.vectorValuesConsumer = new VectorValuesConsumer(indexWriterConfig.getCodec(), directory, segmentInfo, this.infoStream);
        if (segmentInfo.getIndexSort() == null) {
            this.storedFieldsConsumer = new StoredFieldsConsumer(indexWriterConfig.getCodec(), directory, segmentInfo);
            this.termVectorsWriter = new TermVectorsConsumer(intBlockAllocator, this.byteBlockAllocator, directory, segmentInfo, indexWriterConfig.getCodec());
        } else {
            this.storedFieldsConsumer = new SortingStoredFieldsConsumer(indexWriterConfig.getCodec(), directory, segmentInfo);
            this.termVectorsWriter = new SortingTermVectorsConsumer(intBlockAllocator, this.byteBlockAllocator, directory, segmentInfo, indexWriterConfig.getCodec());
        }
        this.termsHash = new FreqProxTermsWriter(intBlockAllocator, this.byteBlockAllocator, this.bytesUsed, this.termVectorsWriter);
        this.docValuesBytePool = new ByteBlockPool(this.byteBlockAllocator);
    }

    @NotNull
    public final Counter getBytesUsed() {
        return this.bytesUsed;
    }

    @NotNull
    public final FieldInfos.Builder getFieldInfosBuilder() {
        return this.fieldInfosBuilder;
    }

    @NotNull
    public final TermsHash getTermsHash() {
        return this.termsHash;
    }

    @NotNull
    public final ByteBlockPool getDocValuesBytePool() {
        return this.docValuesBytePool;
    }

    @NotNull
    public final StoredFieldsConsumer getStoredFieldsConsumer() {
        return this.storedFieldsConsumer;
    }

    @NotNull
    public final VectorValuesConsumer getVectorValuesConsumer() {
        return this.vectorValuesConsumer;
    }

    @NotNull
    public final TermVectorsConsumer getTermVectorsWriter() {
        return this.termVectorsWriter;
    }

    private final void onAbortingException(Throwable th) {
        if (th == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.hasHitAbortingException = true;
        this.abortingExceptionConsumer.invoke((Object)th);
    }

    private final LeafReader getDocValuesLeafReader() {
        return new DocValuesLeafReader(this){
            final /* synthetic */ IndexingChain this$0;
            {
                this.this$0 = $receiver;
            }

            public NumericDocValues getNumericDocValues(String field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                PerField pf = IndexingChain.access$getPerField(this.this$0, field);
                if (pf == null) {
                    return null;
                }
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                if (fieldInfo.getDocValuesType() == DocValuesType.NUMERIC) {
                    DocValuesWriter<?> docValuesWriter = pf.getDocValuesWriter();
                    Intrinsics.checkNotNull(docValuesWriter);
                    ? obj = docValuesWriter.getDocValues();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.NumericDocValues");
                    return (NumericDocValues)obj;
                }
                return null;
            }

            public BinaryDocValues getBinaryDocValues(String field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                PerField pf = IndexingChain.access$getPerField(this.this$0, field);
                if (pf == null) {
                    return null;
                }
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                if (fieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                    DocValuesWriter<?> docValuesWriter = pf.getDocValuesWriter();
                    Intrinsics.checkNotNull(docValuesWriter);
                    ? obj = docValuesWriter.getDocValues();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.BinaryDocValues");
                    return (BinaryDocValues)obj;
                }
                return null;
            }

            public SortedDocValues getSortedDocValues(String field) throws IOException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                PerField pf = IndexingChain.access$getPerField(this.this$0, field);
                if (pf == null) {
                    return null;
                }
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                if (fieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                    DocValuesWriter<?> docValuesWriter = pf.getDocValuesWriter();
                    Intrinsics.checkNotNull(docValuesWriter);
                    ? obj = docValuesWriter.getDocValues();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SortedDocValues");
                    return (SortedDocValues)obj;
                }
                return null;
            }

            public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                PerField pf = IndexingChain.access$getPerField(this.this$0, field);
                if (pf == null) {
                    return null;
                }
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                if (fieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                    DocValuesWriter<?> docValuesWriter = pf.getDocValuesWriter();
                    Intrinsics.checkNotNull(docValuesWriter);
                    ? obj = docValuesWriter.getDocValues();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SortedNumericDocValues");
                    return (SortedNumericDocValues)obj;
                }
                return null;
            }

            public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                PerField pf = IndexingChain.access$getPerField(this.this$0, field);
                if (pf == null) {
                    return null;
                }
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                if (fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                    DocValuesWriter<?> docValuesWriter = pf.getDocValuesWriter();
                    Intrinsics.checkNotNull(docValuesWriter);
                    ? obj = docValuesWriter.getDocValues();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SortedSetDocValues");
                    return (SortedSetDocValues)obj;
                }
                return null;
            }

            public FieldInfos getFieldInfos() {
                return this.this$0.getFieldInfosBuilder().finish();
            }
        };
    }

    private final Sorter.DocMap maybeSortSegment(SegmentWriteState state2) throws IOException {
        Sort indexSort = state2.getSegmentInfo().getIndexSort();
        if (indexSort == null) {
            return null;
        }
        LeafReader docValuesReader2 = this.getDocValuesLeafReader();
        Function1 comparatorWrapper = IndexingChain::maybeSortSegment$lambda$0;
        if (state2.getSegmentInfo().getHasBlocks()) {
            FieldInfos fieldInfos = state2.getFieldInfos();
            Intrinsics.checkNotNull((Object)fieldInfos);
            if (fieldInfos.getParentField() != null) {
                DocIdSetIterator readerValues = docValuesReader2.getNumericDocValues(state2.getFieldInfos().getParentField());
                if (readerValues == null) {
                    throw new CorruptIndexException("missing doc values for parent field \"" + state2.getFieldInfos().getParentField() + "\"", "IndexingChain", null, 4, null);
                }
                BitSet parents = BitSet.Companion.of(readerValues, state2.getSegmentInfo().maxDoc());
                comparatorWrapper = arg_0 -> IndexingChain.maybeSortSegment$lambda$2(parents, arg_0);
            }
        }
        if (state2.getSegmentInfo().getHasBlocks()) {
            FieldInfos fieldInfos = state2.getFieldInfos();
            Intrinsics.checkNotNull((Object)fieldInfos);
            if (fieldInfos.getParentField() == null && this.indexCreatedVersionMajor >= Version.Companion.getLUCENE_10_0_0().getMajor()) {
                throw new CorruptIndexException("parent field is not set but the index has blocks and uses index sorting. indexCreatedVersionMajor: " + this.indexCreatedVersionMajor, "IndexingChain", null, 4, null);
            }
        }
        List comparators = new ArrayList();
        int n = indexSort.getSort().length;
        for (int i = 0; i < n; ++i) {
            SortField sortField = indexSort.getSort()[i];
            IndexSorter sorter2 = sortField.getIndexSorter();
            if (sorter2 == null) {
                throw new UnsupportedOperationException("Cannot sort index using sort field " + sortField);
            }
            IndexSorter.DocComparator docComparator = sorter2.getDocComparator(docValuesReader2, state2.getSegmentInfo().maxDoc());
            comparators.add(comparatorWrapper.invoke((Object)docComparator));
        }
        Sorter sorter3 = new Sorter(indexSort);
        Collection $this$toTypedArray$iv = comparators;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return sorter3.sort(state2.getSegmentInfo().maxDoc(), thisCollection$iv.toArray(new IndexSorter.DocComparator[0]));
    }

    @Nullable
    public final Sorter.DocMap flush(@NotNull SegmentWriteState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Sorter.DocMap sortMap = this.maybeSortSegment(state2);
        int maxDoc = state2.getSegmentInfo().maxDoc();
        Instant t0 = Clock.System.INSTANCE.now();
        this.writeNorms(state2, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to write norms");
        }
        Directory directory = state2.getDirectory();
        SegmentInfo segmentInfo = state2.getSegmentInfo();
        FieldInfos fieldInfos = state2.getFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        SegmentReadState readState = new SegmentReadState(directory, segmentInfo, fieldInfos, IOContext.Companion.getDEFAULT(), state2.getSegmentSuffix());
        t0 = Clock.System.INSTANCE.now();
        this.writeDocValues(state2, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to write docValues");
        }
        t0 = Clock.System.INSTANCE.now();
        this.writePoints(state2, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to write points");
        }
        t0 = Clock.System.INSTANCE.now();
        this.vectorValuesConsumer.flush(state2, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to write vectors");
        }
        t0 = Clock.System.INSTANCE.now();
        this.storedFieldsConsumer.finish(maxDoc);
        this.storedFieldsConsumer.flush(state2, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to finish stored fields");
        }
        t0 = Clock.System.INSTANCE.now();
        Map fieldsToFlush = new LinkedHashMap();
        int n = this.fieldHash.length;
        for (int i = 0; i < n; ++i) {
            for (PerField perField = this.fieldHash[i]; perField != null; perField = perField.getNext()) {
                if (perField.getInvertState() == null) continue;
                FieldInfo fieldInfo = perField.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                String string = fieldInfo.getName();
                TermsHashPerField termsHashPerField = perField.getTermsHashPerField();
                Intrinsics.checkNotNull((Object)termsHashPerField);
                fieldsToFlush.put(string, termsHashPerField);
            }
        }
        NormsProducer norms = readState.getFieldInfos().hasNorms() ? state2.getSegmentInfo().getCodec().normsFormat().normsProducer(readState) : null;
        NormsProducer normsMergeInstance = null;
        if (norms != null) {
            normsMergeInstance = norms.getMergeInstance();
        }
        NormsProducer normsProducer = normsMergeInstance;
        Intrinsics.checkNotNull((Object)normsProducer);
        this.termsHash.flush(fieldsToFlush, state2, sortMap, normsProducer);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to write postings and finish vectors");
        }
        t0 = Clock.System.INSTANCE.now();
        this.indexWriterConfig.getCodec().fieldInfosFormat().write(state2.getDirectory(), state2.getSegmentInfo(), "", state2.getFieldInfos(), IOContext.Companion.getDEFAULT());
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms to write fieldInfos");
        }
        return sortMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writePoints(SegmentWriteState state2, Sorter.DocMap sortMap) throws IOException {
        PointsWriter pointsWriter = null;
        boolean success = false;
        try {
            int n = this.fieldHash.length;
            for (int i = 0; i < n; ++i) {
                PerField perField = null;
                for (perField = this.fieldHash[i]; perField != null; perField = perField.getNext()) {
                    if (perField.getPointValuesWriter() == null) continue;
                    FieldInfo fieldInfo = perField.getFieldInfo();
                    Intrinsics.checkNotNull((Object)fieldInfo);
                    if (fieldInfo.getPointDimensionCount() > 0) {
                        if (pointsWriter == null) {
                            PointsFormat fmt = state2.getSegmentInfo().getCodec().pointsFormat();
                            if (fmt == null) {
                                boolean bl = false;
                                FieldInfo fieldInfo2 = perField.getFieldInfo();
                                Intrinsics.checkNotNull((Object)fieldInfo2);
                                String string = "field=\"" + fieldInfo2.getName() + "\" was indexed as points but codec does not support points";
                                throw new IllegalStateException(string.toString());
                            }
                            pointsWriter = fmt.fieldsWriter(state2);
                        }
                        PointValuesWriter pointValuesWriter = perField.getPointValuesWriter();
                        Intrinsics.checkNotNull((Object)pointValuesWriter);
                        pointValuesWriter.flush(state2, sortMap, pointsWriter);
                    }
                    perField.setPointValuesWriter(null);
                }
            }
            if (pointsWriter != null) {
                pointsWriter.finish();
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{pointsWriter};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{pointsWriter};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDocValues(SegmentWriteState state2, Sorter.DocMap sortMap) throws IOException {
        DocValuesConsumer dvConsumer = null;
        boolean success = false;
        try {
            int n = this.fieldHash.length;
            for (int i = 0; i < n; ++i) {
                for (PerField perField = this.fieldHash[i]; perField != null; perField = perField.getNext()) {
                    if (perField.getDocValuesWriter() != null) {
                        FieldInfo fieldInfo = perField.getFieldInfo();
                        Intrinsics.checkNotNull((Object)fieldInfo);
                        if (fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                            SegmentInfo segmentInfo = state2.getSegmentInfo();
                            FieldInfo fieldInfo2 = perField.getFieldInfo();
                            Intrinsics.checkNotNull((Object)fieldInfo2);
                            throw new AssertionError((Object)("segment=" + segmentInfo + ": field=\"" + fieldInfo2.getName() + "\" has no docValues but wrote them"));
                        }
                        if (dvConsumer == null) {
                            DocValuesFormat fmt = state2.getSegmentInfo().getCodec().docValuesFormat();
                            dvConsumer = fmt.fieldsConsumer(state2);
                        }
                        DocValuesWriter<?> docValuesWriter = perField.getDocValuesWriter();
                        Intrinsics.checkNotNull(docValuesWriter);
                        docValuesWriter.flush(state2, sortMap, dvConsumer);
                        perField.setDocValuesWriter(null);
                        continue;
                    }
                    if (perField.getFieldInfo() == null) continue;
                    FieldInfo fieldInfo = perField.getFieldInfo();
                    Intrinsics.checkNotNull((Object)fieldInfo);
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                    SegmentInfo segmentInfo = state2.getSegmentInfo();
                    FieldInfo fieldInfo3 = perField.getFieldInfo();
                    Intrinsics.checkNotNull((Object)fieldInfo3);
                    throw new AssertionError((Object)("segment=" + segmentInfo + ": field=\"" + fieldInfo3.getName() + "\" has docValues but did not write them"));
                }
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{dvConsumer};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{dvConsumer};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
        FieldInfos fieldInfos = state2.getFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        if (!fieldInfos.hasDocValues()) {
            if (dvConsumer != null) {
                throw new AssertionError((Object)("segment=" + state2.getSegmentInfo() + ": fieldInfos has no docValues but wrote them"));
            }
        } else if (dvConsumer == null) {
            throw new AssertionError((Object)("segment=" + state2.getSegmentInfo() + ": fieldInfos has docValues but did not wrote them"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeNorms(SegmentWriteState state2, Sorter.DocMap sortMap) throws IOException {
        boolean success = false;
        NormsConsumer normsConsumer = null;
        try {
            FieldInfos fieldInfos = state2.getFieldInfos();
            Intrinsics.checkNotNull((Object)fieldInfos);
            if (fieldInfos.hasNorms()) {
                NormsFormat normsFormat = state2.getSegmentInfo().getCodec().normsFormat();
                if (normsFormat == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                NormsFormat normsFormat2 = normsFormat;
                normsConsumer = normsFormat2.normsConsumer(state2);
                for (FieldInfo fi : state2.getFieldInfos()) {
                    PerField perField;
                    if (this.getPerField(fi.getName()) == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    if (fi.omitsNorms() || fi.getIndexOptions() == IndexOptions.NONE) continue;
                    if (perField.getNorms() == null) {
                        boolean bl = false;
                        String string = "field=" + fi.getName();
                        throw new IllegalStateException(string.toString());
                    }
                    NormValuesWriter normValuesWriter = perField.getNorms();
                    Intrinsics.checkNotNull((Object)normValuesWriter);
                    normValuesWriter.finish(state2.getSegmentInfo().maxDoc());
                    NormValuesWriter normValuesWriter2 = perField.getNorms();
                    Intrinsics.checkNotNull((Object)normValuesWriter2);
                    normValuesWriter2.flush(state2, sortMap, normsConsumer);
                }
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{normsConsumer};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{normsConsumer};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() throws IOException {
        try {
            AutoCloseable autoCloseable = () -> IndexingChain.abort$lambda$5(this);
            Throwable throwable = null;
            try {
                AutoCloseable finalizer2 = autoCloseable;
                boolean bl = false;
                this.storedFieldsConsumer.abort();
                this.vectorValuesConsumer.abort();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        finally {
            org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.fieldHash, null);
        }
    }

    private final void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        boolean condition$iv = newHashSize > this.fieldHash.length;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        PerField[] newHashArray = new PerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (PerField fp0 : this.fieldHash) {
            while (fp0 != null) {
                int hashPos2 = fp0.getFieldName().hashCode() & newHashMask;
                PerField nextFP0 = fp0.getNext();
                fp0.setNext(newHashArray[hashPos2]);
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    private final void startStoredFields(int docID) throws IOException {
        try {
            this.storedFieldsConsumer.startDocument(docID);
        }
        catch (Throwable th) {
            this.onAbortingException(th);
            throw th;
        }
    }

    private final void finishStoredFields() throws IOException {
        try {
            this.storedFieldsConsumer.finishDocument();
        }
        catch (Throwable th) {
            this.onAbortingException(th);
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processDocument(int docID, @NotNull Iterable<? extends IndexableField> document2) throws IOException {
        Intrinsics.checkNotNullParameter(document2, (String)"document");
        int fieldCount = 0;
        int indexedFieldCount = 0;
        long l = this.nextFieldGen;
        this.nextFieldGen = l + 1L;
        long fieldGen = l;
        int docFieldIdx = 0;
        this.termsHash.startDocument();
        this.startStoredFields(docID);
        try {
            for (IndexableField indexableField : document2) {
                IndexableFieldType fieldType = indexableField.fieldType();
                boolean isReserved = indexableField.getClass() == ReservedField.class;
                PerField pf = this.getOrAddPerField(indexableField.name(), false);
                if (!(pf.getReserved() == isReserved)) {
                    boolean bl = false;
                    String string = "\"" + indexableField.name() + "\" is a reserved field and should not be added to any document";
                    throw new IllegalArgumentException(string.toString());
                }
                if (pf.getFieldGen() != fieldGen) {
                    this.fields[fieldCount++] = pf;
                    pf.setFieldGen(fieldGen);
                    pf.reset(docID);
                }
                if (docFieldIdx >= this.docFields.length) {
                    this.oversizeDocFields();
                }
                this.docFields[docFieldIdx++] = pf;
                IndexingChain.Companion.updateDocFieldSchema(indexableField.name(), pf.getSchema(), fieldType);
            }
            int n = fieldCount;
            for (int i = 0; i < n; ++i) {
                PerField pf = this.fields[i];
                if (pf.getFieldInfo() == null) {
                    this.initializeFieldInfo(pf);
                    continue;
                }
                FieldSchema fieldSchema = pf.getSchema();
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                fieldSchema.assertSameSchema(fieldInfo);
            }
            docFieldIdx = 0;
            for (IndexableField indexableField : document2) {
                PerField perField = this.docFields[docFieldIdx];
                Intrinsics.checkNotNull((Object)perField);
                if (this.processField(docID, indexableField, perField)) {
                    Intrinsics.checkNotNull((Object)this.docFields[docFieldIdx]);
                    ++indexedFieldCount;
                }
                ++docFieldIdx;
            }
        }
        finally {
            if (!this.hasHitAbortingException) {
                int n = indexedFieldCount;
                for (int i = 0; i < n; ++i) {
                    this.fields[i].finish(docID);
                }
                this.finishStoredFields();
                try {
                    this.termsHash.finishDocument(docID);
                }
                catch (Throwable th) {
                    this.abortingExceptionConsumer.invoke((Object)th);
                    throw th;
                }
            }
        }
    }

    private final void oversizeDocFields() {
        PerField[] newDocFields = new PerField[ArrayUtil.Companion.oversize(this.docFields.length + 1, 4)];
        System.INSTANCE.arraycopyKtNullable(this.docFields, 0, newDocFields, 0, this.docFields.length);
        this.docFields = newDocFields;
    }

    private final void initializeFieldInfo(PerField pf) throws IOException {
        FieldSchema s = pf.getSchema();
        if (this.indexWriterConfig.getIndexSort() != null && s.getDocValuesType() != DocValuesType.NONE) {
            Sort sort2 = this.indexWriterConfig.getIndexSort();
            Intrinsics.checkNotNull((Object)sort2);
            Sort indexSort = sort2;
            this.validateIndexSortDVType(indexSort, pf.getFieldName(), s.getDocValuesType());
        }
        if (s.getVectorDimension() != 0) {
            IndexingChain.Companion.validateMaxVectorDimension(pf.getFieldName(), s.getVectorDimension(), this.indexWriterConfig.getCodec().knnVectorsFormat().getMaxDimensions(pf.getFieldName()));
        }
        FieldInfo fi = this.fieldInfosBuilder.add(new FieldInfo(pf.getFieldName(), -1, s.getStoreTermVector(), s.getOmitNorms(), false, s.getIndexOptions(), s.getDocValuesType(), s.getDocValuesSkipIndex(), -1L, s.getAttributes(), s.getPointDimensionCount(), s.getPointIndexDimensionCount(), s.getPointNumBytes(), s.getVectorDimension(), s.getVectorEncoding(), s.getVectorSimilarityFunction(), Intrinsics.areEqual((Object)pf.getFieldName(), (Object)this.fieldInfosBuilder.getSoftDeletesFieldName()), Intrinsics.areEqual((Object)pf.getFieldName(), (Object)this.fieldInfosBuilder.getParentFieldName())));
        pf.setFieldInfo(fi);
        if (fi.getIndexOptions() != IndexOptions.NONE) {
            pf.setInvertState();
        }
        DocValuesType dvType = fi.getDocValuesType();
        switch (WhenMappings.$EnumSwitchMapping$0[dvType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                pf.setDocValuesWriter(new NumericDocValuesWriter(fi, this.bytesUsed));
                break;
            }
            case 3: {
                pf.setDocValuesWriter(new BinaryDocValuesWriter(fi, this.bytesUsed));
                break;
            }
            case 4: {
                pf.setDocValuesWriter(new SortedDocValuesWriter(fi, this.bytesUsed, this.docValuesBytePool));
                break;
            }
            case 5: {
                pf.setDocValuesWriter(new SortedNumericDocValuesWriter(fi, this.bytesUsed));
                break;
            }
            case 6: {
                pf.setDocValuesWriter(new SortedSetDocValuesWriter(fi, this.bytesUsed, this.docValuesBytePool));
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + dvType));
            }
        }
        if (fi.getPointDimensionCount() != 0) {
            pf.setPointValuesWriter(new PointValuesWriter(this.bytesUsed, fi));
        }
        if (fi.getVectorDimension() != 0) {
            try {
                pf.setKnnFieldVectorsWriter(this.vectorValuesConsumer.addField(fi));
            }
            catch (Throwable th) {
                this.onAbortingException(th);
                throw th;
            }
        }
    }

    private final boolean processField(int docID, IndexableField field, PerField pf) throws IOException {
        DocValuesType dvType;
        IndexableFieldType fieldType = field.fieldType();
        boolean indexedField = false;
        if (fieldType.indexOptions() != IndexOptions.NONE) {
            if (pf.getFirst()) {
                pf.invert(docID, field, true);
                pf.setFirst(false);
                indexedField = true;
            } else {
                pf.invert(docID, field, false);
            }
        }
        if (fieldType.stored()) {
            StoredValue storedValue = field.storedValue();
            if (storedValue != null) {
                // empty if block
            }
            StoredValue storedValue2 = storedValue;
            Intrinsics.checkNotNull((Object)storedValue2);
            if (!(storedValue2.getType() != StoredValue.Type.STRING || storedValue.getStringValue().length() <= IndexWriter.Companion.getMAX_STORED_STRING_LENGTH())) {
                boolean bl = false;
                String string = "stored field \"" + field.name() + "\" is too large (" + storedValue.getStringValue().length() + " characters) to store";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                FieldInfo fieldInfo = pf.getFieldInfo();
                Intrinsics.checkNotNull((Object)fieldInfo);
                this.storedFieldsConsumer.writeField(fieldInfo, storedValue);
            }
            catch (Throwable th) {
                this.onAbortingException(th);
                throw th;
            }
        }
        if ((dvType = fieldType.docValuesType()) != DocValuesType.NONE) {
            this.indexDocValue(docID, pf, dvType, field);
        }
        if (fieldType.pointDimensionCount() != 0) {
            PointValuesWriter pointValuesWriter = pf.getPointValuesWriter();
            Intrinsics.checkNotNull((Object)pointValuesWriter);
            BytesRef bytesRef = field.binaryValue();
            Intrinsics.checkNotNull((Object)bytesRef);
            pointValuesWriter.addPackedValue(docID, bytesRef);
        }
        if (fieldType.vectorDimension() != 0) {
            this.indexVectorValue(docID, pf, fieldType.vectorEncoding(), field);
        }
        return indexedField;
    }

    private final PerField getOrAddPerField(String fieldName, boolean reserved) {
        PerField pf;
        int hashPos = fieldName.hashCode() & this.hashMask;
        for (pf = this.fieldHash[hashPos]; pf != null && !Intrinsics.areEqual((Object)pf.getFieldName(), (Object)fieldName); pf = pf.getNext()) {
        }
        if (pf == null) {
            FieldSchema schema = new FieldSchema(fieldName);
            pf = new PerField(fieldName, this.indexCreatedVersionMajor, schema, this.indexWriterConfig.getSimilarity(), this.indexWriterConfig.getInfoStream(), this.indexWriterConfig.getAnalyzer(), reserved);
            pf.setNext(this.fieldHash[hashPos]);
            this.fieldHash[hashPos] = pf;
            int n = this.totalFieldCount;
            this.totalFieldCount = n + 1;
            if (this.totalFieldCount >= this.fieldHash.length / 2) {
                this.rehash();
            }
            if (this.totalFieldCount > this.fields.length) {
                PerField[] newFields = new PerField[ArrayUtil.Companion.oversize(this.totalFieldCount, 4)];
                System.INSTANCE.arraycopyKt(this.fields, 0, newFields, 0, this.fields.length);
                this.fields = newFields;
            }
        }
        return pf;
    }

    private final void validateIndexSortDVType(Sort indexSort, String fieldToValidate, DocValuesType dvType) throws IOException {
        for (SortField sortField : indexSort.getSort()) {
            IndexSorter sorter2 = sortField.getIndexSorter();
            if (sorter2 == null) {
                boolean bl = false;
                String string = "Cannot sort index with sort order " + sortField;
                throw new IllegalStateException(string.toString());
            }
            sorter2.getDocComparator(new DocValuesLeafReader(fieldToValidate, dvType, sortField){
                final /* synthetic */ String $fieldToValidate;
                final /* synthetic */ DocValuesType $dvType;
                final /* synthetic */ SortField $sortField;
                {
                    this.$fieldToValidate = $fieldToValidate;
                    this.$dvType = $dvType;
                    this.$sortField = $sortField;
                }

                public NumericDocValues getNumericDocValues(String field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    boolean bl = !Intrinsics.areEqual((Object)field, (Object)this.$fieldToValidate) || this.$dvType == DocValuesType.NUMERIC;
                    SortField sortField = this.$sortField;
                    DocValuesType docValuesType = this.$dvType;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = "SortField " + sortField + " expected field [" + field + "] to be NUMERIC but it is [" + docValuesType + "]";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return DocValues.INSTANCE.emptyNumeric();
                }

                public BinaryDocValues getBinaryDocValues(String field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    boolean bl = !Intrinsics.areEqual((Object)field, (Object)this.$fieldToValidate) || this.$dvType == DocValuesType.BINARY;
                    SortField sortField = this.$sortField;
                    DocValuesType docValuesType = this.$dvType;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = "SortField " + sortField + " expected field [" + field + "] to be BINARY but it is [" + docValuesType + "]";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return DocValues.INSTANCE.emptyBinary();
                }

                public SortedDocValues getSortedDocValues(String field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    boolean bl = !Intrinsics.areEqual((Object)field, (Object)this.$fieldToValidate) || this.$dvType == DocValuesType.SORTED;
                    SortField sortField = this.$sortField;
                    DocValuesType docValuesType = this.$dvType;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = "SortField " + sortField + " expected field [" + field + "] to be SORTED but it is [" + docValuesType + "]";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return DocValues.INSTANCE.emptySorted();
                }

                public SortedNumericDocValues getSortedNumericDocValues(String field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    boolean bl = !Intrinsics.areEqual((Object)field, (Object)this.$fieldToValidate) || this.$dvType == DocValuesType.SORTED_NUMERIC;
                    SortField sortField = this.$sortField;
                    DocValuesType docValuesType = this.$dvType;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = "SortField " + sortField + " expected field [" + field + "] to be SORTED_NUMERIC but it is [" + docValuesType + "]";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return DocValues.INSTANCE.emptySortedNumeric();
                }

                public SortedSetDocValues getSortedSetDocValues(String field) {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    boolean bl = !Intrinsics.areEqual((Object)field, (Object)this.$fieldToValidate) || this.$dvType == DocValuesType.SORTED_SET;
                    SortField sortField = this.$sortField;
                    DocValuesType docValuesType = this.$dvType;
                    if (!bl) {
                        boolean bl2 = false;
                        String string = "SortField " + sortField + " expected field [" + field + "] to be SORTED_SET but it is [" + docValuesType + "]";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return DocValues.INSTANCE.emptySortedSet();
                }

                public FieldInfos getFieldInfos() {
                    throw new UnsupportedOperationException();
                }
            }, 0);
        }
    }

    private final void indexDocValue(int docID, PerField fp, DocValuesType dvType, IndexableField field) {
        switch (WhenMappings.$EnumSwitchMapping$0[dvType.ordinal()]) {
            case 2: {
                if (field.numericValue() == null) {
                    boolean bl = false;
                    FieldInfo fieldInfo = fp.getFieldInfo();
                    Intrinsics.checkNotNull((Object)fieldInfo);
                    String string = "field=\"" + fieldInfo.getName() + "\": null value not allowed";
                    throw new IllegalArgumentException(string.toString());
                }
                DocValuesWriter<?> docValuesWriter = fp.getDocValuesWriter();
                Intrinsics.checkNotNull(docValuesWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.NumericDocValuesWriter");
                NumericDocValuesWriter numericDocValuesWriter = (NumericDocValuesWriter)docValuesWriter;
                Number number = field.numericValue();
                Intrinsics.checkNotNull((Object)number);
                numericDocValuesWriter.addValue(docID, number.longValue());
                break;
            }
            case 3: {
                DocValuesWriter<?> docValuesWriter = fp.getDocValuesWriter();
                Intrinsics.checkNotNull(docValuesWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.BinaryDocValuesWriter");
                BinaryDocValuesWriter binaryDocValuesWriter = (BinaryDocValuesWriter)docValuesWriter;
                BytesRef bytesRef = field.binaryValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                binaryDocValuesWriter.addValue(docID, bytesRef);
                break;
            }
            case 4: {
                DocValuesWriter<?> docValuesWriter = fp.getDocValuesWriter();
                Intrinsics.checkNotNull(docValuesWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SortedDocValuesWriter");
                SortedDocValuesWriter sortedDocValuesWriter = (SortedDocValuesWriter)docValuesWriter;
                BytesRef bytesRef = field.binaryValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                sortedDocValuesWriter.addValue(docID, bytesRef);
                break;
            }
            case 5: {
                DocValuesWriter<?> docValuesWriter = fp.getDocValuesWriter();
                Intrinsics.checkNotNull(docValuesWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SortedNumericDocValuesWriter");
                SortedNumericDocValuesWriter sortedNumericDocValuesWriter = (SortedNumericDocValuesWriter)docValuesWriter;
                Number number = field.numericValue();
                Intrinsics.checkNotNull((Object)number);
                sortedNumericDocValuesWriter.addValue(docID, number.longValue());
                break;
            }
            case 6: {
                DocValuesWriter<?> docValuesWriter = fp.getDocValuesWriter();
                Intrinsics.checkNotNull(docValuesWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SortedSetDocValuesWriter");
                SortedSetDocValuesWriter sortedSetDocValuesWriter = (SortedSetDocValuesWriter)docValuesWriter;
                BytesRef bytesRef = field.binaryValue();
                Intrinsics.checkNotNull((Object)bytesRef);
                sortedSetDocValuesWriter.addValue(docID, bytesRef);
                break;
            }
            case 1: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + dvType));
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + dvType));
            }
        }
    }

    private final void indexVectorValue(int docID, PerField pf, VectorEncoding vectorEncoding, IndexableField field) throws IOException {
        switch (WhenMappings.$EnumSwitchMapping$1[vectorEncoding.ordinal()]) {
            case 1: {
                KnnFieldVectorsWriter<?> knnFieldVectorsWriter = pf.getKnnFieldVectorsWriter();
                Intrinsics.checkNotNull(knnFieldVectorsWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.KnnFieldVectorsWriter<kotlin.ByteArray>");
                Intrinsics.checkNotNull((Object)field, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.document.KnnByteVectorField");
                knnFieldVectorsWriter.addValue(docID, ((KnnByteVectorField)field).vectorValue());
                break;
            }
            case 2: {
                KnnFieldVectorsWriter<?> knnFieldVectorsWriter = pf.getKnnFieldVectorsWriter();
                Intrinsics.checkNotNull(knnFieldVectorsWriter, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.KnnFieldVectorsWriter<kotlin.FloatArray>");
                Intrinsics.checkNotNull((Object)field, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.document.KnnFloatVectorField");
                knnFieldVectorsWriter.addValue(docID, ((KnnFloatVectorField)field).vectorValue());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final PerField getPerField(String name) {
        PerField fp;
        int hashPos = name.hashCode() & this.hashMask;
        for (fp = this.fieldHash[hashPos]; fp != null && !Intrinsics.areEqual((Object)fp.getFieldName(), (Object)name); fp = fp.getNext()) {
        }
        PerField perField = fp;
        Intrinsics.checkNotNull((Object)perField);
        return perField;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.storedFieldsConsumer.getAccountable().ramBytesUsed() + this.termVectorsWriter.getAccountable().ramBytesUsed() + this.vectorValuesConsumer.getAccountable().ramBytesUsed();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        Object[] objectArray = new Accountable[]{this.storedFieldsConsumer.getAccountable(), this.termVectorsWriter.getAccountable(), this.vectorValuesConsumer.getAccountable()};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Nullable
    public final DocIdSetIterator getHasDocValues(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        PerField perField = this.getPerField(field);
        if (perField != null && perField.getDocValuesWriter() != null) {
            FieldInfo fieldInfo = perField.getFieldInfo();
            Intrinsics.checkNotNull((Object)fieldInfo);
            if (fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                return null;
            }
            DocValuesWriter<?> docValuesWriter = perField.getDocValuesWriter();
            Intrinsics.checkNotNull(docValuesWriter);
            return docValuesWriter.getDocValues();
        }
        return null;
    }

    @NotNull
    public final <T extends IndexableField> ReservedField<T> markAsReserved(@NotNull T field) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        this.getOrAddPerField(field.name(), true);
        return new ReservedField<T>(field);
    }

    private static final IndexSorter.DocComparator maybeSortSegment$lambda$0(IndexSorter.DocComparator input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input;
    }

    private static final int maybeSortSegment$lambda$2$lambda$1(IndexSorter.DocComparator $in, BitSet $parents, int docID1, int docID2) {
        return $in.compare($parents.nextSetBit(docID1), $parents.nextSetBit(docID2));
    }

    private static final IndexSorter.DocComparator maybeSortSegment$lambda$2(BitSet $parents, IndexSorter.DocComparator in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        return (arg_0, arg_1) -> IndexingChain.maybeSortSegment$lambda$2$lambda$1(in, $parents, arg_0, arg_1);
    }

    private static final void abort$lambda$5(IndexingChain this$0) {
        this$0.termsHash.abort();
    }

    public static final /* synthetic */ PerField access$getPerField(IndexingChain $this, String name) {
        return $this.getPerField(name);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain$Companion;", "", "<init>", "()V", "updateDocFieldSchema", "", "fieldName", "", "schema", "Lorg/gnit/lucenekmp/index/IndexingChain$FieldSchema;", "fieldType", "Lorg/gnit/lucenekmp/index/IndexableFieldType;", "verifyUnIndexedFieldType", "name", "ft", "validateMaxVectorDimension", "vectorDim", "", "maxVectorDim", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateDocFieldSchema(String fieldName, FieldSchema schema, IndexableFieldType fieldType) {
            if (fieldType.indexOptions() != IndexOptions.NONE) {
                schema.setIndexOptions(fieldType.indexOptions(), fieldType.omitNorms(), fieldType.storeTermVectors());
            } else {
                this.verifyUnIndexedFieldType(fieldName, fieldType);
            }
            if (fieldType.docValuesType() != DocValuesType.NONE) {
                schema.setDocValues(fieldType.docValuesType(), fieldType.docValuesSkipIndexType());
            } else if (!(fieldType.docValuesSkipIndexType() == DocValuesSkipIndexType.NONE)) {
                boolean bl = false;
                String string = "field '" + schema.getName() + "' cannot have docValuesSkipIndexType=" + fieldType.docValuesSkipIndexType() + " without doc values";
                throw new IllegalArgumentException(string.toString());
            }
            if (fieldType.pointDimensionCount() != 0) {
                schema.setPoints(fieldType.pointDimensionCount(), fieldType.pointIndexDimensionCount(), fieldType.pointNumBytes());
            }
            if (fieldType.vectorDimension() != 0) {
                schema.setVectors(fieldType.vectorEncoding(), fieldType.vectorSimilarityFunction(), fieldType.vectorDimension());
            }
            if (fieldType.getAttributes() != null) {
                Map<String, String> map2 = fieldType.getAttributes();
                Intrinsics.checkNotNull(map2);
                if (!map2.isEmpty()) {
                    Map<String, String> map3 = fieldType.getAttributes();
                    Intrinsics.checkNotNull(map3);
                    schema.updateAttributes(map3);
                }
            }
        }

        private final void verifyUnIndexedFieldType(String name, IndexableFieldType ft) {
            if (!(!ft.storeTermVectors())) {
                boolean $i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$52 = false;
                String $i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$52 = "cannot store term vectors for a field that is not indexed (field=\"" + name + "\")";
                throw new IllegalArgumentException($i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$52.toString());
            }
            if (!(!ft.storeTermVectorPositions())) {
                boolean $i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$62 = false;
                String $i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$62 = "cannot store term vector positions for a field that is not indexed (field=\"" + name + "\")";
                throw new IllegalArgumentException($i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$62.toString());
            }
            if (!(!ft.storeTermVectorOffsets())) {
                boolean $i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$72 = false;
                String $i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$72 = "cannot store term vector offsets for a field that is not indexed (field=\"" + name + "\")";
                throw new IllegalArgumentException($i$a$-require-IndexingChain$Companion$verifyUnIndexedFieldType$72.toString());
            }
            if (!(!ft.storeTermVectorPayloads())) {
                boolean bl = false;
                String string = "cannot store term vector payloads for a field that is not indexed (field=\"" + name + "\")";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final void validateMaxVectorDimension(String fieldName, int vectorDim, int maxVectorDim) {
            if (!(vectorDim <= maxVectorDim)) {
                boolean bl = false;
                String string = "Field [" + fieldName + "] vector's dimensions must be <= [" + maxVectorDim + "]; got " + vectorDim;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 a2\u00020\u0001:\u0001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020\u000fJ\u001e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\tJ1\u0010C\u001a\u00020D\"\f\b\u0000\u0010H*\u0006\u0012\u0002\b\u00030I2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u0002HH2\u0006\u0010G\u001a\u0002HH\u00a2\u0006\u0002\u0010JJ\u001e\u0010K\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\u0001J\u001a\u0010L\u001a\u00020D2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bJ\u001e\u0010\u001b\u001a\u00020D2\u0006\u0010N\u001a\u00020\u00182\u0006\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020\u000fJ\u0016\u0010Q\u001a\u00020D2\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020$J\u001e\u0010T\u001a\u00020D2\u0006\u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020\t2\u0006\u0010W\u001a\u00020\tJ\u001e\u0010X\u001a\u00020D2\u0006\u0010Y\u001a\u0002082\u0006\u0010Z\u001a\u00020>2\u0006\u0010[\u001a\u00020\tJ\u000e\u0010\\\u001a\u00020D2\u0006\u0010]\u001a\u00020\tJ\u000e\u0010^\u001a\u00020D2\u0006\u0010_\u001a\u00020`R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001a\u00101\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R\u001a\u00104\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010+\"\u0004\b6\u0010-R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006b"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain$FieldSchema;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "docID", "", "attributes", "", "getAttributes", "()Ljava/util/Map;", "omitNorms", "", "getOmitNorms", "()Z", "setOmitNorms", "(Z)V", "storeTermVector", "getStoreTermVector", "setStoreTermVector", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "getIndexOptions", "()Lorg/gnit/lucenekmp/index/IndexOptions;", "setIndexOptions", "(Lorg/gnit/lucenekmp/index/IndexOptions;)V", "docValuesType", "Lorg/gnit/lucenekmp/index/DocValuesType;", "getDocValuesType", "()Lorg/gnit/lucenekmp/index/DocValuesType;", "setDocValuesType", "(Lorg/gnit/lucenekmp/index/DocValuesType;)V", "docValuesSkipIndex", "Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "getDocValuesSkipIndex", "()Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "setDocValuesSkipIndex", "(Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;)V", "pointDimensionCount", "getPointDimensionCount", "()I", "setPointDimensionCount", "(I)V", "pointIndexDimensionCount", "getPointIndexDimensionCount", "setPointIndexDimensionCount", "pointNumBytes", "getPointNumBytes", "setPointNumBytes", "vectorDimension", "getVectorDimension", "setVectorDimension", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "getVectorEncoding", "()Lorg/gnit/lucenekmp/index/VectorEncoding;", "setVectorEncoding", "(Lorg/gnit/lucenekmp/index/VectorEncoding;)V", "vectorSimilarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "getVectorSimilarityFunction", "()Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "setVectorSimilarityFunction", "(Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;)V", "assertSame", "", "label", "expected", "given", "T", "", "(Ljava/lang/String;Ljava/lang/Enum;Ljava/lang/Enum;)V", "raiseNotSame", "updateAttributes", "attrs", "newIndexOptions", "newOmitNorms", "newStoreTermVector", "setDocValues", "newDocValuesType", "newDocValuesSkipIndex", "setPoints", "dimensionCount", "indexDimensionCount", "numBytes", "setVectors", "encoding", "similarityFunction", "dimension", "reset", "doc", "assertSameSchema", "fi", "Lorg/gnit/lucenekmp/index/FieldInfo;", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexingChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingChain.kt\norg/gnit/lucenekmp/index/IndexingChain$FieldSchema\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1654:1\n216#2,2:1655\n*S KotlinDebug\n*F\n+ 1 IndexingChain.kt\norg/gnit/lucenekmp/index/IndexingChain$FieldSchema\n*L\n1422#1:1655,2\n*E\n"})
    public static final class FieldSchema {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        private int docID;
        @NotNull
        private final Map<String, String> attributes;
        private boolean omitNorms;
        private boolean storeTermVector;
        @NotNull
        private IndexOptions indexOptions;
        @NotNull
        private DocValuesType docValuesType;
        @NotNull
        private DocValuesSkipIndexType docValuesSkipIndex;
        private int pointDimensionCount;
        private int pointIndexDimensionCount;
        private int pointNumBytes;
        private int vectorDimension;
        @NotNull
        private VectorEncoding vectorEncoding;
        @NotNull
        private VectorSimilarityFunction vectorSimilarityFunction;
        @NotNull
        private static final String errMsg = "Inconsistency of field data structures across documents for field ";

        public FieldSchema(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.attributes = new LinkedHashMap();
            this.indexOptions = IndexOptions.NONE;
            this.docValuesType = DocValuesType.NONE;
            this.docValuesSkipIndex = DocValuesSkipIndexType.NONE;
            this.vectorEncoding = VectorEncoding.FLOAT32;
            this.vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        public final boolean getOmitNorms() {
            return this.omitNorms;
        }

        public final void setOmitNorms(boolean bl) {
            this.omitNorms = bl;
        }

        public final boolean getStoreTermVector() {
            return this.storeTermVector;
        }

        public final void setStoreTermVector(boolean bl) {
            this.storeTermVector = bl;
        }

        @NotNull
        public final IndexOptions getIndexOptions() {
            return this.indexOptions;
        }

        public final void setIndexOptions(@NotNull IndexOptions indexOptions) {
            Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"<set-?>");
            this.indexOptions = indexOptions;
        }

        @NotNull
        public final DocValuesType getDocValuesType() {
            return this.docValuesType;
        }

        public final void setDocValuesType(@NotNull DocValuesType docValuesType) {
            Intrinsics.checkNotNullParameter((Object)((Object)docValuesType), (String)"<set-?>");
            this.docValuesType = docValuesType;
        }

        @NotNull
        public final DocValuesSkipIndexType getDocValuesSkipIndex() {
            return this.docValuesSkipIndex;
        }

        public final void setDocValuesSkipIndex(@NotNull DocValuesSkipIndexType docValuesSkipIndexType) {
            Intrinsics.checkNotNullParameter((Object)((Object)docValuesSkipIndexType), (String)"<set-?>");
            this.docValuesSkipIndex = docValuesSkipIndexType;
        }

        public final int getPointDimensionCount() {
            return this.pointDimensionCount;
        }

        public final void setPointDimensionCount(int n) {
            this.pointDimensionCount = n;
        }

        public final int getPointIndexDimensionCount() {
            return this.pointIndexDimensionCount;
        }

        public final void setPointIndexDimensionCount(int n) {
            this.pointIndexDimensionCount = n;
        }

        public final int getPointNumBytes() {
            return this.pointNumBytes;
        }

        public final void setPointNumBytes(int n) {
            this.pointNumBytes = n;
        }

        public final int getVectorDimension() {
            return this.vectorDimension;
        }

        public final void setVectorDimension(int n) {
            this.vectorDimension = n;
        }

        @NotNull
        public final VectorEncoding getVectorEncoding() {
            return this.vectorEncoding;
        }

        public final void setVectorEncoding(@NotNull VectorEncoding vectorEncoding) {
            Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"<set-?>");
            this.vectorEncoding = vectorEncoding;
        }

        @NotNull
        public final VectorSimilarityFunction getVectorSimilarityFunction() {
            return this.vectorSimilarityFunction;
        }

        public final void setVectorSimilarityFunction(@NotNull VectorSimilarityFunction vectorSimilarityFunction) {
            Intrinsics.checkNotNullParameter((Object)((Object)vectorSimilarityFunction), (String)"<set-?>");
            this.vectorSimilarityFunction = vectorSimilarityFunction;
        }

        public final void assertSame(@NotNull String label, boolean expected, boolean given) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            if (expected != given) {
                this.raiseNotSame(label, expected, given);
            }
        }

        public final void assertSame(@NotNull String label, int expected, int given) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            if (expected != given) {
                this.raiseNotSame(label, expected, given);
            }
        }

        public final <T extends Enum<?>> void assertSame(@NotNull String label, @NotNull T expected, @NotNull T given) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(expected, (String)"expected");
            Intrinsics.checkNotNullParameter(given, (String)"given");
            if (expected != given) {
                this.raiseNotSame(label, expected, given);
            }
        }

        public final void raiseNotSame(@NotNull String label, @NotNull Object expected, @NotNull Object given) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            Intrinsics.checkNotNullParameter((Object)given, (String)"given");
            throw new IllegalArgumentException("Inconsistency of field data structures across documents for field [" + this.name + "] of doc [" + this.docID + "]. " + label + ": expected '" + expected + "', but it has '" + given + "'.");
        }

        public final void updateAttributes(@NotNull Map<String, String> attrs) {
            Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
            Map<String, String> $this$forEach$iv = attrs;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator2.next();
                boolean bl = false;
                String k = entry.getKey();
                String v = entry.getValue();
                this.attributes.put(k, v);
            }
        }

        public final void setIndexOptions(@NotNull IndexOptions newIndexOptions, boolean newOmitNorms, boolean newStoreTermVector) {
            Intrinsics.checkNotNullParameter((Object)((Object)newIndexOptions), (String)"newIndexOptions");
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = newIndexOptions;
                this.omitNorms = newOmitNorms;
                this.storeTermVector = newStoreTermVector;
            } else {
                this.assertSame("index options", (Enum)this.indexOptions, (Enum)newIndexOptions);
                this.assertSame("omit norms", this.omitNorms, newOmitNorms);
                this.assertSame("store term vector", this.storeTermVector, newStoreTermVector);
            }
        }

        public final void setDocValues(@NotNull DocValuesType newDocValuesType, @NotNull DocValuesSkipIndexType newDocValuesSkipIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)newDocValuesType), (String)"newDocValuesType");
            Intrinsics.checkNotNullParameter((Object)((Object)newDocValuesSkipIndex), (String)"newDocValuesSkipIndex");
            if (this.docValuesType == DocValuesType.NONE) {
                this.docValuesType = newDocValuesType;
                this.docValuesSkipIndex = newDocValuesSkipIndex;
            } else {
                this.assertSame("doc values type", (Enum)this.docValuesType, (Enum)newDocValuesType);
                this.assertSame("doc values skip index type", (Enum)this.docValuesSkipIndex, (Enum)newDocValuesSkipIndex);
            }
        }

        public final void setPoints(int dimensionCount, int indexDimensionCount, int numBytes) {
            if (this.pointIndexDimensionCount == 0) {
                this.pointDimensionCount = dimensionCount;
                this.pointIndexDimensionCount = indexDimensionCount;
                this.pointNumBytes = numBytes;
            } else {
                this.assertSame("point dimension", this.pointDimensionCount, dimensionCount);
                this.assertSame("point index dimension", this.pointIndexDimensionCount, indexDimensionCount);
                this.assertSame("point num bytes", this.pointNumBytes, numBytes);
            }
        }

        public final void setVectors(@NotNull VectorEncoding encoding, @NotNull VectorSimilarityFunction similarityFunction, int dimension) {
            Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            if (this.vectorDimension == 0) {
                this.vectorEncoding = encoding;
                this.vectorSimilarityFunction = similarityFunction;
                this.vectorDimension = dimension;
            } else {
                this.assertSame("vector encoding", (Enum)this.vectorEncoding, (Enum)encoding);
                this.assertSame("vector similarity function", (Enum)this.vectorSimilarityFunction, (Enum)similarityFunction);
                this.assertSame("vector dimension", this.vectorDimension, dimension);
            }
        }

        public final void reset(int doc) {
            this.docID = doc;
            this.omitNorms = false;
            this.storeTermVector = false;
            this.indexOptions = IndexOptions.NONE;
            this.docValuesType = DocValuesType.NONE;
            this.pointDimensionCount = 0;
            this.pointIndexDimensionCount = 0;
            this.pointNumBytes = 0;
            this.vectorDimension = 0;
            this.vectorEncoding = VectorEncoding.FLOAT32;
            this.vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        }

        public final void assertSameSchema(@NotNull FieldInfo fi) {
            Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
            this.assertSame("index options", (Enum)fi.getIndexOptions(), (Enum)this.indexOptions);
            this.assertSame("omit norms", fi.omitsNorms(), this.omitNorms);
            this.assertSame("store term vector", fi.hasTermVectors(), this.storeTermVector);
            this.assertSame("doc values type", (Enum)fi.getDocValuesType(), (Enum)this.docValuesType);
            this.assertSame("doc values skip index type", (Enum)fi.docValuesSkipIndexType(), (Enum)this.docValuesSkipIndex);
            this.assertSame("vector similarity function", (Enum)fi.getVectorSimilarityFunction(), (Enum)this.vectorSimilarityFunction);
            this.assertSame("vector encoding", (Enum)fi.getVectorEncoding(), (Enum)this.vectorEncoding);
            this.assertSame("vector dimension", fi.getVectorDimension(), this.vectorDimension);
            this.assertSame("point dimension", fi.getPointDimensionCount(), this.pointDimensionCount);
            this.assertSame("point index dimension", fi.getPointIndexDimensionCount(), this.pointIndexDimensionCount);
            this.assertSame("point num bytes", fi.getPointNumBytes(), this.pointNumBytes);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain$FieldSchema$Companion;", "", "<init>", "()V", "errMsg", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain$IntBlockAllocator;", "Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/util/Counter;)V", "intBlock", "", "getIntBlock", "()[I", "recycleIntBlocks", "", "blocks", "", "offset", "", "length", "([[III)V", "core"})
    private static final class IntBlockAllocator
    extends IntBlockPool.Allocator {
        @NotNull
        private final Counter bytesUsed;

        public IntBlockAllocator(@NotNull Counter bytesUsed) {
            Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
            super(IntBlockPool.Companion.getINT_BLOCK_SIZE());
            this.bytesUsed = bytesUsed;
        }

        @Override
        @NotNull
        public int[] getIntBlock() {
            int[] b = new int[IntBlockPool.Companion.getINT_BLOCK_SIZE()];
            this.bytesUsed.addAndGet(IntBlockPool.Companion.getINT_BLOCK_SIZE() * 4);
            return b;
        }

        @Override
        public void recycleIntBlocks(@NotNull int[][] blocks, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            this.bytesUsed.addAndGet(-((long)(length * (IntBlockPool.Companion.getINT_BLOCK_SIZE() * 4))));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u0006J\u0006\u0010(\u001a\u00020^J\u0015\u0010`\u001a\u00020\u00062\n\u0010a\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002J\u000e\u0010b\u001a\u00020^2\u0006\u0010c\u001a\u00020\u0006J\u001e\u0010d\u001a\u00020^2\u0006\u0010c\u001a\u00020\u00062\u0006\u0010e\u001a\u00020f2\u0006\u0010Y\u001a\u00020\u0010J\u001e\u0010g\u001a\u00020^2\u0006\u0010c\u001a\u00020\u00062\u0006\u0010e\u001a\u00020f2\u0006\u0010Y\u001a\u00020\u0010J\u001e\u0010h\u001a\u00020^2\u0006\u0010c\u001a\u00020\u00062\u0006\u0010e\u001a\u00020f2\u0006\u0010Y\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R \u00100\u001a\b\u0012\u0002\b\u0003\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R \u0010<\u001a\b\u0012\u0002\b\u0003\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR \u0010H\u001a\b\u0018\u00010\u0000R\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001c\u0010M\u001a\u0004\u0018\u00010NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001c\u0010S\u001a\u0004\u0018\u00010TX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u001a\u0010Y\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u001c\"\u0004\b[\u0010\\\u00a8\u0006i"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain$PerField;", "", "Lorg/gnit/lucenekmp/index/IndexingChain;", "fieldName", "", "indexCreatedVersionMajor", "", "schema", "Lorg/gnit/lucenekmp/index/IndexingChain$FieldSchema;", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "reserved", "", "<init>", "(Lorg/gnit/lucenekmp/index/IndexingChain;Ljava/lang/String;ILorg/gnit/lucenekmp/index/IndexingChain$FieldSchema;Lorg/gnit/lucenekmp/search/similarities/Similarity;Lorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/analysis/Analyzer;Z)V", "getFieldName", "()Ljava/lang/String;", "getIndexCreatedVersionMajor", "()I", "getSchema", "()Lorg/gnit/lucenekmp/index/IndexingChain$FieldSchema;", "getSimilarity", "()Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getReserved", "()Z", "value", "Lorg/gnit/lucenekmp/index/FieldInfo;", "fieldInfo", "getFieldInfo", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "setFieldInfo", "(Lorg/gnit/lucenekmp/index/FieldInfo;)V", "invertState", "Lorg/gnit/lucenekmp/index/FieldInvertState;", "getInvertState", "()Lorg/gnit/lucenekmp/index/FieldInvertState;", "setInvertState", "(Lorg/gnit/lucenekmp/index/FieldInvertState;)V", "termsHashPerField", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "getTermsHashPerField", "()Lorg/gnit/lucenekmp/index/TermsHashPerField;", "setTermsHashPerField", "(Lorg/gnit/lucenekmp/index/TermsHashPerField;)V", "docValuesWriter", "Lorg/gnit/lucenekmp/index/DocValuesWriter;", "getDocValuesWriter", "()Lorg/gnit/lucenekmp/index/DocValuesWriter;", "setDocValuesWriter", "(Lorg/gnit/lucenekmp/index/DocValuesWriter;)V", "pointValuesWriter", "Lorg/gnit/lucenekmp/index/PointValuesWriter;", "getPointValuesWriter", "()Lorg/gnit/lucenekmp/index/PointValuesWriter;", "setPointValuesWriter", "(Lorg/gnit/lucenekmp/index/PointValuesWriter;)V", "knnFieldVectorsWriter", "Lorg/gnit/lucenekmp/codecs/KnnFieldVectorsWriter;", "getKnnFieldVectorsWriter", "()Lorg/gnit/lucenekmp/codecs/KnnFieldVectorsWriter;", "setKnnFieldVectorsWriter", "(Lorg/gnit/lucenekmp/codecs/KnnFieldVectorsWriter;)V", "fieldGen", "", "getFieldGen", "()J", "setFieldGen", "(J)V", "next", "getNext", "()Lorg/gnit/lucenekmp/index/IndexingChain$PerField;", "setNext", "(Lorg/gnit/lucenekmp/index/IndexingChain$PerField;)V", "norms", "Lorg/gnit/lucenekmp/index/NormValuesWriter;", "getNorms", "()Lorg/gnit/lucenekmp/index/NormValuesWriter;", "setNorms", "(Lorg/gnit/lucenekmp/index/NormValuesWriter;)V", "tokenStream", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "getTokenStream", "()Lorg/gnit/lucenekmp/analysis/TokenStream;", "setTokenStream", "(Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "first", "getFirst", "setFirst", "(Z)V", "reset", "", "docId", "compareTo", "other", "finish", "docID", "invert", "field", "Lorg/gnit/lucenekmp/index/IndexableField;", "invertTokenStream", "invertTerm", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexingChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexingChain.kt\norg/gnit/lucenekmp/index/IndexingChain$PerField\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1654:1\n3#2,8:1655\n3#2,8:1664\n3#2,8:1674\n10#3:1663\n10#3:1672\n10#3:1682\n1#4:1673\n*S KotlinDebug\n*F\n+ 1 IndexingChain.kt\norg/gnit/lucenekmp/index/IndexingChain$PerField\n*L\n1047#1:1655,8\n1089#1:1664,8\n1127#1:1674,8\n1047#1:1663\n1089#1:1672\n1127#1:1682\n*E\n"})
    private final class PerField
    implements Comparable<PerField> {
        @NotNull
        private final String fieldName;
        private final int indexCreatedVersionMajor;
        @NotNull
        private final FieldSchema schema;
        @NotNull
        private final Similarity similarity;
        @NotNull
        private final InfoStream infoStream;
        @NotNull
        private final Analyzer analyzer;
        private final boolean reserved;
        @Nullable
        private FieldInfo fieldInfo;
        @Nullable
        private FieldInvertState invertState;
        @Nullable
        private TermsHashPerField termsHashPerField;
        @Nullable
        private DocValuesWriter<?> docValuesWriter;
        @Nullable
        private PointValuesWriter pointValuesWriter;
        @Nullable
        private KnnFieldVectorsWriter<?> knnFieldVectorsWriter;
        private long fieldGen;
        @Nullable
        private PerField next;
        @Nullable
        private NormValuesWriter norms;
        @Nullable
        private TokenStream tokenStream;
        private boolean first;

        public PerField(String fieldName, @NotNull int indexCreatedVersionMajor, @NotNull FieldSchema schema, @NotNull Similarity similarity, @NotNull InfoStream infoStream, Analyzer analyzer, boolean reserved) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)similarity, (String)"similarity");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            this.fieldName = fieldName;
            this.indexCreatedVersionMajor = indexCreatedVersionMajor;
            this.schema = schema;
            this.similarity = similarity;
            this.infoStream = infoStream;
            this.analyzer = analyzer;
            this.reserved = reserved;
            this.fieldGen = -1L;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        public final int getIndexCreatedVersionMajor() {
            return this.indexCreatedVersionMajor;
        }

        @NotNull
        public final FieldSchema getSchema() {
            return this.schema;
        }

        @NotNull
        public final Similarity getSimilarity() {
            return this.similarity;
        }

        public final boolean getReserved() {
            return this.reserved;
        }

        @Nullable
        public final FieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        public final void setFieldInfo(@Nullable FieldInfo value) {
            boolean condition$iv = this.fieldInfo == null;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.fieldInfo = value;
        }

        @Nullable
        public final FieldInvertState getInvertState() {
            return this.invertState;
        }

        public final void setInvertState(@Nullable FieldInvertState fieldInvertState) {
            this.invertState = fieldInvertState;
        }

        @Nullable
        public final TermsHashPerField getTermsHashPerField() {
            return this.termsHashPerField;
        }

        public final void setTermsHashPerField(@Nullable TermsHashPerField termsHashPerField) {
            this.termsHashPerField = termsHashPerField;
        }

        @Nullable
        public final DocValuesWriter<?> getDocValuesWriter() {
            return this.docValuesWriter;
        }

        public final void setDocValuesWriter(@Nullable DocValuesWriter<?> docValuesWriter) {
            this.docValuesWriter = docValuesWriter;
        }

        @Nullable
        public final PointValuesWriter getPointValuesWriter() {
            return this.pointValuesWriter;
        }

        public final void setPointValuesWriter(@Nullable PointValuesWriter pointValuesWriter) {
            this.pointValuesWriter = pointValuesWriter;
        }

        @Nullable
        public final KnnFieldVectorsWriter<?> getKnnFieldVectorsWriter() {
            return this.knnFieldVectorsWriter;
        }

        public final void setKnnFieldVectorsWriter(@Nullable KnnFieldVectorsWriter<?> knnFieldVectorsWriter) {
            this.knnFieldVectorsWriter = knnFieldVectorsWriter;
        }

        public final long getFieldGen() {
            return this.fieldGen;
        }

        public final void setFieldGen(long l) {
            this.fieldGen = l;
        }

        @Nullable
        public final PerField getNext() {
            return this.next;
        }

        public final void setNext(@Nullable PerField perField) {
            this.next = perField;
        }

        @Nullable
        public final NormValuesWriter getNorms() {
            return this.norms;
        }

        public final void setNorms(@Nullable NormValuesWriter normValuesWriter) {
            this.norms = normValuesWriter;
        }

        @Nullable
        public final TokenStream getTokenStream() {
            return this.tokenStream;
        }

        public final void setTokenStream(@Nullable TokenStream tokenStream) {
            this.tokenStream = tokenStream;
        }

        public final boolean getFirst() {
            return this.first;
        }

        public final void setFirst(boolean bl) {
            this.first = bl;
        }

        public final void reset(int docId) {
            this.first = true;
            this.schema.reset(docId);
        }

        public final void setInvertState() {
            FieldInfo fieldInfo = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo);
            String string = fieldInfo.getName();
            FieldInfo fieldInfo2 = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo2);
            this.invertState = new FieldInvertState(this.indexCreatedVersionMajor, string, fieldInfo2.getIndexOptions());
            TermsHash termsHash = IndexingChain.this.getTermsHash();
            FieldInvertState fieldInvertState = this.invertState;
            Intrinsics.checkNotNull((Object)fieldInvertState);
            FieldInfo fieldInfo3 = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo3);
            this.termsHashPerField = termsHash.addField(fieldInvertState, fieldInfo3);
            FieldInfo fieldInfo4 = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo4);
            if (!fieldInfo4.omitsNorms()) {
                boolean condition$iv = this.norms == null;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string2 = "assertion failed";
                    throw new AssertionError((Object)string2);
                }
                FieldInfo fieldInfo5 = this.fieldInfo;
                Intrinsics.checkNotNull((Object)fieldInfo5);
                this.norms = new NormValuesWriter(fieldInfo5, IndexingChain.this.getBytesUsed());
            }
            FieldInfo fieldInfo6 = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo6);
            if (fieldInfo6.hasTermVectors()) {
                IndexingChain.this.getTermVectorsWriter().setHasVectors();
            }
        }

        @Override
        public int compareTo(@NotNull PerField other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.fieldName.compareTo(other.fieldName);
        }

        public final void finish(int docID) throws IOException {
            FieldInfo fieldInfo = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo);
            if (!fieldInfo.omitsNorms()) {
                long normValue = 0L;
                FieldInvertState fieldInvertState = this.invertState;
                Intrinsics.checkNotNull((Object)fieldInvertState);
                if (fieldInvertState.getLength() == 0) {
                    normValue = 0L;
                } else {
                    FieldInvertState fieldInvertState2 = this.invertState;
                    Intrinsics.checkNotNull((Object)fieldInvertState2);
                    normValue = this.similarity.computeNorm(fieldInvertState2);
                    if (!(normValue != 0L)) {
                        boolean bl = false;
                        String string = "Similarity " + this.similarity + " return 0 for non-empty field";
                        throw new IllegalStateException(string.toString());
                    }
                }
                NormValuesWriter normValuesWriter = this.norms;
                Intrinsics.checkNotNull((Object)normValuesWriter);
                normValuesWriter.addValue(docID, normValue);
            }
            TermsHashPerField termsHashPerField = this.termsHashPerField;
            Intrinsics.checkNotNull((Object)termsHashPerField);
            termsHashPerField.finish();
        }

        public final void invert(int docID, @NotNull IndexableField field, boolean first) throws IOException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            boolean condition$iv = field.fieldType().indexOptions().compareTo((Enum)IndexOptions.DOCS) >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            if (first) {
                FieldInvertState fieldInvertState = this.invertState;
                Intrinsics.checkNotNull((Object)fieldInvertState);
                fieldInvertState.reset();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[field.invertableType().ordinal()]) {
                case 1: {
                    this.invertTerm(docID, field, first);
                    break;
                }
                case 2: {
                    this.invertTokenStream(docID, field, first);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void invertTokenStream(int docID, @NotNull IndexableField field, boolean first) throws IOException {
            Object object;
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            boolean analyzed = field.fieldType().tokenized() && this.analyzer != null;
            boolean succeededInProcessingField = false;
            try {
                object = field.tokenStream(this.analyzer, this.tokenStream);
                TokenStream it = object;
                boolean bl = false;
                this.tokenStream = it;
                object = (AutoCloseable)object;
                IndexingChain indexingChain = IndexingChain.this;
                Throwable throwable = null;
                try {
                    AutoCloseable stream = object;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable = stream;
                    Intrinsics.checkNotNull((Object)autoCloseable);
                    ((TokenStream)autoCloseable).reset();
                    FieldInvertState fieldInvertState = this.invertState;
                    Intrinsics.checkNotNull((Object)fieldInvertState);
                    fieldInvertState.setAttributeSource((AttributeSource)((Object)stream));
                    TermsHashPerField termsHashPerField = this.termsHashPerField;
                    Intrinsics.checkNotNull((Object)termsHashPerField);
                    termsHashPerField.start(field, first);
                    while (((TokenStream)stream).incrementToken()) {
                        int $i$a$-require-IndexingChain$PerField$invertTokenStream$2$72;
                        FieldInvertState fieldInvertState2;
                        FieldInvertState fieldInvertState3 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState3);
                        PositionIncrementAttribute positionIncrementAttribute = fieldInvertState3.getPosIncrAttribute();
                        Intrinsics.checkNotNull((Object)positionIncrementAttribute);
                        int posIncr = positionIncrementAttribute.getPositionIncrement();
                        Intrinsics.checkNotNull((Object)this.invertState);
                        fieldInvertState2.setPosition(fieldInvertState2.getPosition() + posIncr);
                        FieldInvertState fieldInvertState4 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState4);
                        int n = fieldInvertState4.getPosition();
                        FieldInvertState fieldInvertState5 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState5);
                        if (n < fieldInvertState5.getLastPosition()) {
                            if (!(posIncr != 0)) {
                                boolean $i$a$-require-IndexingChain$PerField$invertTokenStream$2$52 = false;
                                String $i$a$-require-IndexingChain$PerField$invertTokenStream$2$52 = "first position increment must be > 0 (got 0) for field '" + field.name() + "'";
                                throw new IllegalArgumentException($i$a$-require-IndexingChain$PerField$invertTokenStream$2$52.toString());
                            }
                            if (!(posIncr >= 0)) {
                                boolean $i$a$-require-IndexingChain$PerField$invertTokenStream$2$62 = false;
                                String $i$a$-require-IndexingChain$PerField$invertTokenStream$2$62 = "position increment must be >= 0 (got " + posIncr + ") for field '" + field.name() + "'";
                                throw new IllegalArgumentException($i$a$-require-IndexingChain$PerField$invertTokenStream$2$62.toString());
                            }
                            FieldInvertState fieldInvertState6 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState6);
                            int n2 = fieldInvertState6.getLastPosition();
                            FieldInvertState fieldInvertState7 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState7);
                            throw new IllegalArgumentException("position overflowed Integer.MAX_VALUE (got posIncr=" + posIncr + " lastPosition=" + n2 + " position=" + fieldInvertState7.getPosition() + ") for field '" + field.name() + "'");
                        }
                        FieldInvertState fieldInvertState8 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState8);
                        if (!(fieldInvertState8.getPosition() <= 0x7FFFFF7F)) {
                            $i$a$-require-IndexingChain$PerField$invertTokenStream$2$72 = 0;
                            FieldInvertState fieldInvertState9 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState9);
                            String $i$a$-require-IndexingChain$PerField$invertTokenStream$2$72 = "position " + fieldInvertState9.getPosition() + " is too large for field '" + field.name() + "': max allowed position is 2147483519";
                            throw new IllegalArgumentException($i$a$-require-IndexingChain$PerField$invertTokenStream$2$72.toString());
                        }
                        FieldInvertState fieldInvertState10 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState10);
                        FieldInvertState fieldInvertState11 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState11);
                        fieldInvertState10.setLastPosition(fieldInvertState11.getPosition());
                        if (posIncr == 0) {
                            FieldInvertState fieldInvertState12 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState12);
                            fieldInvertState2 = fieldInvertState12;
                            $i$a$-require-IndexingChain$PerField$invertTokenStream$2$72 = fieldInvertState2.getNumOverlap();
                            fieldInvertState2.setNumOverlap($i$a$-require-IndexingChain$PerField$invertTokenStream$2$72 + 1);
                        }
                        FieldInvertState fieldInvertState13 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState13);
                        int n3 = fieldInvertState13.getOffset();
                        FieldInvertState fieldInvertState14 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState14);
                        OffsetAttribute offsetAttribute = fieldInvertState14.getOffsetAttribute();
                        Intrinsics.checkNotNull((Object)offsetAttribute);
                        int startOffset = n3 + offsetAttribute.startOffset();
                        FieldInvertState fieldInvertState15 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState15);
                        int n4 = fieldInvertState15.getOffset();
                        FieldInvertState fieldInvertState16 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState16);
                        OffsetAttribute offsetAttribute2 = fieldInvertState16.getOffsetAttribute();
                        Intrinsics.checkNotNull((Object)offsetAttribute2);
                        int endOffset = n4 + offsetAttribute2.endOffset();
                        FieldInvertState fieldInvertState17 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState17);
                        if (!(startOffset >= fieldInvertState17.getLastStartOffset() && endOffset >= startOffset)) {
                            boolean $i$a$-require-IndexingChain$PerField$invertTokenStream$2$82 = false;
                            FieldInvertState fieldInvertState18 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState18);
                            String $i$a$-require-IndexingChain$PerField$invertTokenStream$2$82 = "startOffset must be non-negative, and endOffset must be >= startOffset, and offsets must not go backwards startOffset=" + startOffset + ",endOffset=" + endOffset + ",lastStartOffset=" + fieldInvertState18.getLastStartOffset() + " for field '" + field.name() + "'";
                            throw new IllegalArgumentException($i$a$-require-IndexingChain$PerField$invertTokenStream$2$82.toString());
                        }
                        FieldInvertState fieldInvertState19 = this.invertState;
                        Intrinsics.checkNotNull((Object)fieldInvertState19);
                        fieldInvertState19.setLastStartOffset(startOffset);
                        try {
                            FieldInvertState fieldInvertState20 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState20);
                            FieldInvertState fieldInvertState21 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState21);
                            int n5 = fieldInvertState21.getLength();
                            FieldInvertState fieldInvertState22 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState22);
                            TermFrequencyAttribute termFrequencyAttribute = fieldInvertState22.getTermFreqAttribute();
                            Intrinsics.checkNotNull((Object)termFrequencyAttribute);
                            fieldInvertState20.setLength(Math.INSTANCE.addExact(n5, termFrequencyAttribute.getTermFrequency()));
                        }
                        catch (ArithmeticException ae) {
                            throw new IllegalArgumentException("too many tokens for field \"" + field.name() + "\"", ae);
                        }
                        try {
                            TermsHashPerField termsHashPerField2 = this.termsHashPerField;
                            Intrinsics.checkNotNull((Object)termsHashPerField2);
                            FieldInvertState fieldInvertState23 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState23);
                            TermToBytesRefAttribute termToBytesRefAttribute = fieldInvertState23.getTermAttribute();
                            Intrinsics.checkNotNull((Object)termToBytesRefAttribute);
                            termsHashPerField2.add(termToBytesRefAttribute.getBytesRef(), docID);
                        }
                        catch (BytesRefHash.MaxBytesLengthExceededException e) {
                            byte[] prefix = new byte[30];
                            FieldInvertState fieldInvertState24 = this.invertState;
                            Intrinsics.checkNotNull((Object)fieldInvertState24);
                            TermToBytesRefAttribute termToBytesRefAttribute = fieldInvertState24.getTermAttribute();
                            Intrinsics.checkNotNull((Object)termToBytesRefAttribute);
                            BytesRef bigTerm = termToBytesRefAttribute.getBytesRef();
                            System.INSTANCE.arraycopy(bigTerm.getBytes(), bigTerm.getOffset(), prefix, 0, 30);
                            FieldInfo fieldInfo = this.fieldInfo;
                            Intrinsics.checkNotNull((Object)fieldInfo);
                            String string = fieldInfo.getName();
                            String string2 = Arrays.toString(prefix);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                            String msg = "Document contains at least one immense term in field=\"" + string + "\" (whose UTF8 encoding is longer than the max length 32766), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + string2 + "...', original message: " + e.getMessage();
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "ERROR: " + msg);
                            }
                            throw new IllegalArgumentException(msg, e);
                        }
                        catch (Throwable th) {
                            indexingChain.onAbortingException(th);
                            throw th;
                        }
                    }
                    ((TokenStream)stream).end();
                    FieldInvertState fieldInvertState25 = this.invertState;
                    Intrinsics.checkNotNull((Object)fieldInvertState25);
                    FieldInvertState fieldInvertState26 = fieldInvertState25;
                    int n = fieldInvertState26.getPosition();
                    FieldInvertState fieldInvertState27 = this.invertState;
                    Intrinsics.checkNotNull((Object)fieldInvertState27);
                    PositionIncrementAttribute positionIncrementAttribute = fieldInvertState27.getPosIncrAttribute();
                    Intrinsics.checkNotNull((Object)positionIncrementAttribute);
                    fieldInvertState26.setPosition(n + positionIncrementAttribute.getPositionIncrement());
                    FieldInvertState fieldInvertState28 = this.invertState;
                    Intrinsics.checkNotNull((Object)fieldInvertState28);
                    fieldInvertState26 = fieldInvertState28;
                    int n6 = fieldInvertState26.getOffset();
                    FieldInvertState fieldInvertState29 = this.invertState;
                    Intrinsics.checkNotNull((Object)fieldInvertState29);
                    OffsetAttribute offsetAttribute = fieldInvertState29.getOffsetAttribute();
                    Intrinsics.checkNotNull((Object)offsetAttribute);
                    fieldInvertState26.setOffset(n6 + offsetAttribute.endOffset());
                    succeededInProcessingField = true;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
                if (!succeededInProcessingField && this.infoStream.isEnabled("DW")) {
                    FieldInfo fieldInfo = this.fieldInfo;
                    Intrinsics.checkNotNull((Object)fieldInfo);
                    this.infoStream.message("DW", "An exception was thrown while processing field " + fieldInfo.getName());
                }
                throw throwable;
            }
            if (analyzed) {
                FieldInvertState fieldInvertState = this.invertState;
                Intrinsics.checkNotNull((Object)fieldInvertState);
                object = fieldInvertState;
                int n = ((FieldInvertState)object).getPosition();
                FieldInfo fieldInfo = this.fieldInfo;
                Intrinsics.checkNotNull((Object)fieldInfo);
                ((FieldInvertState)object).setPosition(n + this.analyzer.getPositionIncrementGap(fieldInfo.getName()));
                FieldInvertState fieldInvertState30 = this.invertState;
                Intrinsics.checkNotNull((Object)fieldInvertState30);
                object = fieldInvertState30;
                int n7 = ((FieldInvertState)object).getOffset();
                FieldInfo fieldInfo2 = this.fieldInfo;
                Intrinsics.checkNotNull((Object)fieldInfo2);
                ((FieldInvertState)object).setOffset(n7 + this.analyzer.getOffsetGap(fieldInfo2.getName()));
            }
        }

        public final void invertTerm(int docID, @NotNull IndexableField field, boolean first) throws IOException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            BytesRef binaryValue = field.binaryValue();
            if (binaryValue == null) {
                boolean $i$a$-requireNotNull-IndexingChain$PerField$invertTerm$22 = false;
                String $i$a$-requireNotNull-IndexingChain$PerField$invertTerm$22 = "Field " + field.name() + " returns TERM for invertableType() and null for binaryValue(), which is illegal";
                throw new IllegalArgumentException($i$a$-requireNotNull-IndexingChain$PerField$invertTerm$22.toString());
            }
            IndexableFieldType fieldType = field.fieldType();
            if (!(!fieldType.tokenized() && fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0 && !fieldType.storeTermVectorPositions() && !fieldType.storeTermVectorOffsets() && !fieldType.storeTermVectorPayloads())) {
                boolean $i$a$-require-IndexingChain$PerField$invertTerm$32 = false;
                String $i$a$-require-IndexingChain$PerField$invertTerm$32 = "Fields that are tokenized or index proximity data must produce a non-null TokenStream, but " + field.name() + " did not";
                throw new IllegalArgumentException($i$a$-require-IndexingChain$PerField$invertTerm$32.toString());
            }
            FieldInvertState fieldInvertState = this.invertState;
            Intrinsics.checkNotNull((Object)fieldInvertState);
            fieldInvertState.setAttributeSource(null);
            FieldInvertState fieldInvertState2 = this.invertState;
            Intrinsics.checkNotNull((Object)fieldInvertState2);
            FieldInvertState fieldInvertState3 = fieldInvertState2;
            int $i$a$-require-IndexingChain$PerField$invertTerm$32 = fieldInvertState3.getPosition();
            fieldInvertState3.setPosition($i$a$-require-IndexingChain$PerField$invertTerm$32 + 1);
            FieldInvertState fieldInvertState4 = this.invertState;
            Intrinsics.checkNotNull((Object)fieldInvertState4);
            fieldInvertState3 = fieldInvertState4;
            $i$a$-require-IndexingChain$PerField$invertTerm$32 = fieldInvertState3.getLength();
            fieldInvertState3.setLength($i$a$-require-IndexingChain$PerField$invertTerm$32 + 1);
            TermsHashPerField termsHashPerField = this.termsHashPerField;
            Intrinsics.checkNotNull((Object)termsHashPerField);
            termsHashPerField.start(field, first);
            FieldInvertState fieldInvertState5 = this.invertState;
            Intrinsics.checkNotNull((Object)fieldInvertState5);
            FieldInvertState fieldInvertState6 = this.invertState;
            Intrinsics.checkNotNull((Object)fieldInvertState6);
            fieldInvertState5.setLength(Math.INSTANCE.addExact(fieldInvertState6.getLength(), 1));
            try {
                TermsHashPerField termsHashPerField2 = this.termsHashPerField;
                Intrinsics.checkNotNull((Object)termsHashPerField2);
                termsHashPerField2.add(binaryValue, docID);
            }
            catch (BytesRefHash.MaxBytesLengthExceededException e) {
                byte[] prefix = new byte[30];
                System.INSTANCE.arraycopy(binaryValue.getBytes(), binaryValue.getOffset(), prefix, 0, 30);
                FieldInfo fieldInfo = this.fieldInfo;
                Intrinsics.checkNotNull((Object)fieldInfo);
                String string = fieldInfo.getName();
                String string2 = Arrays.toString(prefix);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String msg = "Document contains at least one immense term in field=\"" + string + "\" (whose length is longer than the max length 32766), all of which were skipped. The prefix of the first immense term is: '" + string2 + "...'";
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "ERROR: " + msg);
                }
                throw new IllegalArgumentException(msg, e);
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[InvertableType.values().length];
                try {
                    nArray[InvertableType.BINARY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InvertableType.TOKEN_STREAM.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/index/IndexingChain$ReservedField;", "T", "Lorg/gnit/lucenekmp/index/IndexableField;", "delegate", "<init>", "(Lorg/gnit/lucenekmp/index/IndexableField;)V", "getDelegate", "()Lorg/gnit/lucenekmp/index/IndexableField;", "Lorg/gnit/lucenekmp/index/IndexableField;", "name", "", "fieldType", "Lorg/gnit/lucenekmp/index/IndexableFieldType;", "tokenStream", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "reuse", "binaryValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "stringValue", "charSequenceValue", "", "getCharSequenceValue", "()Ljava/lang/CharSequence;", "readerValue", "Lorg/gnit/lucenekmp/jdkport/Reader;", "numericValue", "", "storedValue", "Lorg/gnit/lucenekmp/document/StoredValue;", "invertableType", "Lorg/gnit/lucenekmp/document/InvertableType;", "core"})
    public static final class ReservedField<T extends IndexableField>
    implements IndexableField {
        @NotNull
        private final T delegate;

        public ReservedField(@NotNull T delegate) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public final T getDelegate() {
            return this.delegate;
        }

        @Override
        @NotNull
        public String name() {
            return this.delegate.name();
        }

        @Override
        @NotNull
        public IndexableFieldType fieldType() {
            return this.delegate.fieldType();
        }

        @Override
        @NotNull
        public TokenStream tokenStream(@NotNull Analyzer analyzer, @Nullable TokenStream reuse) {
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            TokenStream tokenStream = this.delegate.tokenStream(analyzer, reuse);
            Intrinsics.checkNotNull((Object)tokenStream);
            return tokenStream;
        }

        @Override
        @NotNull
        public BytesRef binaryValue() {
            BytesRef bytesRef = this.delegate.binaryValue();
            Intrinsics.checkNotNull((Object)bytesRef);
            return bytesRef;
        }

        @Override
        @NotNull
        public String stringValue() {
            String string = this.delegate.stringValue();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        public CharSequence getCharSequenceValue() {
            CharSequence charSequence = this.delegate.getCharSequenceValue();
            Intrinsics.checkNotNull((Object)charSequence);
            return charSequence;
        }

        @Override
        @NotNull
        public Reader readerValue() {
            Reader reader2 = this.delegate.readerValue();
            Intrinsics.checkNotNull((Object)reader2);
            return reader2;
        }

        @Override
        @NotNull
        public Number numericValue() {
            Number number = this.delegate.numericValue();
            Intrinsics.checkNotNull((Object)number);
            return number;
        }

        @Override
        @NotNull
        public StoredValue storedValue() {
            StoredValue storedValue = this.delegate.storedValue();
            Intrinsics.checkNotNull((Object)storedValue);
            return storedValue;
        }

        @Override
        @NotNull
        public InvertableType invertableType() {
            return this.delegate.invertableType();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DocValuesType.values().length];
            try {
                nArray[DocValuesType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocValuesType.NUMERIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocValuesType.BINARY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocValuesType.SORTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocValuesType.SORTED_NUMERIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocValuesType.SORTED_SET.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VectorEncoding.values().length];
            try {
                nArray[VectorEncoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

