/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.MergeTrigger;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfos;
import org.gnit.lucenekmp.index.SegmentReader;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.ExecutionException;
import org.gnit.lucenekmp.jdkport.Executor;
import org.gnit.lucenekmp.jdkport.Optional;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.jdkport.TimeoutException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.MergeInfo;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.IOConsumer;
import org.gnit.lucenekmp.util.IOFunction;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.ThreadInterruptedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 D2\u00020\u0001:\b=>?@ABCDB\u001d\b\u0004\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J!\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ6\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\u0006\u0010\u0016\u001a\u00020\u0017H&J\u001a\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\"\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010*\u001a\u00020\u0005H\u0016J\u0018\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020!H\u0004J \u0010-\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010)\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0016\u00102\u001a\u00020\"2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a04H\u0016J&\u00105\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020!2\u0006\u0010,\u001a\u00020\u001e2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a04H\u0016J\u001e\u00107\u001a\u0002082\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!09H\u0004J\u0018\u0010:\u001a\u00020;2\u0006\u0010:\u001a\u0002082\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010<\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010/\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\r\"\u0004\b1\u0010\u000f\u00a8\u0006E"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy;", "", "noCFSRatio", "", "maxCFSSegmentSize", "", "<init>", "(DJ)V", "getMaxCFSSegmentSize", "()J", "setMaxCFSSegmentSize", "(J)V", "getNoCFSRatio", "()D", "setNoCFSRatio", "(D)V", "findMerges", "Lorg/gnit/lucenekmp/index/MergePolicy$MergeSpecification;", "mergeTrigger", "Lorg/gnit/lucenekmp/index/MergeTrigger;", "segmentInfos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "mergeContext", "Lorg/gnit/lucenekmp/index/MergePolicy$MergeContext;", "readers", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "([Lorg/gnit/lucenekmp/index/CodecReader;)Lorg/gnit/lucenekmp/index/MergePolicy$MergeSpecification;", "findForcedMerges", "maxSegmentCount", "", "segmentsToMerge", "", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "", "findForcedDeletesMerges", "findFullFlushMerges", "useCompoundFile", "infos", "mergedInfo", "size", "info", "maxFullFlushMergeSize", "assertDelCount", "delCount", "isMerged", "v", "maxCFSSegmentSizeMB", "getMaxCFSSegmentSizeMB", "setMaxCFSSegmentSizeMB", "keepFullyDeletedSegment", "readerIOSupplier", "Lorg/gnit/lucenekmp/util/IOSupplier;", "numDeletesToMerge", "readerSupplier", "segString", "", "", "message", "", "verbose", "OneMergeProgress", "OneMerge", "MergeSpecification", "MergeException", "MergeAbortedException", "MergeContext", "MergeReader", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMergePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergePolicy.kt\norg/gnit/lucenekmp/index/MergePolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,956:1\n1#2:957\n3#3,8:958\n3#3,8:967\n8#3,2:976\n8#3,2:978\n3#3,8:980\n10#4:966\n10#4:975\n10#4:988\n*S KotlinDebug\n*F\n+ 1 MergePolicy.kt\norg/gnit/lucenekmp/index/MergePolicy\n*L\n777#1:958,8\n780#1:967,8\n794#1:976,2\n795#1:978,2\n813#1:980,8\n777#1:966\n780#1:975\n813#1:988\n*E\n"})
public abstract class MergePolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long maxCFSSegmentSize;
    private double noCFSRatio;
    protected static final double DEFAULT_NO_CFS_RATIO = 1.0;
    protected static final long DEFAULT_MAX_CFS_SEGMENT_SIZE = Long.MAX_VALUE;

    protected MergePolicy(double noCFSRatio, long maxCFSSegmentSize) {
        this.maxCFSSegmentSize = maxCFSSegmentSize;
        this.noCFSRatio = noCFSRatio;
    }

    public /* synthetic */ MergePolicy(double d, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        if ((n & 2) != 0) {
            l = Long.MAX_VALUE;
        }
        this(d, l);
    }

    protected final long getMaxCFSSegmentSize() {
        return this.maxCFSSegmentSize;
    }

    protected final void setMaxCFSSegmentSize(long l) {
        this.maxCFSSegmentSize = l;
    }

    public double getNoCFSRatio() {
        return this.noCFSRatio;
    }

    public void setNoCFSRatio(double noCFSRatio) {
        if (!(!(noCFSRatio < 0.0) && !(noCFSRatio > 1.0))) {
            boolean bl = false;
            String string = "noCFSRatio must be 0.0 to 1.0 inclusive; got " + noCFSRatio;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public abstract MergeSpecification findMerges(@NotNull MergeTrigger var1, @NotNull SegmentInfos var2, @NotNull MergeContext var3) throws IOException;

    @NotNull
    public MergeSpecification findMerges(CodecReader ... readers) throws IOException {
        Intrinsics.checkNotNullParameter((Object)readers, (String)"readers");
        MergeSpecification mergeSpec = new MergeSpecification();
        mergeSpec.add(new OneMerge(Arrays.copyOf(readers, readers.length)));
        return mergeSpec;
    }

    @Nullable
    public abstract MergeSpecification findForcedMerges(@NotNull SegmentInfos var1, int var2, @NotNull Map<SegmentCommitInfo, Boolean> var3, @NotNull MergeContext var4) throws IOException;

    @Nullable
    public abstract MergeSpecification findForcedDeletesMerges(@NotNull SegmentInfos var1, @NotNull MergeContext var2) throws IOException;

    @Nullable
    public MergeSpecification findFullFlushMerges(@NotNull MergeTrigger mergeTrigger, @NotNull SegmentInfos segmentInfos, @NotNull MergeContext mergeContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)mergeTrigger), (String)"mergeTrigger");
        Intrinsics.checkNotNullParameter((Object)segmentInfos, (String)"segmentInfos");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        MergeSpecification mergeSpec = this.findMerges(mergeTrigger, segmentInfos, mergeContext);
        if (mergeSpec == null) {
            return null;
        }
        MergeSpecification newMergeSpec = null;
        for (OneMerge oneMerge : mergeSpec.getMerges()) {
            boolean belowMaxFullFlushSize = true;
            for (SegmentCommitInfo sci : oneMerge.getSegments()) {
                if (this.size(sci, mergeContext) < this.maxFullFlushMergeSize()) continue;
                belowMaxFullFlushSize = false;
                break;
            }
            if (!belowMaxFullFlushSize) continue;
            if (newMergeSpec == null) {
                newMergeSpec = new MergeSpecification();
            }
            newMergeSpec.add(oneMerge);
        }
        return newMergeSpec;
    }

    public boolean useCompoundFile(@NotNull SegmentInfos infos, @NotNull SegmentCommitInfo mergedInfo, @NotNull MergeContext mergeContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)mergedInfo, (String)"mergedInfo");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        if (this.getNoCFSRatio() == 0.0) {
            return false;
        }
        long mergedInfoSize = this.size(mergedInfo, mergeContext);
        if (mergedInfoSize > this.maxCFSSegmentSize) {
            return false;
        }
        if (this.getNoCFSRatio() >= 1.0) {
            return true;
        }
        long totalSize = 0L;
        for (SegmentCommitInfo info : infos) {
            totalSize += this.size(info, mergeContext);
        }
        return (double)mergedInfoSize <= this.getNoCFSRatio() * (double)totalSize;
    }

    public long size(@NotNull SegmentCommitInfo info, @NotNull MergeContext mergeContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        long byteSize = info.sizeInBytes();
        int delCount = mergeContext.numDeletesToMerge(info);
        boolean condition$iv = this.assertDelCount(delCount, info);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        double delRatio = info.getInfo().maxDoc() <= 0 ? 0.0 : (double)delCount / (double)info.getInfo().maxDoc();
        boolean condition$iv2 = delRatio <= 1.0;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return info.getInfo().maxDoc() <= 0 ? byteSize : (long)((double)byteSize * (1.0 - delRatio));
    }

    public long maxFullFlushMergeSize() {
        return 0L;
    }

    protected final boolean assertDelCount(int delCount, @NotNull SegmentCommitInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean condition$iv = delCount >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "delCount must be positive: " + delCount;
            throw new AssertionError((Object)string);
        }
        condition$iv = delCount <= info.getInfo().maxDoc();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "delCount: " + delCount + " must be leq than maxDoc: " + info.getInfo().maxDoc();
            throw new AssertionError((Object)string);
        }
        return true;
    }

    protected final boolean isMerged(@NotNull SegmentInfos infos, @NotNull SegmentCommitInfo info, @NotNull MergeContext mergeContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        int delCount = mergeContext.numDeletesToMerge(info);
        boolean condition$iv = this.assertDelCount(delCount, info);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return delCount == 0 && this.useCompoundFile(infos, info, mergeContext) == info.getInfo().getUseCompoundFile();
    }

    public double getMaxCFSSegmentSizeMB() {
        return (double)this.maxCFSSegmentSize / 1024.0 / 1024.0;
    }

    public void setMaxCFSSegmentSizeMB(double v) {
        double v2 = 0.0;
        v2 = v;
        if (!(!(v2 < 0.0))) {
            boolean bl = false;
            String string = "maxCFSSegmentSizeMB must be >=0 (got " + v2 + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxCFSSegmentSize = (v2 *= 1048576.0) > 9.223372036854776E18 ? Long.MAX_VALUE : (long)v2;
    }

    public boolean keepFullyDeletedSegment(@NotNull IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        Intrinsics.checkNotNullParameter(readerIOSupplier, (String)"readerIOSupplier");
        return false;
    }

    public int numDeletesToMerge(@NotNull SegmentCommitInfo info, int delCount, @NotNull IOSupplier<CodecReader> readerSupplier) throws IOException {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(readerSupplier, (String)"readerSupplier");
        return delCount;
    }

    @NotNull
    protected final String segString(@NotNull MergeContext mergeContext, @NotNull Iterable<SegmentCommitInfo> infos) {
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        return CollectionsKt.joinToString$default(infos, (CharSequence)" ", null, null, (int)0, null, arg_0 -> MergePolicy.segString$lambda$4(mergeContext, arg_0), (int)30, null);
    }

    protected final void message(@NotNull String message, @NotNull MergeContext mergeContext) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        if (this.verbose(mergeContext)) {
            mergeContext.getInfoStream().message("MP", message);
        }
    }

    protected final boolean verbose(@NotNull MergeContext mergeContext) {
        Intrinsics.checkNotNullParameter((Object)mergeContext, (String)"mergeContext");
        return mergeContext.getInfoStream().isEnabled("MP");
    }

    private static final CharSequence segString$lambda$4(MergeContext $mergeContext, SegmentCommitInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        int delCount = $mergeContext.numDeletedDocs(info) - info.getDelCount();
        return info.toString(delCount);
    }

    protected MergePolicy() {
        this(0.0, 0L, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$Companion;", "", "<init>", "()V", "DEFAULT_NO_CFS_RATIO", "", "DEFAULT_MAX_CFS_SEGMENT_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$MergeAbortedException;", "Ljava/io/IOException;", "Lokio/IOException;", "<init>", "()V", "message", "", "(Ljava/lang/String;)V", "core"})
    public static final class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$MergeContext;", "", "numDeletesToMerge", "", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "numDeletedDocs", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "getInfoStream", "()Lorg/gnit/lucenekmp/util/InfoStream;", "mergingSegments", "", "getMergingSegments", "()Ljava/util/Set;", "core"})
    public static interface MergeContext {
        public int numDeletesToMerge(@NotNull SegmentCommitInfo var1) throws IOException;

        public int numDeletedDocs(@NotNull SegmentCommitInfo var1);

        @NotNull
        public InfoStream getInfoStream();

        @NotNull
        public Set<SegmentCommitInfo> getMergingSegments();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$MergeException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "exc", "", "(Ljava/lang/Throwable;)V", "core"})
    public static final class MergeException
    extends RuntimeException {
        public MergeException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public MergeException(@NotNull Throwable exc) {
            Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
            super(exc);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\tR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$MergeReader;", "", "reader", "Lorg/gnit/lucenekmp/index/SegmentReader;", "hardLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentReader;Lorg/gnit/lucenekmp/util/Bits;)V", "Lorg/gnit/lucenekmp/index/CodecReader;", "(Lorg/gnit/lucenekmp/index/CodecReader;Lorg/gnit/lucenekmp/util/Bits;)V", "codecReader", "getCodecReader", "()Lorg/gnit/lucenekmp/index/CodecReader;", "getReader", "()Lorg/gnit/lucenekmp/index/SegmentReader;", "getHardLiveDocs", "()Lorg/gnit/lucenekmp/util/Bits;", "core"})
    public static final class MergeReader {
        @NotNull
        private final CodecReader codecReader;
        @Nullable
        private final SegmentReader reader;
        @Nullable
        private final Bits hardLiveDocs;

        @NotNull
        public final CodecReader getCodecReader() {
            return this.codecReader;
        }

        @Nullable
        public final SegmentReader getReader() {
            return this.reader;
        }

        @Nullable
        public final Bits getHardLiveDocs() {
            return this.hardLiveDocs;
        }

        public MergeReader(@NotNull SegmentReader reader2, @Nullable Bits hardLiveDocs) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            this.codecReader = reader2;
            this.reader = reader2;
            this.hardLiveDocs = hardLiveDocs;
        }

        public MergeReader(@NotNull CodecReader reader2, @Nullable Bits hardLiveDocs) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            this.reader = reader2 instanceof SegmentReader ? (SegmentReader)reader2 : null;
            this.codecReader = reader2;
            this.hardLiveDocs = hardLiveDocs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$MergeSpecification;", "", "<init>", "()V", "merges", "", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "getMerges", "()Ljava/util/List;", "add", "", "merge", "segString", "", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "toString", "mergeCompletedFutures", "Lkotlinx/coroutines/Deferred;", "getMergeCompletedFutures$annotations", "getMergeCompletedFutures", "()Lkotlinx/coroutines/Deferred;", "await", "", "timeout", "", "unit", "Lorg/gnit/lucenekmp/jdkport/TimeUnit;", "core"})
    public static final class MergeSpecification {
        @NotNull
        private final List<OneMerge> merges = new ArrayList();

        @NotNull
        public final List<OneMerge> getMerges() {
            return this.merges;
        }

        public final void add(@NotNull OneMerge merge2) {
            Intrinsics.checkNotNullParameter((Object)merge2, (String)"merge");
            this.merges.add(merge2);
        }

        @NotNull
        public final String segString(@NotNull Directory dir) {
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:\n");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString());
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("\n  ").append(1 + i).append(": ").append(this.merges.get(i).segString());
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final Deferred<Unit> getMergeCompletedFutures() {
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MergeSpecification this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$mapTo$iv$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            Iterable $this$map$iv = this.this$0.getMerges();
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                OneMerge oneMerge = (OneMerge)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getMergeCompleted());
                            }
                            this.label = 1;
                            Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static /* synthetic */ void getMergeCompletedFutures$annotations() {
        }

        public final boolean await() {
            boolean bl;
            try {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ MergeSpecification this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.this$0.getMergeCompletedFutures().await((Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                bl = true;
            }
            catch (CancellationException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                bl = false;
            }
            return bl;
        }

        public final boolean await(long timeout, @NotNull TimeUnit unit) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            try {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(unit, timeout, this, null){
                    int label;
                    final /* synthetic */ TimeUnit $unit;
                    final /* synthetic */ long $timeout;
                    final /* synthetic */ MergeSpecification this$0;
                    {
                        this.$unit = $unit;
                        this.$timeout = $timeout;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((long)this.$unit.toNanos(this.$timeout), (DurationUnit)DurationUnit.NANOSECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ MergeSpecification this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = this.this$0.getMergeCompletedFutures().await((Continuation)this);
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                bl = true;
            }
            catch (CancellationException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                bl = false;
            }
            catch (TimeoutException e) {
                bl = false;
            }
            catch (TimeoutCancellationException e) {
                bl = false;
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\nB\u0011\b\u0014\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\fJ\u000e\u0010H\u001a\u00020IH\u0086@\u00a2\u0006\u0002\u0010JJ\u0018\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000fH\u0016J$\u0010N\u001a\u00020I2\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000f2\f\u0010O\u001a\b\u0012\u0004\u0012\u0002040PJ\u0010\u0010Q\u001a\u00020\t2\u0006\u0010R\u001a\u00020\tH\u0016J\"\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010R\u001a\u00020\t2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020I2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0006\u0010\\\u001a\u00020]J\u0006\u0010^\u001a\u00020\u001dJ\u0006\u0010_\u001a\u00020%J\u000e\u0010e\u001a\u00020IH\u0086@\u00a2\u0006\u0002\u0010JJ\u0006\u0010f\u001a\u00020IJ\u001e\u0010g\u001a\u00020\u000f2\u0006\u0010h\u001a\u00020\u001d2\u0006\u0010i\u001a\u00020jH\u0086@\u00a2\u0006\u0002\u0010kJ\u0006\u0010l\u001a\u00020\u000fJ\u000e\u0010m\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0nJ\b\u0010o\u001a\u00020IH\u0016J\u001c\u0010p\u001a\u00020I2\u0012\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002040rH\u0016R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0019\"\u0004\b#\u0010\u001bR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0019\"\u0004\b,\u0010\u001bR\u001a\u0010-\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001f\"\u0004\b/\u0010!R\u001a\u00100\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001f\"\u0004\b2\u0010!R*\u00105\u001a\b\u0012\u0004\u0012\u0002040\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00107R\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001f\"\u0004\b?\u0010!R\u0011\u0010@\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010'R\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u0013\u0010Z\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0014R\u0011\u0010`\u001a\u00020a8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u0011\u0010d\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\bd\u0010\u0019\u00a8\u0006s"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "", "segments", "", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "<init>", "(Ljava/util/List;)V", "codecReaders", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "([Lorg/gnit/lucenekmp/index/CodecReader;)V", "oneMerge", "(Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;)V", "mergeCompleted", "Lkotlinx/coroutines/CompletableDeferred;", "", "getMergeCompleted", "()Lkotlinx/coroutines/CompletableDeferred;", "info", "getInfo", "()Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "setInfo", "(Lorg/gnit/lucenekmp/index/SegmentCommitInfo;)V", "registerDone", "getRegisterDone", "()Z", "setRegisterDone", "(Z)V", "mergeGen", "", "getMergeGen", "()J", "setMergeGen", "(J)V", "isExternal", "setExternal", "maxNumSegments", "", "getMaxNumSegments", "()I", "setMaxNumSegments", "(I)V", "usesPooledReaders", "getUsesPooledReaders", "setUsesPooledReaders", "estimatedMergeBytes", "getEstimatedMergeBytes", "setEstimatedMergeBytes", "totalMergeBytes", "getTotalMergeBytes", "setTotalMergeBytes", "value", "Lorg/gnit/lucenekmp/index/MergePolicy$MergeReader;", "mergeReader", "getMergeReader", "()Ljava/util/List;", "getSegments", "mergeProgress", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress;", "getMergeProgress", "()Lorg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress;", "mergeStartNS", "getMergeStartNS", "setMergeStartNS", "totalMaxDoc", "getTotalMaxDoc", "exception", "", "getException", "()Ljava/lang/Throwable;", "setException", "(Ljava/lang/Throwable;)V", "mergeInit", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mergeFinished", "success", "segmentDropped", "close", "readerConsumer", "Lorg/gnit/lucenekmp/util/IOConsumer;", "wrapForMerge", "reader", "reorder", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "executor", "Lorg/gnit/lucenekmp/jdkport/Executor;", "setMergeInfo", "mergeInfo", "getMergeInfo", "segString", "", "totalBytesSize", "totalNumDocs", "storeMergeInfo", "Lorg/gnit/lucenekmp/store/MergeInfo;", "getStoreMergeInfo", "()Lorg/gnit/lucenekmp/store/MergeInfo;", "isAborted", "setAborted", "checkAborted", "await", "timeout", "timeUnit", "Lorg/gnit/lucenekmp/jdkport/TimeUnit;", "(JLorg/gnit/lucenekmp/jdkport/TimeUnit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasFinished", "hasCompletedSuccessfully", "Lorg/gnit/lucenekmp/jdkport/Optional;", "onMergeComplete", "initMergeReaders", "readerFactory", "Lorg/gnit/lucenekmp/util/IOFunction;", "core"})
    @SourceDebugExtension(value={"SMAP\nMergePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergePolicy.kt\norg/gnit/lucenekmp/index/MergePolicy$OneMerge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,956:1\n1#2:957\n8#3,2:958\n8#3,2:960\n*S KotlinDebug\n*F\n+ 1 MergePolicy.kt\norg/gnit/lucenekmp/index/MergePolicy$OneMerge\n*L\n495#1:958,2\n496#1:960,2\n*E\n"})
    public static class OneMerge {
        @NotNull
        private final CompletableDeferred<Boolean> mergeCompleted;
        @Nullable
        private SegmentCommitInfo info;
        private boolean registerDone;
        private long mergeGen;
        private boolean isExternal;
        private int maxNumSegments;
        private boolean usesPooledReaders;
        private volatile long estimatedMergeBytes;
        private volatile long totalMergeBytes;
        @NotNull
        private List<MergeReader> mergeReader;
        @NotNull
        private final List<SegmentCommitInfo> segments;
        @NotNull
        private final OneMergeProgress mergeProgress;
        private volatile long mergeStartNS;
        private final int totalMaxDoc;
        @Nullable
        private Throwable exception;

        @NotNull
        public final CompletableDeferred<Boolean> getMergeCompleted() {
            return this.mergeCompleted;
        }

        @Nullable
        public final SegmentCommitInfo getInfo() {
            return this.info;
        }

        public final void setInfo(@Nullable SegmentCommitInfo segmentCommitInfo) {
            this.info = segmentCommitInfo;
        }

        public final boolean getRegisterDone() {
            return this.registerDone;
        }

        public final void setRegisterDone(boolean bl) {
            this.registerDone = bl;
        }

        public final long getMergeGen() {
            return this.mergeGen;
        }

        public final void setMergeGen(long l) {
            this.mergeGen = l;
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public final void setExternal(boolean bl) {
            this.isExternal = bl;
        }

        public final int getMaxNumSegments() {
            return this.maxNumSegments;
        }

        public final void setMaxNumSegments(int n) {
            this.maxNumSegments = n;
        }

        public final boolean getUsesPooledReaders() {
            return this.usesPooledReaders;
        }

        public final void setUsesPooledReaders(boolean bl) {
            this.usesPooledReaders = bl;
        }

        public final long getEstimatedMergeBytes() {
            return this.estimatedMergeBytes;
        }

        public final void setEstimatedMergeBytes(long l) {
            this.estimatedMergeBytes = l;
        }

        public final long getTotalMergeBytes() {
            return this.totalMergeBytes;
        }

        public final void setTotalMergeBytes(long l) {
            this.totalMergeBytes = l;
        }

        @NotNull
        public final List<MergeReader> getMergeReader() {
            return this.mergeReader;
        }

        @NotNull
        public final List<SegmentCommitInfo> getSegments() {
            return this.segments;
        }

        @NotNull
        public final OneMergeProgress getMergeProgress() {
            return this.mergeProgress;
        }

        public final long getMergeStartNS() {
            return this.mergeStartNS;
        }

        public final void setMergeStartNS(long l) {
            this.mergeStartNS = l;
        }

        public final int getTotalMaxDoc() {
            return this.totalMaxDoc;
        }

        @Nullable
        public final Throwable getException() {
            return this.exception;
        }

        public final void setException(@Nullable Throwable throwable) {
            this.exception = throwable;
        }

        /*
         * WARNING - void declaration
         */
        public OneMerge(@NotNull List<SegmentCommitInfo> segments) {
            int n;
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            this.mergeCompleted = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.maxNumSegments = -1;
            this.mergeStartNS = -1L;
            if (segments.isEmpty()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = CollectionsKt.toMutableList((Collection)segments);
            Iterable iterable = segments;
            OneMerge oneMerge = this;
            int n2 = 0;
            for (Object t : iterable) {
                void i;
                SegmentCommitInfo segmentCommitInfo = (SegmentCommitInfo)t;
                n = n2;
                boolean bl = false;
                int n3 = i.getInfo().maxDoc();
                n2 = n + n3;
            }
            oneMerge.totalMaxDoc = n = n2;
            this.mergeProgress = new OneMergeProgress();
            this.mergeReader = new ArrayList();
            this.usesPooledReaders = true;
        }

        public OneMerge(CodecReader ... codecReaders) {
            Intrinsics.checkNotNullParameter((Object)codecReaders, (String)"codecReaders");
            this.mergeCompleted = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.maxNumSegments = -1;
            this.mergeStartNS = -1L;
            List readers = new ArrayList(codecReaders.length);
            int totalDocs = 0;
            for (CodecReader r : codecReaders) {
                Bits bits = r.getLiveDocs();
                Intrinsics.checkNotNull((Object)bits);
                readers.add(new MergeReader(r, bits));
                totalDocs += r.numDocs();
            }
            this.mergeReader = CollectionsKt.toMutableList((Collection)readers);
            this.segments = new ArrayList();
            this.totalMaxDoc = totalDocs;
            this.mergeProgress = new OneMergeProgress();
            this.usesPooledReaders = false;
        }

        protected OneMerge(@NotNull OneMerge oneMerge) {
            Intrinsics.checkNotNullParameter((Object)oneMerge, (String)"oneMerge");
            this.mergeCompleted = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.maxNumSegments = -1;
            this.mergeStartNS = -1L;
            this.segments = oneMerge.segments;
            this.mergeReader = oneMerge.mergeReader;
            this.totalMaxDoc = oneMerge.totalMaxDoc;
            this.mergeProgress = new OneMergeProgress();
            this.usesPooledReaders = oneMerge.usesPooledReaders;
        }

        @Nullable
        public final Object mergeInit(@NotNull Continuation<? super Unit> $completion) {
            Job job2 = (Job)$completion.getContext().get((CoroutineContext.Key)Job.Key);
            if (job2 == null) {
                throw new IOException("mergeInit must be called from a coroutine context with a Job");
            }
            Job currentJob = job2;
            this.mergeProgress.setMergeThread(currentJob);
            return Unit.INSTANCE;
        }

        public void mergeFinished(boolean success, boolean segmentDropped) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close(boolean success, boolean segmentDropped, @NotNull IOConsumer<MergeReader> readerConsumer) throws IOException {
            Intrinsics.checkNotNullParameter(readerConsumer, (String)"readerConsumer");
            if (!this.mergeCompleted.complete((Object)success)) {
                boolean $i$a$-check-MergePolicy$OneMerge$close$22 = false;
                String $i$a$-check-MergePolicy$OneMerge$close$22 = "merge has already finished";
                throw new IllegalStateException($i$a$-check-MergePolicy$OneMerge$close$22.toString());
            }
            try {
                this.mergeFinished(success, segmentDropped);
            }
            finally {
                List<MergeReader> readers = this.mergeReader;
                this.mergeReader = new ArrayList();
                IOUtils.INSTANCE.applyToAll((Collection)readers, readerConsumer);
            }
        }

        @NotNull
        public CodecReader wrapForMerge(@NotNull CodecReader reader2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            return reader2;
        }

        @Nullable
        public Sorter.DocMap reorder(@NotNull CodecReader reader2, @NotNull Directory dir, @NotNull Executor executor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return null;
        }

        public void setMergeInfo(@NotNull SegmentCommitInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.info = info;
        }

        @Nullable
        public final SegmentCommitInfo getMergeInfo() {
            return this.info;
        }

        @NotNull
        public final String segString() {
            StringBuilder b = new StringBuilder();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.get(i).toString());
            }
            if (this.info != null) {
                StringBuilder stringBuilder = b.append(" into ");
                SegmentCommitInfo segmentCommitInfo = this.info;
                Intrinsics.checkNotNull((Object)segmentCommitInfo);
                stringBuilder.append(segmentCommitInfo.getInfo().getName());
            }
            if (this.maxNumSegments != -1) {
                b.append(" [maxNumSegments=").append(this.maxNumSegments).append(']');
            }
            if (this.isAborted()) {
                b.append(" [ABORTED]");
            }
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public final long totalBytesSize() {
            return this.totalMergeBytes;
        }

        public final int totalNumDocs() {
            return this.totalMaxDoc;
        }

        @NotNull
        public final MergeInfo getStoreMergeInfo() {
            return new MergeInfo(this.totalMaxDoc, this.estimatedMergeBytes, this.isExternal, this.maxNumSegments);
        }

        public final boolean isAborted() {
            return this.mergeProgress.isAborted();
        }

        @Nullable
        public final Object setAborted(@NotNull Continuation<? super Unit> $completion) {
            Object object = this.mergeProgress.abort($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public final void checkAborted() throws MergeAbortedException {
            if (this.isAborted()) {
                throw new MergeAbortedException("merge is aborted: " + this.segString());
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object await(long timeout, @NotNull TimeUnit timeUnit, @NotNull Continuation<? super Boolean> $completion) {
            if (!($completion instanceof await.1)) ** GOTO lbl-1000
            var8_4 = $completion;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    long J$0;
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ OneMerge this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.await(0L, null, (Continuation<? super Boolean>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)timeUnit);
                    $continuation.J$0 = timeout;
                    $continuation.label = 1;
                    v0 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((long)timeUnit.toNanos(timeout), (DurationUnit)DurationUnit.NANOSECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
                        int label;
                        final /* synthetic */ OneMerge this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.this$0.getMergeCompleted().await((Continuation)this);
                                    if (object2 != object) return Boxing.boxBoolean((boolean)true);
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Boxing.boxBoolean((boolean)true);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v0 != var9_6) goto lbl21
lbl20:
                    // 1 sources

                    return var9_6;
lbl21:
                    // 1 sources

                    ** GOTO lbl29
                }
                case 1: {
                    timeout = $continuation.J$0;
                    timeUnit = (TimeUnit)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl29:
                        // 2 sources

                        var5_7 = (Boolean)v0;
                    }
                    catch (CancellationException ce) {
                        throw new ThreadInterruptedException(ce);
                    }
                    catch (ExecutionException e) {
                        var5_7 = false;
                    }
                    catch (TimeoutException e) {
                        var5_7 = false;
                    }
                    catch (TimeoutCancellationException e) {
                        var5_7 = false;
                    }
                    return Boxing.boxBoolean((boolean)(var5_7 != false));
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final boolean hasFinished() {
            return this.mergeCompleted.isCompleted();
        }

        @NotNull
        public final Optional<Boolean> hasCompletedSuccessfully() {
            return Optional.Companion.ofNullable(this.mergeCompleted.getCompleted());
        }

        public void onMergeComplete() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initMergeReaders(@NotNull IOFunction<SegmentCommitInfo, MergeReader> readerFactory2) throws IOException {
            Intrinsics.checkNotNullParameter(readerFactory2, (String)"readerFactory");
            boolean condition$iv = this.mergeReader.isEmpty();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-MergePolicy$OneMerge$initMergeReaders$32 = false;
                String $i$a$-assert-MergePolicy$OneMerge$initMergeReaders$32 = "merge readers must be empty";
                throw new AssertionError((Object)$i$a$-assert-MergePolicy$OneMerge$initMergeReaders$32);
            }
            condition$iv = !this.mergeCompleted.isCompleted();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-MergePolicy$OneMerge$initMergeReaders$42 = false;
                String $i$a$-assert-MergePolicy$OneMerge$initMergeReaders$42 = "merge is already done";
                throw new AssertionError((Object)$i$a$-assert-MergePolicy$OneMerge$initMergeReaders$42);
            }
            ArrayList<MergeReader> readers = new ArrayList<MergeReader>(this.segments.size());
            try {
                for (SegmentCommitInfo info : this.segments) {
                    readers.add(readerFactory2.apply(info));
                }
            }
            finally {
                this.mergeReader = CollectionsKt.toMutableList((Collection)readers);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010!\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0003R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress;", "", "<init>", "()V", "pauseLock", "Lkotlinx/coroutines/sync/Mutex;", "pausing", "Lkotlinx/coroutines/channels/Channel;", "", "pauseTimesNS", "", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress$PauseReason;", "Lkotlin/concurrent/atomics/AtomicLong;", "getPauseTimesNS$annotations", "value", "", "isAborted", "()Z", "owner", "Lkotlinx/coroutines/Job;", "abort", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pauseNanos", "initialPauseNanos", "", "reason", "condition", "Lkotlin/Function0;", "(JLorg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress$PauseReason;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "wakeup", "pauseTimes", "getPauseTimes", "()Ljava/util/Map;", "setMergeThread", "PauseReason", "core"})
    @SourceDebugExtension(value={"SMAP\nMergePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergePolicy.kt\norg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 6 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,956:1\n116#2,11:957\n463#3:968\n413#3:969\n1252#4,4:970\n3#5,8:974\n10#6:982\n*S KotlinDebug\n*F\n+ 1 MergePolicy.kt\norg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress\n*L\n186#1:957,11\n193#1:968\n193#1:969\n193#1:970,4\n196#1:974,8\n196#1:982\n*E\n"})
    public static final class OneMergeProgress {
        @NotNull
        private final Mutex pauseLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        @NotNull
        private final Channel<Unit> pausing = ChannelKt.Channel$default((int)0, null, null, (int)6, null);
        @NotNull
        private final Map<PauseReason, AtomicLong> pauseTimesNS = new LinkedHashMap();
        private volatile boolean isAborted;
        @Nullable
        private Job owner;

        public OneMergeProgress() {
            for (PauseReason p : PauseReason.getEntries()) {
                this.pauseTimesNS.put(p, new AtomicLong(0L));
            }
        }

        private static /* synthetic */ void getPauseTimesNS$annotations() {
        }

        public final boolean isAborted() {
            return this.isAborted;
        }

        @Nullable
        public final Object abort(@NotNull Continuation<? super Unit> $completion) {
            this.isAborted = true;
            Object object = this.wakeup($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object pauseNanos(long initialPauseNanos, @NotNull PauseReason reason, @NotNull Function0<Boolean> condition, @NotNull Continuation<? super Unit> $completion) {
            block17: {
                if (!($completion instanceof pauseNanos.1)) ** GOTO lbl-1000
                var16_5 = $completion;
                if ((var16_5.label & -2147483648) != 0) {
                    var16_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        long J$0;
                        long J$1;
                        long J$2;
                        long J$3;
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        /* synthetic */ Object result;
                        final /* synthetic */ OneMergeProgress this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.pauseNanos(0L, null, null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var17_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        remainingNanosToPause = initialPauseNanos;
                        functionStartTime = System.INSTANCE.nanoTime();
                        v0 = this.pauseTimesNS.get((Object)reason);
                        Intrinsics.checkNotNull((Object)v0);
                        timeUpdate = v0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)reason);
                        $continuation.L$1 = condition;
                        $continuation.L$2 = timeUpdate;
                        $continuation.J$0 = initialPauseNanos;
                        $continuation.J$1 = remainingNanosToPause;
                        $continuation.J$2 = functionStartTime;
                        $continuation.label = 1;
                        v1 = Mutex.DefaultImpls.lock$default((Mutex)this.pauseLock, null, (Continuation)$continuation, (int)1, null);
                        if (v1 == var17_7) {
                            return var17_7;
                        }
                        ** GOTO lbl38
                    }
                    case 1: {
                        functionStartTime = $continuation.J$2;
                        remainingNanosToPause = $continuation.J$1;
                        initialPauseNanos = $continuation.J$0;
                        timeUpdate = (AtomicLong)$continuation.L$2;
                        condition = (Function0)$continuation.L$1;
                        reason = (PauseReason)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl38:
                        // 3 sources

lbl39:
                        // 4 sources

                        while (remainingNanosToPause > 0L && !this.isAborted && ((Boolean)condition.invoke()).booleanValue()) {
                            iterationStartTimeNanos = System.INSTANCE.nanoTime();
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)reason);
                            $continuation.L$1 = condition;
                            $continuation.L$2 = timeUpdate;
                            $continuation.J$0 = initialPauseNanos;
                            $continuation.J$1 = remainingNanosToPause;
                            $continuation.J$2 = functionStartTime;
                            $continuation.J$3 = iterationStartTimeNanos;
                            $continuation.label = 2;
                            v2 = v3 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((long)remainingNanosToPause, (DurationUnit)DurationUnit.NANOSECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                int label;
                                final /* synthetic */ OneMergeProgress this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = OneMergeProgress.access$getPausing$p(this.this$0).receive((Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)$continuation);
                        }
                        break;
                        {
                            if (v2 == var17_7) {
                                return var17_7;
                            }
                            ** GOTO lbl71
                            break;
                        }
                    }
                    case 2: {
                        iterationStartTimeNanos = $continuation.J$3;
                        functionStartTime = $continuation.J$2;
                        remainingNanosToPause = $continuation.J$1;
                        initialPauseNanos = $continuation.J$0;
                        timeUpdate = (AtomicLong)$continuation.L$2;
                        condition = (Function0)$continuation.L$1;
                        reason = (PauseReason)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl71:
                        // 2 sources

                        if ((remainingNanosToPause -= (elapsedInIteration = System.INSTANCE.nanoTime() - iterationStartTimeNanos)) >= 0L) ** GOTO lbl39
                        remainingNanosToPause = 0L;
                        ** GOTO lbl39
                        {
                            catch (TimeoutCancellationException e) {
                                remainingNanosToPause = 0L;
                                ** GOTO lbl39
                            }
                            catch (CancellationException e) {
                                throw new RuntimeException("Merge was aborted while waiting for pause", e);
                            }
                        }
                    }
                }
                break block17;
                catch (Throwable var11_12) {
                    Mutex.DefaultImpls.unlock$default((Mutex)this.pauseLock, null, (int)1, null);
                    timeUpdate.addAndGet(System.INSTANCE.nanoTime() - functionStartTime);
                    throw var11_12;
                }
            }
            Mutex.DefaultImpls.unlock$default((Mutex)this.pauseLock, null, (int)1, null);
            timeUpdate.addAndGet(System.INSTANCE.nanoTime() - functionStartTime);
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object wakeup(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof wakeup.1)) ** GOTO lbl-1000
            var8_2 = $completion;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ OneMergeProgress this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.wakeup((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$withLock_u24default$iv = this.pauseLock;
                    owner$iv = null;
                    $i$f$withLock = 0;
                    $continuation.L$0 = $this$withLock_u24default$iv;
                    $continuation.I$0 = $i$f$withLock;
                    $continuation.label = 1;
                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    $i$f$withLock = $continuation.I$0;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    try {
                        $i$a$-withLock$default-MergePolicy$OneMergeProgress$wakeup$2 = false;
                        var6_11 = this.pausing.trySend-JP2dKIU((Object)Unit.INSTANCE);
                    }
                    finally {
                        $this$withLock_u24default$iv.unlock(owner$iv);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<PauseReason, Long> getPauseTimes() {
            void $this$mapValuesTo$iv$iv;
            Map<PauseReason, AtomicLong> $this$mapValues$iv = this.pauseTimesNS;
            boolean $i$f$mapValues = false;
            Map<PauseReason, AtomicLong> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                AtomicLong atomic = (AtomicLong)entry2.getValue();
                Long l = atomic.get();
                map4.put(k, l);
            }
            return MapsKt.toMutableMap((Map)destination$iv$iv);
        }

        public final void setMergeThread(@NotNull Job owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            boolean condition$iv = this.owner == null;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.owner = owner;
        }

        public static final /* synthetic */ Channel access$getPausing$p(OneMergeProgress $this) {
            return $this.pausing;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/index/MergePolicy$OneMergeProgress$PauseReason;", "", "<init>", "(Ljava/lang/String;I)V", "STOPPED", "PAUSED", "OTHER", "core"})
        public static final class PauseReason
        extends Enum<PauseReason> {
            public static final /* enum */ PauseReason STOPPED = new PauseReason();
            public static final /* enum */ PauseReason PAUSED = new PauseReason();
            public static final /* enum */ PauseReason OTHER = new PauseReason();
            private static final /* synthetic */ PauseReason[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static PauseReason[] values() {
                return (PauseReason[])$VALUES.clone();
            }

            public static PauseReason valueOf(String value) {
                return Enum.valueOf(PauseReason.class, value);
            }

            @NotNull
            public static EnumEntries<PauseReason> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = pauseReasonArray = new PauseReason[]{PauseReason.STOPPED, PauseReason.PAUSED, PauseReason.OTHER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

