/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.codecs.FieldsProducer;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.TermVectorsReader;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.MultiSorter;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.jdkport.Executor;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b3\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ]2\u00020\u0001:\u0002\\]B1\b\u0010\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u00d9\u0001\b\u0016\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000e\u0012\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000e\u0012\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u000e\u0012\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000e\u0012\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e\u0012\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u000e\u0012\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u000e\u0012\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u000e\u0012\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u000e\u0012\u0006\u0010#\u001a\u00020$\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010%\u001a\u00020&\u00a2\u0006\u0004\b\u000b\u0010'J!\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010WJ-\u0010X\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010Y\u001a\u0004\u0018\u00010ZH\u0002\u00a2\u0006\u0002\u0010[R\u001b\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010*\u001a\u0004\b(\u0010)R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001b\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u000e\u00a2\u0006\n\n\u0002\u00103\u001a\u0004\b1\u00102R\u001b\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000e\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b4\u00105R\u001b\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u000e\u00a2\u0006\n\n\u0002\u00109\u001a\u0004\b7\u00108R\u001b\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000e\u00a2\u0006\n\n\u0002\u0010<\u001a\u0004\b:\u0010;R\u001b\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e\u00a2\u0006\n\n\u0002\u0010?\u001a\u0004\b=\u0010>R\u001b\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u000e\u00a2\u0006\n\n\u0002\u0010B\u001a\u0004\b@\u0010AR\u001b\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u000e\u00a2\u0006\n\n\u0002\u0010E\u001a\u0004\bC\u0010DR\u001b\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u000e\u00a2\u0006\n\n\u0002\u0010H\u001a\u0004\bF\u0010GR\u001b\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u000e\u00a2\u0006\n\n\u0002\u0010K\u001a\u0004\bI\u0010JR\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010U\u00a8\u0006^"}, d2={"Lorg/gnit/lucenekmp/index/MergeState;", "", "readers", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "intraMergeTaskExecutor", "Lorg/gnit/lucenekmp/jdkport/Executor;", "<init>", "(Ljava/util/List;Lorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/jdkport/Executor;)V", "docMaps", "", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "mergeFieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "storedFieldsReaders", "Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "termVectorsReaders", "Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "normsProducers", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "docValuesProducers", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "fieldInfos", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "fieldsProducers", "Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "pointsReaders", "Lorg/gnit/lucenekmp/codecs/PointsReader;", "knnVectorsReaders", "Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "maxDocs", "", "needsIndexSort", "", "([Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/index/FieldInfos;[Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;[Lorg/gnit/lucenekmp/codecs/TermVectorsReader;[Lorg/gnit/lucenekmp/codecs/NormsProducer;[Lorg/gnit/lucenekmp/codecs/DocValuesProducer;[Lorg/gnit/lucenekmp/index/FieldInfos;[Lorg/gnit/lucenekmp/util/Bits;[Lorg/gnit/lucenekmp/codecs/FieldsProducer;[Lorg/gnit/lucenekmp/codecs/PointsReader;[Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;[ILorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/jdkport/Executor;Z)V", "getDocMaps", "()[Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "[Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "getSegmentInfo", "()Lorg/gnit/lucenekmp/index/SegmentInfo;", "getMergeFieldInfos", "()Lorg/gnit/lucenekmp/index/FieldInfos;", "setMergeFieldInfos", "(Lorg/gnit/lucenekmp/index/FieldInfos;)V", "getStoredFieldsReaders", "()[Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "[Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "getTermVectorsReaders", "()[Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "[Lorg/gnit/lucenekmp/codecs/TermVectorsReader;", "getNormsProducers", "()[Lorg/gnit/lucenekmp/codecs/NormsProducer;", "[Lorg/gnit/lucenekmp/codecs/NormsProducer;", "getDocValuesProducers", "()[Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "[Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "getFieldInfos", "()[Lorg/gnit/lucenekmp/index/FieldInfos;", "[Lorg/gnit/lucenekmp/index/FieldInfos;", "getLiveDocs", "()[Lorg/gnit/lucenekmp/util/Bits;", "[Lorg/gnit/lucenekmp/util/Bits;", "getFieldsProducers", "()[Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "[Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "getPointsReaders", "()[Lorg/gnit/lucenekmp/codecs/PointsReader;", "[Lorg/gnit/lucenekmp/codecs/PointsReader;", "getKnnVectorsReaders", "()[Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "[Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "getMaxDocs", "()[I", "getInfoStream", "()Lorg/gnit/lucenekmp/util/InfoStream;", "getIntraMergeTaskExecutor", "()Lorg/gnit/lucenekmp/jdkport/Executor;", "getNeedsIndexSort", "()Z", "setNeedsIndexSort", "(Z)V", "buildDeletionDocMaps", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "buildDocMaps", "indexSort", "Lorg/gnit/lucenekmp/search/Sort;", "(Ljava/util/List;Lorg/gnit/lucenekmp/search/Sort;)[Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "DocMap", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMergeState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeState.kt\norg/gnit/lucenekmp/index/MergeState\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,290:1\n24#2:291\n63#2,3:292\n*S KotlinDebug\n*F\n+ 1 MergeState.kt\norg/gnit/lucenekmp/index/MergeState\n*L\n196#1:291\n196#1:292,3\n*E\n"})
public final class MergeState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DocMap[] docMaps;
    @NotNull
    private final SegmentInfo segmentInfo;
    @Nullable
    private FieldInfos mergeFieldInfos;
    @NotNull
    private final StoredFieldsReader[] storedFieldsReaders;
    @NotNull
    private final TermVectorsReader[] termVectorsReaders;
    @NotNull
    private final NormsProducer[] normsProducers;
    @NotNull
    private final DocValuesProducer[] docValuesProducers;
    @NotNull
    private final FieldInfos[] fieldInfos;
    @NotNull
    private final Bits[] liveDocs;
    @NotNull
    private final FieldsProducer[] fieldsProducers;
    @NotNull
    private final PointsReader[] pointsReaders;
    @NotNull
    private final KnnVectorsReader[] knnVectorsReaders;
    @NotNull
    private final int[] maxDocs;
    @NotNull
    private final InfoStream infoStream;
    @Nullable
    private final Executor intraMergeTaskExecutor;
    private boolean needsIndexSort;

    @Nullable
    public final DocMap[] getDocMaps() {
        return this.docMaps;
    }

    @NotNull
    public final SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }

    @Nullable
    public final FieldInfos getMergeFieldInfos() {
        return this.mergeFieldInfos;
    }

    public final void setMergeFieldInfos(@Nullable FieldInfos fieldInfos) {
        this.mergeFieldInfos = fieldInfos;
    }

    @NotNull
    public final StoredFieldsReader[] getStoredFieldsReaders() {
        return this.storedFieldsReaders;
    }

    @NotNull
    public final TermVectorsReader[] getTermVectorsReaders() {
        return this.termVectorsReaders;
    }

    @NotNull
    public final NormsProducer[] getNormsProducers() {
        return this.normsProducers;
    }

    @NotNull
    public final DocValuesProducer[] getDocValuesProducers() {
        return this.docValuesProducers;
    }

    @NotNull
    public final FieldInfos[] getFieldInfos() {
        return this.fieldInfos;
    }

    @NotNull
    public final Bits[] getLiveDocs() {
        return this.liveDocs;
    }

    @NotNull
    public final FieldsProducer[] getFieldsProducers() {
        return this.fieldsProducers;
    }

    @NotNull
    public final PointsReader[] getPointsReaders() {
        return this.pointsReaders;
    }

    @NotNull
    public final KnnVectorsReader[] getKnnVectorsReaders() {
        return this.knnVectorsReaders;
    }

    @NotNull
    public final int[] getMaxDocs() {
        return this.maxDocs;
    }

    @NotNull
    public final InfoStream getInfoStream() {
        return this.infoStream;
    }

    @Nullable
    public final Executor getIntraMergeTaskExecutor() {
        return this.intraMergeTaskExecutor;
    }

    public final boolean getNeedsIndexSort() {
        return this.needsIndexSort;
    }

    public final void setNeedsIndexSort(boolean bl) {
        this.needsIndexSort = bl;
    }

    public MergeState(@NotNull List<CodecReader> readers, @NotNull SegmentInfo segmentInfo, @NotNull InfoStream infoStream, @Nullable Executor intraMergeTaskExecutor) {
        Intrinsics.checkNotNullParameter(readers, (String)"readers");
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        MergeState.Companion.verifyIndexSort(readers, segmentInfo);
        this.infoStream = infoStream;
        int numReaders = readers.size();
        this.intraMergeTaskExecutor = intraMergeTaskExecutor;
        this.maxDocs = new int[numReaders];
        this.fieldsProducers = new FieldsProducer[numReaders];
        this.normsProducers = new NormsProducer[numReaders];
        this.storedFieldsReaders = new StoredFieldsReader[numReaders];
        this.termVectorsReaders = new TermVectorsReader[numReaders];
        this.docValuesProducers = new DocValuesProducer[numReaders];
        this.pointsReaders = new PointsReader[numReaders];
        this.knnVectorsReaders = new KnnVectorsReader[numReaders];
        this.fieldInfos = new FieldInfos[numReaders];
        this.liveDocs = new Bits[numReaders];
        int numDocs = 0;
        for (int i = 0; i < numReaders; ++i) {
            CodecReader reader2 = readers.get(i);
            this.maxDocs[i] = reader2.maxDoc();
            this.liveDocs[i] = reader2.getLiveDocs();
            this.fieldInfos[i] = reader2.getFieldInfos();
            this.normsProducers[i] = reader2.getNormsReader();
            if (this.normsProducers[i] != null) {
                NormsProducer normsProducer = this.normsProducers[i];
                Intrinsics.checkNotNull((Object)normsProducer);
                this.normsProducers[i] = normsProducer.getMergeInstance();
            }
            this.docValuesProducers[i] = reader2.getDocValuesReader();
            if (this.docValuesProducers[i] != null) {
                DocValuesProducer docValuesProducer = this.docValuesProducers[i];
                Intrinsics.checkNotNull((Object)docValuesProducer);
                this.docValuesProducers[i] = docValuesProducer.getMergeInstance();
            }
            this.storedFieldsReaders[i] = reader2.getFieldsReader();
            if (this.storedFieldsReaders[i] != null) {
                StoredFieldsReader storedFieldsReader = this.storedFieldsReaders[i];
                Intrinsics.checkNotNull((Object)storedFieldsReader);
                this.storedFieldsReaders[i] = storedFieldsReader.getMergeInstance();
            }
            this.termVectorsReaders[i] = reader2.getTermVectorsReader();
            if (this.termVectorsReaders[i] != null) {
                TermVectorsReader termVectorsReader = this.termVectorsReaders[i];
                Intrinsics.checkNotNull((Object)termVectorsReader);
                this.termVectorsReaders[i] = termVectorsReader.getMergeInstance();
            }
            this.fieldsProducers[i] = reader2.getPostingsReader();
            if (this.fieldsProducers[i] != null) {
                FieldsProducer fieldsProducer = this.fieldsProducers[i];
                Intrinsics.checkNotNull((Object)fieldsProducer);
                this.fieldsProducers[i] = fieldsProducer.getMergeInstance();
            }
            this.pointsReaders[i] = reader2.getPointsReader();
            if (this.pointsReaders[i] != null) {
                PointsReader pointsReader2 = this.pointsReaders[i];
                Intrinsics.checkNotNull((Object)pointsReader2);
                this.pointsReaders[i] = pointsReader2.getMergeInstance();
            }
            this.knnVectorsReaders[i] = reader2.getVectorReader();
            if (this.knnVectorsReaders[i] != null) {
                KnnVectorsReader knnVectorsReader = this.knnVectorsReaders[i];
                Intrinsics.checkNotNull((Object)knnVectorsReader);
                this.knnVectorsReaders[i] = knnVectorsReader.getMergeInstance();
            }
            numDocs += reader2.numDocs();
        }
        segmentInfo.setMaxDoc(numDocs);
        this.segmentInfo = segmentInfo;
        this.docMaps = this.buildDocMaps(readers, segmentInfo.getIndexSort());
    }

    private final DocMap[] buildDeletionDocMaps(List<CodecReader> readers) {
        int totalDocs = 0;
        int numReaders = readers.size();
        DocMap[] docMaps = new DocMap[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            LeafReader reader2 = readers.get(i);
            Bits liveDocs2 = reader2.getLiveDocs();
            PackedLongValues delDocMap = liveDocs2 != null ? Companion.removeDeletes(reader2.maxDoc(), liveDocs2) : null;
            int docBase = totalDocs;
            docMaps[i] = arg_0 -> MergeState.buildDeletionDocMaps$lambda$0(liveDocs2, docBase, delDocMap, arg_0);
            totalDocs += reader2.numDocs();
        }
        return docMaps;
    }

    private final DocMap[] buildDocMaps(List<CodecReader> readers, Sort indexSort) throws IOException {
        if (indexSort == null) {
            return this.buildDeletionDocMaps(readers);
        }
        DocMap[] result = null;
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        result = MultiSorter.INSTANCE.sort(indexSort, readers);
        if (result == null) {
            return this.buildDeletionDocMaps(readers);
        }
        this.needsIndexSort = true;
        long duratoin = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        if (this.infoStream.isEnabled("SM")) {
            this.infoStream.message("SM", Duration.toString-impl((long)duratoin) + " to build merge sorted DocMaps");
        }
        return result;
    }

    public MergeState(@NotNull DocMap[] docMaps, @NotNull SegmentInfo segmentInfo, @NotNull FieldInfos mergeFieldInfos, @NotNull StoredFieldsReader[] storedFieldsReaders, @NotNull TermVectorsReader[] termVectorsReaders, @NotNull NormsProducer[] normsProducers, @NotNull DocValuesProducer[] docValuesProducers, @NotNull FieldInfos[] fieldInfos, @NotNull Bits[] liveDocs2, @NotNull FieldsProducer[] fieldsProducers, @NotNull PointsReader[] pointsReaders, @NotNull KnnVectorsReader[] knnVectorsReaders, @NotNull int[] maxDocs, @NotNull InfoStream infoStream, @Nullable Executor intraMergeTaskExecutor, boolean needsIndexSort) {
        Intrinsics.checkNotNullParameter((Object)docMaps, (String)"docMaps");
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)mergeFieldInfos, (String)"mergeFieldInfos");
        Intrinsics.checkNotNullParameter((Object)storedFieldsReaders, (String)"storedFieldsReaders");
        Intrinsics.checkNotNullParameter((Object)termVectorsReaders, (String)"termVectorsReaders");
        Intrinsics.checkNotNullParameter((Object)normsProducers, (String)"normsProducers");
        Intrinsics.checkNotNullParameter((Object)docValuesProducers, (String)"docValuesProducers");
        Intrinsics.checkNotNullParameter((Object)fieldInfos, (String)"fieldInfos");
        Intrinsics.checkNotNullParameter((Object)liveDocs2, (String)"liveDocs");
        Intrinsics.checkNotNullParameter((Object)fieldsProducers, (String)"fieldsProducers");
        Intrinsics.checkNotNullParameter((Object)pointsReaders, (String)"pointsReaders");
        Intrinsics.checkNotNullParameter((Object)knnVectorsReaders, (String)"knnVectorsReaders");
        Intrinsics.checkNotNullParameter((Object)maxDocs, (String)"maxDocs");
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this.docMaps = docMaps;
        this.segmentInfo = segmentInfo;
        this.mergeFieldInfos = mergeFieldInfos;
        this.storedFieldsReaders = storedFieldsReaders;
        this.termVectorsReaders = termVectorsReaders;
        this.normsProducers = normsProducers;
        this.docValuesProducers = docValuesProducers;
        this.fieldInfos = fieldInfos;
        this.liveDocs = liveDocs2;
        this.fieldsProducers = fieldsProducers;
        this.pointsReaders = pointsReaders;
        this.knnVectorsReaders = knnVectorsReaders;
        this.maxDocs = maxDocs;
        this.infoStream = infoStream;
        this.intraMergeTaskExecutor = intraMergeTaskExecutor;
        this.needsIndexSort = needsIndexSort;
    }

    private static final int buildDeletionDocMaps$lambda$0(Bits $liveDocs, int $docBase, PackedLongValues $delDocMap, int docID) {
        if ($liveDocs == null) {
            return $docBase + docID;
        }
        if ($liveDocs.get(docID)) {
            PackedLongValues packedLongValues = $delDocMap;
            Intrinsics.checkNotNull((Object)packedLongValues);
            return $docBase + (int)packedLongValues.get(docID);
        }
        return -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/MergeState$Companion;", "", "<init>", "()V", "verifyIndexSort", "", "readers", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "removeDeletes", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "maxDoc", "", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void verifyIndexSort(List<CodecReader> readers, SegmentInfo segmentInfo) {
            Sort indexSort = segmentInfo.getIndexSort();
            if (indexSort == null) {
                return;
            }
            for (CodecReader leaf : readers) {
                Sort segmentSort = leaf.getMetaData().getSort();
                if (segmentSort != null && IndexWriter.Companion.isCongruentSort(indexSort, segmentSort)) continue;
                boolean bl = false;
                Object object = segmentSort;
                if (object == null) {
                    object = "null";
                }
                String string = "index sort mismatch: merged segment has sort=" + indexSort + " but to-be-merged segment has sort=" + object;
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final PackedLongValues removeDeletes(int maxDoc, @NotNull Bits liveDocs2) {
            Intrinsics.checkNotNullParameter((Object)liveDocs2, (String)"liveDocs");
            PackedLongValues.Builder docMapBuilder = PackedLongValues.Companion.monotonicBuilder(0.0f);
            int del = 0;
            for (int i = 0; i < maxDoc; ++i) {
                docMapBuilder.add(i - del);
                if (liveDocs2.get(i)) continue;
                ++del;
            }
            return docMapBuilder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "", "get", "", "docID", "core"})
    public static interface DocMap {
        public int get(int var1);
    }
}

