/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.OrdinalMap;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.LongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/index/MultiDocValues;", "", "<init>", "()V", "getNormValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "r", "Lorg/gnit/lucenekmp/index/IndexReader;", "field", "", "getNumericValues", "getBinaryValues", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "getSortedNumericValues", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "getSortedValues", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "getSortedSetValues", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "MultiSortedDocValues", "MultiSortedSetDocValues", "core"})
public final class MultiDocValues {
    @NotNull
    public static final MultiDocValues INSTANCE = new MultiDocValues();

    private MultiDocValues() {
    }

    @Nullable
    public final NumericDocValues getNormValues(@NotNull IndexReader r, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        List<LeafReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        switch (size2) {
            case 0: {
                return null;
            }
            case 1: {
                return leaves.get(0).reader().getNormValues(field);
            }
        }
        boolean normFound = false;
        for (LeafReaderContext leaf : leaves) {
            LeafReader reader2 = leaf.reader();
            FieldInfo info = reader2.getFieldInfos().fieldInfo(field);
            if (info == null || !info.hasNorms()) continue;
            normFound = true;
            break;
        }
        if (!normFound) {
            return null;
        }
        return new NumericDocValues(leaves, field){
            private int nextLeaf;
            private NumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID;
            final /* synthetic */ List<LeafReaderContext> $leaves;
            final /* synthetic */ String $field;
            {
                this.$leaves = $leaves;
                this.$field = $field;
                this.docID = -1;
            }

            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == this.$leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(this.nextLeaf);
                        Intrinsics.checkNotNull((Object)leafReaderContext);
                        this.currentValues = leafReaderContext.reader().getNormValues(this.$field);
                        int n = this.nextLeaf;
                        this.nextLeaf = n + 1;
                        continue;
                    }
                    NumericDocValues numericDocValues = this.currentValues;
                    Intrinsics.checkNotNull((Object)numericDocValues);
                    newDocID = numericDocValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                this.docID = leafReaderContext.getDocBase() + newDocID;
                return this.docID;
            }

            public int docID() {
                return this.docID;
            }

            public int advance(int targetDocID) throws IOException {
                if (!(targetDocID > this.docID)) {
                    boolean $i$a$-require-MultiDocValues$getNormValues$1$advance$22 = false;
                    String $i$a$-require-MultiDocValues$getNormValues$1$advance$22 = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException($i$a$-require-MultiDocValues$getNormValues$1$advance$22.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == this.$leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(readerIndex);
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    this.currentValues = leafReaderContext.reader().getNormValues(this.$field);
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                    this.nextLeaf = readerIndex + 1;
                }
                NumericDocValues numericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)numericDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                int newDocID = numericDocValues.advance(targetDocID - leafReaderContext.getDocBase());
                if (newDocID == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                LeafReaderContext leafReaderContext2 = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext2);
                this.docID = leafReaderContext2.getDocBase() + newDocID;
                return this.docID;
            }

            public boolean advanceExact(int targetDocID) throws IOException {
                if (!(targetDocID >= this.docID)) {
                    boolean bl = false;
                    String string = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException(string.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (!(readerIndex != this.$leaves.size())) {
                        boolean bl = false;
                        String string = "Out of range: " + targetDocID;
                        throw new IllegalArgumentException(string.toString());
                    }
                    LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(readerIndex);
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    this.currentValues = leafReaderContext.reader().getNormValues(this.$field);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                NumericDocValues numericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)numericDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                return numericDocValues.advanceExact(targetDocID - leafReaderContext.getDocBase());
            }

            public long longValue() throws IOException {
                NumericDocValues numericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)numericDocValues);
                return numericDocValues.longValue();
            }

            public long cost() {
                return 0L;
            }
        };
    }

    @Nullable
    public final NumericDocValues getNumericValues(@NotNull IndexReader r, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        List<LeafReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        switch (size2) {
            case 0: {
                return null;
            }
            case 1: {
                return leaves.get(0).reader().getNumericDocValues(field);
            }
        }
        boolean anyReal = false;
        for (LeafReaderContext leaf : leaves) {
            DocValuesType dvType;
            FieldInfo fieldInfo = leaf.reader().getFieldInfos().fieldInfo(field);
            if (fieldInfo == null || (dvType = fieldInfo.getDocValuesType()) != DocValuesType.NUMERIC) continue;
            anyReal = true;
            break;
        }
        if (!anyReal) {
            return null;
        }
        return new NumericDocValues(leaves, field){
            private int nextLeaf;
            private NumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID;
            final /* synthetic */ List<LeafReaderContext> $leaves;
            final /* synthetic */ String $field;
            {
                this.$leaves = $leaves;
                this.$field = $field;
                this.docID = -1;
            }

            public int docID() {
                return this.docID;
            }

            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == this.$leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(this.nextLeaf);
                        Intrinsics.checkNotNull((Object)leafReaderContext);
                        this.currentValues = leafReaderContext.reader().getNumericDocValues(this.$field);
                        int n = this.nextLeaf;
                        this.nextLeaf = n + 1;
                        continue;
                    }
                    NumericDocValues numericDocValues = this.currentValues;
                    Intrinsics.checkNotNull((Object)numericDocValues);
                    newDocID = numericDocValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                this.docID = leafReaderContext.getDocBase() + newDocID;
                return this.docID;
            }

            public int advance(int targetDocID) throws IOException {
                if (!(targetDocID > this.docID)) {
                    boolean $i$a$-require-MultiDocValues$getNumericValues$1$advance$22 = false;
                    String $i$a$-require-MultiDocValues$getNumericValues$1$advance$22 = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException($i$a$-require-MultiDocValues$getNumericValues$1$advance$22.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == this.$leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(readerIndex);
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    this.currentValues = leafReaderContext.reader().getNumericDocValues(this.$field);
                    this.nextLeaf = readerIndex + 1;
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                }
                NumericDocValues numericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)numericDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                int newDocID = numericDocValues.advance(targetDocID - leafReaderContext.getDocBase());
                if (newDocID == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                LeafReaderContext leafReaderContext2 = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext2);
                this.docID = leafReaderContext2.getDocBase() + newDocID;
                return this.docID;
            }

            public boolean advanceExact(int targetDocID) throws IOException {
                if (!(targetDocID >= this.docID)) {
                    boolean bl = false;
                    String string = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException(string.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (!(readerIndex != this.$leaves.size())) {
                        boolean bl = false;
                        String string = "Out of range: " + targetDocID;
                        throw new IllegalArgumentException(string.toString());
                    }
                    LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(readerIndex);
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    this.currentValues = leafReaderContext.reader().getNumericDocValues(this.$field);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                NumericDocValues numericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)numericDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                return numericDocValues.advanceExact(targetDocID - leafReaderContext.getDocBase());
            }

            public long longValue() throws IOException {
                NumericDocValues numericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)numericDocValues);
                return numericDocValues.longValue();
            }

            public long cost() {
                return 0L;
            }
        };
    }

    @Nullable
    public final BinaryDocValues getBinaryValues(@NotNull IndexReader r, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        List<LeafReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        switch (size2) {
            case 0: {
                return null;
            }
            case 1: {
                return leaves.get(0).reader().getBinaryDocValues(field);
            }
        }
        boolean anyReal = false;
        for (LeafReaderContext leaf : leaves) {
            DocValuesType dvType;
            FieldInfo fieldInfo = leaf.reader().getFieldInfos().fieldInfo(field);
            if (fieldInfo == null || (dvType = fieldInfo.getDocValuesType()) != DocValuesType.BINARY) continue;
            anyReal = true;
            break;
        }
        if (!anyReal) {
            return null;
        }
        return new BinaryDocValues(leaves, field){
            private int nextLeaf;
            private BinaryDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID;
            final /* synthetic */ List<LeafReaderContext> $leaves;
            final /* synthetic */ String $field;
            {
                this.$leaves = $leaves;
                this.$field = $field;
                this.docID = -1;
            }

            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == this.$leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(this.nextLeaf);
                        Intrinsics.checkNotNull((Object)leafReaderContext);
                        this.currentValues = leafReaderContext.reader().getBinaryDocValues(this.$field);
                        int n = this.nextLeaf;
                        this.nextLeaf = n + 1;
                        continue;
                    }
                    BinaryDocValues binaryDocValues = this.currentValues;
                    Intrinsics.checkNotNull((Object)binaryDocValues);
                    newDocID = binaryDocValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                this.docID = leafReaderContext.getDocBase() + newDocID;
                return this.docID;
            }

            public int docID() {
                return this.docID;
            }

            public int advance(int targetDocID) throws IOException {
                if (!(targetDocID > this.docID)) {
                    boolean $i$a$-require-MultiDocValues$getBinaryValues$1$advance$22 = false;
                    String $i$a$-require-MultiDocValues$getBinaryValues$1$advance$22 = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException($i$a$-require-MultiDocValues$getBinaryValues$1$advance$22.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == this.$leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(readerIndex);
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    this.currentValues = leafReaderContext.reader().getBinaryDocValues(this.$field);
                    this.nextLeaf = readerIndex + 1;
                    if (this.currentValues == null) {
                        return this.nextDoc();
                    }
                }
                BinaryDocValues binaryDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)binaryDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                int newDocID = binaryDocValues.advance(targetDocID - leafReaderContext.getDocBase());
                if (newDocID == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                LeafReaderContext leafReaderContext2 = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext2);
                this.docID = leafReaderContext2.getDocBase() + newDocID;
                return this.docID;
            }

            public boolean advanceExact(int targetDocID) throws IOException {
                if (!(targetDocID >= this.docID)) {
                    boolean bl = false;
                    String string = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException(string.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (!(readerIndex != this.$leaves.size())) {
                        boolean bl = false;
                        String string = "Out of range: " + targetDocID;
                        throw new IllegalArgumentException(string.toString());
                    }
                    LeafReaderContext leafReaderContext = this.currentLeaf = this.$leaves.get(readerIndex);
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    this.currentValues = leafReaderContext.reader().getBinaryDocValues(this.$field);
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                BinaryDocValues binaryDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)binaryDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                return binaryDocValues.advanceExact(targetDocID - leafReaderContext.getDocBase());
            }

            public BytesRef binaryValue() throws IOException {
                BinaryDocValues binaryDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)binaryDocValues);
                return binaryDocValues.binaryValue();
            }

            public long cost() {
                return 0L;
            }
        };
    }

    @Nullable
    public final SortedNumericDocValues getSortedNumericValues(@NotNull IndexReader r, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        List<LeafReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        switch (size2) {
            case 0: {
                return null;
            }
            case 1: {
                return leaves.get(0).reader().getSortedNumericDocValues(field);
            }
        }
        boolean anyReal = false;
        SortedNumericDocValues[] values2 = new SortedNumericDocValues[size2];
        long totalCost = 0L;
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedNumericDocValues v = context.reader().getSortedNumericDocValues(field);
            if (v == null) {
                v = DocValues.INSTANCE.emptySortedNumeric();
            } else {
                anyReal = true;
            }
            values2[i] = v;
            totalCost += v.cost();
        }
        if (!anyReal) {
            return null;
        }
        long finalTotalCost = totalCost;
        return new SortedNumericDocValues(leaves, values2, finalTotalCost){
            private int nextLeaf;
            private SortedNumericDocValues currentValues;
            private LeafReaderContext currentLeaf;
            private int docID;
            final /* synthetic */ List<LeafReaderContext> $leaves;
            final /* synthetic */ SortedNumericDocValues[] $values;
            final /* synthetic */ long $finalTotalCost;
            {
                this.$leaves = $leaves;
                this.$values = $values;
                this.$finalTotalCost = $finalTotalCost;
                this.docID = -1;
            }

            public int nextDoc() throws IOException {
                int newDocID;
                while (true) {
                    if (this.currentValues == null) {
                        if (this.nextLeaf == this.$leaves.size()) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.currentLeaf = this.$leaves.get(this.nextLeaf);
                        this.currentValues = this.$values[this.nextLeaf];
                        int n = this.nextLeaf;
                        this.nextLeaf = n + 1;
                    }
                    SortedNumericDocValues sortedNumericDocValues = this.currentValues;
                    Intrinsics.checkNotNull((Object)sortedNumericDocValues);
                    newDocID = sortedNumericDocValues.nextDoc();
                    if (newDocID != Integer.MAX_VALUE) break;
                    this.currentValues = null;
                }
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                this.docID = leafReaderContext.getDocBase() + newDocID;
                return this.docID;
            }

            public int docID() {
                return this.docID;
            }

            public int advance(int targetDocID) throws IOException {
                if (!(targetDocID > this.docID)) {
                    boolean $i$a$-require-MultiDocValues$getSortedNumericValues$1$advance$22 = false;
                    String $i$a$-require-MultiDocValues$getSortedNumericValues$1$advance$22 = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException($i$a$-require-MultiDocValues$getSortedNumericValues$1$advance$22.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (readerIndex == this.$leaves.size()) {
                        this.currentValues = null;
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentLeaf = this.$leaves.get(readerIndex);
                    this.currentValues = this.$values[readerIndex];
                    this.nextLeaf = readerIndex + 1;
                }
                SortedNumericDocValues sortedNumericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)sortedNumericDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                int newDocID = sortedNumericDocValues.advance(targetDocID - leafReaderContext.getDocBase());
                if (newDocID == Integer.MAX_VALUE) {
                    this.currentValues = null;
                    return this.nextDoc();
                }
                LeafReaderContext leafReaderContext2 = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext2);
                this.docID = leafReaderContext2.getDocBase() + newDocID;
                return this.docID;
            }

            public boolean advanceExact(int targetDocID) throws IOException {
                if (!(targetDocID >= this.docID)) {
                    boolean bl = false;
                    String string = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                    throw new IllegalArgumentException(string.toString());
                }
                int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.$leaves);
                if (readerIndex >= this.nextLeaf) {
                    if (!(readerIndex != this.$leaves.size())) {
                        boolean bl = false;
                        String string = "Out of range: " + targetDocID;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.currentLeaf = this.$leaves.get(readerIndex);
                    this.currentValues = this.$values[readerIndex];
                    this.nextLeaf = readerIndex + 1;
                }
                this.docID = targetDocID;
                if (this.currentValues == null) {
                    return false;
                }
                SortedNumericDocValues sortedNumericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)sortedNumericDocValues);
                LeafReaderContext leafReaderContext = this.currentLeaf;
                Intrinsics.checkNotNull((Object)leafReaderContext);
                return sortedNumericDocValues.advanceExact(targetDocID - leafReaderContext.getDocBase());
            }

            public long cost() {
                return this.$finalTotalCost;
            }

            public int docValueCount() {
                SortedNumericDocValues sortedNumericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)sortedNumericDocValues);
                return sortedNumericDocValues.docValueCount();
            }

            public long nextValue() throws IOException {
                SortedNumericDocValues sortedNumericDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)sortedNumericDocValues);
                return sortedNumericDocValues.nextValue();
            }
        };
    }

    @Nullable
    public final SortedDocValues getSortedValues(@NotNull IndexReader r, @NotNull String field) throws IOException {
        IndexReader.CacheHelper cacheHelper2;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        List<LeafReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        switch (size2) {
            case 0: {
                return null;
            }
            case 1: {
                return leaves.get(0).reader().getSortedDocValues(field);
            }
        }
        boolean anyReal = false;
        SortedDocValues[] values2 = new SortedDocValues[size2];
        int[] starts = new int[size2 + 1];
        long totalCost = 0L;
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedDocValues v = context.reader().getSortedDocValues(field);
            if (v == null) {
                v = DocValues.INSTANCE.emptySorted();
            } else {
                anyReal = true;
                totalCost += v.cost();
            }
            values2[i] = v;
            starts[i] = context.getDocBase();
        }
        starts[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        IndexReader.CacheHelper cacheHelper3 = cacheHelper2 = r.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper3 != null ? cacheHelper3.getKey() : null;
        OrdinalMap mapping = OrdinalMap.Companion.build(owner, values2, 0.25f);
        return new MultiSortedDocValues(values2, starts, mapping, totalCost);
    }

    @Nullable
    public final SortedSetDocValues getSortedSetValues(@NotNull IndexReader r, @NotNull String field) throws IOException {
        IndexReader.CacheHelper cacheHelper2;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        List<LeafReaderContext> leaves = r.leaves();
        int size2 = leaves.size();
        switch (size2) {
            case 0: {
                return null;
            }
            case 1: {
                return leaves.get(0).reader().getSortedSetDocValues(field);
            }
        }
        boolean anyReal = false;
        SortedSetDocValues[] values2 = new SortedSetDocValues[size2];
        int[] starts = new int[size2 + 1];
        long totalCost = 0L;
        for (int i = 0; i < size2; ++i) {
            LeafReaderContext context = leaves.get(i);
            SortedSetDocValues v = context.reader().getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.INSTANCE.emptySortedSet();
            } else {
                anyReal = true;
                totalCost += v.cost();
            }
            values2[i] = v;
            starts[i] = context.getDocBase();
        }
        starts[size2] = r.maxDoc();
        if (!anyReal) {
            return null;
        }
        IndexReader.CacheHelper cacheHelper3 = cacheHelper2 = r.getReaderCacheHelper();
        IndexReader.CacheKey owner = cacheHelper3 != null ? cacheHelper3.getKey() : null;
        OrdinalMap mapping = OrdinalMap.Companion.build(owner, values2, 0.25f);
        return new MultiSortedSetDocValues(values2, starts, mapping, totalCost);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/index/MultiDocValues$MultiSortedDocValues;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "values", "", "docStarts", "", "mapping", "Lorg/gnit/lucenekmp/index/OrdinalMap;", "totalCost", "", "<init>", "([Lorg/gnit/lucenekmp/index/SortedDocValues;[ILorg/gnit/lucenekmp/index/OrdinalMap;J)V", "getDocStarts", "()[I", "getValues", "()[Lorg/gnit/lucenekmp/index/SortedDocValues;", "[Lorg/gnit/lucenekmp/index/SortedDocValues;", "getMapping", "()Lorg/gnit/lucenekmp/index/OrdinalMap;", "nextLeaf", "", "currentValues", "currentDocStart", "docID", "nextDoc", "advance", "targetDocID", "advanceExact", "", "ordValue", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "valueCount", "getValueCount", "()I", "cost", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiDocValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiDocValues.kt\norg/gnit/lucenekmp/index/MultiDocValues$MultiSortedDocValues\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,945:1\n3#2,8:946\n10#3:954\n1#4:955\n*S KotlinDebug\n*F\n+ 1 MultiDocValues.kt\norg/gnit/lucenekmp/index/MultiDocValues$MultiSortedDocValues\n*L\n699#1:946,8\n699#1:954\n*E\n"})
    public static final class MultiSortedDocValues
    extends SortedDocValues {
        @NotNull
        private final int[] docStarts;
        @NotNull
        private final SortedDocValues[] values;
        @NotNull
        private final OrdinalMap mapping;
        private final long totalCost;
        private int nextLeaf;
        @Nullable
        private SortedDocValues currentValues;
        private int currentDocStart;
        private int docID;

        public MultiSortedDocValues(@NotNull SortedDocValues[] values2, @NotNull int[] docStarts, @NotNull OrdinalMap mapping, long totalCost) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docStarts, (String)"docStarts");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            this.docID = -1;
            boolean condition$iv = docStarts.length == values2.length + 1;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.values = values2;
            this.docStarts = docStarts;
            this.mapping = mapping;
            this.totalCost = totalCost;
        }

        @NotNull
        public final int[] getDocStarts() {
            return this.docStarts;
        }

        @NotNull
        public final SortedDocValues[] getValues() {
            return this.values;
        }

        @NotNull
        public final OrdinalMap getMapping() {
            return this.mapping;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            int newDocID;
            while (true) {
                if (this.currentValues == null) {
                    if (this.nextLeaf == this.values.length) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentDocStart = this.docStarts[this.nextLeaf];
                    this.currentValues = this.values[this.nextLeaf];
                    int n = this.nextLeaf;
                    this.nextLeaf = n + 1;
                    continue;
                }
                SortedDocValues sortedDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)sortedDocValues);
                newDocID = sortedDocValues.nextDoc();
                if (newDocID != Integer.MAX_VALUE) break;
                this.currentValues = null;
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public int advance(int targetDocID) throws IOException {
            if (!(targetDocID > this.docID)) {
                boolean $i$a$-require-MultiDocValues$MultiSortedDocValues$advance$22 = false;
                String $i$a$-require-MultiDocValues$MultiSortedDocValues$advance$22 = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                throw new IllegalArgumentException($i$a$-require-MultiDocValues$MultiSortedDocValues$advance$22.toString());
            }
            int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    this.currentValues = null;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            SortedDocValues sortedDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedDocValues);
            int newDocID = sortedDocValues.advance(targetDocID - this.currentDocStart);
            if (newDocID == Integer.MAX_VALUE) {
                this.currentValues = null;
                return this.nextDoc();
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public boolean advanceExact(int targetDocID) throws IOException {
            if (!(targetDocID >= this.docID)) {
                boolean bl = false;
                String string = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                throw new IllegalArgumentException(string.toString());
            }
            int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (!(readerIndex != this.values.length)) {
                    boolean bl = false;
                    String string = "Out of range: " + targetDocID;
                    throw new IllegalArgumentException(string.toString());
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            this.docID = targetDocID;
            if (this.currentValues == null) {
                return false;
            }
            SortedDocValues sortedDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedDocValues);
            return sortedDocValues.advanceExact(targetDocID - this.currentDocStart);
        }

        @Override
        public int ordValue() throws IOException {
            LongValues longValues = this.mapping.getGlobalOrds(this.nextLeaf - 1);
            SortedDocValues sortedDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedDocValues);
            return (int)longValues.get(sortedDocValues.ordValue());
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            int segmentOrd = (int)this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public int getValueCount() {
            return (int)this.mapping.getValueCount();
        }

        @Override
        public long cost() {
            return this.totalCost;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\tH\u0016J\b\u0010%\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/index/MultiDocValues$MultiSortedSetDocValues;", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "values", "", "docStarts", "", "mapping", "Lorg/gnit/lucenekmp/index/OrdinalMap;", "totalCost", "", "<init>", "([Lorg/gnit/lucenekmp/index/SortedSetDocValues;[ILorg/gnit/lucenekmp/index/OrdinalMap;J)V", "getDocStarts", "()[I", "getValues", "()[Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "[Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "getMapping", "()Lorg/gnit/lucenekmp/index/OrdinalMap;", "nextLeaf", "", "currentValues", "currentDocStart", "docID", "nextDoc", "advance", "targetDocID", "advanceExact", "", "nextOrd", "docValueCount", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "valueCount", "getValueCount", "()J", "cost", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiDocValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiDocValues.kt\norg/gnit/lucenekmp/index/MultiDocValues$MultiSortedSetDocValues\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,945:1\n3#2,8:946\n10#3:954\n1#4:955\n*S KotlinDebug\n*F\n+ 1 MultiDocValues.kt\norg/gnit/lucenekmp/index/MultiDocValues$MultiSortedSetDocValues\n*L\n834#1:946,8\n834#1:954\n*E\n"})
    public static final class MultiSortedSetDocValues
    extends SortedSetDocValues {
        @NotNull
        private final int[] docStarts;
        @NotNull
        private final SortedSetDocValues[] values;
        @NotNull
        private final OrdinalMap mapping;
        private final long totalCost;
        private int nextLeaf;
        @Nullable
        private SortedSetDocValues currentValues;
        private int currentDocStart;
        private int docID;

        public MultiSortedSetDocValues(@NotNull SortedSetDocValues[] values2, @NotNull int[] docStarts, @NotNull OrdinalMap mapping, long totalCost) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docStarts, (String)"docStarts");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            this.docID = -1;
            boolean condition$iv = docStarts.length == values2.length + 1;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.values = values2;
            this.docStarts = docStarts;
            this.mapping = mapping;
            this.totalCost = totalCost;
        }

        @NotNull
        public final int[] getDocStarts() {
            return this.docStarts;
        }

        @NotNull
        public final SortedSetDocValues[] getValues() {
            return this.values;
        }

        @NotNull
        public final OrdinalMap getMapping() {
            return this.mapping;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            int newDocID;
            while (true) {
                if (this.currentValues == null) {
                    if (this.nextLeaf == this.values.length) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.currentDocStart = this.docStarts[this.nextLeaf];
                    this.currentValues = this.values[this.nextLeaf];
                    int n = this.nextLeaf;
                    this.nextLeaf = n + 1;
                    continue;
                }
                SortedSetDocValues sortedSetDocValues = this.currentValues;
                Intrinsics.checkNotNull((Object)sortedSetDocValues);
                newDocID = sortedSetDocValues.nextDoc();
                if (newDocID != Integer.MAX_VALUE) break;
                this.currentValues = null;
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public int advance(int targetDocID) throws IOException {
            if (!(targetDocID > this.docID)) {
                boolean $i$a$-require-MultiDocValues$MultiSortedSetDocValues$advance$22 = false;
                String $i$a$-require-MultiDocValues$MultiSortedSetDocValues$advance$22 = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                throw new IllegalArgumentException($i$a$-require-MultiDocValues$MultiSortedSetDocValues$advance$22.toString());
            }
            int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (readerIndex == this.values.length) {
                    this.currentValues = null;
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            SortedSetDocValues sortedSetDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedSetDocValues);
            int newDocID = sortedSetDocValues.advance(targetDocID - this.currentDocStart);
            if (newDocID == Integer.MAX_VALUE) {
                this.currentValues = null;
                return this.nextDoc();
            }
            this.docID = this.currentDocStart + newDocID;
            return this.docID;
        }

        @Override
        public boolean advanceExact(int targetDocID) throws IOException {
            if (!(targetDocID >= this.docID)) {
                boolean bl = false;
                String string = "can only advance beyond current document: on docID=" + this.docID + " but targetDocID=" + targetDocID;
                throw new IllegalArgumentException(string.toString());
            }
            int readerIndex = ReaderUtil.INSTANCE.subIndex(targetDocID, this.docStarts);
            if (readerIndex >= this.nextLeaf) {
                if (!(readerIndex != this.values.length)) {
                    boolean bl = false;
                    String string = "Out of range: " + targetDocID;
                    throw new IllegalArgumentException(string.toString());
                }
                this.currentDocStart = this.docStarts[readerIndex];
                this.currentValues = this.values[readerIndex];
                this.nextLeaf = readerIndex + 1;
            }
            this.docID = targetDocID;
            if (this.currentValues == null) {
                return false;
            }
            SortedSetDocValues sortedSetDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedSetDocValues);
            return sortedSetDocValues.advanceExact(targetDocID - this.currentDocStart);
        }

        @Override
        public long nextOrd() throws IOException {
            SortedSetDocValues sortedSetDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedSetDocValues);
            long segmentOrd = sortedSetDocValues.nextOrd();
            return this.mapping.getGlobalOrds(this.nextLeaf - 1).get(segmentOrd);
        }

        @Override
        public int docValueCount() {
            SortedSetDocValues sortedSetDocValues = this.currentValues;
            Intrinsics.checkNotNull((Object)sortedSetDocValues);
            return sortedSetDocValues.docValueCount();
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(long ord) throws IOException {
            int subIndex = this.mapping.getFirstSegmentNumber(ord);
            long segmentOrd = this.mapping.getFirstSegmentOrd(ord);
            return this.values[subIndex].lookupOrd(segmentOrd);
        }

        @Override
        public long getValueCount() {
            return this.mapping.getValueCount();
        }

        @Override
        public long cost() {
            return this.totalCost;
        }
    }
}

