/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.MultiTermsEnum;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.ReaderSlice;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003J!\u0010'\u001a\u00020\u00002\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0005H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0016J\b\u0010.\u001a\u00020\u0005H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016J\b\u00100\u001a\u00020\u0005H\u0016J\b\u00101\u001a\u00020\u0005H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000209H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\t\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0014\"\u0004\b!\u0010\u0016R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R\u0016\u00102\u001a\u0004\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/index/MultiPostingsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "parent", "Lorg/gnit/lucenekmp/index/MultiTermsEnum;", "subReaderCount", "", "<init>", "(Lorg/gnit/lucenekmp/index/MultiTermsEnum;I)V", "subPostingsEnums", "", "getSubPostingsEnums", "()[Lorg/gnit/lucenekmp/index/PostingsEnum;", "[Lorg/gnit/lucenekmp/index/PostingsEnum;", "subs", "Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;", "getSubs", "()[Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;", "[Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;", "numSubs", "getNumSubs", "()I", "setNumSubs", "(I)V", "upto", "getUpto", "setUpto", "current", "getCurrent", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "setCurrent", "(Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "currentBase", "getCurrentBase", "setCurrentBase", "doc", "getDoc", "setDoc", "canReuse", "", "reset", "newSubs", "([Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;I)Lorg/gnit/lucenekmp/index/MultiPostingsEnum;", "freq", "docID", "advance", "target", "nextDoc", "nextPosition", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "cost", "", "toString", "", "EnumWithSlice", "core"})
@SourceDebugExtension(value={"SMAP\nMultiPostingsEnum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPostingsEnum.kt\norg/gnit/lucenekmp/index/MultiPostingsEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class MultiPostingsEnum
extends PostingsEnum {
    @NotNull
    private final MultiTermsEnum parent;
    @NotNull
    private final PostingsEnum[] subPostingsEnums;
    @NotNull
    private final EnumWithSlice[] subs;
    private int numSubs;
    private int upto;
    @Nullable
    private PostingsEnum current;
    private int currentBase;
    private int doc;

    public MultiPostingsEnum(@NotNull MultiTermsEnum parent, int subReaderCount) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.subPostingsEnums = new PostingsEnum[subReaderCount];
        this.doc = -1;
        this.subs = new EnumWithSlice[subReaderCount];
        int n = this.subs.length;
        for (int i = 0; i < n; ++i) {
            this.subs[i] = new EnumWithSlice();
        }
    }

    @NotNull
    public final PostingsEnum[] getSubPostingsEnums() {
        return this.subPostingsEnums;
    }

    @NotNull
    public final EnumWithSlice[] getSubs() {
        return this.subs;
    }

    public final int getNumSubs() {
        return this.numSubs;
    }

    public final void setNumSubs(int n) {
        this.numSubs = n;
    }

    public final int getUpto() {
        return this.upto;
    }

    public final void setUpto(int n) {
        this.upto = n;
    }

    @Nullable
    public final PostingsEnum getCurrent() {
        return this.current;
    }

    public final void setCurrent(@Nullable PostingsEnum postingsEnum) {
        this.current = postingsEnum;
    }

    public final int getCurrentBase() {
        return this.currentBase;
    }

    public final void setCurrentBase(int n) {
        this.currentBase = n;
    }

    public final int getDoc() {
        return this.doc;
    }

    public final void setDoc(int n) {
        this.doc = n;
    }

    public final boolean canReuse(@NotNull MultiTermsEnum parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.parent == parent;
    }

    @NotNull
    public final MultiPostingsEnum reset(@NotNull EnumWithSlice[] newSubs, int numSubs) {
        Intrinsics.checkNotNullParameter((Object)newSubs, (String)"newSubs");
        this.numSubs = numSubs;
        for (int i = 0; i < numSubs; ++i) {
            EnumWithSlice enumWithSlice = this.subs[i];
            Intrinsics.checkNotNull((Object)enumWithSlice);
            enumWithSlice.setPostingsEnum(newSubs[i].getPostingsEnum());
            EnumWithSlice enumWithSlice2 = this.subs[i];
            Intrinsics.checkNotNull((Object)enumWithSlice2);
            enumWithSlice2.setSlice(newSubs[i].getSlice());
        }
        this.upto = -1;
        this.doc = -1;
        this.current = null;
        return this;
    }

    @Override
    public int freq() throws IOException {
        if (this.current == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        PostingsEnum postingsEnum = this.current;
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.freq();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        if (!(target > this.doc)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (true) {
            int n;
            if (this.current != null) {
                int n2;
                int doc = 0;
                if (target < this.currentBase) {
                    PostingsEnum postingsEnum = this.current;
                    Intrinsics.checkNotNull((Object)postingsEnum);
                    v1 = postingsEnum.nextDoc();
                } else {
                    PostingsEnum postingsEnum = this.current;
                    Intrinsics.checkNotNull((Object)postingsEnum);
                    v1 = doc = postingsEnum.advance(target - this.currentBase);
                }
                if (doc == Integer.MAX_VALUE) {
                    this.current = null;
                    continue;
                }
                int it = n2 = doc + this.currentBase;
                boolean bl = false;
                this.doc = it;
                return n2;
            }
            if (this.upto == this.numSubs - 1) {
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }
            n = this.upto;
            this.upto = n + 1;
            EnumWithSlice enumWithSlice = this.subs[this.upto];
            Intrinsics.checkNotNull((Object)enumWithSlice);
            this.current = enumWithSlice.getPostingsEnum();
            EnumWithSlice enumWithSlice2 = this.subs[this.upto];
            Intrinsics.checkNotNull((Object)enumWithSlice2);
            ReaderSlice readerSlice = enumWithSlice2.getSlice();
            Intrinsics.checkNotNull((Object)readerSlice);
            this.currentBase = readerSlice.getStart();
        }
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            if (this.current == null) {
                int n;
                if (this.upto == this.numSubs - 1) {
                    int it = n = Integer.MAX_VALUE;
                    boolean bl = false;
                    this.doc = it;
                    return n;
                }
                n = this.upto;
                this.upto = n + 1;
                EnumWithSlice enumWithSlice = this.subs[this.upto];
                Intrinsics.checkNotNull((Object)enumWithSlice);
                this.current = enumWithSlice.getPostingsEnum();
                EnumWithSlice enumWithSlice2 = this.subs[this.upto];
                Intrinsics.checkNotNull((Object)enumWithSlice2);
                ReaderSlice readerSlice = enumWithSlice2.getSlice();
                Intrinsics.checkNotNull((Object)readerSlice);
                this.currentBase = readerSlice.getStart();
            }
            PostingsEnum postingsEnum = this.current;
            Intrinsics.checkNotNull((Object)postingsEnum);
            int doc = postingsEnum.nextDoc();
            if (doc != Integer.MAX_VALUE) {
                int n;
                int it = n = this.currentBase + doc;
                boolean bl = false;
                this.doc = it;
                return n;
            }
            this.current = null;
        }
    }

    @Override
    public int nextPosition() throws IOException {
        PostingsEnum postingsEnum = this.current;
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.nextPosition();
    }

    @Override
    public int startOffset() throws IOException {
        PostingsEnum postingsEnum = this.current;
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        PostingsEnum postingsEnum = this.current;
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.endOffset();
    }

    @Override
    @Nullable
    public BytesRef getPayload() {
        PostingsEnum postingsEnum = this.current;
        Intrinsics.checkNotNull((Object)postingsEnum);
        return postingsEnum.getPayload();
    }

    @Override
    public long cost() {
        long cost = 0L;
        int n = this.numSubs;
        for (int i = 0; i < n; ++i) {
            EnumWithSlice enumWithSlice = this.subs[i];
            Intrinsics.checkNotNull((Object)enumWithSlice);
            PostingsEnum postingsEnum = enumWithSlice.getPostingsEnum();
            Intrinsics.checkNotNull((Object)postingsEnum);
            cost += postingsEnum.cost();
        }
        return cost;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.subs);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "MultiDocsAndPositionsEnum(" + string + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;", "", "<init>", "()V", "postingsEnum", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "getPostingsEnum", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "setPostingsEnum", "(Lorg/gnit/lucenekmp/index/PostingsEnum;)V", "slice", "Lorg/gnit/lucenekmp/index/ReaderSlice;", "getSlice", "()Lorg/gnit/lucenekmp/index/ReaderSlice;", "setSlice", "(Lorg/gnit/lucenekmp/index/ReaderSlice;)V", "toString", "", "core"})
    public static final class EnumWithSlice {
        @Nullable
        private PostingsEnum postingsEnum;
        @Nullable
        private ReaderSlice slice;

        @Nullable
        public final PostingsEnum getPostingsEnum() {
            return this.postingsEnum;
        }

        public final void setPostingsEnum(@Nullable PostingsEnum postingsEnum) {
            this.postingsEnum = postingsEnum;
        }

        @Nullable
        public final ReaderSlice getSlice() {
            return this.slice;
        }

        public final void setSlice(@Nullable ReaderSlice readerSlice) {
            this.slice = readerSlice;
        }

        @NotNull
        public String toString() {
            return this.slice + ":" + this.postingsEnum;
        }
    }
}

