/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.MultiPostingsEnum;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.ReaderSlice;
import org.gnit.lucenekmp.index.SlowImpactsEnum;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.index.TermsEnumIndex;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00029:B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010 \u001a\u0004\u0018\u00010\u0014H\u0016J\u0019\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0003\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020)H\u0002J\n\u0010.\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010/\u001a\u00020\u001aH\u0016J\b\u00100\u001a\u00020+H\u0016J\u001a\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001022\u0006\u00104\u001a\u00020\u001aH\u0016J\u0010\u00105\u001a\u0002062\u0006\u00104\u001a\u00020\u001aH\u0016J\b\u00107\u001a\u000208H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001b\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/index/MultiTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "slices", "", "Lorg/gnit/lucenekmp/index/ReaderSlice;", "<init>", "([Lorg/gnit/lucenekmp/index/ReaderSlice;)V", "queue", "Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermMergeQueue;", "subs", "Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice;", "[Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice;", "currentSubs", "matchArray", "getMatchArray", "()[Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice;", "subDocs", "Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;", "[Lorg/gnit/lucenekmp/index/MultiPostingsEnum$EnumWithSlice;", "lastSeek", "Lorg/gnit/lucenekmp/util/BytesRef;", "lastSeekExact", "", "lastSeekScratch", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "value", "", "matchCount", "getMatchCount", "()I", "numSubs", "current", "term", "reset", "Lorg/gnit/lucenekmp/index/TermsEnum;", "termsEnumsIndex", "Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "([Lorg/gnit/lucenekmp/index/TermsEnumIndex;)Lorg/gnit/lucenekmp/index/TermsEnum;", "seekExact", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "", "ord", "", "pullTop", "pushTop", "next", "docFreq", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "toString", "", "TermsEnumWithSlice", "TermMergeQueue", "core"})
public final class MultiTermsEnum
extends BaseTermsEnum {
    @NotNull
    private final TermMergeQueue queue;
    @NotNull
    private final TermsEnumWithSlice[] subs;
    @NotNull
    private final TermsEnumWithSlice[] currentSubs;
    @NotNull
    private final TermsEnumWithSlice[] matchArray;
    @NotNull
    private final MultiPostingsEnum.EnumWithSlice[] subDocs;
    @Nullable
    private BytesRef lastSeek;
    private boolean lastSeekExact;
    @NotNull
    private final BytesRefBuilder lastSeekScratch;
    private int matchCount;
    private int numSubs;
    @Nullable
    private BytesRef current;

    public MultiTermsEnum(@NotNull ReaderSlice[] slices) {
        Intrinsics.checkNotNullParameter((Object)slices, (String)"slices");
        this.queue = new TermMergeQueue(slices.length);
        this.lastSeekScratch = new BytesRefBuilder();
        this.matchArray = new TermsEnumWithSlice[slices.length];
        this.subs = new TermsEnumWithSlice[slices.length];
        this.subDocs = new MultiPostingsEnum.EnumWithSlice[slices.length];
        int n = slices.length;
        for (int i = 0; i < n; ++i) {
            this.subs[i] = new TermsEnumWithSlice(i, slices[i]);
            this.subDocs[i] = new MultiPostingsEnum.EnumWithSlice();
            MultiPostingsEnum.EnumWithSlice enumWithSlice = this.subDocs[i];
            Intrinsics.checkNotNull((Object)enumWithSlice);
            enumWithSlice.setSlice(slices[i]);
        }
        this.currentSubs = new TermsEnumWithSlice[slices.length];
    }

    @NotNull
    public final TermsEnumWithSlice[] getMatchArray() {
        return this.matchArray;
    }

    public final int getMatchCount() {
        return this.matchCount;
    }

    @Override
    @Nullable
    public BytesRef term() {
        return this.current;
    }

    @NotNull
    public final TermsEnum reset(@NotNull TermsEnumIndex[] termsEnumsIndex) throws IOException {
        Intrinsics.checkNotNullParameter((Object)termsEnumsIndex, (String)"termsEnumsIndex");
        if (!(termsEnumsIndex.length <= this.matchArray.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.numSubs = 0;
        this.matchCount = 0;
        this.queue.clear();
        int n = termsEnumsIndex.length;
        for (int i = 0; i < n; ++i) {
            TermsEnumWithSlice entry;
            TermsEnumIndex termsEnumIndex;
            if (termsEnumsIndex[i] == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            BytesRef term = termsEnumIndex.next();
            if (term == null) continue;
            TermsEnumWithSlice termsEnumWithSlice = entry = this.subs[termsEnumIndex.getSubIndex()];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice);
            termsEnumWithSlice.reset(termsEnumIndex);
            this.queue.add(entry);
            int n2 = this.numSubs;
            this.numSubs = n2 + 1;
            this.currentSubs[n2] = entry;
        }
        return this.queue.size() == 0 ? TermsEnum.Companion.getEMPTY() : (TermsEnum)this;
    }

    @Override
    public boolean seekExact(@NotNull BytesRef term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.queue.clear();
        this.matchCount = 0;
        boolean seekOpt = false;
        if (this.lastSeek != null) {
            BytesRef bytesRef = this.lastSeek;
            Intrinsics.checkNotNull((Object)bytesRef);
            if (bytesRef.compareTo(term) <= 0) {
                seekOpt = true;
            }
        }
        this.lastSeek = null;
        this.lastSeekExact = true;
        int n = this.numSubs;
        for (int i = 0; i < n; ++i) {
            boolean status = false;
            if (seekOpt) {
                TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice);
                BytesRef curTerm = termsEnumWithSlice.term();
                if (curTerm != null) {
                    boolean bl;
                    int cmp = term.compareTo(curTerm);
                    if (cmp == 0) {
                        bl = true;
                    } else if (cmp < 0) {
                        bl = false;
                    } else {
                        TermsEnumWithSlice termsEnumWithSlice2 = this.currentSubs[i];
                        Intrinsics.checkNotNull((Object)termsEnumWithSlice2);
                        bl = termsEnumWithSlice2.seekExact(term);
                    }
                    status = bl;
                } else {
                    status = false;
                }
            } else {
                TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice);
                status = termsEnumWithSlice.seekExact(term);
            }
            if (!status) continue;
            int n2 = this.matchCount;
            this.matchCount = n2 + 1;
            Intrinsics.checkNotNull((Object)this.currentSubs[i]);
            TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice);
            this.current = termsEnumWithSlice.term();
            TermsEnumWithSlice termsEnumWithSlice3 = this.currentSubs[i];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice3);
            if (Intrinsics.areEqual((Object)term, (Object)termsEnumWithSlice3.term())) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.matchCount > 0;
    }

    @Override
    @NotNull
    public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef term) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.queue.clear();
        this.matchCount = 0;
        this.lastSeekExact = false;
        boolean seekOpt = false;
        if (this.lastSeek != null) {
            BytesRef bytesRef = this.lastSeek;
            Intrinsics.checkNotNull((Object)bytesRef);
            if (bytesRef.compareTo(term) <= 0) {
                seekOpt = true;
            }
        }
        this.lastSeekScratch.copyBytes(term);
        this.lastSeek = this.lastSeekScratch.get();
        int n = this.numSubs;
        for (int i = 0; i < n; ++i) {
            Object object;
            TermsEnum.SeekStatus status = null;
            if (seekOpt) {
                TermsEnum.SeekStatus seekStatus;
                TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice);
                BytesRef curTerm = termsEnumWithSlice.term();
                if (curTerm != null) {
                    int cmp = term.compareTo(curTerm);
                    if (cmp == 0) {
                        seekStatus = TermsEnum.SeekStatus.FOUND;
                    } else if (cmp < 0) {
                        seekStatus = TermsEnum.SeekStatus.NOT_FOUND;
                    } else {
                        TermsEnumWithSlice termsEnumWithSlice2 = this.currentSubs[i];
                        Intrinsics.checkNotNull((Object)termsEnumWithSlice2);
                        seekStatus = termsEnumWithSlice2.seekCeil(term);
                    }
                } else {
                    seekStatus = TermsEnum.SeekStatus.END;
                }
                status = seekStatus;
            } else {
                TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice);
                status = termsEnumWithSlice.seekCeil(term);
            }
            if (status == TermsEnum.SeekStatus.FOUND) {
                int n2 = this.matchCount;
                this.matchCount = n2 + 1;
                Intrinsics.checkNotNull((Object)this.currentSubs[i]);
                TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice);
                this.current = termsEnumWithSlice.term();
                TermsEnumWithSlice termsEnumWithSlice3 = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice3);
                object = this.queue.add(termsEnumWithSlice3);
                continue;
            }
            if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                TermsEnumWithSlice termsEnumWithSlice = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice);
                if (termsEnumWithSlice.term() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                TermsEnumWithSlice termsEnumWithSlice4 = this.currentSubs[i];
                Intrinsics.checkNotNull((Object)termsEnumWithSlice4);
                object = this.queue.add(termsEnumWithSlice4);
                continue;
            }
            if (!(status == TermsEnum.SeekStatus.END)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            object = Unit.INSTANCE;
        }
        if (this.matchCount > 0) {
            return TermsEnum.SeekStatus.FOUND;
        }
        if (this.queue.size() > 0) {
            this.pullTop();
            return TermsEnum.SeekStatus.NOT_FOUND;
        }
        return TermsEnum.SeekStatus.END;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    private final void pullTop() {
        if (!(this.matchCount == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.matchCount = this.queue.fillTop(this.matchArray);
        this.current = this.matchArray[0].term();
    }

    private final void pushTop() throws IOException {
        int n = this.matchCount;
        for (int i = 0; i < n; ++i) {
            TermsEnumWithSlice top = (TermsEnumWithSlice)this.queue.top();
            TermsEnumWithSlice termsEnumWithSlice = top.next() == null ? (TermsEnumWithSlice)this.queue.pop() : (TermsEnumWithSlice)this.queue.updateTop();
        }
        this.matchCount = 0;
    }

    @Override
    @Nullable
    public BytesRef next() throws IOException {
        if (this.lastSeekExact) {
            BytesRef bytesRef = this.current;
            Intrinsics.checkNotNull((Object)bytesRef);
            TermsEnum.SeekStatus status = this.seekCeil(bytesRef);
            if (!(status == TermsEnum.SeekStatus.FOUND)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.lastSeekExact = false;
        }
        this.lastSeek = null;
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    @Override
    public int docFreq() throws IOException {
        int sum = 0;
        int n = this.matchCount;
        for (int i = 0; i < n; ++i) {
            TermsEnumWithSlice termsEnumWithSlice = this.matchArray[i];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice);
            TermsEnum termsEnum = termsEnumWithSlice.getTermsEnum();
            Intrinsics.checkNotNull((Object)termsEnum);
            sum += termsEnum.docFreq();
        }
        return sum;
    }

    @Override
    public long totalTermFreq() throws IOException {
        long sum = 0L;
        int n = this.matchCount;
        for (int i = 0; i < n; ++i) {
            TermsEnumWithSlice termsEnumWithSlice = this.matchArray[i];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice);
            TermsEnum termsEnum = termsEnumWithSlice.getTermsEnum();
            Intrinsics.checkNotNull((Object)termsEnum);
            long v = termsEnum.totalTermFreq();
            if (!(v != -1L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            sum += v;
        }
        return sum;
    }

    @Override
    @NotNull
    public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
        PostingsEnum docsEnum = null;
        if (reuse != null && reuse instanceof MultiPostingsEnum) {
            docsEnum = reuse;
            if (!((MultiPostingsEnum)docsEnum).canReuse(this)) {
                docsEnum = new MultiPostingsEnum(this, this.subs.length);
            }
        } else {
            docsEnum = new MultiPostingsEnum(this, this.subs.length);
        }
        int upto = 0;
        ArrayUtil.Companion.timSort(this.matchArray, 0, this.matchCount, (arg_0, arg_1) -> MultiTermsEnum.postings$lambda$1(MultiTermsEnum::postings$lambda$0, arg_0, arg_1));
        int n = this.matchCount;
        for (int i = 0; i < n; ++i) {
            PostingsEnum subPostingsEnum;
            TermsEnumWithSlice entry;
            TermsEnumWithSlice termsEnumWithSlice = entry = this.matchArray[i];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice);
            if (!(termsEnumWithSlice.getSubIndex() < ((MultiPostingsEnum)docsEnum).getSubPostingsEnums().length)) {
                boolean bl = false;
                String string = entry.getSubIndex() + " vs " + ((MultiPostingsEnum)docsEnum).getSubPostingsEnums().length + "; " + this.subs.length;
                throw new IllegalArgumentException(string.toString());
            }
            TermsEnum termsEnum = entry.getTermsEnum();
            Intrinsics.checkNotNull((Object)termsEnum);
            if (termsEnum.postings(((MultiPostingsEnum)docsEnum).getSubPostingsEnums()[entry.getSubIndex()], flags) == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            ((MultiPostingsEnum)docsEnum).getSubPostingsEnums()[entry.getSubIndex()] = subPostingsEnum;
            MultiPostingsEnum.EnumWithSlice enumWithSlice = this.subDocs[upto];
            Intrinsics.checkNotNull((Object)enumWithSlice);
            enumWithSlice.setPostingsEnum(subPostingsEnum);
            MultiPostingsEnum.EnumWithSlice enumWithSlice2 = this.subDocs[upto];
            Intrinsics.checkNotNull((Object)enumWithSlice2);
            enumWithSlice2.setSlice(entry.getSubSlice$core());
            ++upto;
        }
        return ((MultiPostingsEnum)docsEnum).reset(this.subDocs, upto);
    }

    @Override
    @NotNull
    public ImpactsEnum impacts(int flags) throws IOException {
        return new SlowImpactsEnum(this.postings(null, flags));
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.subs);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "MultiTermsEnum(" + string + ")";
    }

    private static final int postings$lambda$0(TermsEnumWithSlice o1, TermsEnumWithSlice o2) {
        TermsEnumWithSlice termsEnumWithSlice = o1;
        Intrinsics.checkNotNull((Object)termsEnumWithSlice);
        int n = termsEnumWithSlice.getSubIndex();
        TermsEnumWithSlice termsEnumWithSlice2 = o2;
        Intrinsics.checkNotNull((Object)termsEnumWithSlice2);
        return n - termsEnumWithSlice2.getSubIndex();
    }

    private static final int postings$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0019\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermMergeQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice;", "size", "", "<init>", "(I)V", "stack", "", "getStack", "()[I", "lessThan", "", "termsA", "termsB", "fillTop", "tops", "", "([Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice;)I", "get", "i", "core"})
    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithSlice> {
        @NotNull
        private final int[] stack;

        public TermMergeQueue(int size2) {
            super(size2, null, 2, null);
            this.stack = new int[size2];
        }

        @NotNull
        public final int[] getStack() {
            return this.stack;
        }

        @Override
        public boolean lessThan(@NotNull TermsEnumWithSlice termsA, @NotNull TermsEnumWithSlice termsB) {
            Intrinsics.checkNotNullParameter((Object)termsA, (String)"termsA");
            Intrinsics.checkNotNullParameter((Object)termsB, (String)"termsB");
            return termsA.compareTermTo(termsB) < 0;
        }

        public final int fillTop(@NotNull TermsEnumWithSlice[] tops) {
            Intrinsics.checkNotNullParameter((Object)tops, (String)"tops");
            int size2 = this.size();
            if (size2 == 0) {
                return 0;
            }
            tops[0] = this.top();
            int numTop = 1;
            this.stack[0] = 1;
            int stackLen = 1;
            while (stackLen != 0) {
                int leftChild;
                int index = this.stack[--stackLen];
                int end = Math.min(size2, leftChild + 1);
                for (int child = leftChild = index << 1; child <= end; ++child) {
                    TermsEnumWithSlice te = this.get(child);
                    if (te.compareTermTo(tops[0]) != 0) continue;
                    tops[numTop++] = te;
                    this.stack[stackLen++] = child;
                }
            }
            return numTop;
        }

        @NotNull
        public final TermsEnumWithSlice get(int i) {
            TermsEnumWithSlice termsEnumWithSlice = ((TermsEnumWithSlice[])this.getHeapArray())[i];
            Intrinsics.checkNotNull((Object)termsEnumWithSlice, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.MultiTermsEnum.TermsEnumWithSlice");
            return termsEnumWithSlice;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice;", "Lorg/gnit/lucenekmp/index/TermsEnumIndex;", "index", "", "subSlice", "Lorg/gnit/lucenekmp/index/ReaderSlice;", "<init>", "(ILorg/gnit/lucenekmp/index/ReaderSlice;)V", "getSubSlice$core", "()Lorg/gnit/lucenekmp/index/ReaderSlice;", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nMultiTermsEnum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTermsEnum.kt\norg/gnit/lucenekmp/index/MultiTermsEnum$TermsEnumWithSlice\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n1#2:391\n*E\n"})
    public static final class TermsEnumWithSlice
    extends TermsEnumIndex {
        @NotNull
        private final ReaderSlice subSlice;

        public TermsEnumWithSlice(int index, @NotNull ReaderSlice subSlice) {
            Intrinsics.checkNotNullParameter((Object)subSlice, (String)"subSlice");
            super(null, index);
            this.subSlice = subSlice;
            if (!(this.subSlice.getLength() >= 0)) {
                boolean bl = false;
                String string = "length=" + this.subSlice.getLength();
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final ReaderSlice getSubSlice$core() {
            return this.subSlice;
        }

        @Override
        @NotNull
        public String toString() {
            return this.subSlice + ":" + super.toString();
        }
    }
}

