/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.NormsConsumer;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.NumericDocValuesWriter;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000fJ \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/index/NormValuesWriter;", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iwBytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/Counter;)V", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "pending", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "bytesUsed", "", "lastDocID", "", "addValue", "", "docID", "value", "updateBytesUsed", "finish", "maxDoc", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "normsConsumer", "Lorg/gnit/lucenekmp/codecs/NormsConsumer;", "BufferedNorms", "core"})
public final class NormValuesWriter {
    @NotNull
    private final DocsWithFieldSet docsWithField;
    @NotNull
    private final PackedLongValues.Builder pending;
    @NotNull
    private final Counter iwBytesUsed;
    private long bytesUsed;
    @NotNull
    private final FieldInfo fieldInfo;
    private int lastDocID;

    public NormValuesWriter(@NotNull FieldInfo fieldInfo, @NotNull Counter iwBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)iwBytesUsed, (String)"iwBytesUsed");
        this.docsWithField = new DocsWithFieldSet();
        this.pending = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
        this.lastDocID = -1;
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public final void addValue(int docID, long value) {
        if (!(docID > this.lastDocID)) {
            boolean bl = false;
            String string = "Norm for \"" + this.fieldInfo.getName() + "\" appears more than once in this document (only one value is allowed per field)";
            throw new IllegalArgumentException(string.toString());
        }
        this.pending.add(value);
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private final void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    public final void finish(int maxDoc) {
    }

    public final void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull NormsConsumer normsConsumer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)normsConsumer, (String)"normsConsumer");
        PackedLongValues values2 = this.pending.build();
        NumericDocValuesWriter.NumericDVs sorted = sortMap != null ? NumericDocValuesWriter.Companion.sortDocValues(state2.getSegmentInfo().maxDoc(), sortMap, new BufferedNorms(values2, this.docsWithField.iterator()), sortMap.size() == this.docsWithField.cardinality()) : null;
        normsConsumer.addNormsField(this.fieldInfo, new NormsProducer(this, sorted, values2){
            final /* synthetic */ NormValuesWriter this$0;
            final /* synthetic */ NumericDocValuesWriter.NumericDVs $sorted;
            final /* synthetic */ PackedLongValues $values;
            {
                this.this$0 = $receiver;
                this.$sorted = $sorted;
                this.$values = $values;
            }

            public NumericDocValues getNorms(FieldInfo fieldInfo2) {
                Intrinsics.checkNotNullParameter((Object)fieldInfo2, (String)"fieldInfo2");
                if (!Intrinsics.areEqual((Object)NormValuesWriter.access$getFieldInfo$p(this.this$0), (Object)NormValuesWriter.access$getFieldInfo$p(this.this$0))) {
                    boolean bl = false;
                    String string = "wrong fieldInfo";
                    throw new IllegalArgumentException(string.toString());
                }
                return this.$sorted == null ? (NumericDocValues)new BufferedNorms(this.$values, NormValuesWriter.access$getDocsWithField$p(this.this$0).iterator()) : (NumericDocValues)new NumericDocValuesWriter.SortingNumericDocValues(this.$sorted);
            }

            public void checkIntegrity() {
            }

            public void close() {
            }
        });
    }

    public static final /* synthetic */ FieldInfo access$getFieldInfo$p(NormValuesWriter $this) {
        return $this.fieldInfo;
    }

    public static final /* synthetic */ DocsWithFieldSet access$getDocsWithField$p(NormValuesWriter $this) {
        return $this.docsWithField;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016R\u0015\u0010\b\u001a\u00060\tR\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/NormValuesWriter$BufferedNorms;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "values", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "docsWithFields", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedLongValues;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "iter", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "getIter", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "docsWithField", "getDocsWithField", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "value", "", "docID", "", "nextDoc", "advance", "target", "advanceExact", "", "cost", "longValue", "core"})
    private static final class BufferedNorms
    extends NumericDocValues {
        @NotNull
        private final PackedLongValues.Iterator iter;
        @NotNull
        private final DocIdSetIterator docsWithField;
        private long value;

        public BufferedNorms(@NotNull PackedLongValues values2, @NotNull DocIdSetIterator docsWithFields) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docsWithFields, (String)"docsWithFields");
            this.iter = values2.iterator();
            this.docsWithField = docsWithFields;
        }

        @NotNull
        public final PackedLongValues.Iterator getIter() {
            return this.iter;
        }

        @NotNull
        public final DocIdSetIterator getDocsWithField() {
            return this.docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.iter.next();
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }
}

