/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.index.DocValuesWriter;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\"#$%B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000eJ\b\u0010\u0017\u001a\u00020\u0014H\u0002J\"\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesWriter;", "Lorg/gnit/lucenekmp/index/DocValuesWriter;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iwBytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/Counter;)V", "pending", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "finalValues", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "bytesUsed", "", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "lastDocID", "", "addValue", "", "docID", "value", "updateBytesUsed", "docValues", "getDocValues", "()Lorg/gnit/lucenekmp/index/NumericDocValues;", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "dvConsumer", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "BufferedNumericDocValues", "SortingNumericDocValues", "NumericDVs", "Companion", "core"})
public final class NumericDocValuesWriter
extends DocValuesWriter<NumericDocValues> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PackedLongValues.Builder pending;
    @Nullable
    private PackedLongValues finalValues;
    @NotNull
    private final Counter iwBytesUsed;
    private long bytesUsed;
    @NotNull
    private final DocsWithFieldSet docsWithField;
    @NotNull
    private final FieldInfo fieldInfo;
    private int lastDocID;

    public NumericDocValuesWriter(@NotNull FieldInfo fieldInfo, @NotNull Counter iwBytesUsed) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)iwBytesUsed, (String)"iwBytesUsed");
        this.pending = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
        this.lastDocID = -1;
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public final void addValue(int docID, long value) {
        if (!(docID > this.lastDocID)) {
            boolean bl = false;
            String string = "DocValuesField \"" + this.fieldInfo.getName() + "\" appears more than once in this document (only one value is allowed per field)";
            throw new IllegalArgumentException(string.toString());
        }
        this.pending.add(value);
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private final void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    @NotNull
    public NumericDocValues getDocValues() {
        if (this.finalValues == null) {
            this.finalValues = this.pending.build();
        }
        PackedLongValues packedLongValues = this.finalValues;
        Intrinsics.checkNotNull((Object)packedLongValues);
        return new BufferedNumericDocValues(packedLongValues, this.docsWithField.iterator());
    }

    @Override
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull DocValuesConsumer dvConsumer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dvConsumer, (String)"dvConsumer");
        if (this.finalValues == null) {
            this.finalValues = this.pending.build();
        }
        PackedLongValues packedLongValues = this.finalValues;
        Intrinsics.checkNotNull((Object)packedLongValues);
        dvConsumer.addNumericField(this.fieldInfo, Companion.getDocValuesProducer(this.fieldInfo, packedLongValues, this.docsWithField, sortMap));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016R\u0015\u0010\b\u001a\u00060\tR\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$BufferedNumericDocValues;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "values", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "docsWithFields", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedLongValues;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "iter", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "getIter", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "docsWithField", "getDocsWithField", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "value", "", "docID", "", "nextDoc", "advance", "target", "advanceExact", "", "cost", "longValue", "core"})
    public static final class BufferedNumericDocValues
    extends NumericDocValues {
        @NotNull
        private final PackedLongValues.Iterator iter;
        @NotNull
        private final DocIdSetIterator docsWithField;
        private long value;

        public BufferedNumericDocValues(@NotNull PackedLongValues values2, @NotNull DocIdSetIterator docsWithFields) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docsWithFields, (String)"docsWithFields");
            this.iter = values2.iterator();
            this.docsWithField = docsWithFields;
        }

        @NotNull
        public final PackedLongValues.Iterator getIter() {
            return this.iter;
        }

        @NotNull
        public final DocIdSetIterator getDocsWithField() {
            return this.docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.iter.next();
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$Companion;", "", "<init>", "()V", "sortDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$NumericDVs;", "maxDoc", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "oldDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "dense", "", "getDocValuesProducer", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "writerFieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "values", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NumericDVs sortDocValues(int maxDoc, @NotNull Sorter.DocMap sortMap, @NotNull NumericDocValues oldDocValues, boolean dense) throws IOException {
            int docID;
            Intrinsics.checkNotNullParameter((Object)sortMap, (String)"sortMap");
            Intrinsics.checkNotNullParameter((Object)oldDocValues, (String)"oldDocValues");
            FixedBitSet docsWithField = null;
            if (!dense) {
                docsWithField = new FixedBitSet(maxDoc);
            }
            long[] values2 = new long[maxDoc];
            while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
                int newDocID = sortMap.oldToNew(docID);
                FixedBitSet fixedBitSet = docsWithField;
                if (fixedBitSet != null) {
                    fixedBitSet.set(newDocID);
                }
                values2[newDocID] = oldDocValues.longValue();
            }
            FixedBitSet fixedBitSet = docsWithField;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            return new NumericDVs(values2, fixedBitSet);
        }

        @NotNull
        public final DocValuesProducer getDocValuesProducer(@NotNull FieldInfo writerFieldInfo, @NotNull PackedLongValues values2, @NotNull DocsWithFieldSet docsWithField, @Nullable Sorter.DocMap sortMap) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writerFieldInfo, (String)"writerFieldInfo");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            NumericDVs sorted = null;
            if (sortMap != null) {
                NumericDocValues oldValues = new BufferedNumericDocValues(values2, docsWithField.iterator());
                sorted = this.sortDocValues(sortMap.size(), sortMap, oldValues, sortMap.size() == docsWithField.cardinality());
            } else {
                sorted = null;
            }
            return new EmptyDocValuesProducer(writerFieldInfo, sorted, values2, docsWithField){
                final /* synthetic */ FieldInfo $writerFieldInfo;
                final /* synthetic */ NumericDVs $sorted;
                final /* synthetic */ PackedLongValues $values;
                final /* synthetic */ DocsWithFieldSet $docsWithField;
                {
                    this.$writerFieldInfo = $writerFieldInfo;
                    this.$sorted = $sorted;
                    this.$values = $values;
                    this.$docsWithField = $docsWithField;
                }

                public NumericDocValues getNumeric(FieldInfo fieldInfo) {
                    Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                    if (!Intrinsics.areEqual((Object)fieldInfo, (Object)this.$writerFieldInfo)) {
                        boolean bl = false;
                        String string = "wrong fieldInfo";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return this.$sorted == null ? (NumericDocValues)new BufferedNumericDocValues(this.$values, this.$docsWithField.iterator()) : (NumericDocValues)new SortingNumericDocValues(this.$sorted);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$NumericDVs;", "", "values", "", "docsWithField", "Lorg/gnit/lucenekmp/util/BitSet;", "<init>", "([JLorg/gnit/lucenekmp/util/BitSet;)V", "getValues", "()[J", "maxDoc", "", "advanceExact", "", "target", "advance", "cost", "", "core"})
    public static final class NumericDVs {
        @NotNull
        private final long[] values;
        @NotNull
        private final BitSet docsWithField;
        private final int maxDoc;

        public NumericDVs(@NotNull long[] values2, @NotNull BitSet docsWithField) {
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            this.values = values2;
            this.docsWithField = docsWithField;
            this.maxDoc = this.values.length;
        }

        @NotNull
        public final long[] getValues() {
            return this.values;
        }

        public final int maxDoc() {
            return this.maxDoc;
        }

        public final boolean advanceExact(int target) {
            if (this.docsWithField != null) {
                return this.docsWithField.get(target);
            }
            return true;
        }

        public final int advance(int target) {
            if (this.docsWithField != null) {
                return this.docsWithField.nextSetBit(target);
            }
            return target;
        }

        public final long cost() {
            if (this.docsWithField != null) {
                return this.docsWithField.cardinality();
            }
            return this.maxDoc;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$SortingNumericDocValues;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "dvs", "Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$NumericDVs;", "<init>", "(Lorg/gnit/lucenekmp/index/NumericDocValuesWriter$NumericDVs;)V", "docID", "", "cost", "", "nextDoc", "advance", "target", "advanceExact", "", "longValue", "core"})
    public static final class SortingNumericDocValues
    extends NumericDocValues {
        @NotNull
        private final NumericDVs dvs;
        private int docID;
        private long cost;

        public SortingNumericDocValues(@NotNull NumericDVs dvs) {
            Intrinsics.checkNotNullParameter((Object)dvs, (String)"dvs");
            this.dvs = dvs;
            this.docID = -1;
            this.cost = -1L;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            this.docID = this.docID + 1 == this.dvs.maxDoc() ? Integer.MAX_VALUE : this.dvs.advance(this.docID + 1);
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc() instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.dvs.advanceExact(target);
        }

        @Override
        public long longValue() {
            return this.dvs.getValues()[this.docID];
        }

        @Override
        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.dvs.cost();
            }
            return this.cost;
        }
    }
}

