/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.codecs.FieldInfosFormat;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.DocValuesFieldUpdates;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.PendingDeletes;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentReader;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FieldExistsQuery;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IOSupplier;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u001e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\u0016\u0010%\u001a\u00020\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0002J\u0016\u0010&\u001a\u00020\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$H\u0016J\b\u0010'\u001a\u00020(H\u0002J\b\u0010-\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/index/PendingSoftDeletes;", "Lorg/gnit/lucenekmp/index/PendingDeletes;", "field", "", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/index/SegmentCommitInfo;)V", "reader", "Lorg/gnit/lucenekmp/index/SegmentReader;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/index/SegmentReader;Lorg/gnit/lucenekmp/index/SegmentCommitInfo;)V", "dvGeneration", "", "hardDeletes", "delete", "", "docID", "", "numPendingDeletes", "onNewReader", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "writeLiveDocs", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "dropChanges", "onDocValuesUpdate", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "assertPendingDeletes", "toString", "numDeletesToMerge", "policy", "Lorg/gnit/lucenekmp/index/MergePolicy;", "readerIOSupplier", "Lorg/gnit/lucenekmp/util/IOSupplier;", "ensureInitialized", "isFullyDeleted", "readFieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "hardLiveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "getHardLiveDocs", "()Lorg/gnit/lucenekmp/util/Bits;", "mustInitOnDelete", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPendingSoftDeletes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingSoftDeletes.kt\norg/gnit/lucenekmp/index/PendingSoftDeletes\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,280:1\n3#2,8:281\n3#2,8:290\n8#2,2:299\n8#2,2:301\n8#2,2:303\n3#2,8:305\n8#2,2:314\n8#2,2:316\n8#2,2:318\n3#2,8:320\n10#3:289\n10#3:298\n10#3:313\n10#3:328\n*S KotlinDebug\n*F\n+ 1 PendingSoftDeletes.kt\norg/gnit/lucenekmp/index/PendingSoftDeletes\n*L\n47#1:281,8\n51#1:290,8\n77#1:299,2\n82#1:301,2\n87#1:303,2\n119#1:305,8\n123#1:314,2\n131#1:316,2\n136#1:318,2\n139#1:320,8\n47#1:289\n51#1:298\n119#1:313\n139#1:328\n*E\n"})
public final class PendingSoftDeletes
extends PendingDeletes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    private long dvGeneration;
    @NotNull
    private final PendingDeletes hardDeletes;

    public PendingSoftDeletes(@NotNull String field, @NotNull SegmentCommitInfo info) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super(info, null, info.getDelCount(true) == 0);
        this.dvGeneration = -2L;
        this.field = field;
        this.hardDeletes = new PendingDeletes(info, null, false, 6, null);
    }

    public PendingSoftDeletes(@NotNull String field, @NotNull SegmentReader reader2, @NotNull SegmentCommitInfo info) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super(reader2, info);
        this.dvGeneration = -2L;
        this.field = field;
        this.hardDeletes = new PendingDeletes(reader2, info);
    }

    @Override
    public boolean delete(int docID) throws IOException {
        FixedBitSet mutableBits = this.getMutableBits();
        if (this.hardDeletes.delete(docID)) {
            if (mutableBits.getAndClear(docID)) {
                boolean condition$iv = !this.hardDeletes.delete(docID);
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
            } else {
                int condition$iv = this.getPendingDeleteCount();
                this.setPendingDeleteCount(condition$iv + -1);
                condition$iv = this.assertPendingDeletes() ? 1 : 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && condition$iv == 0) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int numPendingDeletes() {
        return super.numPendingDeletes() + this.hardDeletes.numPendingDeletes();
    }

    @Override
    public void onNewReader(@NotNull CodecReader reader2, @NotNull SegmentCommitInfo info) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super.onNewReader(reader2, info);
        this.hardDeletes.onNewReader(reader2, info);
        if (this.dvGeneration < info.getDocValuesGen()) {
            boolean $i$f$assert;
            boolean condition$iv;
            int newDelCount = 0;
            DocIdSetIterator iterator2 = FieldExistsQuery.Companion.getDocValuesDocIdSetIterator(this.field, reader2);
            if (iterator2 != null && iterator2.nextDoc() != Integer.MAX_VALUE) {
                DocIdSetIterator docIdSetIterator = iterator2 = FieldExistsQuery.Companion.getDocValuesDocIdSetIterator(this.field, reader2);
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                newDelCount = Companion.applySoftDeletes(docIdSetIterator, this.getMutableBits());
                condition$iv = newDelCount >= 0;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = " illegal pending delete count: " + newDelCount;
                    throw new AssertionError((Object)string);
                }
            } else {
                newDelCount = 0;
            }
            condition$iv = info.getSoftDelCount() == newDelCount;
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "softDeleteCount doesn't match " + info.getSoftDelCount() + " != " + newDelCount;
                throw new AssertionError((Object)string);
            }
            this.dvGeneration = info.getDocValuesGen();
        }
        boolean condition$iv = this.getDelCount() <= info.getInfo().maxDoc();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = this.getDelCount() + " > " + info.getInfo().maxDoc();
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public boolean writeLiveDocs(@NotNull Directory dir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.getInfo().setSoftDelCount(this.getInfo().getSoftDelCount() + this.getPendingDeleteCount());
        super.dropChanges();
        return this.hardDeletes.writeLiveDocs(dir);
    }

    @Override
    public void dropChanges() {
        this.hardDeletes.dropChanges();
    }

    @Override
    public void onDocValuesUpdate(@NotNull FieldInfo info, @NotNull DocValuesFieldUpdates.Iterator iterator2) throws IOException {
        boolean condition$iv;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (Intrinsics.areEqual((Object)this.field, (Object)info.getName())) {
            this.setPendingDeleteCount(this.getPendingDeleteCount() + Companion.applySoftDeletes(iterator2, this.getMutableBits()));
            condition$iv = this.assertPendingDeletes();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.getInfo().setSoftDelCount(this.getInfo().getSoftDelCount() + this.getPendingDeleteCount());
            super.dropChanges();
        }
        condition$iv = this.dvGeneration < info.getDocValuesGen();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "we have seen this generation update already: " + this.dvGeneration + " vs. " + info.getDocValuesGen();
            throw new AssertionError((Object)string);
        }
        condition$iv = this.dvGeneration != -2L;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "docValues generation is still uninitialized";
            throw new AssertionError((Object)string);
        }
        this.dvGeneration = info.getDocValuesGen();
    }

    private final boolean assertPendingDeletes() {
        boolean condition$iv = this.getPendingDeleteCount() + this.getInfo().getSoftDelCount() >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "illegal pending delete count: " + (this.getPendingDeleteCount() + this.getInfo().getSoftDelCount());
            throw new AssertionError((Object)string);
        }
        condition$iv = this.getInfo().getInfo().maxDoc() >= this.getDelCount();
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingSoftDeletes(seg=").append(this.getInfo());
        sb.append(" numPendingDeletes=").append(this.getPendingDeleteCount());
        sb.append(" field=").append(this.field);
        sb.append(" dvGeneration=").append(this.dvGeneration);
        sb.append(" hardDeletes=").append(this.hardDeletes);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int numDeletesToMerge(@NotNull MergePolicy policy, @NotNull IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter(readerIOSupplier, (String)"readerIOSupplier");
        this.ensureInitialized(readerIOSupplier);
        return super.numDeletesToMerge(policy, readerIOSupplier);
    }

    private final void ensureInitialized(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        if (this.dvGeneration == -2L) {
            FieldInfos fieldInfos = this.readFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(this.field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                this.onNewReader(readerIOSupplier.get(), this.getInfo());
            } else {
                FieldInfo fieldInfo2 = fieldInfo;
                this.dvGeneration = fieldInfo2 != null ? fieldInfo2.getDocValuesGen() : -1L;
            }
        }
    }

    @Override
    public boolean isFullyDeleted(@NotNull IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        Intrinsics.checkNotNullParameter(readerIOSupplier, (String)"readerIOSupplier");
        this.ensureInitialized(readerIOSupplier);
        return super.isFullyDeleted(readerIOSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FieldInfos readFieldInfos() throws IOException {
        SegmentInfo segInfo = this.getInfo().getInfo();
        Directory dir = segInfo.getDir();
        if (!this.getInfo().hasFieldUpdates()) {
            FieldInfos fieldInfos;
            AutoCloseable toClose = null;
            if (segInfo.getUseCompoundFile()) {
                dir = segInfo.getCodec().compoundFormat().getCompoundReader(segInfo.getDir(), segInfo);
                toClose = dir;
            } else {
                toClose = null;
                dir = segInfo.getDir();
            }
            try {
                fieldInfos = segInfo.getCodec().fieldInfosFormat().read(dir, segInfo, "", IOContext.Companion.getREADONCE());
            }
            catch (Throwable throwable) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{toClose};
                IOUtils.INSTANCE.closeNullable(autoCloseableArray);
                throw throwable;
            }
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{toClose};
            IOUtils.INSTANCE.closeNullable(autoCloseableArray);
            return fieldInfos;
        }
        FieldInfosFormat fisFormat = segInfo.getCodec().fieldInfosFormat();
        String string = Long.toString(this.getInfo().getFieldInfosGen(), CharsKt.checkRadix((int)RangesKt.coerceIn((int)36, (int)2, (int)36)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String segmentSuffix = string;
        return fisFormat.read(dir, segInfo, segmentSuffix, IOContext.Companion.getREADONCE());
    }

    @Override
    @Nullable
    public Bits getHardLiveDocs() {
        return this.hardDeletes.getLiveDocs();
    }

    @Override
    public boolean mustInitOnDelete() {
        return !this.getLiveDocsInitialized();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/PendingSoftDeletes$Companion;", "", "<init>", "()V", "applySoftDeletes", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "bits", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "countSoftDeletes", "softDeletedDocs", "hardDeletes", "Lorg/gnit/lucenekmp/util/Bits;", "core"})
    @SourceDebugExtension(value={"SMAP\nPendingSoftDeletes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingSoftDeletes.kt\norg/gnit/lucenekmp/index/PendingSoftDeletes$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int applySoftDeletes(@NotNull DocIdSetIterator iterator2, @NotNull FixedBitSet bits) throws IOException {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
            int newDeletes = 0;
            int docID = 0;
            DocValuesFieldUpdates.Iterator hasValue = iterator2 instanceof DocValuesFieldUpdates.Iterator ? (DocValuesFieldUpdates.Iterator)iterator2 : null;
            while (true) {
                int n;
                int it = n = iterator2.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                if (hasValue == null || hasValue.hasValue()) {
                    if (!bits.getAndClear(docID)) continue;
                    ++newDeletes;
                    continue;
                }
                if (bits.getAndSet(docID)) continue;
                --newDeletes;
            }
            return newDeletes;
        }

        public final int countSoftDeletes(@Nullable DocIdSetIterator softDeletedDocs, @Nullable Bits hardDeletes) throws IOException {
            int count = 0;
            if (softDeletedDocs != null) {
                int doc = 0;
                while (true) {
                    int n;
                    int it = n = softDeletedDocs.nextDoc();
                    boolean bl = false;
                    doc = it;
                    if (n == Integer.MAX_VALUE) break;
                    if (hardDeletes != null && !hardDeletes.get(doc)) continue;
                    ++count;
                }
            }
            return count;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

