/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.MutablePointTree;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.codecs.PointsWriter;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.PagedBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/PointValuesWriter;", "", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "<init>", "(Lorg/gnit/lucenekmp/util/Counter;Lorg/gnit/lucenekmp/index/FieldInfo;)V", "bytes", "Lorg/gnit/lucenekmp/util/PagedBytes;", "bytesOut", "Lorg/gnit/lucenekmp/store/DataOutput;", "iwBytesUsed", "docIDs", "", "numPoints", "", "value", "numDocs", "getNumDocs", "()I", "lastDocID", "packedBytesLength", "addPackedValue", "", "docID", "Lorg/gnit/lucenekmp/util/BytesRef;", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "writer", "Lorg/gnit/lucenekmp/codecs/PointsWriter;", "MutableSortingPointValues", "core"})
@SourceDebugExtension(value={"SMAP\nPointValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointValuesWriter.kt\norg/gnit/lucenekmp/index/PointValuesWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class PointValuesWriter {
    @NotNull
    private final FieldInfo fieldInfo;
    @NotNull
    private final PagedBytes bytes;
    @NotNull
    private final DataOutput bytesOut;
    @NotNull
    private final Counter iwBytesUsed;
    @NotNull
    private int[] docIDs;
    private int numPoints;
    private int numDocs;
    private int lastDocID;
    private final int packedBytesLength;

    public PointValuesWriter(@NotNull Counter bytesUsed, @NotNull FieldInfo fieldInfo) {
        Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.fieldInfo = fieldInfo;
        this.bytes = new PagedBytes(12);
        this.bytesOut = this.bytes.getDataOutput();
        this.iwBytesUsed = bytesUsed;
        this.lastDocID = -1;
        this.docIDs = new int[16];
        this.iwBytesUsed.addAndGet(64L);
        this.packedBytesLength = this.fieldInfo.getPointDimensionCount() * this.fieldInfo.getPointNumBytes();
    }

    public final int getNumDocs() {
        return this.numDocs;
    }

    public final void addPackedValue(int docID, @NotNull BytesRef value) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value.getLength() == this.packedBytesLength)) {
            boolean bl = false;
            String string = "field=" + this.fieldInfo.getName() + ": this field's value has length=" + value.getLength() + " but should be " + this.fieldInfo.getPointDimensionCount() * this.fieldInfo.getPointNumBytes();
            throw new IllegalArgumentException(string.toString());
        }
        if (this.docIDs.length == this.numPoints) {
            this.docIDs = ArrayUtil.Companion.grow(this.docIDs, this.numPoints + 1);
            this.iwBytesUsed.addAndGet((long)(this.docIDs.length - this.numPoints) * 4L);
        }
        long bytesRamBytesUsedBefore = this.bytes.ramBytesUsed();
        this.bytesOut.writeBytes(value.getBytes(), value.getOffset(), value.getLength());
        this.iwBytesUsed.addAndGet(this.bytes.ramBytesUsed() - bytesRamBytesUsedBefore);
        this.docIDs[this.numPoints] = docID;
        if (docID != this.lastDocID) {
            n = this.numDocs;
            this.numDocs = n + 1;
            this.lastDocID = docID;
        }
        n = this.numPoints;
        this.numPoints = n + 1;
    }

    public final void flush(@Nullable SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull PointsWriter writer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        PagedBytes.Reader bytesReader = this.bytes.freeze(false);
        MutablePointTree points2 = new MutablePointTree(this, bytesReader){
            private final int[] ords;
            private int[] temp;
            final /* synthetic */ PointValuesWriter this$0;
            final /* synthetic */ PagedBytes.Reader $bytesReader;
            {
                this.this$0 = $receiver;
                this.$bytesReader = $bytesReader;
                this.ords = new int[PointValuesWriter.access$getNumPoints$p($receiver)];
                int n = PointValuesWriter.access$getNumPoints$p($receiver);
                for (int i = 0; i < n; ++i) {
                    this.ords[i] = i;
                }
            }

            public final int[] getOrds() {
                return this.ords;
            }

            public final int[] getTemp() {
                return this.temp;
            }

            public final void setTemp(int[] nArray) {
                this.temp = nArray;
            }

            public long size() {
                return PointValuesWriter.access$getNumPoints$p(this.this$0);
            }

            public void visitDocValues(PointValues.IntersectVisitor visitor2) throws IOException {
                Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
                BytesRef scratch = new BytesRef();
                byte[] packedValue = new byte[PointValuesWriter.access$getPackedBytesLength$p(this.this$0)];
                int n = PointValuesWriter.access$getNumPoints$p(this.this$0);
                for (int i = 0; i < n; ++i) {
                    this.getValue(i, scratch);
                    boolean condition$iv = scratch.getLength() == packedValue.length;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    System.INSTANCE.arraycopy(scratch.getBytes(), scratch.getOffset(), packedValue, 0, PointValuesWriter.access$getPackedBytesLength$p(this.this$0));
                    visitor2.visit(this.getDocID(i), packedValue);
                }
            }

            public void swap(int i, int j) {
                int tmp = this.ords[i];
                this.ords[i] = this.ords[j];
                this.ords[j] = tmp;
            }

            public int getDocID(int i) {
                return PointValuesWriter.access$getDocIDs$p(this.this$0)[this.ords[i]];
            }

            public void getValue(int i, BytesRef packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                long offset = (long)PointValuesWriter.access$getPackedBytesLength$p(this.this$0) * (long)this.ords[i];
                this.$bytesReader.fillSlice(packedValue, offset, PointValuesWriter.access$getPackedBytesLength$p(this.this$0));
            }

            public byte getByteAt(int i, int k) {
                long offset = (long)PointValuesWriter.access$getPackedBytesLength$p(this.this$0) * (long)this.ords[i] + (long)k;
                return this.$bytesReader.getByte(offset);
            }

            public void save(int i, int j) {
                if (this.temp == null) {
                    this.temp = new int[this.ords.length];
                }
                Intrinsics.checkNotNull((Object)this.temp);
                this.temp[j] = this.ords[i];
            }

            public void restore(int i, int j) {
                if (this.temp != null) {
                    Intrinsics.checkNotNull((Object)this.temp);
                    System.INSTANCE.arraycopy(this.temp, i, this.ords, i, j - i);
                }
            }
        };
        MutablePointTree values2 = sortMap == null ? points2 : (MutablePointTree)new MutableSortingPointValues(points2, sortMap);
        PointsReader reader2 = new PointsReader(this, values2){
            final /* synthetic */ PointValuesWriter this$0;
            final /* synthetic */ MutablePointTree $values;
            {
                this.this$0 = $receiver;
                this.$values = $values;
            }

            public PointValues getValues(String fieldName) {
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                if (!Intrinsics.areEqual((Object)fieldName, (Object)PointValuesWriter.access$getFieldInfo$p(this.this$0).getName())) {
                    boolean bl = false;
                    String string = "fieldName must be the same";
                    throw new IllegalArgumentException(string.toString());
                }
                return new PointValues(this.$values){
                    final /* synthetic */ MutablePointTree $values;
                    {
                        this.$values = $values;
                    }

                    public PointValues.PointTree getPointTree() {
                        return this.$values;
                    }

                    public byte[] getMinPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    public byte[] getMaxPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    public int getNumDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    public int getNumIndexDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    public int getBytesPerDimension() {
                        throw new UnsupportedOperationException();
                    }

                    public long size() {
                        throw new UnsupportedOperationException();
                    }

                    public int getDocCount() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public void checkIntegrity() {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
        writer.writeField(this.fieldInfo, reader2);
    }

    public static final /* synthetic */ int access$getNumPoints$p(PointValuesWriter $this) {
        return $this.numPoints;
    }

    public static final /* synthetic */ int access$getPackedBytesLength$p(PointValuesWriter $this) {
        return $this.packedBytesLength;
    }

    public static final /* synthetic */ int[] access$getDocIDs$p(PointValuesWriter $this) {
        return $this.docIDs;
    }

    public static final /* synthetic */ FieldInfo access$getFieldInfo$p(PointValuesWriter $this) {
        return $this.fieldInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/index/PointValuesWriter$MutableSortingPointValues;", "Lorg/gnit/lucenekmp/codecs/MutablePointTree;", "in", "docMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "<init>", "(Lorg/gnit/lucenekmp/codecs/MutablePointTree;Lorg/gnit/lucenekmp/index/Sorter$DocMap;)V", "size", "", "visitDocValues", "", "visitor", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "getValue", "i", "", "packedValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "getByteAt", "", "k", "getDocID", "swap", "j", "save", "restore", "core"})
    public static final class MutableSortingPointValues
    extends MutablePointTree {
        @NotNull
        private final MutablePointTree in;
        @NotNull
        private final Sorter.DocMap docMap;

        public MutableSortingPointValues(@NotNull MutablePointTree in, @NotNull Sorter.DocMap docMap) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            this.in = in;
            this.docMap = docMap;
        }

        @Override
        public long size() {
            return this.in.size();
        }

        @Override
        public void visitDocValues(@NotNull PointValues.IntersectVisitor visitor2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            this.in.visitDocValues(new PointValues.IntersectVisitor(visitor2, this){
                final /* synthetic */ PointValues.IntersectVisitor $visitor;
                final /* synthetic */ MutableSortingPointValues this$0;
                {
                    this.$visitor = $visitor;
                    this.this$0 = $receiver;
                }

                public void visit(int docID) throws IOException {
                    this.$visitor.visit(MutableSortingPointValues.access$getDocMap$p(this.this$0).oldToNew(docID));
                }

                public void visit(int docID, byte[] packedValue) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                    this.$visitor.visit(MutableSortingPointValues.access$getDocMap$p(this.this$0).oldToNew(docID), packedValue);
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                    Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                    return this.$visitor.compare(minPackedValue, maxPackedValue);
                }

                public void visit(DocIdSetIterator iterator2) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2);
                }

                public void visit(IntsRef ref) throws IOException {
                    PointValues.IntersectVisitor.super.visit(ref);
                }

                public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
                }

                public void grow(int count) {
                    PointValues.IntersectVisitor.super.grow(count);
                }
            });
        }

        @Override
        public void getValue(int i, @NotNull BytesRef packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            this.in.getValue(i, packedValue);
        }

        @Override
        public byte getByteAt(int i, int k) {
            return this.in.getByteAt(i, k);
        }

        @Override
        public int getDocID(int i) {
            return this.docMap.oldToNew(this.in.getDocID(i));
        }

        @Override
        public void swap(int i, int j) {
            this.in.swap(i, j);
        }

        @Override
        public void save(int i, int j) {
            this.in.save(i, j);
        }

        @Override
        public void restore(int i, int j) {
            this.in.restore(i, j);
        }

        public static final /* synthetic */ Sorter.DocMap access$getDocMap$p(MutableSortingPointValues $this) {
            return $this.docMap;
        }
    }
}

