/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.IndexReaderContext;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/index/ReaderUtil;", "", "<init>", "()V", "getTopLevelContext", "Lorg/gnit/lucenekmp/index/IndexReaderContext;", "context", "subIndex", "", "n", "docStarts", "", "leaves", "", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "core"})
public final class ReaderUtil {
    @NotNull
    public static final ReaderUtil INSTANCE = new ReaderUtil();

    private ReaderUtil() {
    }

    @NotNull
    public final IndexReaderContext getTopLevelContext(@NotNull IndexReaderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IndexReaderContext context2 = context;
        while (context2.getParent() != null) {
            context2 = context2.getParent();
        }
        return context2;
    }

    public final int subIndex(int n, @NotNull int[] docStarts) {
        Intrinsics.checkNotNullParameter((Object)docStarts, (String)"docStarts");
        int size2 = docStarts.length;
        int lo = 0;
        int hi = size2 - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = docStarts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < size2 && docStarts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public final int subIndex(int n, @NotNull List<LeafReaderContext> leaves) {
        Intrinsics.checkNotNullParameter(leaves, (String)"leaves");
        int size2 = leaves.size();
        int lo = 0;
        int hi = size2 - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = leaves.get(mid).getDocBase();
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < size2 && leaves.get(mid + 1).getDocBase() == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }
}

