/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.TrackingDirectoryWrapper;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\b\n\u0018\u0000 J2\u00020\u0001:\u0001JB\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u00102\u001a\u0002032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011J\u001a\u00104\u001a\u0002032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011J\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011J\u0006\u00106\u001a\u000203J\u0006\u0010\t\u001a\u00020\nJ\u000e\u00107\u001a\u0002032\u0006\u0010\t\u001a\u00020\nJ\f\u00108\u001a\b\u0012\u0004\u0012\u00020\b09J\b\u0010:\u001a\u00020\bH\u0016J\u000e\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\nJ\u0013\u0010<\u001a\u00020\f2\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010>\u001a\u00020\nH\u0016J\u0006\u0010?\u001a\u00020\u0013J\u0014\u0010@\u001a\u0002032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\b0AJ\u0014\u0010B\u001a\u0002032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\b0AJ\u000e\u0010C\u001a\u0002032\u0006\u0010D\u001a\u00020\bJ\u0016\u0010E\u001a\u0002032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\b0AH\u0002J\u000e\u0010F\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bJ\u000e\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u00020\bJ\u0018\u0010I\u001a\u0004\u0018\u00010\b2\u0006\u0010H\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00112\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010-\"\u0004\b/\u00100R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001fR\u0016\u0010@\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/gnit/lucenekmp/index/SegmentInfo;", "", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "version", "Lorg/gnit/lucenekmp/util/Version;", "minVersion", "name", "", "maxDoc", "", "isCompoundFile", "", "hasBlocks", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "diagnostics", "", "id", "", "attributes", "indexSort", "Lorg/gnit/lucenekmp/search/Sort;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/util/Version;Lorg/gnit/lucenekmp/util/Version;Ljava/lang/String;IZZLorg/gnit/lucenekmp/codecs/Codec;Ljava/util/Map;[BLjava/util/Map;Lorg/gnit/lucenekmp/search/Sort;)V", "getName", "()Ljava/lang/String;", "getDir", "()Lorg/gnit/lucenekmp/store/Directory;", "useCompoundFile", "getUseCompoundFile", "()Z", "setUseCompoundFile", "(Z)V", "codecNullable", "getCodec", "()Lorg/gnit/lucenekmp/codecs/Codec;", "setCodec", "(Lorg/gnit/lucenekmp/codecs/Codec;)V", "value", "getAttributes", "()Ljava/util/Map;", "getIndexSort", "()Lorg/gnit/lucenekmp/search/Sort;", "getVersion", "()Lorg/gnit/lucenekmp/util/Version;", "getMinVersion", "setMinVersion", "(Lorg/gnit/lucenekmp/util/Version;)V", "getHasBlocks", "setDiagnostics", "", "addDiagnostics", "getDiagnostics", "setHasBlocks", "setMaxDoc", "files", "", "toString", "delCount", "equals", "obj", "hashCode", "getId", "setFiles", "", "addFiles", "addFile", "file", "checkFileNames", "namedForThisSegment", "getAttribute", "key", "putAttribute", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentInfo.kt\norg/gnit/lucenekmp/index/SegmentInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n1#2:329\n*E\n"})
public final class SegmentInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private int maxDoc;
    @NotNull
    private final Directory dir;
    private boolean useCompoundFile;
    @NotNull
    private final byte[] id;
    @Nullable
    private Codec codecNullable;
    @NotNull
    private Map<String, String> diagnostics;
    @NotNull
    private Map<String, String> attributes;
    @Nullable
    private final Sort indexSort;
    @NotNull
    private final Version version;
    @Nullable
    private Version minVersion;
    private boolean hasBlocks;
    @Nullable
    private Set<String> setFiles;
    public static final int NO = -1;
    public static final int YES = 1;

    public SegmentInfo(@NotNull Directory dir, @NotNull Version version, @Nullable Version minVersion, @NotNull String name, int maxDoc, boolean isCompoundFile, boolean hasBlocks, @Nullable Codec codec, @NotNull Map<String, String> diagnostics, @NotNull byte[] id, @NotNull Map<String, String> attributes, @Nullable Sort indexSort) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        if (!(!(dir instanceof TrackingDirectoryWrapper))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.dir = dir;
        this.version = version;
        this.minVersion = minVersion;
        this.name = name;
        this.maxDoc = maxDoc;
        this.useCompoundFile = isCompoundFile;
        this.hasBlocks = hasBlocks;
        this.codecNullable = codec;
        this.diagnostics = new HashMap<String, String>(diagnostics);
        this.id = id;
        if (!(id.length == 16)) {
            boolean bl = false;
            String string = Arrays.toString(id);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = "invalid id: " + string;
            throw new IllegalArgumentException(string2.toString());
        }
        this.attributes = new HashMap<String, String>(attributes);
        this.indexSort = indexSort;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Directory getDir() {
        return this.dir;
    }

    public final boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public final void setUseCompoundFile(boolean bl) {
        this.useCompoundFile = bl;
    }

    @NotNull
    public final Codec getCodec() {
        Codec codec = this.codecNullable;
        Intrinsics.checkNotNull((Object)codec);
        return codec;
    }

    public final void setCodec(@NotNull Codec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (!(this.codecNullable == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.codecNullable = codec;
    }

    @NotNull
    public final Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public final Sort getIndexSort() {
        return this.indexSort;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @Nullable
    public final Version getMinVersion() {
        return this.minVersion;
    }

    public final void setMinVersion(@Nullable Version version) {
        this.minVersion = version;
    }

    public final boolean getHasBlocks() {
        return this.hasBlocks;
    }

    public final void setDiagnostics(@NotNull Map<String, String> diagnostics) {
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        this.diagnostics = new HashMap<String, String>(diagnostics);
    }

    public final void addDiagnostics(@NotNull Map<String, String> diagnostics) {
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Map copy = new HashMap<String, String>(this.diagnostics);
        copy.putAll(diagnostics);
        this.setDiagnostics(copy);
    }

    @NotNull
    public final Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public final void setHasBlocks() {
        this.hasBlocks = true;
    }

    public final int maxDoc() {
        if (!(this.maxDoc != -1)) {
            boolean bl = false;
            String string = "maxDoc isn't set yet";
            throw new IllegalStateException(string.toString());
        }
        return this.maxDoc;
    }

    public final void setMaxDoc(int maxDoc) {
        if (!(this.maxDoc == -1)) {
            boolean bl = false;
            String string = "maxDoc was already set: this.maxDoc=" + this.maxDoc + " vs maxDoc=" + maxDoc;
            throw new IllegalStateException(string.toString());
        }
        this.maxDoc = maxDoc;
    }

    @NotNull
    public final Set<String> files() {
        if (this.setFiles == null) {
            boolean bl = false;
            String string = "files were not computed yet; segment=" + this.name + " maxDoc=" + this.maxDoc;
            throw new IllegalStateException(string.toString());
        }
        Set<String> set = this.setFiles;
        Intrinsics.checkNotNull(set);
        return set;
    }

    @NotNull
    public String toString() {
        return this.toString(0);
    }

    @NotNull
    public final String toString(int delCount) {
        Map<String, String> attributes;
        StringBuilder s = new StringBuilder();
        s.append(this.name).append('(').append(this.version == null ? "" : this.version).append(')').append(':');
        char cfs = this.useCompoundFile ? (char)'c' : 'C';
        s.append(cfs);
        s.append(this.maxDoc);
        if (delCount != 0) {
            s.append('/').append(delCount);
        }
        if (this.indexSort != null) {
            s.append(":[indexSort=");
            s.append(this.indexSort);
            s.append(']');
        }
        if (!this.diagnostics.isEmpty()) {
            s.append(":[diagnostics=");
            s.append(this.diagnostics.toString());
            s.append(']');
        }
        if (!(attributes = this.attributes).isEmpty()) {
            s.append(":[attributes=");
            s.append(attributes.toString());
            s.append(']');
        }
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SegmentInfo) {
            return ((SegmentInfo)obj).dir == this.dir && Intrinsics.areEqual((Object)((SegmentInfo)obj).name, (Object)this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.dir.hashCode() + this.name.hashCode();
    }

    @NotNull
    public final byte[] getId() {
        byte[] byArray = Arrays.copyOf(this.id, this.id.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        Intrinsics.checkNotNull((Object)byArray, (String)"null cannot be cast to non-null type kotlin.ByteArray");
        return byArray;
    }

    public final void setFiles(@NotNull Collection<String> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.setFiles = new HashSet();
        this.addFiles(files);
    }

    public final void addFiles(@NotNull Collection<String> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.checkFileNames(files);
        for (String f : files) {
            Set<String> set = this.setFiles;
            Intrinsics.checkNotNull(set);
            set.add(this.namedForThisSegment(f));
        }
    }

    public final void addFile(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new String[]{file};
        this.checkFileNames(SetsKt.mutableSetOf((Object[])objectArray));
        Set<String> set = this.setFiles;
        Intrinsics.checkNotNull(set);
        set.add(this.namedForThisSegment(file));
    }

    private final void checkFileNames(Collection<String> files) {
        Regex pattern = IndexFileNames.INSTANCE.getCODEC_FILE_PATTERN();
        for (String file : files) {
            if (!pattern.matches((CharSequence)file)) {
                boolean $i$a$-require-SegmentInfo$checkFileNames$32 = false;
                String $i$a$-require-SegmentInfo$checkFileNames$32 = "invalid codec filename '" + file + "', must match: " + pattern.getPattern();
                throw new IllegalArgumentException($i$a$-require-SegmentInfo$checkFileNames$32.toString());
            }
            String string = file.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".tmp", (boolean)false, (int)2, null)) continue;
            boolean bl = false;
            String string2 = "invalid codec filename '" + file + "', cannot end with .tmp extension";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final String namedForThisSegment(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.name + IndexFileNames.INSTANCE.stripSegmentName(file);
    }

    @NotNull
    public final String getAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = this.attributes.get(key);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final String putAttribute(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        HashMap<String, String> newMap = new HashMap<String, String>(this.attributes);
        String oldValue = newMap.put(key, value);
        this.attributes = newMap;
        return oldValue;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/index/SegmentInfo$Companion;", "", "<init>", "()V", "NO", "", "YES", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

