/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.FieldInfosFormat;
import org.gnit.lucenekmp.codecs.FieldsConsumer;
import org.gnit.lucenekmp.codecs.KnnVectorsWriter;
import org.gnit.lucenekmp.codecs.NormsConsumer;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PointsWriter;
import org.gnit.lucenekmp.codecs.StoredFieldsWriter;
import org.gnit.lucenekmp.codecs.TermVectorsWriter;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.jdkport.Executor;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u000289BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010 \u001a\u00020!J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\"\u001a\u00020\u0017J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020.H\u0002J\u0018\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u00101\u001a\u00020.2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J0\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002062\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u0002052\u0006\u00107\u001a\u00020.H\u0002R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/index/SegmentMerger;", "", "readers", "", "Lorg/gnit/lucenekmp/index/CodecReader;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "fieldNumbers", "Lorg/gnit/lucenekmp/index/FieldInfos$FieldNumbers;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "intraMergeTaskExecutor", "Lorg/gnit/lucenekmp/jdkport/Executor;", "<init>", "(Ljava/util/List;Lorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/FieldInfos$FieldNumbers;Lorg/gnit/lucenekmp/store/IOContext;Lorg/gnit/lucenekmp/jdkport/Executor;)V", "directory", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "getMergeState", "()Lorg/gnit/lucenekmp/index/MergeState;", "fieldInfosBuilder", "Lorg/gnit/lucenekmp/index/FieldInfos$Builder;", "mergeStateCreationThread", "Lkotlinx/coroutines/Job;", "getMergeStateCreationThread", "()Lkotlinx/coroutines/Job;", "shouldMerge", "", "merge", "mergeFieldInfos", "", "segmentWriteState", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "segmentReadState", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "mergeDocValues", "mergePoints", "mergeNorms", "mergeTerms", "mergeFields", "", "mergeTermVectors", "mergeVectorValues", "mergeWithLogging", "merger", "Lorg/gnit/lucenekmp/index/SegmentMerger$Merger;", "formatName", "", "Lorg/gnit/lucenekmp/index/SegmentMerger$VoidMerger;", "numMerged", "Merger", "VoidMerger", "core"})
@SourceDebugExtension(value={"SMAP\nSegmentMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentMerger.kt\norg/gnit/lucenekmp/index/SegmentMerger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,372:1\n1#2:373\n8#3,2:374\n8#3,2:376\n3#3,8:378\n10#4:386\n*S KotlinDebug\n*F\n+ 1 SegmentMerger.kt\norg/gnit/lucenekmp/index/SegmentMerger\n*L\n61#1:374,2\n97#1:376,2\n295#1:378,8\n295#1:386\n*E\n"})
public final class SegmentMerger {
    @NotNull
    private final Directory directory;
    @NotNull
    private final Codec codec;
    @NotNull
    private final IOContext context;
    @NotNull
    private final MergeState mergeState;
    @NotNull
    private final FieldInfos.Builder fieldInfosBuilder;
    @NotNull
    private final Job mergeStateCreationThread;

    /*
     * WARNING - void declaration
     */
    public SegmentMerger(@NotNull List<CodecReader> readers, @NotNull SegmentInfo segmentInfo, @NotNull InfoStream infoStream, @NotNull Directory dir, @NotNull FieldInfos.FieldNumbers fieldNumbers, @NotNull IOContext context, @NotNull Executor intraMergeTaskExecutor) {
        void condition$iv;
        Intrinsics.checkNotNullParameter(readers, (String)"readers");
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fieldNumbers, (String)"fieldNumbers");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intraMergeTaskExecutor, (String)"intraMergeTaskExecutor");
        if (!(context.getContext() == IOContext.Context.MERGE)) {
            boolean $i$a$-require-SegmentMerger$22 = false;
            String $i$a$-require-SegmentMerger$22 = "IOContext.context should be MERGE; got: " + context.getContext();
            throw new IllegalArgumentException($i$a$-require-SegmentMerger$22.toString());
        }
        this.mergeState = new MergeState(readers, segmentInfo, infoStream, intraMergeTaskExecutor);
        this.mergeStateCreationThread = (Job)JobKt.Job$default(null, (int)1, null);
        this.directory = dir;
        this.codec = segmentInfo.getCodec();
        this.context = context;
        this.fieldInfosBuilder = new FieldInfos.Builder(fieldNumbers);
        Version minVersion = Version.Companion.getLATEST();
        for (CodecReader reader2 : readers) {
            Version leafMinVersion = reader2.getMetaData().getMinVersion();
            if (leafMinVersion == null) {
                minVersion = null;
                break;
            }
            Version version = minVersion;
            Intrinsics.checkNotNull((Object)version);
            if (!version.onOrAfter(leafMinVersion)) continue;
            minVersion = leafMinVersion;
        }
        boolean $i$a$-require-SegmentMerger$22 = segmentInfo.getMinVersion() == null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == false) {
            boolean bl = false;
            String string = "The min version should be set by SegmentMerger for merged segments";
            throw new AssertionError((Object)string);
        }
        segmentInfo.setMinVersion(minVersion);
        if (this.mergeState.getInfoStream().isEnabled("SM") && segmentInfo.getIndexSort() != null) {
            this.mergeState.getInfoStream().message("SM", "index sort during merge: " + segmentInfo.getIndexSort());
        }
    }

    @NotNull
    public final MergeState getMergeState() {
        return this.mergeState;
    }

    @NotNull
    public final Job getMergeStateCreationThread() {
        return this.mergeStateCreationThread;
    }

    public final boolean shouldMerge() {
        return this.mergeState.getSegmentInfo().maxDoc() > 0;
    }

    private final MergeState mergeState() {
        return this.mergeState;
    }

    @NotNull
    public final MergeState merge() throws IOException {
        if (!this.shouldMerge()) {
            boolean $i$a$-check-SegmentMerger$merge$22 = false;
            String $i$a$-check-SegmentMerger$merge$22 = "Merge would result in 0 document segment";
            throw new IllegalStateException($i$a$-check-SegmentMerger$merge$22.toString());
        }
        this.mergeFieldInfos();
        int numMerged = this.mergeWithLogging(() -> SegmentMerger.merge$lambda$3(this), "stored fields");
        boolean condition$iv = numMerged == this.mergeState.getSegmentInfo().maxDoc();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "numMerged=" + numMerged + " vs mergeState.segmentInfo.maxDoc()=" + this.mergeState.getSegmentInfo().maxDoc();
            throw new AssertionError((Object)string);
        }
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.mergeState.getInfoStream(), this.directory, this.mergeState.getSegmentInfo(), this.mergeState.getMergeFieldInfos(), null, this.context);
        SegmentInfo segmentInfo = this.mergeState.getSegmentInfo();
        FieldInfos fieldInfos = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        SegmentReadState segmentReadState = new SegmentReadState(this.directory, segmentInfo, fieldInfos, IOContext.Companion.getDEFAULT(), segmentWriteState.getSegmentSuffix());
        FieldInfos fieldInfos2 = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos2);
        if (fieldInfos2.hasNorms()) {
            this.mergeWithLogging((arg_0, arg_1) -> SegmentMerger.merge$lambda$5(this, arg_0, arg_1), segmentWriteState, segmentReadState, "norms", numMerged);
        }
        this.mergeWithLogging((arg_0, arg_1) -> SegmentMerger.merge$lambda$6(this, arg_0, arg_1), segmentWriteState, segmentReadState, "postings", numMerged);
        FieldInfos fieldInfos3 = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos3);
        if (fieldInfos3.hasDocValues()) {
            this.mergeWithLogging((arg_0, arg_1) -> SegmentMerger.merge$lambda$7(this, arg_0, arg_1), segmentWriteState, segmentReadState, "doc values", numMerged);
        }
        FieldInfos fieldInfos4 = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos4);
        if (fieldInfos4.hasPointValues()) {
            this.mergeWithLogging((arg_0, arg_1) -> SegmentMerger.merge$lambda$8(this, arg_0, arg_1), segmentWriteState, segmentReadState, "points", numMerged);
        }
        FieldInfos fieldInfos5 = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos5);
        if (fieldInfos5.hasVectorValues()) {
            this.mergeWithLogging((arg_0, arg_1) -> SegmentMerger.merge$lambda$9(this, arg_0, arg_1), segmentWriteState, segmentReadState, "numeric vectors", numMerged);
        }
        FieldInfos fieldInfos6 = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos6);
        if (fieldInfos6.hasTermVectors()) {
            this.mergeWithLogging(() -> SegmentMerger.merge$lambda$10(this), "term vectors");
        }
        this.mergeWithLogging((arg_0, arg_1) -> SegmentMerger.merge$lambda$11(this, arg_0, arg_1), segmentWriteState, segmentReadState, "field infos", numMerged);
        return this.mergeState;
    }

    private final void mergeFieldInfos(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        FieldInfosFormat fieldInfosFormat = this.codec.fieldInfosFormat();
        SegmentInfo segmentInfo = this.mergeState.getSegmentInfo();
        FieldInfos fieldInfos = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        fieldInfosFormat.write(this.directory, segmentInfo, "", fieldInfos, this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeDocValues(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        MergeState mergeState = this.mergeState();
        AutoCloseable autoCloseable = this.codec.docValuesFormat().fieldsConsumer(segmentWriteState);
        Throwable throwable = null;
        try {
            DocValuesConsumer consumer = (DocValuesConsumer)autoCloseable;
            boolean bl = false;
            consumer.merge(mergeState);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergePoints(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        MergeState mergeState = this.mergeState();
        AutoCloseable autoCloseable = this.codec.pointsFormat().fieldsWriter(segmentWriteState);
        Throwable throwable = null;
        try {
            PointsWriter writer = (PointsWriter)autoCloseable;
            boolean bl = false;
            writer.merge(mergeState);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeNorms(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        MergeState mergeState = this.mergeState();
        AutoCloseable autoCloseable = this.codec.normsFormat().normsConsumer(segmentWriteState);
        Throwable throwable = null;
        try {
            NormsConsumer consumer = (NormsConsumer)autoCloseable;
            boolean bl = false;
            consumer.merge(mergeState);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void mergeTerms(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        FieldInfos fieldInfos = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        NormsProducer norms = fieldInfos.hasNorms() ? this.codec.normsFormat().normsProducer(segmentReadState) : null;
        NormsProducer normsMergeInstance = null;
        if (norms != null) {
            normsMergeInstance = norms.getMergeInstance();
        }
        FieldInfos fieldInfos2 = this.mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos2);
        if (fieldInfos2.hasPostings()) {
            FieldsConsumer consumer = this.codec.postingsFormat().fieldsConsumer(segmentWriteState);
            NormsProducer normsProducer = normsMergeInstance;
            Intrinsics.checkNotNull((Object)normsProducer);
            consumer.merge(this.mergeState, normsProducer);
        }
    }

    public final void mergeFieldInfos() {
        for (FieldInfos readerFieldInfos : this.mergeState.getFieldInfos()) {
            if (readerFieldInfos == null) continue;
            for (FieldInfo fi : readerFieldInfos) {
                this.fieldInfosBuilder.add(fi);
            }
        }
        this.mergeState.setMergeFieldInfos(this.fieldInfosBuilder.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws IOException {
        MergeState mergeState = this.mergeState();
        AutoCloseable autoCloseable = this.codec.storedFieldsFormat().fieldsWriter(this.directory, mergeState.getSegmentInfo(), this.context);
        Throwable throwable = null;
        try {
            StoredFieldsWriter fieldsWriter = (StoredFieldsWriter)autoCloseable;
            boolean bl = false;
            int n = fieldsWriter.merge(mergeState);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeTermVectors() throws IOException {
        MergeState mergeState = this.mergeState();
        AutoCloseable autoCloseable = this.codec.termVectorsFormat().vectorsWriter(this.directory, mergeState.getSegmentInfo(), this.context);
        Throwable throwable = null;
        try {
            TermVectorsWriter termVectorsWriter = (TermVectorsWriter)autoCloseable;
            boolean bl = false;
            int numMerged = termVectorsWriter.merge(mergeState);
            boolean condition$iv = numMerged == mergeState.getSegmentInfo().maxDoc();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl2 = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            int n = numMerged;
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectorValues(SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) throws IOException {
        MergeState mergeState = this.mergeState();
        AutoCloseable autoCloseable = this.codec.knnVectorsFormat().fieldsWriter(segmentWriteState);
        Throwable throwable = null;
        try {
            KnnVectorsWriter writer = (KnnVectorsWriter)autoCloseable;
            boolean bl = false;
            writer.merge(mergeState);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final int mergeWithLogging(Merger merger, String formatName) throws IOException {
        long t0 = 0L;
        if (this.mergeState.getInfoStream().isEnabled("SM")) {
            t0 = System.INSTANCE.nanoTime();
        }
        int numMerged = merger.merge();
        if (this.mergeState.getInfoStream().isEnabled("SM")) {
            this.mergeState.getInfoStream().message("SM", TimeUnit.NANOSECONDS.toMillis(System.INSTANCE.nanoTime() - t0) + " ms to merge " + formatName + " [" + numMerged + " docs]");
        }
        return numMerged;
    }

    private final void mergeWithLogging(VoidMerger merger, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState, String formatName, int numMerged) throws IOException {
        long t0 = 0L;
        if (this.mergeState.getInfoStream().isEnabled("SM")) {
            t0 = System.INSTANCE.nanoTime();
        }
        merger.merge(segmentWriteState, segmentReadState);
        long t1 = System.INSTANCE.nanoTime();
        if (this.mergeState.getInfoStream().isEnabled("SM")) {
            this.mergeState.getInfoStream().message("SM", TimeUnit.NANOSECONDS.toMillis(t1 - t0) + " ms to merge " + formatName + " [" + numMerged + " docs]");
        }
    }

    private static final int merge$lambda$3(SegmentMerger this$0) {
        return this$0.mergeFields();
    }

    private static final void merge$lambda$5(SegmentMerger this$0, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) {
        Intrinsics.checkNotNullParameter((Object)segmentWriteState, (String)"segmentWriteState");
        Intrinsics.checkNotNullParameter((Object)segmentReadState, (String)"segmentReadState");
        this$0.mergeNorms(segmentWriteState, segmentReadState);
    }

    private static final void merge$lambda$6(SegmentMerger this$0, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) {
        Intrinsics.checkNotNullParameter((Object)segmentWriteState, (String)"segmentWriteState");
        Intrinsics.checkNotNullParameter((Object)segmentReadState, (String)"segmentReadState");
        this$0.mergeTerms(segmentWriteState, segmentReadState);
    }

    private static final void merge$lambda$7(SegmentMerger this$0, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) {
        Intrinsics.checkNotNullParameter((Object)segmentWriteState, (String)"segmentWriteState");
        Intrinsics.checkNotNullParameter((Object)segmentReadState, (String)"segmentReadState");
        this$0.mergeDocValues(segmentWriteState, segmentReadState);
    }

    private static final void merge$lambda$8(SegmentMerger this$0, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) {
        Intrinsics.checkNotNullParameter((Object)segmentWriteState, (String)"segmentWriteState");
        Intrinsics.checkNotNullParameter((Object)segmentReadState, (String)"segmentReadState");
        this$0.mergePoints(segmentWriteState, segmentReadState);
    }

    private static final void merge$lambda$9(SegmentMerger this$0, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) {
        Intrinsics.checkNotNullParameter((Object)segmentWriteState, (String)"segmentWriteState");
        Intrinsics.checkNotNullParameter((Object)segmentReadState, (String)"segmentReadState");
        this$0.mergeVectorValues(segmentWriteState, segmentReadState);
    }

    private static final int merge$lambda$10(SegmentMerger this$0) {
        return this$0.mergeTermVectors();
    }

    private static final void merge$lambda$11(SegmentMerger this$0, SegmentWriteState segmentWriteState, SegmentReadState segmentReadState) {
        Intrinsics.checkNotNullParameter((Object)segmentWriteState, (String)"segmentWriteState");
        Intrinsics.checkNotNullParameter((Object)segmentReadState, (String)"segmentReadState");
        this$0.mergeFieldInfos(segmentWriteState, segmentReadState);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/SegmentMerger$Merger;", "", "merge", "", "core"})
    private static interface Merger {
        public int merge() throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/SegmentMerger$VoidMerger;", "", "merge", "", "segmentWriteState", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "segmentReadState", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "core"})
    private static interface VoidMerger {
        public void merge(@NotNull SegmentWriteState var1, @NotNull SegmentReadState var2) throws IOException;
    }
}

