/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.DocValuesConsumer;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.index.DocValuesWriter;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.EmptyDocValuesProducer;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.packed.PackedLongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003./0B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\"\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/index/SortedDocValuesWriter;", "Lorg/gnit/lucenekmp/index/DocValuesWriter;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "iwBytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/Counter;Lorg/gnit/lucenekmp/util/ByteBlockPool;)V", "hash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "getHash", "()Lorg/gnit/lucenekmp/util/BytesRefHash;", "pending", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Builder;", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "bytesUsed", "", "lastDocID", "", "finalOrds", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "finalSortedValues", "", "finalOrdMap", "addValue", "", "docID", "value", "Lorg/gnit/lucenekmp/util/BytesRef;", "addOneValue", "updateBytesUsed", "finish", "docValues", "getDocValues", "()Lorg/gnit/lucenekmp/index/SortedDocValues;", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "dvConsumer", "Lorg/gnit/lucenekmp/codecs/DocValuesConsumer;", "BufferedSortedDocValues", "SortingSortedDocValues", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSortedDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedDocValuesWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,293:1\n1#2:294\n3#3,8:295\n10#4:303\n*S KotlinDebug\n*F\n+ 1 SortedDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedDocValuesWriter\n*L\n98#1:295,8\n98#1:303\n*E\n"})
public final class SortedDocValuesWriter
extends DocValuesWriter<SortedDocValues> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FieldInfo fieldInfo;
    @NotNull
    private final Counter iwBytesUsed;
    @NotNull
    private final BytesRefHash hash;
    @NotNull
    private final PackedLongValues.Builder pending;
    @NotNull
    private final DocsWithFieldSet docsWithField;
    private long bytesUsed;
    private int lastDocID;
    @Nullable
    private PackedLongValues finalOrds;
    private int[] finalSortedValues;
    private int[] finalOrdMap;

    public SortedDocValuesWriter(@NotNull FieldInfo fieldInfo, @NotNull Counter iwBytesUsed, @NotNull ByteBlockPool pool) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)iwBytesUsed, (String)"iwBytesUsed");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(pool, 16, new BytesRefHash.DirectBytesStartArray(16, this.iwBytesUsed));
        this.pending = PackedLongValues.Companion.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.lastDocID = -1;
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(this.bytesUsed);
    }

    @NotNull
    public final BytesRefHash getHash() {
        return this.hash;
    }

    public final void addValue(int docID, @NotNull BytesRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(docID > this.lastDocID)) {
            boolean $i$a$-require-SortedDocValuesWriter$addValue$22 = false;
            String $i$a$-require-SortedDocValuesWriter$addValue$22 = "DocValuesField \"" + this.fieldInfo.getName() + "\" appears more than once in this document (only one value is allowed per field)";
            throw new IllegalArgumentException($i$a$-require-SortedDocValuesWriter$addValue$22.toString());
        }
        if (!(value.getLength() <= 32766)) {
            boolean bl = false;
            String string = "DocValuesField \"" + this.fieldInfo.getName() + "\" is too large, must be <= 32766";
            throw new IllegalArgumentException(string.toString());
        }
        this.addOneValue(value);
        this.docsWithField.add(docID);
        this.lastDocID = docID;
    }

    private final void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        this.pending.add(termID);
        this.updateBytesUsed();
    }

    private final void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    private final void finish() {
        int[] nArray = this.finalSortedValues;
        if (this.finalSortedValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
            nArray = null;
        }
    }

    @Override
    @NotNull
    public SortedDocValues getDocValues() {
        this.finish();
        PackedLongValues packedLongValues = this.finalOrds;
        Intrinsics.checkNotNull((Object)packedLongValues);
        int[] nArray = this.finalSortedValues;
        if (this.finalSortedValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
            nArray = null;
        }
        int[] nArray2 = this.finalOrdMap;
        if (this.finalOrdMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalOrdMap");
            nArray2 = null;
        }
        return new BufferedSortedDocValues(this.hash, packedLongValues, nArray, nArray2, this.docsWithField.iterator());
    }

    @Override
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull DocValuesConsumer dvConsumer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dvConsumer, (String)"dvConsumer");
        this.finish();
        PackedLongValues packedLongValues = this.finalOrds;
        Intrinsics.checkNotNull((Object)packedLongValues);
        int[] nArray = this.finalSortedValues;
        if (this.finalSortedValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalSortedValues");
            nArray = null;
        }
        int[] nArray2 = this.finalOrdMap;
        if (this.finalOrdMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"finalOrdMap");
            nArray2 = null;
        }
        dvConsumer.addSortedField(this.fieldInfo, Companion.getDocValuesProducer(this.fieldInfo, this.hash, packedLongValues, nArray, nArray2, this.docsWithField, sortMap));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001a\u001a\u00060\u001bR\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010(\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/index/SortedDocValuesWriter$BufferedSortedDocValues;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "hash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "docToOrd", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "sortedValues", "", "ordMap", "docsWithField", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(Lorg/gnit/lucenekmp/util/BytesRefHash;Lorg/gnit/lucenekmp/util/packed/PackedLongValues;[I[ILorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getHash", "()Lorg/gnit/lucenekmp/util/BytesRefHash;", "getSortedValues", "()[I", "getOrdMap", "getDocsWithField", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "scratch", "Lorg/gnit/lucenekmp/util/BytesRef;", "getScratch", "()Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "", "iter", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "getIter", "()Lorg/gnit/lucenekmp/util/packed/PackedLongValues$Iterator;", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "ordValue", "lookupOrd", "valueCount", "getValueCount", "()I", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedDocValuesWriter$BufferedSortedDocValues\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,293:1\n3#2,8:294\n3#2,8:303\n10#3:302\n10#3:311\n*S KotlinDebug\n*F\n+ 1 SortedDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedDocValuesWriter$BufferedSortedDocValues\n*L\n175#1:294,8\n176#1:303,8\n175#1:302\n176#1:311\n*E\n"})
    public static final class BufferedSortedDocValues
    extends SortedDocValues {
        @NotNull
        private final BytesRefHash hash;
        @NotNull
        private final int[] sortedValues;
        @NotNull
        private final int[] ordMap;
        @NotNull
        private final DocIdSetIterator docsWithField;
        @NotNull
        private final BytesRef scratch;
        private int ord;
        @NotNull
        private final PackedLongValues.Iterator iter;

        public BufferedSortedDocValues(@NotNull BytesRefHash hash, @NotNull PackedLongValues docToOrd, @NotNull int[] sortedValues, @NotNull int[] ordMap, @NotNull DocIdSetIterator docsWithField) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)docToOrd, (String)"docToOrd");
            Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
            Intrinsics.checkNotNullParameter((Object)ordMap, (String)"ordMap");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            this.hash = hash;
            this.sortedValues = sortedValues;
            this.ordMap = ordMap;
            this.docsWithField = docsWithField;
            this.scratch = new BytesRef();
            this.iter = docToOrd.iterator();
        }

        @NotNull
        public final BytesRefHash getHash() {
            return this.hash;
        }

        @NotNull
        public final int[] getSortedValues() {
            return this.sortedValues;
        }

        @NotNull
        public final int[] getOrdMap() {
            return this.ordMap;
        }

        @NotNull
        public final DocIdSetIterator getDocsWithField() {
            return this.docsWithField;
        }

        @NotNull
        public final BytesRef getScratch() {
            return this.scratch;
        }

        @NotNull
        public final PackedLongValues.Iterator getIter() {
            return this.iter;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.ord = Math.INSTANCE.toIntExact(this.iter.next());
                this.ord = this.ordMap[this.ord];
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        @NotNull
        public BytesRef lookupOrd(int ord) {
            boolean condition$iv = ord >= 0 && ord < this.sortedValues.length;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = this.sortedValues[ord] >= 0 && this.sortedValues[ord] < this.sortedValues.length;
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.hash.get(this.sortedValues[ord], this.scratch);
            return this.scratch;
        }

        @Override
        public int getValueCount() {
            return this.hash.size();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/index/SortedDocValuesWriter$Companion;", "", "<init>", "()V", "sortDocValues", "", "maxDoc", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "oldValues", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "getDocValuesProducer", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "writerFieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "hash", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "ords", "Lorg/gnit/lucenekmp/util/packed/PackedLongValues;", "sortedValues", "ordMap", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "core"})
    @SourceDebugExtension(value={"SMAP\nSortedDocValuesWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortedDocValuesWriter.kt\norg/gnit/lucenekmp/index/SortedDocValuesWriter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] sortDocValues(int maxDoc, Sorter.DocMap sortMap, SortedDocValues oldValues) throws IOException {
            int[] ords = new int[maxDoc];
            Arrays.INSTANCE.fill(ords, -1);
            int docID = 0;
            while (true) {
                int n;
                int it = n = oldValues.nextDoc();
                boolean bl = false;
                docID = it;
                if (n == Integer.MAX_VALUE) break;
                int newDocID = sortMap.oldToNew(docID);
                ords[newDocID] = oldValues.ordValue();
            }
            return ords;
        }

        @NotNull
        public final DocValuesProducer getDocValuesProducer(@NotNull FieldInfo writerFieldInfo, @NotNull BytesRefHash hash, @NotNull PackedLongValues ords, @NotNull int[] sortedValues, @NotNull int[] ordMap, @NotNull DocsWithFieldSet docsWithField, @Nullable Sorter.DocMap sortMap) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writerFieldInfo, (String)"writerFieldInfo");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)ords, (String)"ords");
            Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
            Intrinsics.checkNotNullParameter((Object)ordMap, (String)"ordMap");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            int[] sorted = null;
            sorted = sortMap != null ? this.sortDocValues(sortMap.size(), sortMap, new BufferedSortedDocValues(hash, ords, sortedValues, ordMap, docsWithField.iterator())) : null;
            return new EmptyDocValuesProducer(writerFieldInfo, hash, ords, sortedValues, ordMap, docsWithField, sorted){
                final /* synthetic */ FieldInfo $writerFieldInfo;
                final /* synthetic */ BytesRefHash $hash;
                final /* synthetic */ PackedLongValues $ords;
                final /* synthetic */ int[] $sortedValues;
                final /* synthetic */ int[] $ordMap;
                final /* synthetic */ DocsWithFieldSet $docsWithField;
                final /* synthetic */ int[] $sorted;
                {
                    this.$writerFieldInfo = $writerFieldInfo;
                    this.$hash = $hash;
                    this.$ords = $ords;
                    this.$sortedValues = $sortedValues;
                    this.$ordMap = $ordMap;
                    this.$docsWithField = $docsWithField;
                    this.$sorted = $sorted;
                }

                public SortedDocValues getSorted(FieldInfo fieldInfoIn) {
                    Intrinsics.checkNotNullParameter((Object)fieldInfoIn, (String)"fieldInfoIn");
                    if (!Intrinsics.areEqual((Object)fieldInfoIn, (Object)this.$writerFieldInfo)) {
                        boolean bl = false;
                        String string = "wrong fieldInfo";
                        throw new IllegalArgumentException(string.toString());
                    }
                    SortedDocValues buf = new BufferedSortedDocValues(this.$hash, this.$ords, this.$sortedValues, this.$ordMap, this.$docsWithField.iterator());
                    if (this.$sorted == null) {
                        return buf;
                    }
                    return new SortingSortedDocValues(buf, this.$sorted);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/SortedDocValuesWriter$SortingSortedDocValues;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "in", "ords", "", "<init>", "(Lorg/gnit/lucenekmp/index/SortedDocValues;[I)V", "docID", "", "nextDoc", "advance", "target", "advanceExact", "", "ordValue", "cost", "", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "valueCount", "getValueCount", "()I", "core"})
    public static final class SortingSortedDocValues
    extends SortedDocValues {
        @NotNull
        private final SortedDocValues in;
        @NotNull
        private final int[] ords;
        private int docID;

        public SortingSortedDocValues(@NotNull SortedDocValues in, @NotNull int[] ords) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)ords, (String)"ords");
            this.in = in;
            this.ords = ords;
            this.docID = -1;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                int n = this.docID;
                this.docID = n + 1;
                if (this.docID != this.ords.length) continue;
                this.docID = Integer.MAX_VALUE;
                break;
            } while (this.ords[this.docID] == -1);
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.ords[target] != -1;
        }

        @Override
        public int ordValue() {
            return this.ords[this.docID];
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return this.in.getValueCount();
        }
    }
}

