/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.OrdTermState;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0018\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/index/SortedSetDocValuesTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "values", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedSetDocValues;)V", "currentOrd", "", "scratch", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "text", "Lorg/gnit/lucenekmp/util/BytesRef;", "seekExact", "", "", "ord", "next", "term", "docFreq", "", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "state", "Lorg/gnit/lucenekmp/index/TermState;", "termState", "core"})
public final class SortedSetDocValuesTermsEnum
extends BaseTermsEnum {
    @NotNull
    private final SortedSetDocValues values;
    private long currentOrd;
    @NotNull
    private final BytesRefBuilder scratch;

    public SortedSetDocValuesTermsEnum(@NotNull SortedSetDocValues values2) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        this.values = values2;
        this.currentOrd = -1L;
        this.scratch = new BytesRefBuilder();
    }

    @Override
    @NotNull
    public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        long ord = this.values.lookupTerm(text);
        if (ord >= 0L) {
            this.currentOrd = ord;
            this.scratch.copyBytes(text);
            return TermsEnum.SeekStatus.FOUND;
        }
        this.currentOrd = -ord - 1L;
        if (this.currentOrd == this.values.getValueCount()) {
            return TermsEnum.SeekStatus.END;
        }
        BytesRef bytesRef = this.values.lookupOrd(this.currentOrd);
        Intrinsics.checkNotNull((Object)bytesRef);
        this.scratch.copyBytes(bytesRef);
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public boolean seekExact(@NotNull BytesRef text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        long ord = this.values.lookupTerm(text);
        if (ord >= 0L) {
            this.currentOrd = ord;
            this.scratch.copyBytes(text);
            return true;
        }
        return false;
    }

    @Override
    public void seekExact(long ord) throws IOException {
        if (!(ord >= 0L && ord < this.values.getValueCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentOrd = (int)ord;
        BytesRef bytesRef = this.values.lookupOrd(this.currentOrd);
        Intrinsics.checkNotNull((Object)bytesRef);
        this.scratch.copyBytes(bytesRef);
    }

    @Override
    @Nullable
    public BytesRef next() throws IOException {
        long l = this.currentOrd;
        this.currentOrd = l + 1L;
        if (this.currentOrd >= this.values.getValueCount()) {
            return null;
        }
        BytesRef bytesRef = this.values.lookupOrd(this.currentOrd);
        Intrinsics.checkNotNull((Object)bytesRef);
        this.scratch.copyBytes(bytesRef);
        return this.scratch.get();
    }

    @Override
    @NotNull
    public BytesRef term() throws IOException {
        return this.scratch.get();
    }

    @Override
    public long ord() throws IOException {
        return this.currentOrd;
    }

    @Override
    public int docFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalTermFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ImpactsEnum impacts(int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(@NotNull BytesRef term, @NotNull TermState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!(state2 instanceof OrdTermState)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.seekExact(((OrdTermState)state2).getOrd());
    }

    @Override
    @NotNull
    public TermState termState() throws IOException {
        OrdTermState state2 = new OrdTermState();
        state2.setOrd(this.currentOrd);
        return state2;
    }
}

