/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.DirectoryReader;
import org.gnit.lucenekmp.index.IndexCommit;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfos;
import org.gnit.lucenekmp.index.SegmentReader;
import org.gnit.lucenekmp.index.StandardDirectoryReader;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.gnit.lucenekmp.util.IOConsumer;
import org.gnit.lucenekmp.util.IOFunction;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 92\u00020\u0001:\u000289Bc\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\fj\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u0001`\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\nJ\b\u0010'\u001a\u00020(H\u0014J\u000e\u00103\u001a\u00020(H\u0094@\u00a2\u0006\u0002\u00104R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/index/StandardDirectoryReader;", "Lorg/gnit/lucenekmp/index/DirectoryReader;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "readers", "", "Lorg/gnit/lucenekmp/index/LeafReader;", "writer", "Lorg/gnit/lucenekmp/index/IndexWriter;", "sis", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "leafSorter", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "applyAllDeletes", "", "writeAllDeletes", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;[Lorg/gnit/lucenekmp/index/LeafReader;Lorg/gnit/lucenekmp/index/IndexWriter;Lorg/gnit/lucenekmp/index/SegmentInfos;Ljava/util/Comparator;ZZ)V", "getWriter", "()Lorg/gnit/lucenekmp/index/IndexWriter;", "segmentInfos", "getSegmentInfos", "()Lorg/gnit/lucenekmp/index/SegmentInfos;", "toString", "", "doOpenIfChanged", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "doOpenFromWriter", "doOpenNoWriter", "doOpenFromCommit", "infos", "version", "", "getVersion", "()J", "isCurrent", "()Z", "doClose", "", "indexCommit", "getIndexCommit", "()Lorg/gnit/lucenekmp/index/IndexCommit;", "readerClosedListeners", "", "Lorg/gnit/lucenekmp/index/IndexReader$ClosedListener;", "readerClosedListenerLock", "Lkotlinx/coroutines/sync/Mutex;", "cacheHelper", "Lorg/gnit/lucenekmp/index/IndexReader$CacheHelper;", "notifyReaderClosedListeners", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readerCacheHelper", "getReaderCacheHelper", "()Lorg/gnit/lucenekmp/index/IndexReader$CacheHelper;", "ReaderCommit", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStandardDirectoryReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardDirectoryReader.kt\norg/gnit/lucenekmp/index/StandardDirectoryReader\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,575:1\n116#2,11:576\n*S KotlinDebug\n*F\n+ 1 StandardDirectoryReader.kt\norg/gnit/lucenekmp/index/StandardDirectoryReader\n*L\n254#1:576,11\n*E\n"})
public final class StandardDirectoryReader
extends DirectoryReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IndexWriter writer;
    private final boolean applyAllDeletes;
    private final boolean writeAllDeletes;
    @NotNull
    private final SegmentInfos segmentInfos;
    @NotNull
    private final Set<IndexReader.ClosedListener> readerClosedListeners;
    @NotNull
    private final Mutex readerClosedListenerLock;
    @NotNull
    private final IndexReader.CacheHelper cacheHelper;

    public StandardDirectoryReader(@NotNull Directory directory, @NotNull LeafReader[] readers, @Nullable IndexWriter writer, @NotNull SegmentInfos sis, @Nullable Comparator<? extends LeafReader> leafSorter, boolean applyAllDeletes, boolean writeAllDeletes) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)readers, (String)"readers");
        Intrinsics.checkNotNullParameter((Object)sis, (String)"sis");
        super(directory, readers, leafSorter);
        this.writer = writer;
        this.applyAllDeletes = applyAllDeletes;
        this.writeAllDeletes = writeAllDeletes;
        this.segmentInfos = sis;
        this.readerClosedListeners = new LinkedHashSet();
        this.readerClosedListenerLock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.cacheHelper = new IndexReader.CacheHelper(this){
            private final IndexReader.CacheKey cacheKey;
            final /* synthetic */ StandardDirectoryReader this$0;
            {
                this.this$0 = $receiver;
                this.cacheKey = new IndexReader.CacheKey();
            }

            public IndexReader.CacheKey getKey() {
                return this.cacheKey;
            }

            public Object addClosedListener(IndexReader.ClosedListener listener, Continuation<? super Unit> $completion) {
                this.this$0.ensureOpen();
                StandardDirectoryReader.access$getReaderClosedListeners$p(this.this$0).add(listener);
                return Unit.INSTANCE;
            }
        };
    }

    @Nullable
    public final IndexWriter getWriter() {
        return this.writer;
    }

    @NotNull
    public final SegmentInfos getSegmentInfos() {
        return this.segmentInfos;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        buffer.append('(');
        String segmentsFile = this.segmentInfos.getSegmentsFileName();
        if (segmentsFile != null) {
            buffer.append(segmentsFile).append(":").append(this.segmentInfos.getVersion());
        }
        if (this.writer != null) {
            buffer.append(":nrt");
        }
        for (LeafReader r : this.getSequentialSubReaders()) {
            buffer.append(' ');
            buffer.append(r);
        }
        buffer.append(')');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @Nullable
    public DirectoryReader doOpenIfChanged() throws IOException {
        return this.doOpenIfChanged((IndexCommit)null);
    }

    @Override
    @Nullable
    public DirectoryReader doOpenIfChanged(@Nullable IndexCommit commit2) throws IOException {
        this.ensureOpen();
        return this.writer != null ? this.doOpenFromWriter(commit2) : this.doOpenNoWriter(commit2);
    }

    @Override
    @Nullable
    public DirectoryReader doOpenIfChanged(@NotNull IndexWriter writer, boolean applyAllDeletes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.ensureOpen();
        return writer == this.writer && applyAllDeletes == this.applyAllDeletes ? this.doOpenFromWriter(null) : writer.getReader(applyAllDeletes, this.writeAllDeletes);
    }

    private final DirectoryReader doOpenFromWriter(IndexCommit commit2) throws IOException {
        if (commit2 != null) {
            return this.doOpenFromCommit(commit2);
        }
        IndexWriter indexWriter = this.writer;
        Intrinsics.checkNotNull((Object)indexWriter);
        if (indexWriter.nrtIsCurrent(this.segmentInfos)) {
            return null;
        }
        DirectoryReader reader2 = this.writer.getReader(this.applyAllDeletes, this.writeAllDeletes);
        if (reader2.getVersion() == this.segmentInfos.getVersion()) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(reader2, null){
                int label;
                final /* synthetic */ DirectoryReader $reader;
                {
                    this.$reader = $reader;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$reader.decRef((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            return null;
        }
        return reader2;
    }

    private final DirectoryReader doOpenNoWriter(IndexCommit commit2) throws IOException {
        if (commit2 == null) {
            if (this.isCurrent()) {
                return null;
            }
        } else {
            if (this.getDirectory() != commit2.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && Intrinsics.areEqual((Object)commit2.getSegmentsFileName(), (Object)this.segmentInfos.getSegmentsFileName())) {
                return null;
            }
        }
        IndexCommit indexCommit = commit2;
        Intrinsics.checkNotNull((Object)indexCommit);
        return this.doOpenFromCommit(indexCommit);
    }

    private final DirectoryReader doOpenFromCommit(IndexCommit commit2) throws IOException {
        Directory directory = this.getDirectory();
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(this, directory){
            final /* synthetic */ StandardDirectoryReader this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected DirectoryReader doBody(String segmentFileName) throws IOException {
                Intrinsics.checkNotNullParameter((Object)segmentFileName, (String)"segmentFileName");
                SegmentInfos infos = SegmentInfos.Companion.readCommit$default(SegmentInfos.Companion, this.getDirectory(), segmentFileName, 0, 4, null);
                return this.this$0.doOpenIfChanged(infos);
            }
        }.run(commit2);
    }

    @NotNull
    public final DirectoryReader doOpenIfChanged(@NotNull SegmentInfos infos) throws IOException {
        Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
        return Companion.open(this.getDirectory(), infos, this.getSequentialSubReaders(), this.getSubReadersSorter());
    }

    @Override
    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    @Override
    public boolean isCurrent() {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            SegmentInfos sis = SegmentInfos.Companion.readLatestCommit$default(SegmentInfos.Companion, this.getDirectory(), 0, 2, null);
            return sis.getVersion() == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        AutoCloseable decRefDeleter;
        AutoCloseable autoCloseable = decRefDeleter = () -> StandardDirectoryReader.doClose$lambda$0(this);
        Throwable throwable = null;
        try {
            AutoCloseable autoCloseable2 = autoCloseable;
            boolean bl = false;
            List sequentialSubReaders = this.getSequentialSubReaders();
            IOUtils.INSTANCE.applyToAll(sequentialSubReaders, StandardDirectoryReader::doClose$lambda$2$lambda$1);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public IndexCommit getIndexCommit() {
        this.ensureOpen();
        return new ReaderCommit(this, this.segmentInfos, this.getDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object notifyReaderClosedListeners(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof notifyReaderClosedListeners.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StandardDirectoryReader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.notifyReaderClosedListeners((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.readerClosedListenerLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-StandardDirectoryReader$notifyReaderClosedListeners$2 = false;
                    IOUtils.INSTANCE.applyToAll((Collection)this.readerClosedListeners, (IOConsumer<IndexReader.ClosedListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, notifyReaderClosedListeners$lambda$4$lambda$3(org.gnit.lucenekmp.index.StandardDirectoryReader org.gnit.lucenekmp.index.IndexReader$ClosedListener ), (Lorg/gnit/lucenekmp/index/IndexReader$ClosedListener;)V)((StandardDirectoryReader)this));
                    var6_11 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.cacheHelper;
    }

    private static final void doClose$lambda$0(StandardDirectoryReader this$0) {
        if (this$0.writer != null) {
            try {
                this$0.writer.decRefDeleter(this$0.segmentInfos);
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    private static final void doClose$lambda$2$lambda$1(LeafReader obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(obj, null){
            int label;
            final /* synthetic */ LeafReader $obj;
            {
                this.$obj = $obj;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$obj.decRef((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void notifyReaderClosedListeners$lambda$4$lambda$3(StandardDirectoryReader this$0, IndexReader.ClosedListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        l.onClose(this$0.cacheHelper.getKey());
    }

    public static final /* synthetic */ Set access$getReaderClosedListeners$p(StandardDirectoryReader $this) {
        return $this.readerClosedListeners;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u001a\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\n\u0012\u0004\u0012\u00020\f\u0018\u0001`\rJ@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u001e\u0010\n\u001a\u001a\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bj\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u0001`\rJ:\u0010\u0004\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u001e\u0010\n\u001a\u001a\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bj\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u0001`\rJ\u001c\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!H\u0082@\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/StandardDirectoryReader$Companion;", "", "<init>", "()V", "open", "Lorg/gnit/lucenekmp/index/DirectoryReader;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "commit", "Lorg/gnit/lucenekmp/index/IndexCommit;", "leafSorter", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/index/LeafReader;", "Lkotlin/Comparator;", "minSupportedMajorVersion", "", "Lorg/gnit/lucenekmp/index/StandardDirectoryReader;", "writer", "Lorg/gnit/lucenekmp/index/IndexWriter;", "readerFunction", "Lorg/gnit/lucenekmp/util/IOFunction;", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "Lorg/gnit/lucenekmp/index/SegmentReader;", "infos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "applyAllDeletes", "", "writeAllDeletes", "oldReaders", "", "decRefWhileHandlingException", "", "readers", "", "([Lorg/gnit/lucenekmp/index/SegmentReader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
    @SourceDebugExtension(value={"SMAP\nStandardDirectoryReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardDirectoryReader.kt\norg/gnit/lucenekmp/index/StandardDirectoryReader$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,575:1\n3#2,8:576\n3#2,8:589\n10#3:584\n10#3:597\n37#4:585\n36#4,3:586\n*S KotlinDebug\n*F\n+ 1 StandardDirectoryReader.kt\norg/gnit/lucenekmp/index/StandardDirectoryReader$Companion\n*L\n360#1:576,8\n506#1:589,8\n360#1:584\n506#1:597\n379#1:585\n379#1:586,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectoryReader open(@NotNull Directory directory, @Nullable IndexCommit commit2, @Nullable Comparator<LeafReader> leafSorter) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return this.open(directory, Version.Companion.getMIN_SUPPORTED_MAJOR(), commit2, leafSorter);
        }

        @NotNull
        public final DirectoryReader open(@NotNull Directory directory, int minSupportedMajorVersion, @Nullable IndexCommit commit2, @Nullable Comparator<? extends LeafReader> leafSorter) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(directory, minSupportedMajorVersion, leafSorter){
                final /* synthetic */ Directory $directory;
                final /* synthetic */ int $minSupportedMajorVersion;
                final /* synthetic */ Comparator<? extends LeafReader> $leafSorter;
                {
                    this.$directory = $directory;
                    this.$minSupportedMajorVersion = $minSupportedMajorVersion;
                    this.$leafSorter = $leafSorter;
                    super($directory);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected DirectoryReader doBody(String segmentFileName) throws IOException {
                    DirectoryReader directoryReader;
                    Intrinsics.checkNotNullParameter((Object)segmentFileName, (String)"segmentFileName");
                    boolean bl = this.$minSupportedMajorVersion <= Version.Companion.getLATEST().getMajor() && this.$minSupportedMajorVersion >= 0;
                    int n = this.$minSupportedMajorVersion;
                    if (!bl) {
                        boolean $i$a$-require-StandardDirectoryReader$Companion$open$1$doBody$22 = false;
                        String $i$a$-require-StandardDirectoryReader$Companion$open$1$doBody$22 = "minSupportedMajorVersion must be positive and <= " + Version.Companion.getLATEST().getMajor() + " but was: " + n;
                        throw new IllegalArgumentException($i$a$-require-StandardDirectoryReader$Companion$open$1$doBody$22.toString());
                    }
                    SegmentInfos sis = SegmentInfos.Companion.readCommit(this.$directory, segmentFileName, this.$minSupportedMajorVersion);
                    SegmentReader[] readers = new SegmentReader[sis.size()];
                    boolean success = false;
                    try {
                        for (int i = sis.size() - 1; -1 < i; --i) {
                            readers[i] = new SegmentReader(sis.info(i), sis.getIndexCreatedVersionMajor(), IOContext.Companion.getDEFAULT());
                        }
                        DirectoryReader reader2 = new StandardDirectoryReader(this.$directory, readers, null, sis, this.$leafSorter, false, false);
                        success = true;
                        directoryReader = reader2;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.INSTANCE.closeWhileHandlingException(Arrays.copyOf(readers, readers.length));
                        }
                        throw throwable;
                    }
                    return directoryReader;
                }
            }.run(commit2);
        }

        @NotNull
        public final StandardDirectoryReader open(@NotNull IndexWriter writer, @NotNull IOFunction<SegmentCommitInfo, SegmentReader> readerFunction, @NotNull SegmentInfos infos, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(readerFunction, (String)"readerFunction");
            Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
            int numSegments = infos.size();
            List readers = new ArrayList(numSegments);
            Directory dir = writer.getDirectory();
            SegmentInfos segmentInfos = infos.clone();
            int infosUpto = 0;
            try {
                for (int i = 0; i < numSegments; ++i) {
                    SegmentCommitInfo info = infos.info(i);
                    boolean condition$iv = info.getInfo().getDir() == dir;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    SegmentReader reader2 = readerFunction.apply(info);
                    if (reader2.numDocs() > 0 || writer.getConfig().getMergePolicy().keepFullyDeletedSegment(() -> Companion.open$lambda$0(reader2))) {
                        readers.add(reader2);
                        ++infosUpto;
                        continue;
                    }
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(reader2, null){
                        int label;
                        final /* synthetic */ SegmentReader $reader;
                        {
                            this.$reader = $reader;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = this.$reader.decRef((Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    segmentInfos.remove(infosUpto);
                }
                writer.incRefDeleter(segmentInfos);
                Collection $this$toTypedArray$iv = readers;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                StandardDirectoryReader result = new StandardDirectoryReader(dir, thisCollection$iv.toArray(new SegmentReader[0]), writer, segmentInfos, writer.getConfig().getLeafSorter(), applyAllDeletes, writeAllDeletes);
                return result;
            }
            catch (Throwable t) {
                try {
                    IOUtils.INSTANCE.applyToAll(readers, Companion::open$lambda$1);
                }
                catch (Throwable t1) {
                    ExceptionsKt.addSuppressed((Throwable)t, (Throwable)t1);
                }
                throw t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final DirectoryReader open(@NotNull Directory directory, @NotNull SegmentInfos infos, @NotNull List<? extends LeafReader> oldReaders, @Nullable Comparator<? extends LeafReader> leafSorter) throws IOException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
            Intrinsics.checkNotNullParameter(oldReaders, (String)"oldReaders");
            Map<String, Integer> segmentReaders = new LinkedHashMap();
            segmentReaders = CollectionUtil.INSTANCE.newHashMap(oldReaders.size());
            int c = oldReaders.size();
            for (int i = 0; i < c; ++i) {
                LeafReader leafReader = oldReaders.get(i);
                Intrinsics.checkNotNull((Object)leafReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SegmentReader");
                SegmentReader sr = (SegmentReader)leafReader;
                segmentReaders.put(sr.getSegmentName(), i);
            }
            SegmentReader[] newReaders = new SegmentReader[infos.size()];
            for (int i = infos.size() - 1; -1 < i; --i) {
                SegmentReader oldReader;
                SegmentCommitInfo commitInfo = infos.info(i);
                Integer oldReaderIndex = (Integer)segmentReaders.get(commitInfo.getInfo().getName());
                if (oldReaderIndex == null) {
                    v1 = null;
                } else {
                    LeafReader leafReader = oldReaders.get(oldReaderIndex);
                    Intrinsics.checkNotNull((Object)leafReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.SegmentReader");
                    v1 = oldReader = (SegmentReader)leafReader;
                }
                if (!(oldReader == null || Arrays.equals(commitInfo.getInfo().getId(), oldReader.getSegmentInfo().getInfo().getId()))) {
                    boolean $i$a$-check-StandardDirectoryReader$Companion$open$62 = false;
                    String $i$a$-check-StandardDirectoryReader$Companion$open$62 = "same segment " + commitInfo.getInfo().getName() + " has invalid doc count change; likely you are re-opening a reader after illegally removing index files yourself and building a new index in their place.  Use IndexWriter.deleteAll or open a new IndexWriter using OpenMode.CREATE instead";
                    throw new IllegalStateException($i$a$-check-StandardDirectoryReader$Companion$open$62.toString());
                }
                boolean success = false;
                try {
                    SegmentReader newReader = null;
                    if (oldReader == null || commitInfo.getInfo().getUseCompoundFile() != oldReader.getSegmentInfo().getInfo().getUseCompoundFile()) {
                        newReaders[i] = newReader = new SegmentReader(commitInfo, infos.getIndexCreatedVersionMajor(), IOContext.Companion.getDEFAULT());
                    } else if (oldReader.isNRT()) {
                        Bits liveDocs2 = commitInfo.hasDeletions() ? commitInfo.getInfo().getCodec().liveDocsFormat().readLiveDocs(commitInfo.getInfo().getDir(), commitInfo, IOContext.Companion.getREADONCE()) : null;
                        newReaders[i] = new SegmentReader(commitInfo, oldReader, liveDocs2, liveDocs2, commitInfo.getInfo().maxDoc() - commitInfo.getDelCount(), false);
                    } else if (oldReader.getSegmentInfo().getDelGen() == commitInfo.getDelGen() && oldReader.getSegmentInfo().getFieldInfosGen() == commitInfo.getFieldInfosGen()) {
                        oldReader.incRef();
                        newReaders[i] = oldReader;
                    } else {
                        boolean condition$iv = commitInfo.getInfo().getDir() == oldReader.getSegmentInfo().getInfo().getDir();
                        boolean $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean bl = false;
                            String string = "assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        if (oldReader.getSegmentInfo().getDelGen() == commitInfo.getDelGen()) {
                            newReaders[i] = new SegmentReader(commitInfo, oldReader, oldReader.getLiveDocs(), oldReader.getHardLiveDocs(), oldReader.numDocs(), false);
                        } else {
                            Bits liveDocs3 = commitInfo.hasDeletions() ? commitInfo.getInfo().getCodec().liveDocsFormat().readLiveDocs(commitInfo.getInfo().getDir(), commitInfo, IOContext.Companion.getREADONCE()) : null;
                            newReaders[i] = new SegmentReader(commitInfo, oldReader, liveDocs3, liveDocs3, commitInfo.getInfo().maxDoc() - commitInfo.getDelCount(), false);
                        }
                    }
                    success = true;
                }
                catch (Throwable throwable) {
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newReaders, null){
                        int label;
                        final /* synthetic */ SegmentReader[] $newReaders;
                        {
                            this.$newReaders = $newReaders;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = org.gnit.lucenekmp.index.StandardDirectoryReader$Companion.access$decRefWhileHandlingException(StandardDirectoryReader.Companion, this.$newReaders, (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    throw throwable;
                }
            }
            return new StandardDirectoryReader(directory, newReaders, null, infos, leafSorter, false, false);
        }

        /*
         * Unable to fully structure code
         */
        private final Object decRefWhileHandlingException(SegmentReader[] readers, Continuation<? super Unit> $completion) {
            if (!($completion instanceof decRefWhileHandlingException.1)) ** GOTO lbl-1000
            var8_3 = $completion;
            if ((var8_3.label & -2147483648) != 0) {
                var8_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return org.gnit.lucenekmp.index.StandardDirectoryReader$Companion.access$decRefWhileHandlingException(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var3_6 = 0;
                    var4_7 = readers.length;
lbl14:
                    // 2 sources

                    while (var3_6 < var4_7) {
                        reader = readers[var3_6];
                        if (reader != null) {
                            $continuation.L$0 = readers;
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)reader);
                            $continuation.I$0 = var3_6;
                            $continuation.I$1 = var4_7;
                            $continuation.label = 1;
                            v0 = reader.decRef((Continuation<? super Unit>)$continuation);
                            ** if (v0 != var9_5) goto lbl27
lbl26:
                            // 1 sources

                            return var9_5;
                        }
lbl27:
                        // 3 sources

                        ** GOTO lbl41
                    }
                    break;
                }
                case 1: {
                    var4_7 = $continuation.I$1;
                    var3_6 = $continuation.I$0;
                    reader = (SegmentReader)$continuation.L$1;
                    readers = (SegmentReader[])$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                    }
                    catch (Throwable var6_9) {
                        // empty catch block
                    }
lbl41:
                    // 3 sources

                    ++var3_6;
                    ** GOTO lbl14
                }
            }
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private static final CodecReader open$lambda$0(SegmentReader $reader) {
            return $reader;
        }

        private static final void open$lambda$1(SegmentReader obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(obj, null){
                int label;
                final /* synthetic */ SegmentReader $obj;
                {
                    this.$obj = $obj;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$obj.decRef((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public static final /* synthetic */ Object access$decRefWhileHandlingException(Companion $this, SegmentReader[] readers, Continuation $completion) {
            return $this.decRefWhileHandlingException(readers, (Continuation<? super Unit>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010(\u001a\u00020\u0011H\u0016J\b\u0010.\u001a\u00020/H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\rR\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010-\u00a8\u00060"}, d2={"Lorg/gnit/lucenekmp/index/StandardDirectoryReader$ReaderCommit;", "Lorg/gnit/lucenekmp/index/IndexCommit;", "reader", "Lorg/gnit/lucenekmp/index/StandardDirectoryReader;", "infos", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "<init>", "(Lorg/gnit/lucenekmp/index/StandardDirectoryReader;Lorg/gnit/lucenekmp/index/SegmentInfos;Lorg/gnit/lucenekmp/store/Directory;)V", "getReader", "()Lorg/gnit/lucenekmp/index/StandardDirectoryReader;", "getDir", "()Lorg/gnit/lucenekmp/store/Directory;", "setDir", "(Lorg/gnit/lucenekmp/store/Directory;)V", "segmentsFileName", "", "getSegmentsFileName", "()Ljava/lang/String;", "fileNames", "", "getFileNames", "()Ljava/util/Collection;", "setFileNames", "(Ljava/util/Collection;)V", "generation", "", "getGeneration", "()J", "setGeneration", "(J)V", "userData", "", "getUserData", "()Ljava/util/Map;", "segmentCount", "", "getSegmentCount", "()I", "toString", "directory", "getDirectory", "isDeleted", "", "()Z", "delete", "", "core"})
    public static final class ReaderCommit
    extends IndexCommit {
        @Nullable
        private final StandardDirectoryReader reader;
        @NotNull
        private Directory dir;
        @Nullable
        private final String segmentsFileName;
        @NotNull
        private Collection<String> fileNames;
        private long generation;
        @NotNull
        private final Map<String, String> userData;
        private final int segmentCount;

        public ReaderCommit(@Nullable StandardDirectoryReader reader2, @NotNull SegmentInfos infos, @NotNull Directory dir) {
            Intrinsics.checkNotNullParameter((Object)infos, (String)"infos");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            this.reader = reader2;
            this.dir = dir;
            this.segmentsFileName = infos.getSegmentsFileName();
            this.fileNames = infos.files(true);
            this.generation = infos.getGeneration();
            this.userData = infos.getUserData();
            this.segmentCount = infos.size();
        }

        @Override
        @Nullable
        public StandardDirectoryReader getReader() {
            return this.reader;
        }

        @NotNull
        public final Directory getDir() {
            return this.dir;
        }

        public final void setDir(@NotNull Directory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"<set-?>");
            this.dir = directory;
        }

        @Override
        @Nullable
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        @NotNull
        public Collection<String> getFileNames() {
            return this.fileNames;
        }

        public void setFileNames(@NotNull Collection<String> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.fileNames = collection;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        public void setGeneration(long l) {
            this.generation = l;
        }

        @Override
        @NotNull
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @NotNull
        public String toString() {
            return "StandardDirectoryReader.ReaderCommit(" + this.getSegmentsFileName() + " files=" + this.getFileNames() + ")";
        }

        @Override
        @NotNull
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }
}

