/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.StoredFieldsWriter;
import org.gnit.lucenekmp.document.StoredValue;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.StoredFieldDataInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001dJ\u0016\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u001fJ\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001dJ\u001a\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/index/StoredFieldsConsumer;", "", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "info", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "<init>", "(Lorg/gnit/lucenekmp/codecs/Codec;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;)V", "getCodec", "()Lorg/gnit/lucenekmp/codecs/Codec;", "getDirectory", "()Lorg/gnit/lucenekmp/store/Directory;", "getInfo", "()Lorg/gnit/lucenekmp/index/SegmentInfo;", "writer", "Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "getWriter", "()Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "setWriter", "(Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;)V", "accountable", "Lorg/gnit/lucenekmp/util/Accountable;", "getAccountable", "()Lorg/gnit/lucenekmp/util/Accountable;", "setAccountable", "(Lorg/gnit/lucenekmp/util/Accountable;)V", "lastDoc", "", "initStoredFieldsWriter", "", "startDocument", "docID", "writeField", "Lorg/gnit/lucenekmp/index/FieldInfo;", "value", "Lorg/gnit/lucenekmp/document/StoredValue;", "finishDocument", "finish", "maxDoc", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "abort", "core"})
@SourceDebugExtension(value={"SMAP\nStoredFieldsConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredFieldsConsumer.kt\norg/gnit/lucenekmp/index/StoredFieldsConsumer\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,87:1\n3#2,8:88\n10#3:96\n*S KotlinDebug\n*F\n+ 1 StoredFieldsConsumer.kt\norg/gnit/lucenekmp/index/StoredFieldsConsumer\n*L\n38#1:88,8\n38#1:96\n*E\n"})
public class StoredFieldsConsumer {
    @NotNull
    private final Codec codec;
    @NotNull
    private final Directory directory;
    @NotNull
    private final SegmentInfo info;
    @Nullable
    private StoredFieldsWriter writer;
    @NotNull
    private Accountable accountable;
    private int lastDoc;

    public StoredFieldsConsumer(@NotNull Codec codec, @NotNull Directory directory, @NotNull SegmentInfo info) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.codec = codec;
        this.directory = directory;
        this.info = info;
        this.accountable = Accountable.Companion.getNULL_ACCOUNTABLE();
        this.lastDoc = -1;
    }

    @NotNull
    public final Codec getCodec() {
        return this.codec;
    }

    @NotNull
    public final Directory getDirectory() {
        return this.directory;
    }

    @NotNull
    public final SegmentInfo getInfo() {
        return this.info;
    }

    @Nullable
    public final StoredFieldsWriter getWriter() {
        return this.writer;
    }

    public final void setWriter(@Nullable StoredFieldsWriter storedFieldsWriter) {
        this.writer = storedFieldsWriter;
    }

    @NotNull
    public final Accountable getAccountable() {
        return this.accountable;
    }

    public final void setAccountable(@NotNull Accountable accountable) {
        Intrinsics.checkNotNullParameter((Object)accountable, (String)"<set-?>");
        this.accountable = accountable;
    }

    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            StoredFieldsWriter storedFieldsWriter = this.writer = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.info, IOContext.Companion.getDEFAULT());
            Intrinsics.checkNotNull((Object)storedFieldsWriter);
            this.accountable = storedFieldsWriter;
        }
    }

    public final void startDocument(int docID) throws IOException {
        boolean condition$iv = this.lastDoc < docID;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.initStoredFieldsWriter();
        while (true) {
            ++this.lastDoc;
            if (this.lastDoc >= docID) break;
            StoredFieldsWriter storedFieldsWriter = this.writer;
            Intrinsics.checkNotNull((Object)storedFieldsWriter);
            storedFieldsWriter.startDocument();
            StoredFieldsWriter storedFieldsWriter2 = this.writer;
            Intrinsics.checkNotNull((Object)storedFieldsWriter2);
            storedFieldsWriter2.finishDocument();
        }
        StoredFieldsWriter storedFieldsWriter = this.writer;
        Intrinsics.checkNotNull((Object)storedFieldsWriter);
        storedFieldsWriter.startDocument();
    }

    public final void writeField(@NotNull FieldInfo info, @NotNull StoredValue value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
            case 1: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                storedFieldsWriter.writeField(info, value.getIntValue());
                break;
            }
            case 2: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                storedFieldsWriter.writeField(info, value.getLongValue());
                break;
            }
            case 3: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                storedFieldsWriter.writeField(info, value.getFloatValue());
                break;
            }
            case 4: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                storedFieldsWriter.writeField(info, value.getDoubleValue());
                break;
            }
            case 5: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                storedFieldsWriter.writeField(info, value.getBinaryValue());
                break;
            }
            case 6: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                StoredFieldDataInput storedFieldDataInput = value.getDataInputValue();
                Intrinsics.checkNotNull((Object)storedFieldDataInput);
                storedFieldsWriter.writeField(info, storedFieldDataInput);
                break;
            }
            case 7: {
                StoredFieldsWriter storedFieldsWriter = this.writer;
                Intrinsics.checkNotNull((Object)storedFieldsWriter);
                storedFieldsWriter.writeField(info, value.getStringValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public final void finishDocument() throws IOException {
        StoredFieldsWriter storedFieldsWriter = this.writer;
        Intrinsics.checkNotNull((Object)storedFieldsWriter);
        storedFieldsWriter.finishDocument();
    }

    public final void finish(int maxDoc) throws IOException {
        while (this.lastDoc < maxDoc - 1) {
            this.startDocument(this.lastDoc + 1);
            this.finishDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        try {
            StoredFieldsWriter storedFieldsWriter = this.writer;
            Intrinsics.checkNotNull((Object)storedFieldsWriter);
            storedFieldsWriter.finish(state2.getSegmentInfo().maxDoc());
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
            IOUtils.INSTANCE.closeNullable(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
    }

    public void abort() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
        IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StoredValue.Type.values().length];
            try {
                nArray[StoredValue.Type.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.BINARY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.DATA_INPUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.STRING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

