/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001$B\u001b\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0011\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010!\u001a\u00020\u0004H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/index/Term;", "", "Lorg/gnit/lucenekmp/util/Accountable;", "fld", "", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/util/BytesRef;)V", "bytesBuilder", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/util/BytesRefBuilder;)V", "text", "(Ljava/lang/String;Ljava/lang/String;)V", "field", "getField", "()Ljava/lang/String;", "setField", "(Ljava/lang/String;)V", "getBytes", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setBytes", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "equals", "", "obj", "", "hashCode", "", "compareTo", "other", "set", "", "toString", "ramBytesUsed", "", "Companion", "core"})
public final class Term
implements Comparable<Term>,
Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String field;
    @NotNull
    private BytesRef bytes;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Term.class)) + RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(BytesRef.class));

    @NotNull
    public final String getField() {
        return this.field;
    }

    public final void setField(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.field = string;
    }

    @NotNull
    public final BytesRef getBytes() {
        return this.bytes;
    }

    public final void setBytes(@NotNull BytesRef bytesRef) {
        Intrinsics.checkNotNullParameter((Object)bytesRef, (String)"<set-?>");
        this.bytes = bytesRef;
    }

    @JvmOverloads
    public Term(@NotNull String fld, @NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)fld, (String)"fld");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.field = fld;
        this.bytes = BytesRef.Companion.deepCopyOf(bytes);
    }

    public /* synthetic */ Term(String string, BytesRef bytesRef, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bytesRef = new BytesRef();
        }
        this(string, bytesRef);
    }

    public Term(@NotNull String fld, @NotNull BytesRefBuilder bytesBuilder) {
        Intrinsics.checkNotNullParameter((Object)fld, (String)"fld");
        Intrinsics.checkNotNullParameter((Object)bytesBuilder, (String)"bytesBuilder");
        this.field = fld;
        this.bytes = bytesBuilder.toBytesRef();
    }

    public Term(@NotNull String fld, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)fld, (String)"fld");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(fld, new BytesRef(text));
    }

    @NotNull
    public final String field() {
        return this.field;
    }

    @NotNull
    public final String text() {
        return this.bytes.utf8ToString();
    }

    @NotNull
    public final BytesRef bytes() {
        return this.bytes;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        if (this.field == null ? other.field != null : !Intrinsics.areEqual((Object)this.field, (Object)other.field)) {
            return false;
        }
        if (this.bytes == null) {
            if (other.bytes != null) {
                return false;
            }
        } else {
            BytesRef bytesRef = this.bytes;
            Intrinsics.checkNotNull((Object)bytesRef);
            if (!bytesRef.equals(other.bytes)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.field == null ? 0 : this.field.hashCode());
        result = prime * result + (this.bytes == null ? 0 : this.bytes.hashCode());
        return result;
    }

    @Override
    public int compareTo(@NotNull Term other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this.field, (Object)other.field)) {
            BytesRef bytesRef = this.bytes;
            Intrinsics.checkNotNull((Object)bytesRef);
            BytesRef bytesRef2 = other.bytes;
            Intrinsics.checkNotNull((Object)bytesRef2);
            return bytesRef.compareTo(bytesRef2);
        }
        String string = this.field;
        Intrinsics.checkNotNull((Object)string);
        String string2 = other.field;
        Intrinsics.checkNotNull((Object)string2);
        return string.compareTo(string2);
    }

    public final void set(@NotNull String fld, @NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)fld, (String)"fld");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.field = fld;
        this.bytes = bytes;
    }

    @NotNull
    public String toString() {
        return this.field + ":" + this.text();
    }

    @Override
    public long ramBytesUsed() {
        long l;
        long l2 = BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.field);
        if (this.bytes != null) {
            BytesRef bytesRef = this.bytes;
            Intrinsics.checkNotNull((Object)bytesRef);
            l = RamUsageEstimator.Companion.alignObjectSize(bytesRef.getBytes().length + 8);
        } else {
            l = 0L;
        }
        return l2 + l;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public Term(@NotNull String fld) {
        Intrinsics.checkNotNullParameter((Object)fld, (String)"fld");
        this(fld, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/Term$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "toString", "", "termText", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toString(@NotNull BytesRef termText) {
            Intrinsics.checkNotNullParameter((Object)termText, (String)"termText");
            ByteBuffer bb = ByteBuffer.Companion.wrap(termText.getBytes(), termText.getOffset(), termText.getLength());
            byte[] byteArray = new byte[bb.remaining()];
            ByteBuffer.get$default(bb, byteArray, 0, 0, 6, null);
            String decoded = byteArray.toString();
            return Arrays.equals(StringsKt.encodeToByteArray((String)decoded), byteArray) ? decoded : termText.toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

