/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.IndexReaderContext;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IOBooleanSupplier;
import org.gnit.lucenekmp.util.IOSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\bB1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/TermStates;", "", "term", "Lorg/gnit/lucenekmp/index/Term;", "context", "Lorg/gnit/lucenekmp/index/IndexReaderContext;", "<init>", "(Lorg/gnit/lucenekmp/index/Term;Lorg/gnit/lucenekmp/index/IndexReaderContext;)V", "(Lorg/gnit/lucenekmp/index/IndexReaderContext;)V", "state", "Lorg/gnit/lucenekmp/index/TermState;", "ord", "", "docFreq", "totalTermFreq", "", "(Lorg/gnit/lucenekmp/index/IndexReaderContext;Lorg/gnit/lucenekmp/index/TermState;IIJ)V", "topReaderContextIdentity", "states", "", "[Lorg/gnit/lucenekmp/index/TermState;", "wasBuiltFor", "", "clear", "", "register", "accumulateStatistics", "get", "Lorg/gnit/lucenekmp/util/IOSupplier;", "ctx", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "toString", "", "PendingTermLookup", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTermStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermStates.kt\norg/gnit/lucenekmp/index/TermStates\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
public final class TermStates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object topReaderContextIdentity;
    @NotNull
    private final TermState[] states;
    @Nullable
    private final Term term;
    private int docFreq;
    private long totalTermFreq;
    @NotNull
    private static final TermState EMPTY_TERMSTATE = new TermState(){

        public void copyFrom(TermState other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        }
    };

    private TermStates(Term term, IndexReaderContext context) {
        if (!(context != null && context.isTopLevel())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.topReaderContextIdentity = context.getIdentity();
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        this.states = new TermState[context.leaves().size()];
        this.term = term;
    }

    public TermStates(@Nullable IndexReaderContext context) {
        this(null, context);
    }

    public final boolean wasBuiltFor(@NotNull IndexReaderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.topReaderContextIdentity == context.getIdentity();
    }

    public TermStates(@NotNull IndexReaderContext context, @NotNull TermState state2, int ord, int docFreq, long totalTermFreq) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this(null, context);
        this.register(state2, ord, docFreq, totalTermFreq);
    }

    public final void clear() {
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        ArraysKt.fill$default((Object[])this.states, null, (int)0, (int)0, (int)6, null);
    }

    public final void register(@NotNull TermState state2, int ord, int docFreq, long totalTermFreq) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.register(state2, ord);
        this.accumulateStatistics(docFreq, totalTermFreq);
    }

    public final void register(@NotNull TermState state2, int ord) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (!(ord >= 0 && ord < this.states.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.states[ord] == null)) {
            boolean bl = false;
            String string = "state for ord: " + ord + " already registered";
            throw new IllegalArgumentException(string.toString());
        }
        this.states[ord] = state2;
    }

    public final void accumulateStatistics(int docFreq, long totalTermFreq) {
        if (!(docFreq >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(totalTermFreq >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((long)docFreq <= totalTermFreq)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.docFreq += docFreq;
        this.totalTermFreq += totalTermFreq;
    }

    @Nullable
    public final IOSupplier<TermState> get(@NotNull LeafReaderContext ctx) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!(ctx.getOrd() >= 0 && ctx.getOrd() < this.states.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.term == null) {
            return this.states[ctx.getOrd()] == null ? null : () -> TermStates.get$lambda$2(this, ctx);
        }
        if (this.states[ctx.getOrd()] == null) {
            Terms terms = ctx.reader().terms(this.term.field());
            if (terms == null) {
                this.states[ctx.getOrd()] = EMPTY_TERMSTATE;
                return null;
            }
            TermsEnum termsEnum = terms.iterator();
            IOBooleanSupplier termExistsSupplier = termsEnum.prepareSeekExact(this.term.bytes());
            if (termExistsSupplier == null) {
                this.states[ctx.getOrd()] = EMPTY_TERMSTATE;
                return null;
            }
            return () -> TermStates.get$lambda$3(this, ctx, termExistsSupplier, termsEnum);
        }
        TermState state2 = this.states[ctx.getOrd()];
        if (state2 == EMPTY_TERMSTATE) {
            return null;
        }
        return () -> TermStates.get$lambda$4(state2);
    }

    public final int docFreq() {
        if (!(this.term == null)) {
            boolean bl = false;
            String string = "Cannot call docFreq() when needsStats=false";
            throw new IllegalStateException(string.toString());
        }
        return this.docFreq;
    }

    public final long totalTermFreq() {
        if (!(this.term == null)) {
            boolean bl = false;
            String string = "Cannot call totalTermFreq() when needsStats=false";
            throw new IllegalStateException(string.toString());
        }
        return this.totalTermFreq;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TermStates\n");
        for (TermState termState2 : this.states) {
            sb.append("  state=");
            sb.append(termState2);
            sb.append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final TermState get$lambda$2(TermStates this$0, LeafReaderContext $ctx) {
        return this$0.states[$ctx.getOrd()];
    }

    private static final TermState get$lambda$3(TermStates this$0, LeafReaderContext $ctx, IOBooleanSupplier $termExistsSupplier, TermsEnum $termsEnum) {
        TermState state2;
        if (this$0.states[$ctx.getOrd()] == null) {
            state2 = null;
            this$0.states[$ctx.getOrd()] = $termExistsSupplier.get() ? (state2 = $termsEnum.termState()) : EMPTY_TERMSTATE;
        }
        if ((state2 = this$0.states[$ctx.getOrd()]) == EMPTY_TERMSTATE) {
            return null;
        }
        return state2;
    }

    private static final TermState get$lambda$4(TermState $state) {
        return $state;
    }

    public /* synthetic */ TermStates(Term term, IndexReaderContext context, DefaultConstructorMarker $constructor_marker) {
        this(term, context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/TermStates$Companion;", "", "<init>", "()V", "EMPTY_TERMSTATE", "Lorg/gnit/lucenekmp/index/TermState;", "build", "Lorg/gnit/lucenekmp/index/TermStates;", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "term", "Lorg/gnit/lucenekmp/index/Term;", "needsStats", "", "core"})
    @SourceDebugExtension(value={"SMAP\nTermStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermStates.kt\norg/gnit/lucenekmp/index/TermStates$Companion\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,235:1\n217#2,5:236\n189#2,2:241\n222#2:243\n*S KotlinDebug\n*F\n+ 1 TermStates.kt\norg/gnit/lucenekmp/index/TermStates$Companion\n*L\n217#1:236,5\n217#1:241,2\n217#1:243\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TermStates build(@NotNull IndexSearcher indexSearcher, @NotNull Term term, boolean needsStats) throws IOException {
            Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            IndexReaderContext indexReaderContext = indexSearcher.getTopReaderContext();
            if (indexReaderContext == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            IndexReaderContext context = indexReaderContext;
            TermStates perReaderTermState = new TermStates(needsStats ? null : term, context, null);
            if (needsStats) {
                TermsEnum termsEnum;
                PendingTermLookup[] pendingTermLookups = new PendingTermLookup[]{};
                for (LeafReaderContext ctx : context.leaves()) {
                    PendingTermLookup[] pendingTermLookupArray;
                    void array$iv;
                    Terms terms = Terms.Companion.getTerms(ctx.reader(), term.field());
                    termsEnum = terms.iterator();
                    IOBooleanSupplier termExistsSupplier = termsEnum.prepareSeekExact(term.bytes());
                    if (termExistsSupplier == null) continue;
                    ArrayUtil.Companion companion = ArrayUtil.Companion;
                    PendingTermLookup[] pendingTermLookupArray2 = pendingTermLookups;
                    int minSize$iv = ctx.getOrd() + 1;
                    boolean $i$f$growNullable = false;
                    if (minSize$iv < 0) {
                        throw new Exception("size must be positive (got " + minSize$iv + "): likely integer overflow?");
                    }
                    if (((void)array$iv).length < minSize$iv) {
                        void array$iv$iv;
                        void this_$iv;
                        int newLength$iv = this_$iv.oversize(minSize$iv, 4);
                        void var17_20 = this_$iv;
                        void var18_21 = array$iv;
                        int newLength$iv$iv = newLength$iv;
                        boolean $i$f$growExactNullable = false;
                        if (newLength$iv$iv < ((void)array$iv$iv).length) {
                            throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                        }
                        PendingTermLookup[] pendingTermLookupArray3 = new PendingTermLookup[newLength$iv$iv];
                        for (int i = 0; i < newLength$iv$iv; ++i) {
                            int n = i;
                            pendingTermLookupArray3[n] = n < ((void)array$iv$iv).length ? array$iv$iv[n] : null;
                        }
                        pendingTermLookupArray = pendingTermLookupArray3;
                    } else {
                        pendingTermLookupArray = array$iv;
                    }
                    pendingTermLookups = pendingTermLookupArray;
                    pendingTermLookups[ctx.getOrd()] = new PendingTermLookup(termsEnum, termExistsSupplier);
                }
                int n = pendingTermLookups.length;
                for (int ord = 0; ord < n; ++ord) {
                    PendingTermLookup pendingTermLookup = pendingTermLookups[ord];
                    if (pendingTermLookup == null || !pendingTermLookup.getSupplier().get()) continue;
                    termsEnum = pendingTermLookup.getTermsEnum();
                    perReaderTermState.register(termsEnum.termState(), ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                }
            }
            return perReaderTermState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/index/TermStates$PendingTermLookup;", "", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "supplier", "Lorg/gnit/lucenekmp/util/IOBooleanSupplier;", "<init>", "(Lorg/gnit/lucenekmp/index/TermsEnum;Lorg/gnit/lucenekmp/util/IOBooleanSupplier;)V", "getTermsEnum", "()Lorg/gnit/lucenekmp/index/TermsEnum;", "getSupplier", "()Lorg/gnit/lucenekmp/util/IOBooleanSupplier;", "core"})
    private static final class PendingTermLookup {
        @NotNull
        private final TermsEnum termsEnum;
        @NotNull
        private final IOBooleanSupplier supplier;

        public PendingTermLookup(@NotNull TermsEnum termsEnum, @NotNull IOBooleanSupplier supplier) {
            Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
            Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
            this.termsEnum = termsEnum;
            this.supplier = supplier;
        }

        @NotNull
        public final TermsEnum getTermsEnum() {
            return this.termsEnum;
        }

        @NotNull
        public final IOBooleanSupplier getSupplier() {
            return this.supplier;
        }
    }
}

