/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.PayloadAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermFrequencyAttribute;
import org.gnit.lucenekmp.codecs.TermVectorsWriter;
import org.gnit.lucenekmp.index.ByteSliceReader;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInvertState;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.index.ParallelPostingsArray;
import org.gnit.lucenekmp.index.TermVectorsConsumer;
import org.gnit.lucenekmp.index.TermsHashPerField;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBlockPool;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001dJ\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u0016\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0016J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0016J\b\u0010-\u001a\u00020\u001dH\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020&H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/index/TermVectorsConsumerPerField;", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "invertState", "Lorg/gnit/lucenekmp/index/FieldInvertState;", "termsHash", "Lorg/gnit/lucenekmp/index/TermVectorsConsumer;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInvertState;Lorg/gnit/lucenekmp/index/TermVectorsConsumer;Lorg/gnit/lucenekmp/index/FieldInfo;)V", "termVectorsPostingsArray", "Lorg/gnit/lucenekmp/index/TermVectorsConsumerPerField$TermVectorsPostingsArray;", "termsWriter", "fieldState", "doVectors", "", "doVectorPositions", "doVectorOffsets", "doVectorPayloads", "offsetAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "payloadAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/PayloadAttribute;", "termFreqAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/TermFrequencyAttribute;", "termBytePool", "Lorg/gnit/lucenekmp/util/BytesRefBlockPool;", "hasPayloads", "finish", "", "finishDocument", "start", "field", "Lorg/gnit/lucenekmp/index/IndexableField;", "first", "writeProx", "postings", "termID", "", "newTerm", "docID", "addTerm", "termFreq", "getTermFreq", "()I", "newPostingsArray", "createPostingsArray", "Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "size", "TermVectorsPostingsArray", "core"})
@SourceDebugExtension(value={"SMAP\nTermVectorsConsumerPerField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermVectorsConsumerPerField.kt\norg/gnit/lucenekmp/index/TermVectorsConsumerPerField\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,308:1\n3#2,8:309\n3#2,8:318\n10#3:317\n10#3:326\n*S KotlinDebug\n*F\n+ 1 TermVectorsConsumerPerField.kt\norg/gnit/lucenekmp/index/TermVectorsConsumerPerField\n*L\n67#1:309,8\n114#1:318,8\n67#1:317\n114#1:326\n*E\n"})
public final class TermVectorsConsumerPerField
extends TermsHashPerField {
    @NotNull
    private final FieldInfo fieldInfo;
    @Nullable
    private TermVectorsPostingsArray termVectorsPostingsArray;
    @NotNull
    private final TermVectorsConsumer termsWriter;
    @NotNull
    private final FieldInvertState fieldState;
    private boolean doVectors;
    private boolean doVectorPositions;
    private boolean doVectorOffsets;
    private boolean doVectorPayloads;
    @Nullable
    private OffsetAttribute offsetAttribute;
    @Nullable
    private PayloadAttribute payloadAttribute;
    @Nullable
    private TermFrequencyAttribute termFreqAtt;
    @NotNull
    private final BytesRefBlockPool termBytePool;
    private boolean hasPayloads;

    public TermVectorsConsumerPerField(@NotNull FieldInvertState invertState, @NotNull TermVectorsConsumer termsHash, @NotNull FieldInfo fieldInfo) {
        Intrinsics.checkNotNullParameter((Object)invertState, (String)"invertState");
        Intrinsics.checkNotNullParameter((Object)termsHash, (String)"termsHash");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        IntBlockPool intBlockPool = termsHash.getIntPool();
        ByteBlockPool byteBlockPool = termsHash.getBytePool();
        ByteBlockPool byteBlockPool2 = termsHash.getTermBytePool();
        Intrinsics.checkNotNull((Object)byteBlockPool2);
        super(2, intBlockPool, byteBlockPool, byteBlockPool2, termsHash.getBytesUsed(), null, fieldInfo.getName(), fieldInfo.getIndexOptions());
        this.fieldInfo = fieldInfo;
        this.termsWriter = termsHash;
        this.fieldState = invertState;
        ByteBlockPool byteBlockPool3 = termsHash.getTermBytePool();
        Intrinsics.checkNotNull((Object)byteBlockPool3);
        this.termBytePool = new BytesRefBlockPool(byteBlockPool3);
    }

    @Override
    public void finish() {
        if (!this.doVectors || this.getNumTerms() == 0) {
            return;
        }
        this.termsWriter.addFieldToFlush(this);
    }

    public final void finishDocument() throws IOException {
        if (!this.doVectors) {
            return;
        }
        this.doVectors = false;
        int numPostings = this.getNumTerms();
        BytesRef flushTerm = this.termsWriter.getFlushTerm();
        boolean condition$iv = numPostings >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        TermVectorsPostingsArray termVectorsPostingsArray = this.termVectorsPostingsArray;
        Intrinsics.checkNotNull((Object)termVectorsPostingsArray);
        TermVectorsPostingsArray postings = termVectorsPostingsArray;
        TermVectorsWriter termVectorsWriter = this.termsWriter.getWriter();
        Intrinsics.checkNotNull((Object)termVectorsWriter);
        TermVectorsWriter tv = termVectorsWriter;
        this.sortTerms();
        int[] termIDs = this.getSortedTermIDs();
        tv.startField(this.fieldInfo, numPostings, this.doVectorPositions, this.doVectorOffsets, this.hasPayloads);
        ByteSliceReader posReader = this.doVectorPositions ? this.termsWriter.getVectorSliceReaderPos() : null;
        ByteSliceReader offReader = this.doVectorOffsets ? this.termsWriter.getVectorSliceReaderOff() : null;
        for (int j = 0; j < numPostings; ++j) {
            int termID = termIDs[j];
            int freq = postings.getFreqs()[termID];
            this.termBytePool.fillBytesRef(flushTerm, postings.getTextStarts()[termID]);
            tv.startTerm(flushTerm, freq);
            if (this.doVectorPositions || this.doVectorOffsets) {
                if (posReader != null) {
                    this.initReader(posReader, termID, 0);
                }
                if (offReader != null) {
                    this.initReader(offReader, termID, 1);
                }
                tv.addProx(freq, posReader, offReader);
            }
            tv.finishTerm();
        }
        tv.finishField();
        this.reset();
        this.fieldInfo.setStoreTermVectors();
    }

    @Override
    public boolean start(@NotNull IndexableField field, boolean first) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        super.start(field, first);
        this.termFreqAtt = this.fieldState.getTermFreqAttribute();
        boolean condition$iv = field.fieldType().indexOptions() != IndexOptions.NONE;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (first) {
            if (this.getNumTerms() != 0) {
                this.reset();
            }
            this.reinitHash();
            this.hasPayloads = false;
            this.doVectors = field.fieldType().storeTermVectors();
            if (this.doVectors) {
                this.doVectorPositions = field.fieldType().storeTermVectorPositions();
                this.doVectorOffsets = field.fieldType().storeTermVectorOffsets();
                if (this.doVectorPositions) {
                    this.doVectorPayloads = field.fieldType().storeTermVectorPayloads();
                } else {
                    this.doVectorPayloads = false;
                    if (!(!field.fieldType().storeTermVectorPayloads())) {
                        boolean $i$a$-require-TermVectorsConsumerPerField$start$92 = false;
                        String $i$a$-require-TermVectorsConsumerPerField$start$92 = "cannot index term vector payloads without term vector positions (field=\"" + field.name() + "\")";
                        throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$92.toString());
                    }
                }
            } else {
                if (!(!field.fieldType().storeTermVectorOffsets())) {
                    boolean $i$a$-require-TermVectorsConsumerPerField$start$102 = false;
                    String $i$a$-require-TermVectorsConsumerPerField$start$102 = "cannot index term vector offsets when term vectors are not indexed (field=\"" + field.name() + "\")";
                    throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$102.toString());
                }
                if (!(!field.fieldType().storeTermVectorPositions())) {
                    boolean $i$a$-require-TermVectorsConsumerPerField$start$112 = false;
                    String $i$a$-require-TermVectorsConsumerPerField$start$112 = "cannot index term vector positions when term vectors are not indexed (field=\"" + field.name() + "\")";
                    throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$112.toString());
                }
                if (!(!field.fieldType().storeTermVectorPayloads())) {
                    boolean $i$a$-require-TermVectorsConsumerPerField$start$122 = false;
                    String $i$a$-require-TermVectorsConsumerPerField$start$122 = "cannot index term vector payloads when term vectors are not indexed (field=\"" + field.name() + "\")";
                    throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$122.toString());
                }
            }
        } else {
            if (!(this.doVectors == field.fieldType().storeTermVectors())) {
                boolean $i$a$-require-TermVectorsConsumerPerField$start$132 = false;
                String $i$a$-require-TermVectorsConsumerPerField$start$132 = "all instances of a given field name must have the same term vectors settings (storeTermVectors changed for field=\"" + field.name() + "\")";
                throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$132.toString());
            }
            if (!(this.doVectorPositions == field.fieldType().storeTermVectorPositions())) {
                boolean $i$a$-require-TermVectorsConsumerPerField$start$142 = false;
                String $i$a$-require-TermVectorsConsumerPerField$start$142 = "all instances of a given field name must have the same term vectors settings (storeTermVectorPositions changed for field=\"" + field.name() + "\")";
                throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$142.toString());
            }
            if (!(this.doVectorOffsets == field.fieldType().storeTermVectorOffsets())) {
                boolean $i$a$-require-TermVectorsConsumerPerField$start$152 = false;
                String $i$a$-require-TermVectorsConsumerPerField$start$152 = "all instances of a given field name must have the same term vectors settings (storeTermVectorOffsets changed for field=\"" + field.name() + "\")";
                throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$start$152.toString());
            }
            if (!(this.doVectorPayloads == field.fieldType().storeTermVectorPayloads())) {
                boolean bl = false;
                String string = "all instances of a given field name must have the same term vectors settings (storeTermVectorPayloads changed for field=\"" + field.name() + "\")";
                throw new IllegalArgumentException(string.toString());
            }
        }
        if (this.doVectors) {
            if (this.doVectorOffsets && (this.offsetAttribute = this.fieldState.getOffsetAttribute()) == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            this.payloadAttribute = this.doVectorPayloads ? this.fieldState.getPayloadAttribute() : null;
        }
        return this.doVectors;
    }

    public final void writeProx(@NotNull TermVectorsPostingsArray postings, int termID) {
        Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
        if (this.doVectorOffsets) {
            int n = this.fieldState.getOffset();
            OffsetAttribute offsetAttribute = this.offsetAttribute;
            Intrinsics.checkNotNull((Object)offsetAttribute);
            int startOffset = n + offsetAttribute.startOffset();
            int n2 = this.fieldState.getOffset();
            OffsetAttribute offsetAttribute2 = this.offsetAttribute;
            Intrinsics.checkNotNull((Object)offsetAttribute2);
            int endOffset = n2 + offsetAttribute2.endOffset();
            this.writeVInt(1, startOffset - postings.getLastOffsets()[termID]);
            this.writeVInt(1, endOffset - startOffset);
            postings.getLastOffsets()[termID] = endOffset;
        }
        if (this.doVectorPositions) {
            BytesRef bytesRef;
            if (this.payloadAttribute == null) {
                bytesRef = null;
            } else {
                PayloadAttribute payloadAttribute = this.payloadAttribute;
                Intrinsics.checkNotNull((Object)payloadAttribute);
                bytesRef = payloadAttribute.getPayload();
            }
            BytesRef payload = bytesRef;
            int pos = this.fieldState.getPosition() - postings.getLastPositions()[termID];
            if (payload != null && payload.getLength() > 0) {
                this.writeVInt(0, pos << 1 | 1);
                this.writeVInt(0, payload.getLength());
                this.writeBytes(0, payload.getBytes(), payload.getOffset(), payload.getLength());
                this.hasPayloads = true;
            } else {
                this.writeVInt(0, pos << 1);
            }
            postings.getLastPositions()[termID] = this.fieldState.getPosition();
        }
    }

    @Override
    public void newTerm(int termID, int docID) {
        TermVectorsPostingsArray termVectorsPostingsArray = this.termVectorsPostingsArray;
        Intrinsics.checkNotNull((Object)termVectorsPostingsArray);
        TermVectorsPostingsArray postings = termVectorsPostingsArray;
        postings.getFreqs()[termID] = this.getTermFreq();
        postings.getLastOffsets()[termID] = 0;
        postings.getLastPositions()[termID] = 0;
        this.writeProx(postings, termID);
    }

    @Override
    public void addTerm(int termID, int docID) {
        TermVectorsPostingsArray termVectorsPostingsArray = this.termVectorsPostingsArray;
        Intrinsics.checkNotNull((Object)termVectorsPostingsArray);
        TermVectorsPostingsArray postings = termVectorsPostingsArray;
        int[] nArray = postings.getFreqs();
        nArray[termID] = nArray[termID] + this.getTermFreq();
        this.writeProx(postings, termID);
    }

    private final int getTermFreq() {
        if (this.termFreqAtt == null) {
            return 1;
        }
        TermFrequencyAttribute termFrequencyAttribute = this.termFreqAtt;
        Intrinsics.checkNotNull((Object)termFrequencyAttribute);
        int freq = termFrequencyAttribute.getTermFrequency();
        if (freq != 1) {
            if (!(!this.doVectorPositions)) {
                boolean $i$a$-require-TermVectorsConsumerPerField$termFreq$32 = false;
                String $i$a$-require-TermVectorsConsumerPerField$termFreq$32 = "field \"" + this.getFieldName() + "\": cannot index term vector positions while using custom TermFrequencyAttribute";
                throw new IllegalArgumentException($i$a$-require-TermVectorsConsumerPerField$termFreq$32.toString());
            }
            if (!(!this.doVectorOffsets)) {
                boolean bl = false;
                String string = "field \"" + this.getFieldName() + "\": cannot index term vector offsets while using custom TermFrequencyAttribute";
                throw new IllegalArgumentException(string.toString());
            }
        }
        return freq;
    }

    @Override
    public void newPostingsArray() {
        ParallelPostingsArray parallelPostingsArray = this.getPostingsArray();
        this.termVectorsPostingsArray = parallelPostingsArray instanceof TermVectorsPostingsArray ? (TermVectorsPostingsArray)parallelPostingsArray : null;
    }

    @Override
    @NotNull
    public ParallelPostingsArray createPostingsArray(int size2) {
        return new TermVectorsPostingsArray(size2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/index/TermVectorsConsumerPerField$TermVectorsPostingsArray;", "Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "size", "", "<init>", "(I)V", "freqs", "", "getFreqs", "()[I", "setFreqs", "([I)V", "lastOffsets", "getLastOffsets", "setLastOffsets", "lastPositions", "getLastPositions", "setLastPositions", "newInstance", "copyTo", "", "toArray", "numToCopy", "bytesPerPosting", "core"})
    @SourceDebugExtension(value={"SMAP\nTermVectorsConsumerPerField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermVectorsConsumerPerField.kt\norg/gnit/lucenekmp/index/TermVectorsConsumerPerField$TermVectorsPostingsArray\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,308:1\n3#2,8:309\n10#3:317\n*S KotlinDebug\n*F\n+ 1 TermVectorsConsumerPerField.kt\norg/gnit/lucenekmp/index/TermVectorsConsumerPerField$TermVectorsPostingsArray\n*L\n293#1:309,8\n293#1:317\n*E\n"})
    public static final class TermVectorsPostingsArray
    extends ParallelPostingsArray {
        @NotNull
        private int[] freqs;
        @NotNull
        private int[] lastOffsets;
        @NotNull
        private int[] lastPositions;

        public TermVectorsPostingsArray(int size2) {
            super(size2);
            this.freqs = new int[size2];
            this.lastOffsets = new int[size2];
            this.lastPositions = new int[size2];
        }

        @NotNull
        public final int[] getFreqs() {
            return this.freqs;
        }

        public final void setFreqs(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.freqs = nArray;
        }

        @NotNull
        public final int[] getLastOffsets() {
            return this.lastOffsets;
        }

        public final void setLastOffsets(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.lastOffsets = nArray;
        }

        @NotNull
        public final int[] getLastPositions() {
            return this.lastPositions;
        }

        public final void setLastPositions(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.lastPositions = nArray;
        }

        @Override
        @NotNull
        public ParallelPostingsArray newInstance(int size2) {
            return new TermVectorsPostingsArray(size2);
        }

        @Override
        public void copyTo(@NotNull ParallelPostingsArray toArray, int numToCopy) {
            Intrinsics.checkNotNullParameter((Object)toArray, (String)"toArray");
            boolean condition$iv = toArray instanceof TermVectorsPostingsArray;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            TermVectorsPostingsArray to = (TermVectorsPostingsArray)toArray;
            super.copyTo(toArray, numToCopy);
            System.INSTANCE.arraycopy(this.freqs, 0, to.freqs, 0, this.getSize());
            System.INSTANCE.arraycopy(this.lastOffsets, 0, to.lastOffsets, 0, this.getSize());
            System.INSTANCE.arraycopy(this.lastPositions, 0, to.lastPositions, 0, this.getSize());
        }

        @Override
        public int bytesPerPosting() {
            return super.bytesPerPosting() + 12;
        }
    }
}

