/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.AutomatonTermsEnum;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0017H&J\b\u0010\u0019\u001a\u00020\u0017H&J\b\u0010\u001a\u001a\u00020\u0017H&J\b\u0010 \u001a\u00020\u0001H\u0016R\u0012\u0010\r\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/index/Terms;", "", "<init>", "()V", "iterator", "Lorg/gnit/lucenekmp/index/TermsEnum;", "intersect", "compiled", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "startTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "size", "", "sumTotalTermFreq", "getSumTotalTermFreq", "()J", "sumDocFreq", "getSumDocFreq", "docCount", "", "getDocCount", "()I", "hasFreqs", "", "hasOffsets", "hasPositions", "hasPayloads", "min", "getMin", "()Lorg/gnit/lucenekmp/util/BytesRef;", "max", "getMax", "getStats", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTerms.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Terms.kt\norg/gnit/lucenekmp/index/Terms\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
public abstract class Terms {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Terms[] EMPTY_ARRAY = new Terms[0];
    @NotNull
    private static final Terms EMPTY = new Terms(){
        private final long sumTotalTermFreq;
        private final long sumDocFreq;
        private final int docCount;

        public TermsEnum iterator() throws IOException {
            return TermsEnum.Companion.getEMPTY();
        }

        public long size() throws IOException {
            return 0L;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() {
            return this.sumDocFreq;
        }

        public int getDocCount() {
            return this.docCount;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    };

    protected Terms() {
    }

    @NotNull
    public abstract TermsEnum iterator() throws IOException;

    @NotNull
    public TermsEnum intersect(@NotNull CompiledAutomaton compiled, @Nullable BytesRef startTerm) throws IOException {
        Intrinsics.checkNotNullParameter((Object)compiled, (String)"compiled");
        TermsEnum termsEnum = this.iterator();
        if (!(compiled.getType() == CompiledAutomaton.AUTOMATON_TYPE.NORMAL)) {
            boolean bl = false;
            String string = "please use CompiledAutomaton.getTermsEnum instead";
            throw new IllegalArgumentException(string.toString());
        }
        if (startTerm == null) {
            return new AutomatonTermsEnum(termsEnum, compiled);
        }
        return new AutomatonTermsEnum(termsEnum, compiled, startTerm){
            final /* synthetic */ BytesRef $startTerm;
            {
                this.$startTerm = $startTerm;
                super($termsEnum, $compiled);
            }

            protected BytesRef nextSeekTerm(BytesRef term) throws IOException {
                BytesRef term2 = term;
                if (term2 == null) {
                    term2 = this.$startTerm;
                }
                BytesRef bytesRef = super.nextSeekTerm(term2);
                Intrinsics.checkNotNull((Object)bytesRef);
                return bytesRef;
            }
        };
    }

    public abstract long size() throws IOException;

    public abstract long getSumTotalTermFreq();

    public abstract long getSumDocFreq();

    public abstract int getDocCount();

    public abstract boolean hasFreqs();

    public abstract boolean hasOffsets();

    public abstract boolean hasPositions();

    public abstract boolean hasPayloads();

    @Nullable
    public BytesRef getMin() {
        BytesRef bytesRef = this.iterator().next();
        Intrinsics.checkNotNull((Object)bytesRef);
        return bytesRef;
    }

    @Nullable
    public BytesRef getMax() {
        TermsEnum iterator2;
        BytesRef v;
        long size2 = this.size();
        if (size2 == 0L) {
            return null;
        }
        if (size2 >= 0L) {
            try {
                TermsEnum iterator3 = this.iterator();
                iterator3.seekExact(size2 - 1L);
                return iterator3.term();
            }
            catch (UnsupportedOperationException iterator3) {
                // empty catch block
            }
        }
        if ((v = (iterator2 = this.iterator()).next()) == null) {
            return v;
        }
        BytesRefBuilder scratch = new BytesRefBuilder();
        scratch.append((byte)0);
        while (true) {
            int low = 0;
            int high = 256;
            while (low != high) {
                int mid = low + high >>> 1;
                scratch.setByteAt(scratch.length() - 1, (byte)mid);
                if (iterator2.seekCeil(scratch.get()) == TermsEnum.SeekStatus.END) {
                    if (mid == 0) {
                        scratch.setLength(scratch.length() - 1);
                        return scratch.get();
                    }
                    high = mid;
                    continue;
                }
                if (low == mid) break;
                low = mid;
            }
            scratch.setLength(scratch.length() + 1);
            scratch.grow(scratch.length());
        }
    }

    @NotNull
    public Object getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("impl=").append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        sb.append(",size=").append(this.size());
        sb.append(",docCount=").append(this.getDocCount());
        sb.append(",sumTotalTermFreq=").append(this.getSumTotalTermFreq());
        sb.append(",sumDocFreq=").append(this.getSumDocFreq());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/Terms$Companion;", "", "<init>", "()V", "getTerms", "Lorg/gnit/lucenekmp/index/Terms;", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "field", "", "EMPTY_ARRAY", "", "getEMPTY_ARRAY", "()[Lorg/gnit/lucenekmp/index/Terms;", "[Lorg/gnit/lucenekmp/index/Terms;", "EMPTY", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Terms getTerms(@NotNull LeafReader reader2, @NotNull String field) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Terms terms = reader2.terms(field);
            if (terms == null) {
                return EMPTY;
            }
            return terms;
        }

        @NotNull
        public final Terms[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

