/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.VectorUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH&j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "", "<init>", "(Ljava/lang/String;I)V", "EUCLIDEAN", "DOT_PRODUCT", "COSINE", "MAXIMUM_INNER_PRODUCT", "compare", "", "v1", "", "v2", "", "core"})
public abstract class VectorSimilarityFunction
extends Enum<VectorSimilarityFunction> {
    public static final /* enum */ VectorSimilarityFunction EUCLIDEAN = new EUCLIDEAN("EUCLIDEAN", 0);
    public static final /* enum */ VectorSimilarityFunction DOT_PRODUCT = new DOT_PRODUCT("DOT_PRODUCT", 1);
    public static final /* enum */ VectorSimilarityFunction COSINE = new COSINE("COSINE", 2);
    public static final /* enum */ VectorSimilarityFunction MAXIMUM_INNER_PRODUCT = new MAXIMUM_INNER_PRODUCT("MAXIMUM_INNER_PRODUCT", 3);
    private static final /* synthetic */ VectorSimilarityFunction[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private VectorSimilarityFunction() {
    }

    public abstract float compare(@NotNull float[] var1, @NotNull float[] var2);

    public abstract float compare(@NotNull byte[] var1, @NotNull byte[] var2);

    public static VectorSimilarityFunction[] values() {
        return (VectorSimilarityFunction[])$VALUES.clone();
    }

    public static VectorSimilarityFunction valueOf(String value) {
        return Enum.valueOf(VectorSimilarityFunction.class, value);
    }

    @NotNull
    public static EnumEntries<VectorSimilarityFunction> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ VectorSimilarityFunction(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        $VALUES = vectorSimilarityFunctionArray = new VectorSimilarityFunction[]{VectorSimilarityFunction.EUCLIDEAN, VectorSimilarityFunction.DOT_PRODUCT, VectorSimilarityFunction.COSINE, VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/gnit/lucenekmp/index/VectorSimilarityFunction.COSINE", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "compare", "", "v1", "", "v2", "", "core"})
    static final class COSINE
    extends VectorSimilarityFunction {
        /*
         * WARNING - void declaration
         */
        COSINE() {
            void var1_1;
        }

        @Override
        public float compare(@NotNull float[] v1, @NotNull float[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return Math.max((1.0f + VectorUtil.INSTANCE.cosine(v1, v2)) / (float)2, 0.0f);
        }

        @Override
        public float compare(@NotNull byte[] v1, @NotNull byte[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return (1.0f + VectorUtil.INSTANCE.cosine(v1, v2)) / (float)2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/gnit/lucenekmp/index/VectorSimilarityFunction.DOT_PRODUCT", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "compare", "", "v1", "", "v2", "", "core"})
    static final class DOT_PRODUCT
    extends VectorSimilarityFunction {
        /*
         * WARNING - void declaration
         */
        DOT_PRODUCT() {
            void var1_1;
        }

        @Override
        public float compare(@NotNull float[] v1, @NotNull float[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return Math.max((1.0f + VectorUtil.INSTANCE.dotProduct(v1, v2)) / (float)2, 0.0f);
        }

        @Override
        public float compare(@NotNull byte[] v1, @NotNull byte[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return VectorUtil.INSTANCE.dotProductScore(v1, v2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/gnit/lucenekmp/index/VectorSimilarityFunction.EUCLIDEAN", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "compare", "", "v1", "", "v2", "", "core"})
    static final class EUCLIDEAN
    extends VectorSimilarityFunction {
        /*
         * WARNING - void declaration
         */
        EUCLIDEAN() {
            void var1_1;
        }

        @Override
        public float compare(@NotNull float[] v1, @NotNull float[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return 1.0f / (1.0f + VectorUtil.INSTANCE.squareDistance(v1, v2));
        }

        @Override
        public float compare(@NotNull byte[] v1, @NotNull byte[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return 1.0f / (1.0f + (float)VectorUtil.INSTANCE.squareDistance(v1, v2));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"org/gnit/lucenekmp/index/VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "compare", "", "v1", "", "v2", "", "core"})
    static final class MAXIMUM_INNER_PRODUCT
    extends VectorSimilarityFunction {
        /*
         * WARNING - void declaration
         */
        MAXIMUM_INNER_PRODUCT() {
            void var1_1;
        }

        @Override
        public float compare(@NotNull float[] v1, @NotNull float[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return VectorUtil.INSTANCE.scaleMaxInnerProductScore(VectorUtil.INSTANCE.dotProduct(v1, v2));
        }

        @Override
        public float compare(@NotNull byte[] v1, @NotNull byte[] v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return VectorUtil.INSTANCE.scaleMaxInnerProductScore(VectorUtil.INSTANCE.dotProduct(v1, v2));
        }
    }
}

