/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.KnnFieldVectorsWriter;
import org.gnit.lucenekmp.codecs.KnnVectorsFormat;
import org.gnit.lucenekmp.codecs.KnnVectorsWriter;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/index/VectorValuesConsumer;", "", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "<init>", "(Lorg/gnit/lucenekmp/codecs/Codec;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Lorg/gnit/lucenekmp/util/InfoStream;)V", "accountable", "Lorg/gnit/lucenekmp/util/Accountable;", "writer", "Lorg/gnit/lucenekmp/codecs/KnnVectorsWriter;", "initKnnVectorsWriter", "", "fieldName", "", "addField", "Lorg/gnit/lucenekmp/codecs/KnnFieldVectorsWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "flush", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "abort", "getAccountable", "core"})
public final class VectorValuesConsumer {
    @NotNull
    private final Codec codec;
    @NotNull
    private final Directory directory;
    @NotNull
    private final SegmentInfo segmentInfo;
    @NotNull
    private final InfoStream infoStream;
    @NotNull
    private Accountable accountable;
    @Nullable
    private KnnVectorsWriter writer;

    public VectorValuesConsumer(@NotNull Codec codec, @NotNull Directory directory, @NotNull SegmentInfo segmentInfo, @NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this.codec = codec;
        this.directory = directory;
        this.segmentInfo = segmentInfo;
        this.infoStream = infoStream;
        this.accountable = Accountable.Companion.getNULL_ACCOUNTABLE();
    }

    private final void initKnnVectorsWriter(String fieldName) throws IOException {
        if (this.writer == null) {
            KnnVectorsFormat fmt = this.codec.knnVectorsFormat();
            if (fmt == null) {
                boolean $i$a$-checkNotNull-VectorValuesConsumer$initKnnVectorsWriter$22 = false;
                String $i$a$-checkNotNull-VectorValuesConsumer$initKnnVectorsWriter$22 = "field=\"" + fieldName + "\" was indexed as vectors but codec does not support vectors";
                throw new IllegalStateException($i$a$-checkNotNull-VectorValuesConsumer$initKnnVectorsWriter$22.toString());
            }
            SegmentWriteState initialWriteState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, null, null, IOContext.Companion.getDEFAULT());
            KnnVectorsWriter knnVectorsWriter = this.writer = fmt.fieldsWriter(initialWriteState);
            Intrinsics.checkNotNull((Object)knnVectorsWriter);
            this.accountable = knnVectorsWriter;
        }
    }

    @NotNull
    public final KnnFieldVectorsWriter<?> addField(@NotNull FieldInfo fieldInfo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.initKnnVectorsWriter(fieldInfo.getName());
        KnnVectorsWriter knnVectorsWriter = this.writer;
        Intrinsics.checkNotNull((Object)knnVectorsWriter);
        return knnVectorsWriter.addField(fieldInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(@NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap) throws IOException {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (this.writer == null) {
            return;
        }
        try {
            KnnVectorsWriter knnVectorsWriter = this.writer;
            Intrinsics.checkNotNull((Object)knnVectorsWriter);
            knnVectorsWriter.flush(state2.getSegmentInfo().maxDoc(), sortMap);
            KnnVectorsWriter knnVectorsWriter2 = this.writer;
            Intrinsics.checkNotNull((Object)knnVectorsWriter2);
            knnVectorsWriter2.finish();
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
            IOUtils.INSTANCE.closeNullable(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
    }

    public final void abort() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writer};
        IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
    }

    @NotNull
    public final Accountable getAccountable() {
        return this.accountable;
    }
}

