/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0003\b\u0016\u0018\u0000 M2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0002LMB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0019\u001a\u00020\r\"\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0000J\u0016\u0010\u001c\u001a\u00020\u00062\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u0016\u0010!\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0006J\u0016\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010-\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010.\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u00101\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u0006H\u0004J\u000e\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u0006J\u0006\u00106\u001a\u00020\u0006J\u0006\u00107\u001a\u00020\u0017J\u0006\u00108\u001a\u00020\u0017J\u0006\u00109\u001a\u00020\u0017J\u0006\u0010:\u001a\u00020\rJ\b\u0010;\u001a\u00020\u0000H\u0016J\b\u0010<\u001a\u00020\u0006H\u0016J\u0013\u0010=\u001a\u00020(2\b\u0010>\u001a\u0004\u0018\u00010?H\u0096\u0002J\u000e\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020\u0000J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020EH\u0016J\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00060GJ\u0006\u0010H\u001a\u00020\u0000J\u0006\u0010I\u001a\u00020\u0000J\u000f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00020KH\u0096\u0002R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\bR\u0011\u0010/\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006N"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "Lorg/gnit/lucenekmp/util/Accountable;", "expectedElements", "", "<init>", "(I)V", "()V", "list", "(Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;)V", "buffer", "", "getBuffer", "()[I", "setBuffer", "([I)V", "elementsCount", "getElementsCount", "()I", "setElementsCount", "add", "", "e1", "elements", "start", "length", "addAll", "iterable", "insert", "index", "get", "set", "removeAt", "removeLast", "removeRange", "fromIndex", "toIndex", "removeElement", "", "e", "removeFirst", "removeAll", "contains", "indexOf", "lastIndexOf", "isEmpty", "()Z", "ensureCapacity", "ensureBufferSpace", "expectedAdditions", "resize", "newSize", "size", "trimToSize", "clear", "release", "toArray", "clone", "hashCode", "equals", "obj", "", "equalElements", "other", "toString", "", "ramBytesUsed", "", "stream", "Lkotlin/sequences/Sequence;", "sort", "reverse", "iterator", "", "ValueIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIntArrayList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntArrayList.kt\norg/gnit/lucenekmp/internal/hppc/IntArrayList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,451:1\n1#2:452\n*E\n"})
public class IntArrayList
implements Iterable<IntCursor>,
Cloneable<IntArrayList>,
Accountable,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private int[] buffer;
    private int elementsCount;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(IntArrayList.class));
    @NotNull
    private static final int[] EMPTY_ARRAY = new int[0];

    public IntArrayList(int expectedElements) {
        this.buffer = new int[expectedElements];
    }

    @NotNull
    public final int[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.buffer = nArray;
    }

    public final int getElementsCount() {
        return this.elementsCount;
    }

    public final void setElementsCount(int n) {
        this.elementsCount = n;
    }

    public IntArrayList() {
        this(4);
    }

    public IntArrayList(@NotNull IntArrayList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this(list.size());
        this.addAll(list);
    }

    public final void add(int e1) {
        this.ensureBufferSpace(1);
        int n = this.elementsCount;
        this.elementsCount = n + 1;
        this.buffer[n] = e1;
    }

    public final void add(@NotNull int[] elements, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!(length >= 0)) {
            boolean bl = false;
            String string = "Length must be >= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureBufferSpace(length);
        ArraysKt.copyInto((int[])elements, (int[])this.buffer, (int)this.elementsCount, (int)start, (int)(start + length));
        this.elementsCount += length;
    }

    public final void add(int ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.add(elements, 0, elements.length);
    }

    public final int addAll(@NotNull IntArrayList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        int size2 = list.size();
        this.ensureBufferSpace(size2);
        Iterator<IntCursor> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            IntCursor cursor;
            IntCursor intCursor = cursor = iterator2.next();
            Intrinsics.checkNotNull((Object)intCursor);
            this.add(intCursor.getValue());
        }
        return size2;
    }

    public final int addAll(@NotNull Iterable<IntCursor> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int size2 = 0;
        for (IntCursor cursor : iterable) {
            this.add(cursor.getValue());
            ++size2;
        }
        return size2;
    }

    public final void insert(int index, int e1) {
        if (!(index >= 0 && index <= this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + "].";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureBufferSpace(1);
        ArraysKt.copyInto((int[])this.buffer, (int[])this.buffer, (int)(index + 1), (int)index, (int)this.elementsCount);
        this.buffer[index] = e1;
        int n = this.elementsCount;
        this.elementsCount = n + 1;
    }

    public final int get(int index) {
        if (!(index >= 0 && index < this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        return this.buffer[index];
    }

    public final int set(int index, int e1) {
        if (!(index >= 0 && index < this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        int v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public final int removeAt(int index) {
        if (!(index >= 0 && index < this.size())) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        int v = this.buffer[index];
        ArraysKt.copyInto((int[])this.buffer, (int[])this.buffer, (int)index, (int)(index + 1), (int)this.elementsCount);
        int n = this.elementsCount;
        this.elementsCount = n + -1;
        return v;
    }

    public final int removeLast() {
        if (!(!this.isEmpty())) {
            boolean bl = false;
            String string = "List is empty";
            throw new IllegalArgumentException(string.toString());
        }
        this.elementsCount += -1;
        return this.buffer[this.elementsCount];
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (!(fromIndex >= 0 && fromIndex <= this.size())) {
            boolean $i$a$-require-IntArrayList$removeRange$42 = false;
            String $i$a$-require-IntArrayList$removeRange$42 = "Index " + fromIndex + " out of bounds [0, " + this.size() + ").";
            throw new IllegalArgumentException($i$a$-require-IntArrayList$removeRange$42.toString());
        }
        if (!(toIndex >= 0 && toIndex <= this.size())) {
            boolean $i$a$-require-IntArrayList$removeRange$52 = false;
            String $i$a$-require-IntArrayList$removeRange$52 = "Index " + toIndex + " out of bounds [0, " + this.size() + "].";
            throw new IllegalArgumentException($i$a$-require-IntArrayList$removeRange$52.toString());
        }
        if (!(fromIndex <= toIndex)) {
            boolean bl = false;
            String string = "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
            throw new IllegalArgumentException(string.toString());
        }
        ArraysKt.copyInto((int[])this.buffer, (int[])this.buffer, (int)fromIndex, (int)toIndex, (int)this.elementsCount);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    public final boolean removeElement(int e) {
        return this.removeFirst(e) != -1;
    }

    public final int removeFirst(int e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public final int removeLast(int e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public final int removeAll(int e) {
        int to = 0;
        int n = this.elementsCount;
        for (int from = 0; from < n; ++from) {
            if (e == this.buffer[from]) continue;
            if (to != from) {
                this.buffer[to] = this.buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    public final boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    public final int indexOf(int e1) {
        int n = this.elementsCount;
        for (int i = 0; i < n; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int e1) {
        for (int i = this.elementsCount - 1; -1 < i; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.buffer.length) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.Companion.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public final void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                ArraysKt.fill((int[])this.buffer, (int)0, (int)newSize, (int)this.elementsCount);
            } else {
                ArraysKt.fill((int[])this.buffer, (int)0, (int)this.elementsCount, (int)newSize);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public final int size() {
        return this.elementsCount;
    }

    public final void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public final void clear() {
        ArraysKt.fill((int[])this.buffer, (int)0, (int)0, (int)this.elementsCount);
        this.elementsCount = 0;
    }

    public final void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @NotNull
    public final int[] toArray() {
        return ArrayUtil.Companion.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    @Override
    @NotNull
    public IntArrayList clone() {
        IntArrayList newInstance = new IntArrayList(this.size());
        newInstance.addAll(this);
        return newInstance;
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + BitMixer.INSTANCE.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntArrayList)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)obj));
    }

    public final boolean equalElements(@NotNull IntArrayList other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.toArray());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.buffer);
    }

    @NotNull
    public final Sequence<Integer> stream() {
        return SequencesKt.take((Sequence)ArraysKt.asSequence((int[])this.buffer), (int)this.elementsCount);
    }

    @NotNull
    public final IntArrayList sort() {
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.sort(this.buffer, 0, this.elementsCount);
        return this;
    }

    @NotNull
    public final IntArrayList reverse() {
        int i = 0;
        int mid = this.elementsCount >> 1;
        int j = this.elementsCount - 1;
        while (i < mid) {
            int tmp = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = tmp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    @NotNull
    public Iterator<IntCursor> iterator() {
        return TypeIntrinsics.asMutableIterator((Object)new ValueIterator(this.buffer, this.size()));
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00020\u0007\"\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntArrayList$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "EMPTY_ARRAY", "", "getEMPTY_ARRAY", "()[I", "from", "Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "elements", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getEMPTY_ARRAY() {
            return EMPTY_ARRAY;
        }

        @NotNull
        public final IntArrayList from(int ... elements) {
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            IntArrayList list = new IntArrayList(elements.length);
            list.add(Arrays.copyOf(elements, elements.length));
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/IntArrayList$ValueIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "buffer", "", "size", "", "<init>", "([II)V", "cursor", "fetch", "core"})
    public static final class ValueIterator
    extends AbstractIterator<IntCursor> {
        @NotNull
        private final IntCursor cursor;
        @NotNull
        private final int[] buffer;
        private final int size;

        public ValueIterator(@NotNull int[] buffer, int size2) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.cursor = new IntCursor();
            this.cursor.setIndex(-1);
            this.size = size2;
            this.buffer = buffer;
        }

        @Override
        @Nullable
        protected IntCursor fetch() {
            if (this.cursor.getIndex() + 1 == this.size) {
                return (IntCursor)this.done();
            }
            IntCursor intCursor = this.cursor;
            intCursor.setIndex(intCursor.getIndex() + 1);
            this.cursor.setValue(this.buffer[intCursor.getIndex()]);
            return this.cursor;
        }
    }
}

