/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.internal.hppc.HashContainers;
import org.gnit.lucenekmp.internal.hppc.LongCursor;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0018\b\u0016\u0018\u0000 Z2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0002YZB\u001b\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\rJ\u000e\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.J\u0012\u0010/\u001a\u00020\u00062\n\u00100\u001a\u00020\u000f\"\u00020.J\u000e\u0010/\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000J\u0014\u0010/\u001a\u00020\u00062\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0006\u00102\u001a\u00020\u000fJ\u000e\u00103\u001a\u00020 2\u0006\u0010-\u001a\u00020.J\u000e\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0000J\u000e\u00106\u001a\u00020 2\u0006\u0010-\u001a\u00020.J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u000208J\u000e\u0010;\u001a\u0002082\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010<\u001a\u00020\u0006J\b\u0010=\u001a\u00020\u0006H\u0016J\u0013\u0010>\u001a\u00020 2\b\u00105\u001a\u0004\u0018\u00010?H\u0096\u0002J\u0010\u0010@\u001a\u00020 2\u0006\u00105\u001a\u00020\u0000H\u0002J\b\u0010A\u001a\u00020\u0000H\u0016J\u000f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020CH\u0096\u0002J\b\u0010D\u001a\u00020.H\u0016J\b\u0010E\u001a\u00020\u0006H\u0004J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0004J\u000e\u0010G\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.J\u000e\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020\u0006J\u000e\u0010J\u001a\u00020.2\u0006\u0010I\u001a\u00020\u0006J\u0016\u0010K\u001a\u00020.2\u0006\u0010I\u001a\u00020\u00062\u0006\u0010L\u001a\u00020.J\u0016\u0010M\u001a\u0002082\u0006\u0010I\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.J\u000e\u0010N\u001a\u0002082\u0006\u0010I\u001a\u00020\u0006J\u0010\u0010O\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010P\u001a\u0002082\u0006\u0010Q\u001a\u00020\u000fH\u0004J\u0010\u0010R\u001a\u0002082\u0006\u0010S\u001a\u00020\u0006H\u0014J\u0018\u0010T\u001a\u0002082\u0006\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020.H\u0004J\u0010\u0010W\u001a\u0002082\u0006\u0010X\u001a\u00020\u0006H\u0004R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020 X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0016\"\u0004\b+\u0010\u0018R\u0011\u0010:\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\"\u00a8\u0006["}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongHashSet;", "", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "expectedElements", "", "loadFactor", "", "<init>", "(ID)V", "()V", "set", "(Lorg/gnit/lucenekmp/internal/hppc/LongHashSet;)V", "keys", "", "getKeys", "()[J", "setKeys", "([J)V", "assigned", "getAssigned", "()I", "setAssigned", "(I)V", "mask", "getMask", "setMask", "resizeAt", "getResizeAt", "setResizeAt", "hasEmptyKey", "", "getHasEmptyKey", "()Z", "setHasEmptyKey", "(Z)V", "getLoadFactor", "()D", "setLoadFactor", "(D)V", "iterationSeed", "getIterationSeed", "setIterationSeed", "add", "key", "", "addAll", "elements", "iterable", "toArray", "remove", "removeAll", "other", "contains", "clear", "", "release", "isEmpty", "ensureCapacity", "size", "hashCode", "equals", "", "sameKeys", "clone", "iterator", "", "ramBytesUsed", "nextIterationSeed", "hashKey", "indexOf", "indexExists", "index", "indexGet", "indexReplace", "equivalentKey", "indexInsert", "indexRemove", "verifyLoadFactor", "rehash", "fromKeys", "allocateBuffers", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "shiftConflictingKeys", "gapSlot", "EntryIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongHashSet.kt\norg/gnit/lucenekmp/internal/hppc/LongHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,687:1\n1#2:688\n*E\n"})
public class LongHashSet
implements Iterable<LongCursor>,
Accountable,
Cloneable<LongHashSet>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private long[] keys;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;
    private int iterationSeed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(LongHashSet.class));

    @JvmOverloads
    public LongHashSet(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = AtomicsKt.incrementAndFetch((AtomicInteger)HashContainers.INSTANCE.getITERATION_SEED());
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ LongHashSet(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        this(n, d);
    }

    @Nullable
    public final long[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable long[] lArray) {
        this.keys = lArray;
    }

    protected final int getAssigned() {
        return this.assigned;
    }

    protected final void setAssigned(int n) {
        this.assigned = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final int getResizeAt() {
        return this.resizeAt;
    }

    protected final void setResizeAt(int n) {
        this.resizeAt = n;
    }

    protected final boolean getHasEmptyKey() {
        return this.hasEmptyKey;
    }

    protected final void setHasEmptyKey(boolean bl) {
        this.hasEmptyKey = bl;
    }

    protected final double getLoadFactor() {
        return this.loadFactor;
    }

    protected final void setLoadFactor(double d) {
        this.loadFactor = d;
    }

    protected final int getIterationSeed() {
        return this.iterationSeed;
    }

    protected final void setIterationSeed(int n) {
        this.iterationSeed = n;
    }

    public LongHashSet() {
        this(4, 0.0, 2, null);
    }

    public LongHashSet(@NotNull LongHashSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this(set.size(), 0.0, 2, null);
        this.addAll(set);
    }

    public final boolean add(long key) {
        if (key == 0L) {
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[this.mask + 1] == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return true;
    }

    public final int addAll(long ... elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        this.ensureCapacity(elements.length);
        int count = 0;
        for (long e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(@NotNull LongHashSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        this.ensureCapacity(set.size());
        return this.addAll((Iterable<LongCursor>)set);
    }

    public final int addAll(@NotNull Iterable<LongCursor> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int count = 0;
        for (LongCursor cursor : iterable) {
            if (!this.add(cursor.getValue())) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public final long[] toArray() {
        long[] cloned = new long[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            int n = j;
            j = n + 1;
            cloned[n] = 0L;
        }
        long[] keys = this.keys;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.INSTANCE.iterationIncrement(seed);
        LongHashSet $this$toArray_u24lambda_u242 = this;
        boolean bl = false;
        int mask = $this$toArray_u24lambda_u242.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            long l;
            long existing = 0L;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl2 = false;
            existing = it;
            if (l != 0L) {
                int n = j;
                j = n + 1;
                cloned[n] = existing;
            }
            slot = slot + inc & mask;
        }
        return cloned;
    }

    public final boolean remove(long key) {
        if (key == 0L) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final int removeAll(@NotNull LongHashSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int before = this.size();
        if (other.size() >= this.size()) {
            if (this.hasEmptyKey && other.contains(0L)) {
                this.hasEmptyKey = false;
            }
            long[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                long l;
                long existing = 0L;
                Intrinsics.checkNotNull((Object)keys);
                long it = l = keys[slot];
                boolean bl = false;
                existing = it;
                if (l != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.getValue());
            }
        }
        return before - this.size();
    }

    public final boolean contains(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Intrinsics.checkNotNull((Object)this.keys);
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.keys, 0L);
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        long[] keys = this.keys;
        for (int slot = this.mask; -1 < slot; --slot) {
            long l;
            long existing = 0L;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) continue;
            h += BitMixer.INSTANCE.mix(existing);
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.sameKeys((LongHashSet)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean sameKeys(LongHashSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongCursor c : other) {
            if (this.contains(c.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public LongHashSet clone() {
        return new LongHashSet(this);
    }

    @Override
    @NotNull
    public Iterator<LongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        Intrinsics.checkNotNull((Object)this.keys);
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.keys);
    }

    protected final int nextIterationSeed() {
        int n;
        int it = n = BitMixer.INSTANCE.mixPhi(this.iterationSeed);
        boolean bl = false;
        this.iterationSeed = it;
        return n;
    }

    protected final int hashKey(long key) {
        if (!(key != 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return BitMixer.INSTANCE.mixPhi(key);
    }

    public final int indexOf(long key) {
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public final boolean indexExists(int index) {
        if (!(index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return index >= 0;
    }

    public final long indexGet(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.keys);
        return this.keys[index];
    }

    public final long indexReplace(int index, long equivalentKey) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.keys);
        if (!(this.keys[index] == equivalentKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.keys);
        long previousValue = this.keys[index];
        Intrinsics.checkNotNull((Object)this.keys);
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public final void indexInsert(int index, long key) {
        int index2 = index;
        if (!(index2 < 0)) {
            boolean bl = false;
            String string = "The index must not point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        index2 ^= 0xFFFFFFFF;
        if (key == 0L) {
            if (!(index2 == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[index2] == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.hasEmptyKey = true;
        } else {
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[index2] == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key);
            } else {
                Intrinsics.checkNotNull((Object)this.keys);
                this.keys[index2] = key;
            }
            int n = this.assigned;
            this.assigned = n + 1;
        }
    }

    public final void indexRemove(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (index > this.mask) {
            this.hasEmptyKey = false;
        } else {
            this.shiftConflictingKeys(index);
        }
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.INSTANCE.checkLoadFactor(loadFactor, HashContainers.INSTANCE.getMIN_LOAD_FACTOR(), HashContainers.INSTANCE.getMAX_LOAD_FACTOR());
        return loadFactor;
    }

    protected final void rehash(@NotNull long[] fromKeys) {
        Intrinsics.checkNotNullParameter((Object)fromKeys, (String)"fromKeys");
        if (!HashContainers.INSTANCE.checkPowerOfTwo(fromKeys.length - 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] keys = this.keys;
        int mask = this.mask;
        long existing = 0L;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            long l;
            long it = l = fromKeys[i];
            boolean bl = false;
            existing = it;
            if (l == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (true) {
                Intrinsics.checkNotNull((Object)keys);
                if (keys[slot] == 0L) break;
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        if (!(IntExtKt.bitCount(IntCompanionObject.INSTANCE, arraySize) == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
        }
        catch (Error e) {
            this.keys = prevKeys;
            Object[] objectArray = new Object[]{this.keys == null ? 0 : this.size(), arraySize};
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, objectArray);
        }
        this.resizeAt = HashContainers.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final void allocateThenInsertThenRehash(int slot, long pendingKey) {
        if (this.assigned != this.resizeAt) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.keys);
        if (this.keys[slot] == 0L && pendingKey != 0L) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) {
            var5_3 = "Failed requirement.";
            throw new IllegalArgumentException(var5_3.toString());
        }
        prevKeys = this.keys;
        this.allocateBuffers(HashContainers.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        Intrinsics.checkNotNull((Object)this.keys);
        v1 = this.keys.length;
        Intrinsics.checkNotNull((Object)prevKeys);
        if (!(v1 > prevKeys.length)) {
            var6_5 = "Failed requirement.";
            throw new IllegalArgumentException(var6_5.toString());
        }
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected final void shiftConflictingKeys(int gapSlot) {
        int gapSlot2 = gapSlot;
        long[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while (true) {
            int slot = gapSlot2 + ++distance & mask;
            Intrinsics.checkNotNull((Object)keys);
            long existing = keys[slot];
            if (existing == 0L) break;
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot2] = existing;
            gapSlot2 = slot;
            distance = 0;
        }
        keys[gapSlot2] = 0L;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public LongHashSet(int expectedElements) {
        this(expectedElements, 0.0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00020\t\"\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongHashSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "from", "Lorg/gnit/lucenekmp/internal/hppc/LongHashSet;", "elements", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongHashSet from(long ... elements) {
            Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
            LongHashSet set = new LongHashSet(elements.length, 0.0, 2, null);
            set.addAll(Arrays.copyOf(elements, elements.length));
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongHashSet$EntryIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongHashSet;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nLongHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongHashSet.kt\norg/gnit/lucenekmp/internal/hppc/LongHashSet$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,687:1\n1#2:688\n*E\n"})
    protected final class EntryIterator
    extends AbstractIterator<LongCursor> {
        @NotNull
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongHashSet.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongHashSet.this.getMask();
        }

        @Override
        @Nullable
        protected LongCursor fetch() {
            int mask = LongHashSet.this.getMask();
            while (this.index <= mask) {
                long l;
                long existing = 0L;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongHashSet.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                long it = l = lArray[this.slot];
                boolean bl = false;
                existing = it;
                if (l == 0L) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setValue(existing);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongHashSet.this.getHasEmptyKey()) {
                int n = this.index;
                this.index = n + 1;
                this.cursor.setIndex(n);
                this.cursor.setValue(0L);
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

