/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.internal.hppc;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.internal.hppc.AbstractIterator;
import org.gnit.lucenekmp.internal.hppc.BitMixer;
import org.gnit.lucenekmp.internal.hppc.BufferAllocationException;
import org.gnit.lucenekmp.internal.hppc.HashContainers;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.internal.hppc.LongCursor;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0016\u0018\u0000 q2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0007klmnopqB\u001b\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\rJ\u0016\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0006J\u0014\u00106\u001a\u00020\u00062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0016\u00108\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0006J\u001e\u00109\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u0006J\u0016\u0010<\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u0010;\u001a\u00020\u0006J\u000e\u0010=\u001a\u00020\u00062\u0006\u00103\u001a\u000204J\u000e\u0010>\u001a\u00020\u00062\u0006\u00103\u001a\u000204J\u0016\u0010?\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u0010@\u001a\u00020\u0006J\u000e\u0010A\u001a\u00020&2\u0006\u00103\u001a\u000204J\u000e\u0010B\u001a\u00020\u00062\u0006\u00103\u001a\u000204J\u000e\u0010C\u001a\u00020&2\u0006\u0010D\u001a\u00020\u0006J\u000e\u0010E\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006J\u0016\u0010F\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u00062\u0006\u0010G\u001a\u00020\u0006J\u001e\u0010H\u001a\u00020I2\u0006\u0010D\u001a\u00020\u00062\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0006J\u000e\u0010J\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006J\u0006\u0010K\u001a\u00020IJ\u0006\u0010L\u001a\u00020IJ\u0006\u0010M\u001a\u00020\u0006J\b\u0010O\u001a\u00020\u0006H\u0016J\u0013\u0010P\u001a\u00020&2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0096\u0002J\u0010\u0010S\u001a\u00020&2\u0006\u0010Q\u001a\u00020\u0000H\u0004J\u000e\u0010T\u001a\u00020I2\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010U\u001a\u00020\u0006H\u0004J\b\u0010V\u001a\u000204H\u0016J\u000f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00020XH\u0096\u0002J\n\u0010\u000e\u001a\u00060YR\u00020\u0000J\n\u0010\u0014\u001a\u00060ZR\u00020\u0000J\b\u0010[\u001a\u00020\u0000H\u0016J\b\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020\u00062\u0006\u00103\u001a\u000204H\u0004J\u0010\u0010_\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010`\u001a\u00020I2\u0006\u0010a\u001a\u00020\u000f2\u0006\u0010b\u001a\u00020\u0015H\u0004J\u0010\u0010c\u001a\u00020I2\u0006\u0010d\u001a\u00020\u0006H\u0014J \u0010e\u001a\u00020I2\u0006\u0010f\u001a\u00020\u00062\u0006\u0010g\u001a\u0002042\u0006\u0010h\u001a\u00020\u0006H\u0004J\u0010\u0010i\u001a\u00020I2\u0006\u0010j\u001a\u00020\u0006H\u0004R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001c\"\u0004\b1\u0010\u001eR\u0011\u0010N\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010(\u00a8\u0006r"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;", "", "Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$LongIntCursor;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "expectedElements", "", "loadFactor", "", "<init>", "(ID)V", "()V", "map", "(Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;)V", "keys", "", "getKeys", "()[J", "setKeys", "([J)V", "values", "", "getValues", "()[I", "setValues", "([I)V", "assigned", "getAssigned", "()I", "setAssigned", "(I)V", "mask", "getMask", "setMask", "resizeAt", "getResizeAt", "setResizeAt", "hasEmptyKey", "", "getHasEmptyKey", "()Z", "setHasEmptyKey", "(Z)V", "getLoadFactor", "()D", "setLoadFactor", "(D)V", "iterationSeed", "getIterationSeed", "setIterationSeed", "put", "key", "", "value", "putAll", "iterable", "putIfAbsent", "putOrAdd", "putValue", "incrementValue", "addTo", "remove", "get", "getOrDefault", "defaultValue", "containsKey", "indexOf", "indexExists", "index", "indexGet", "indexReplace", "newValue", "indexInsert", "", "indexRemove", "clear", "release", "size", "isEmpty", "hashCode", "equals", "other", "", "equalElements", "ensureCapacity", "nextIterationSeed", "ramBytesUsed", "iterator", "", "Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$KeysContainer;", "Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$ValuesContainer;", "clone", "toString", "", "hashKey", "verifyLoadFactor", "rehash", "fromKeys", "fromValues", "allocateBuffers", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "pendingValue", "shiftConflictingKeys", "gapSlot", "EntryIterator", "KeysContainer", "KeysIterator", "ValuesContainer", "ValuesIterator", "LongIntCursor", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLongIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongIntHashMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,821:1\n1#2:822\n*E\n"})
public class LongIntHashMap
implements Iterable<LongIntCursor>,
Accountable,
Cloneable<LongIntHashMap>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private long[] keys;
    @Nullable
    private int[] values;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;
    private int iterationSeed;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(LongIntHashMap.class));

    @JvmOverloads
    public LongIntHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = AtomicsKt.incrementAndFetch((AtomicInteger)HashContainers.INSTANCE.getITERATION_SEED());
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ LongIntHashMap(int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        this(n, d);
    }

    @Nullable
    public final long[] getKeys() {
        return this.keys;
    }

    public final void setKeys(@Nullable long[] lArray) {
        this.keys = lArray;
    }

    @Nullable
    public final int[] getValues() {
        return this.values;
    }

    public final void setValues(@Nullable int[] nArray) {
        this.values = nArray;
    }

    protected final int getAssigned() {
        return this.assigned;
    }

    protected final void setAssigned(int n) {
        this.assigned = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final int getResizeAt() {
        return this.resizeAt;
    }

    protected final void setResizeAt(int n) {
        this.resizeAt = n;
    }

    protected final boolean getHasEmptyKey() {
        return this.hasEmptyKey;
    }

    protected final void setHasEmptyKey(boolean bl) {
        this.hasEmptyKey = bl;
    }

    protected final double getLoadFactor() {
        return this.loadFactor;
    }

    protected final void setLoadFactor(double d) {
        this.loadFactor = d;
    }

    protected final int getIterationSeed() {
        return this.iterationSeed;
    }

    protected final void setIterationSeed(int n) {
        this.iterationSeed = n;
    }

    public LongIntHashMap() {
        this(4, 0.0, 2, null);
    }

    public LongIntHashMap(@NotNull LongIntHashMap map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        this(map2.size(), 0.0, 2, null);
        this.putAll(map2);
    }

    public final int put(long key, int value) {
        if (!(this.assigned < this.mask + 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int mask = this.mask;
        if (key == 0L) {
            int n;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                n = this.values[mask + 1];
            } else {
                n = 0;
            }
            int previousValue = n;
            this.hasEmptyKey = true;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = value;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                int previousValue = this.values[slot];
                Intrinsics.checkNotNull((Object)this.values);
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[slot] = value;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return 0;
    }

    public final int putAll(@NotNull Iterable<LongIntCursor> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        int count = this.size();
        for (LongIntCursor c : iterable) {
            this.put(c.getKey(), c.getValue());
        }
        return this.size() - count;
    }

    public final boolean putIfAbsent(long key, int value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    public final int putOrAdd(long key, int putValue, int incrementValue) {
        int putValue2 = putValue;
        if (!(this.assigned < this.mask + 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            Intrinsics.checkNotNull((Object)this.values);
            putValue2 = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue2);
        } else {
            this.indexInsert(keyIndex, key, putValue2);
        }
        return putValue2;
    }

    public final int addTo(long key, int incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    public final int remove(long key) {
        int mask = this.mask;
        if (key == 0L) {
            if (!this.hasEmptyKey) {
                return 0;
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            int previousValue = this.values[mask + 1];
            Intrinsics.checkNotNull((Object)this.values);
            this.values[mask + 1] = 0;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                int previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public final int get(long key) {
        if (key == 0L) {
            int n;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                n = this.values[this.mask + 1];
            } else {
                n = 0;
            }
            return n;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public final int getOrDefault(long key, int defaultValue) {
        if (key == 0L) {
            int n;
            if (this.hasEmptyKey) {
                Intrinsics.checkNotNull((Object)this.values);
                n = this.values[this.mask + 1];
            } else {
                n = defaultValue;
            }
            return n;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                Intrinsics.checkNotNull((Object)this.values);
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public final boolean containsKey(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public final int indexOf(long key) {
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = 0L;
        while (true) {
            long l;
            Intrinsics.checkNotNull((Object)keys);
            long it = l = keys[slot];
            boolean bl = false;
            existing = it;
            if (l == 0L) break;
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public final boolean indexExists(int index) {
        if (!(index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return index >= 0;
    }

    public final int indexGet(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        return this.values[index];
    }

    public final int indexReplace(int index, int newValue) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        int previousValue = this.values[index];
        Intrinsics.checkNotNull((Object)this.values);
        this.values[index] = newValue;
        return previousValue;
    }

    public final void indexInsert(int index, long key, int value) {
        int index2 = index;
        if (!(index2 < 0)) {
            boolean bl = false;
            String string = "The index must not point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        index2 ^= 0xFFFFFFFF;
        if (key == 0L) {
            if (!(index2 == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index2] = value;
            this.hasEmptyKey = true;
        } else {
            Intrinsics.checkNotNull((Object)this.keys);
            if (!(this.keys[index2] == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value);
            } else {
                Intrinsics.checkNotNull((Object)this.keys);
                this.keys[index2] = key;
                Intrinsics.checkNotNull((Object)this.values);
                this.values[index2] = value;
            }
            int n = this.assigned;
            this.assigned = n + 1;
        }
    }

    public final int indexRemove(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "The index must point at an existing key.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(index <= this.mask || index == this.mask + 1 && this.hasEmptyKey)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.values);
        int previousValue = this.values[index];
        if (index > this.mask) {
            if (!(index == this.mask + 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.hasEmptyKey = false;
            Intrinsics.checkNotNull((Object)this.values);
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    public final void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Intrinsics.checkNotNull((Object)this.keys);
        Arrays.INSTANCE.fill(this.keys, 0L);
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongIntCursor c : this) {
            h += BitMixer.INSTANCE.mix(c.getKey()) + BitMixer.INSTANCE.mix(c.getValue());
        }
        return h;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.equalElements((LongIntHashMap)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    protected final boolean equalElements(@NotNull LongIntHashMap other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.size() != this.size()) {
            return false;
        }
        for (LongIntCursor c : other) {
            long key = c.getKey();
            if (this.containsKey(key) && this.get(key) == c.getValue()) continue;
            return false;
        }
        return true;
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            int[] prevValues = this.values;
            this.allocateBuffers(HashContainers.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                Intrinsics.checkNotNull((Object)prevValues);
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected final int nextIterationSeed() {
        int n;
        int it = n = BitMixer.INSTANCE.mixPhi(this.iterationSeed);
        boolean bl = false;
        this.iterationSeed = it;
        return n;
    }

    @Override
    public long ramBytesUsed() {
        Intrinsics.checkNotNull((Object)this.keys);
        long l = BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.keys);
        Intrinsics.checkNotNull((Object)this.values);
        return l + RamUsageEstimator.Companion.sizeOf(this.values);
    }

    @Override
    @NotNull
    public Iterator<LongIntCursor> iterator() {
        return new EntryIterator();
    }

    @NotNull
    public final KeysContainer keys() {
        return new KeysContainer();
    }

    @NotNull
    public final ValuesContainer values() {
        return new ValuesContainer();
    }

    @Override
    @NotNull
    public LongIntHashMap clone() {
        return new LongIntHashMap(this);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.getKey());
            buffer.append("=>");
            buffer.append(cursor.getValue());
            first = false;
        }
        buffer.append("]");
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected final int hashKey(long key) {
        if (!(key != 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return BitMixer.INSTANCE.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.INSTANCE.checkLoadFactor(loadFactor, HashContainers.INSTANCE.getMIN_LOAD_FACTOR(), HashContainers.INSTANCE.getMAX_LOAD_FACTOR());
        return loadFactor;
    }

    protected final void rehash(@NotNull long[] fromKeys, @NotNull int[] fromValues) {
        Intrinsics.checkNotNullParameter((Object)fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)fromValues, (String)"fromValues");
        if (!(fromKeys.length == fromValues.length && HashContainers.INSTANCE.checkPowerOfTwo(fromKeys.length - 1))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] keys = this.keys;
        int[] values2 = this.values;
        int mask = this.mask;
        long existing = 0L;
        int from = fromKeys.length - 1;
        Intrinsics.checkNotNull((Object)keys);
        keys[keys.length - 1] = fromKeys[from];
        Intrinsics.checkNotNull((Object)values2);
        values2[values2.length - 1] = fromValues[from];
        while (--from >= 0) {
            long l;
            long it = l = fromKeys[from];
            boolean bl = false;
            existing = it;
            if (l == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        if (!(IntExtKt.bitCount(IntCompanionObject.INSTANCE, arraySize) == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] prevKeys = this.keys;
        int[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new int[arraySize + emptyElementSlot];
        }
        catch (Error e) {
            this.keys = prevKeys;
            this.values = prevValues;
            Object[] objectArray = new Object[]{this.mask + 1, arraySize};
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, objectArray);
        }
        this.resizeAt = HashContainers.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final void allocateThenInsertThenRehash(int slot, long pendingKey, int pendingValue) {
        if (this.assigned != this.resizeAt) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.keys);
        if (this.keys[slot] == 0L && pendingKey != 0L) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) {
            var6_4 = "Failed requirement.";
            throw new IllegalArgumentException(var6_4.toString());
        }
        prevKeys = this.keys;
        prevValues = this.values;
        this.allocateBuffers(HashContainers.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        Intrinsics.checkNotNull((Object)this.keys);
        v1 = this.keys.length;
        Intrinsics.checkNotNull((Object)prevKeys);
        if (!(v1 > prevKeys.length)) {
            var7_7 = "Failed requirement.";
            throw new IllegalArgumentException(var7_7.toString());
        }
        prevKeys[slot] = pendingKey;
        Intrinsics.checkNotNull((Object)prevValues);
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected final void shiftConflictingKeys(int gapSlot) {
        int gapSlot2 = gapSlot;
        long[] keys = this.keys;
        int[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while (true) {
            int slot = gapSlot2 + ++distance & mask;
            Intrinsics.checkNotNull((Object)keys);
            long existing = keys[slot];
            if (existing == 0L) break;
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot2] = existing;
            Intrinsics.checkNotNull((Object)values2);
            values2[gapSlot2] = values2[slot];
            gapSlot2 = slot;
            distance = 0;
        }
        keys[gapSlot2] = 0L;
        Intrinsics.checkNotNull((Object)values2);
        values2[gapSlot2] = 0;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    public LongIntHashMap(int expectedElements) {
        this(expectedElements, 0.0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "from", "Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;", "keys", "", "values", "", "core"})
    @SourceDebugExtension(value={"SMAP\nLongIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongIntHashMap$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,821:1\n1#2:822\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongIntHashMap from(@NotNull long[] keys, @NotNull int[] values2) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            if (!(keys.length == values2.length)) {
                boolean $i$a$-require-LongIntHashMap$Companion$from$22 = false;
                String $i$a$-require-LongIntHashMap$Companion$from$22 = "Arrays of keys and values must have an identical length.";
                throw new IllegalArgumentException($i$a$-require-LongIntHashMap$Companion$from$22.toString());
            }
            LongIntHashMap map2 = new LongIntHashMap(keys.length, 0.0, 2, null);
            int n = keys.length;
            for (int i = 0; i < n; ++i) {
                map2.put(keys[i], values2[i]);
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$EntryIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$LongIntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nLongIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongIntHashMap$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,821:1\n1#2:822\n*E\n"})
    private final class EntryIterator
    extends AbstractIterator<LongIntCursor> {
        @NotNull
        private final LongIntCursor cursor = new LongIntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongIntHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected LongIntCursor fetch() {
            int mask = LongIntHashMap.this.getMask();
            while (this.index <= mask) {
                long l;
                long existing = 0L;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongIntHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                long it = l = lArray[this.slot];
                boolean bl = false;
                existing = it;
                if (l == 0L) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setKey(existing);
                int[] nArray = LongIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray);
                this.cursor.setValue(nArray[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongIntHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                this.cursor.setKey(0L);
                int[] nArray = LongIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray);
                int n = this.index;
                this.index = n + 1;
                this.cursor.setValue(nArray[n]);
                return this.cursor;
            }
            return (LongIntCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$KeysContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;)V", "iterator", "", "size", "", "toArray", "", "core"})
    public final class KeysContainer
    implements Iterable<LongCursor>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        public final int size() {
            return LongIntHashMap.this.size();
        }

        @NotNull
        public final long[] toArray() {
            long[] array = new long[this.size()];
            int i = 0;
            for (LongCursor cursor : this) {
                array[i++] = cursor.getValue();
            }
            return array;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$KeysIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/LongCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    @SourceDebugExtension(value={"SMAP\nLongIntHashMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongIntHashMap.kt\norg/gnit/lucenekmp/internal/hppc/LongIntHashMap$KeysIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,821:1\n1#2:822\n*E\n"})
    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        @NotNull
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = LongIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongIntHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected LongCursor fetch() {
            int mask = LongIntHashMap.this.getMask();
            while (this.index <= mask) {
                long l;
                long existing = 0L;
                int n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongIntHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                long it = l = lArray[this.slot];
                boolean bl = false;
                existing = it;
                if (l == 0L) continue;
                this.cursor.setIndex(this.slot);
                this.cursor.setValue(existing);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongIntHashMap.this.getHasEmptyKey()) {
                int n = this.index;
                this.index = n + 1;
                this.cursor.setIndex(n);
                this.cursor.setValue(0L);
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$LongIntCursor;", "", "<init>", "()V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "key", "", "getKey", "()J", "setKey", "(J)V", "value", "getValue", "setValue", "toString", "", "core"})
    public static final class LongIntCursor {
        private int index;
        private long key;
        private int value;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public final long getKey() {
            return this.key;
        }

        public final void setKey(long l) {
            this.key = l;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        @NotNull
        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0096\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$ValuesContainer;", "", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;)V", "iterator", "", "size", "", "toArray", "", "core"})
    public final class ValuesContainer
    implements Iterable<IntCursor>,
    KMappedMarker {
        @Override
        @NotNull
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        public final int size() {
            return LongIntHashMap.this.size();
        }

        @NotNull
        public final int[] toArray() {
            int[] array = new int[this.size()];
            int i = 0;
            for (IntCursor cursor : this) {
                array[i++] = cursor.getValue();
            }
            return array;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap$ValuesIterator;", "Lorg/gnit/lucenekmp/internal/hppc/AbstractIterator;", "Lorg/gnit/lucenekmp/internal/hppc/IntCursor;", "<init>", "(Lorg/gnit/lucenekmp/internal/hppc/LongIntHashMap;)V", "cursor", "increment", "", "index", "slot", "fetch", "core"})
    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        @NotNull
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = LongIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.INSTANCE.iterationIncrement(seed);
            this.slot = seed & LongIntHashMap.this.getMask();
        }

        @Override
        @Nullable
        protected IntCursor fetch() {
            int n;
            int mask = LongIntHashMap.this.getMask();
            while (this.index <= mask) {
                n = this.index;
                this.index = n + 1;
                this.slot = this.slot + this.increment & mask;
                long[] lArray = LongIntHashMap.this.getKeys();
                Intrinsics.checkNotNull((Object)lArray);
                if (lArray[this.slot] == 0L) continue;
                this.cursor.setIndex(this.slot);
                int[] nArray = LongIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray);
                this.cursor.setValue(nArray[this.slot]);
                return this.cursor;
            }
            if (this.index == mask + 1 && LongIntHashMap.this.getHasEmptyKey()) {
                this.cursor.setIndex(this.index);
                int[] nArray = LongIntHashMap.this.getValues();
                Intrinsics.checkNotNull((Object)nArray);
                n = this.index;
                this.index = n + 1;
                this.cursor.setValue(nArray[n]);
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

