/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\u0010\u0015\n\u0002\u0010\u0019\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/jdkport/ArraysSupport;", "", "<init>", "()V", "mismatch", "", "a", "", "aFromIndex", "b", "bFromIndex", "length", "", "", "", "", "SOFT_MAX_ARRAY_LENGTH", "newLength", "oldLength", "minGrowth", "prefGrowth", "hugeLength", "core"})
public final class ArraysSupport {
    @NotNull
    public static final ArraysSupport INSTANCE = new ArraysSupport();
    public static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    private ArraysSupport() {
    }

    public final int mismatch(@NotNull long[] a, int aFromIndex, @NotNull long[] b, int bFromIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (length == 0) {
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return i;
        }
        return -1;
    }

    public final int mismatch(@NotNull float[] a, int aFromIndex, @NotNull float[] b, int bFromIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (length <= 0) {
            return -1;
        }
        int aRem = a.length - aFromIndex;
        int bRem = b.length - bFromIndex;
        if (length > aRem || length > bRem) {
            return Math.min(aRem, bRem);
        }
        for (int i = 0; i < length; ++i) {
            if (FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, a[aFromIndex + i]) == FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, b[bFromIndex + i])) continue;
            return i;
        }
        return -1;
    }

    public final int mismatch(@NotNull int[] a, int aFromIndex, @NotNull int[] b, int bFromIndex, int length) {
        int start;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (length <= 0) {
            return -1;
        }
        if (length > 1 && a[aFromIndex] != b[bFromIndex]) {
            return 0;
        }
        for (int i = start = length > 1 ? 1 : 0; i < length; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return i;
        }
        return -1;
    }

    public final int mismatch(@NotNull char[] a, int aFromIndex, @NotNull char[] b, int bFromIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (int i = 0; i < length; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return i;
        }
        return -1;
    }

    public final int mismatch(@NotNull byte[] a, int aFromIndex, @NotNull byte[] b, int bFromIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        for (int i = 0; i < length; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return i;
        }
        return -1;
    }

    public final int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return this.hugeLength(oldLength, minGrowth);
    }

    private final int hugeLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new Error("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        if (minLength <= 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        return minLength;
    }
}

