/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ArraysSupport;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.jdkport.LongBuffer;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Ported;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.util.BitSet")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u001e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00017B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0011\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005J\u0019\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\fH\u0086\u0002J\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u001e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u000eJ\u0011\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0005H\u0086\u0002J\u0016\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010,\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010-\u001a\u00020\u0005H\u0016J\u0006\u0010.\u001a\u00020\u0005J\u0013\u0010/\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u00020\u0000H\u0016J\u0006\u00103\u001a\u00020\u000eJ\b\u00104\u001a\u000205H\u0016J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Lorg/gnit/lucenekmp/jdkport/BitSet;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "<init>", "()V", "nbits", "", "(I)V", "words", "", "([J)V", "wordsInUse", "sizeIsSticky", "", "checkInvariants", "", "recalculateWordsInUse", "initWords", "toByteArray", "", "toLongArray", "ensureCapacity", "wordsRequired", "expandTo", "wordIndex", "flip", "bitIndex", "fromIndex", "toIndex", "set", "value", "clear", "get", "nextSetBit", "nextClearBit", "previousSetBit", "previousClearBit", "length", "isEmpty", "()Z", "intersects", "cardinality", "and", "or", "xor", "andNot", "hashCode", "size", "equals", "obj", "", "clone", "trimToSize", "toString", "", "toWordIndex", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitSet.kt\norg/gnit/lucenekmp/jdkport/BitSet\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1413:1\n3#2,8:1414\n3#2,8:1423\n3#2,8:1432\n10#3:1422\n10#3:1431\n10#3:1440\n1#4:1441\n*S KotlinDebug\n*F\n+ 1 BitSet.kt\norg/gnit/lucenekmp/jdkport/BitSet\n*L\n63#1:1414,8\n64#1:1423,8\n65#1:1432,8\n63#1:1422\n64#1:1431\n65#1:1440\n*E\n"})
public final class BitSet
implements Cloneable<BitSet> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long[] words;
    private int wordsInUse;
    private boolean sizeIsSticky;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;

    /*
     * Unable to fully structure code
     */
    private final void checkInvariants() {
        if (this.wordsInUse == 0) ** GOTO lbl-1000
        v0 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            v0 = null;
        }
        if (v0[this.wordsInUse - 1] != 0L) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        condition$iv = v1;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            $i$a$-assert-AssertKt$assert$1 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
        }
        if (this.wordsInUse < 0) ** GOTO lbl-1000
        v2 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            v2 = null;
        }
        if (this.wordsInUse <= v2.length) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        condition$iv = v3;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            $i$a$-assert-AssertKt$assert$1 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
        }
        v4 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            v4 = null;
        }
        if (this.wordsInUse == v4.length) ** GOTO lbl-1000
        v5 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            v5 = null;
        }
        if (v5[this.wordsInUse] == 0L) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = false;
        }
        condition$iv = v6;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            var3_8 = "assertion failed";
            throw new AssertionError((Object)var3_8);
        }
    }

    private final void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse - 1; i >= 0; --i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            if (lArray[i] != 0L) break;
        }
        this.wordsInUse = i + 1;
    }

    public BitSet() {
        this.initWords(64);
        this.sizeIsSticky = false;
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new Exception("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
        this.sizeIsSticky = true;
    }

    private final void initWords(int nbits) {
        this.words = new long[BitSet.Companion.wordIndex(nbits - 1) + 1];
    }

    private BitSet(long[] words) {
        int i;
        this.words = words;
        for (i = words.length - 1; i >= 0 && words[i] == 0L; --i) {
        }
        this.wordsInUse = i + 1;
        this.checkInvariants();
    }

    @NotNull
    public final byte[] toByteArray() {
        int lastByte;
        int highest = this.wordsInUse - 1;
        if (highest < 0) {
            return new byte[0];
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long lastWord = lArray[highest];
        for (lastByte = 8; lastByte > 0 && (lastWord >>> (lastByte - 1) * 8 & 0xFFL) == 0L; --lastByte) {
        }
        int byteLen = highest * 8 + lastByte;
        byte[] bytes = new byte[byteLen];
        int k = 0;
        int i = 0;
        if (i <= highest) {
            while (true) {
                long[] lArray2 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray2 = null;
                }
                long w = lArray2[i];
                for (int j = 0; j < 8 && k != bytes.length; ++j) {
                    bytes[k++] = (byte)(w & 0xFFL);
                    w >>>= 8;
                }
                if (i == highest) break;
                ++i;
            }
        }
        return bytes;
    }

    @NotNull
    public final long[] toLongArray() {
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long[] lArray2 = lArray;
        int n = this.wordsInUse;
        long[] lArray3 = Arrays.copyOf(lArray2, n);
        Intrinsics.checkNotNullExpressionValue((Object)lArray3, (String)"copyOf(...)");
        return lArray3;
    }

    private final void ensureCapacity(int wordsRequired) {
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        if (lArray.length < wordsRequired) {
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            int request = Math.max(2 * lArray2.length, wordsRequired);
            long[] lArray3 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            long[] lArray4 = Arrays.copyOf(lArray3, request);
            Intrinsics.checkNotNullExpressionValue((Object)lArray4, (String)"copyOf(...)");
            this.words = lArray4;
            this.sizeIsSticky = false;
        }
    }

    private final void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    public final void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSet.Companion.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long[] lArray2 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray2 = null;
        }
        lArray[wordIndex] = lArray2[wordIndex] ^ 1L << bitIndex;
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void flip(int fromIndex, int toIndex) {
        BitSet.Companion.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSet.Companion.wordIndex(fromIndex);
        int endWordIndex = BitSet.Companion.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            lArray[startWordIndex] = lArray2[startWordIndex] ^ firstWordMask & lastWordMask;
        } else {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray3 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[startWordIndex] = lArray3[startWordIndex] ^ firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                long[] lArray4 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray4 = null;
                }
                long[] lArray5 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray5 = null;
                }
                lArray4[i] = lArray5[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            long[] lArray6 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray6 = null;
            }
            long[] lArray7 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray7 = null;
            }
            lArray6[endWordIndex] = lArray7[endWordIndex] ^ lastWordMask;
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSet.Companion.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long[] lArray2 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray2 = null;
        }
        lArray[wordIndex] = lArray2[wordIndex] | 1L << bitIndex;
        this.checkInvariants();
    }

    public final void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public final void set(int fromIndex, int toIndex) {
        BitSet.Companion.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startWordIndex = BitSet.Companion.wordIndex(fromIndex);
        int endWordIndex = BitSet.Companion.wordIndex(toIndex - 1);
        this.expandTo(endWordIndex);
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            lArray[startWordIndex] = lArray2[startWordIndex] | firstWordMask & lastWordMask;
        } else {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray3 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[startWordIndex] = lArray3[startWordIndex] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                long[] lArray4 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray4 = null;
                }
                lArray4[i] = -1L;
            }
            long[] lArray5 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray5 = null;
            }
            long[] lArray6 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray6 = null;
            }
            lArray5[endWordIndex] = lArray6[endWordIndex] | lastWordMask;
        }
        this.checkInvariants();
    }

    public final void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public final void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = BitSet.Companion.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long[] lArray2 = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray2 = null;
        }
        lArray[wordIndex] = lArray2[wordIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void clear(int fromIndex, int toIndex) {
        int toIndex2 = toIndex;
        BitSet.Companion.checkRange(fromIndex, toIndex2);
        if (fromIndex == toIndex2) {
            return;
        }
        int startWordIndex = BitSet.Companion.wordIndex(fromIndex);
        if (startWordIndex >= this.wordsInUse) {
            return;
        }
        int endWordIndex = BitSet.Companion.wordIndex(toIndex2 - 1);
        if (endWordIndex >= this.wordsInUse) {
            toIndex2 = this.length();
            endWordIndex = this.wordsInUse - 1;
        }
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex2;
        if (startWordIndex == endWordIndex) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            lArray[startWordIndex] = lArray2[startWordIndex] & (firstWordMask & lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray3 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[startWordIndex] = lArray3[startWordIndex] & (firstWordMask ^ 0xFFFFFFFFFFFFFFFFL);
            int n = endWordIndex;
            for (int i = startWordIndex + 1; i < n; ++i) {
                long[] lArray4 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray4 = null;
                }
                lArray4[i] = 0L;
            }
            long[] lArray5 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray5 = null;
            }
            long[] lArray6 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray6 = null;
            }
            lArray5[endWordIndex] = lArray6[endWordIndex] & (lastWordMask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void clear() {
        while (this.wordsInUse > 0) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            this.wordsInUse += -1;
            lArray[this.wordsInUse] = 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = BitSet.Companion.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) return false;
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        if ((lArray[wordIndex] & 1L << bitIndex) == 0L) return false;
        return true;
    }

    @NotNull
    public final BitSet get(int fromIndex, int toIndex) {
        long l;
        int toIndex2 = toIndex;
        BitSet.Companion.checkRange(fromIndex, toIndex2);
        this.checkInvariants();
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex2) {
            return new BitSet(0);
        }
        if (toIndex2 > len) {
            toIndex2 = len;
        }
        BitSet result = new BitSet(toIndex2 - fromIndex);
        int targetWords = BitSet.Companion.wordIndex(toIndex2 - fromIndex - 1) + 1;
        int sourceIndex = BitSet.Companion.wordIndex(fromIndex);
        boolean wordAligned = (fromIndex & 0x3F) == 0;
        int i = 0;
        while (i < targetWords - 1) {
            long l2;
            long[] lArray = result.words;
            if (result.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            if (wordAligned) {
                long[] lArray2 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray2 = null;
                }
                l2 = lArray2[sourceIndex];
            } else {
                long[] lArray3 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray3 = null;
                }
                long l3 = lArray3[sourceIndex] >>> fromIndex;
                long[] lArray4 = this.words;
                if (this.words == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                    lArray4 = null;
                }
                l2 = l3 | lArray4[sourceIndex + 1] << -fromIndex;
            }
            lArray[i] = l2;
            ++i;
            ++sourceIndex;
        }
        long lastWordMask = -1L >>> -toIndex2;
        long[] lArray = result.words;
        if (result.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        if ((toIndex2 - 1 & 0x3F) < (fromIndex & 0x3F)) {
            long[] lArray5 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray5 = null;
            }
            long l4 = lArray5[sourceIndex] >>> fromIndex;
            long[] lArray6 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray6 = null;
            }
            l = l4 | (lArray6[sourceIndex + 1] & lastWordMask) << -fromIndex;
        } else {
            long[] lArray7 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray7 = null;
            }
            l = (lArray7[sourceIndex] & lastWordMask) >>> fromIndex;
        }
        lArray[targetWords - 1] = l;
        result.wordsInUse = targetWords;
        result.recalculateWordsInUse();
        result.checkInvariants();
        return result;
    }

    public final int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long word = lArray[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            word = lArray2[u];
        }
        return u * 64 + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
    }

    public final int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long word = (lArray[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return this.wordsInUse * 64;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            word = lArray2[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u * 64 + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
    }

    public final int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return this.length() - 1;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long word = lArray[u] & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            word = lArray2[u];
        }
        return (u + 1) * 64 - 1 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, word);
    }

    public final int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        this.checkInvariants();
        int u = BitSet.Companion.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return fromIndex;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long word = (lArray[u] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (u-- == 0) {
                return -1;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            word = lArray2[u] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (u + 1) * 64 - 1 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, word);
    }

    public final int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        return 64 * (this.wordsInUse - 1) + (64 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, lArray[this.wordsInUse - 1]));
    }

    public final boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public final boolean intersects(@NotNull BitSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; -1 < i; --i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long l = lArray[i];
            long[] lArray2 = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            if ((l & lArray2[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public final int cardinality() {
        int sum = 0;
        int n = this.wordsInUse;
        for (int i = 0; i < n; ++i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            sum += LongExtKt.bitCount(LongCompanionObject.INSTANCE, lArray[i]);
        }
        return sum;
    }

    public final void and(@NotNull BitSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        while (this.wordsInUse > set.wordsInUse) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            this.wordsInUse += -1;
            lArray[this.wordsInUse] = 0L;
        }
        int n = this.wordsInUse;
        for (int i = 0; i < n; ++i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            long l = lArray2[i];
            long[] lArray3 = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[i] = l & lArray3[i];
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void or(@NotNull BitSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (this == set) {
            return;
        }
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            long l = lArray2[i];
            long[] lArray3 = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[i] = l | lArray3[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            long[] lArray = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray4 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray4 = null;
            }
            ArraysKt.copyInto((long[])lArray, (long[])lArray4, (int)wordsInCommon, (int)wordsInCommon, (int)set.wordsInUse);
        }
        this.checkInvariants();
    }

    public final void xor(@NotNull BitSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        int wordsInCommon = Math.min(this.wordsInUse, set.wordsInUse);
        if (this.wordsInUse < set.wordsInUse) {
            this.ensureCapacity(set.wordsInUse);
            this.wordsInUse = set.wordsInUse;
        }
        for (int i = 0; i < wordsInCommon; ++i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            long l = lArray2[i];
            long[] lArray3 = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[i] = l ^ lArray3[i];
        }
        if (wordsInCommon < set.wordsInUse) {
            long[] lArray = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray4 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray4 = null;
            }
            ArraysKt.copyInto((long[])lArray, (long[])lArray4, (int)wordsInCommon, (int)wordsInCommon, (int)set.wordsInUse);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public final void andNot(@NotNull BitSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        for (int i = Math.min(this.wordsInUse, set.wordsInUse) - 1; -1 < i; --i) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            long l = lArray2[i];
            long[] lArray3 = set.words;
            if (set.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray3 = null;
            }
            lArray[i] = l & (lArray3[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateWordsInUse();
        this.checkInvariants();
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse;
        while (--i >= 0) {
            long[] lArray = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray = null;
            }
            h ^= lArray[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public final int size() {
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        return lArray.length * 64;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitSet)) {
            return false;
        }
        this.checkInvariants();
        ((BitSet)obj).checkInvariants();
        if (this.wordsInUse != ((BitSet)obj).wordsInUse) {
            return false;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long[] lArray2 = ((BitSet)obj).words;
        if (((BitSet)obj).words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray2 = null;
        }
        return ArraysSupport.INSTANCE.mismatch(lArray, 0, lArray2, 0, this.wordsInUse) == -1;
    }

    @Override
    @NotNull
    public BitSet clone() {
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long[] lArray2 = lArray;
        long[] lArray3 = Arrays.copyOf(lArray2, lArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray3, (String)"copyOf(...)");
        long[] clonedWords = lArray3;
        BitSet clone = new BitSet(clonedWords);
        clone.wordsInUse = this.wordsInUse;
        clone.sizeIsSticky = this.sizeIsSticky;
        clone.checkInvariants();
        return clone;
    }

    public final void trimToSize() {
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        if (this.wordsInUse != lArray.length) {
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            long[] lArray3 = lArray2;
            int n = this.wordsInUse;
            long[] lArray4 = Arrays.copyOf(lArray3, n);
            Intrinsics.checkNotNullExpressionValue((Object)lArray4, (String)"copyOf(...)");
            this.words = lArray4;
            this.checkInvariants();
        }
    }

    @NotNull
    public String toString() {
        this.checkInvariants();
        int MAX_INITIAL_CAPACITY = 0x7FFFFFF7;
        int numBits = this.wordsInUse > 128 ? this.cardinality() : this.wordsInUse * 64;
        int initialCapacity = numBits <= (MAX_INITIAL_CAPACITY - 2) / 6 ? 6 * numBits + 2 : MAX_INITIAL_CAPACITY;
        StringBuilder b = new StringBuilder(initialCapacity);
        b.append('{');
        int i = 0;
        i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            while (++i >= 0) {
                int n;
                int it = n = this.nextSetBit(i);
                boolean bl = false;
                i = it;
                if (n < 0) break;
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i != endOfRun);
            }
        }
        b.append('}');
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int nextSetBit(int fromIndex, int toWordIndex) {
        int u = BitSet.Companion.wordIndex(fromIndex);
        if (u > toWordIndex) {
            return -1;
        }
        long[] lArray = this.words;
        if (this.words == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"words");
            lArray = null;
        }
        long word = lArray[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u > toWordIndex) {
                return -1;
            }
            long[] lArray2 = this.words;
            if (this.words == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"words");
                lArray2 = null;
            }
            word = lArray2[u];
        }
        return u * 64 + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
    }

    public /* synthetic */ BitSet(long[] words, DefaultConstructorMarker $constructor_marker) {
        this(words);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/jdkport/BitSet$Companion;", "", "<init>", "()V", "ADDRESS_BITS_PER_WORD", "", "BITS_PER_WORD", "BIT_INDEX_MASK", "WORD_MASK", "", "wordIndex", "bitIndex", "valueOf", "Lorg/gnit/lucenekmp/jdkport/BitSet;", "longs", "", "lb", "Lorg/gnit/lucenekmp/jdkport/LongBuffer;", "bytes", "", "bb", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "checkRange", "", "fromIndex", "toIndex", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int wordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        @NotNull
        public final BitSet valueOf(@NotNull long[] longs) {
            int n;
            Intrinsics.checkNotNullParameter((Object)longs, (String)"longs");
            for (n = longs.length; n > 0 && longs[n - 1] == 0L; --n) {
            }
            long[] lArray = Arrays.copyOf(longs, n);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            return new BitSet(lArray, null);
        }

        @NotNull
        public final BitSet valueOf(@NotNull LongBuffer lb) {
            int n;
            Intrinsics.checkNotNullParameter((Object)lb, (String)"lb");
            LongBuffer lb2 = lb;
            lb2 = lb2.slice();
            for (n = lb2.remaining(); n > 0 && lb2.get(n - 1) == 0L; --n) {
            }
            long[] words = new long[n];
            lb2.get(words);
            return new BitSet(words, null);
        }

        @NotNull
        public final BitSet valueOf(@NotNull byte[] bytes) {
            int n;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            for (n = bytes.length; n > 0 && bytes[n - 1] == 0; --n) {
            }
            long[] words = new long[(n + 7) / 8];
            int n2 = n;
            for (int byteIndex = 0; byteIndex < n2; ++byteIndex) {
                int byteValue = bytes[byteIndex] & 0xFF;
                int wordIndex = byteIndex / 8;
                int byteOffsetInWord = byteIndex % 8;
                words[wordIndex] = words[wordIndex] | ((long)byteValue & 0xFFL) << byteOffsetInWord * 8;
            }
            return new BitSet(words, null);
        }

        @NotNull
        public final BitSet valueOf(@NotNull ByteBuffer bb) {
            long word;
            int end;
            Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
            int originalPos = bb.getPosition();
            int originalLimit = bb.getLimit();
            int start = originalPos;
            for (end = originalLimit - 1; end >= start && (bb.get(end) & 0xFF) == 0; --end) {
            }
            int n = end >= start ? end - start + 1 : 0;
            long[] words = new long[(n + 7) / 8];
            int i = 0;
            int byteIdx = start;
            while (byteIdx + 8 <= start + n) {
                word = 0L;
                for (int b = 0; b < 8; ++b) {
                    word |= ((long)bb.get(byteIdx + b) & 0xFFL) << 8 * b;
                }
                words[i++] = word;
                byteIdx += 8;
            }
            if (byteIdx < start + n) {
                word = 0L;
                int offset = 0;
                while (byteIdx < start + n) {
                    word |= ((long)bb.get(byteIdx) & 0xFFL) << 8 * offset;
                    ++byteIdx;
                    ++offset;
                }
                words[i] = word;
            }
            return new BitSet(words, null);
        }

        private final void checkRange(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
            }
            if (toIndex < 0) {
                throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

