/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ArraysSupport;
import org.gnit.lucenekmp.jdkport.FilterInputStream;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.System;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020\u0005H\u0016J \u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u0005H\u0016J\b\u00102\u001a\u00020%H\u0016J\b\u00103\u001a\u00020\"H\u0016J\b\u00104\u001a\u00020%H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u0014\u0010\u001d\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010#\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\u00a8\u00069"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedInputStream;", "Lorg/gnit/lucenekmp/jdkport/FilterInputStream;", "in", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "size", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/InputStream;I)V", "initialSize", "buf", "", "getBuf", "()[B", "setBuf", "([B)V", "count", "getCount", "()I", "setCount", "(I)V", "pos", "getPos", "setPos", "markpos", "getMarkpos", "setMarkpos", "marklimit", "getMarklimit", "setMarklimit", "inIfOpen", "getInIfOpen", "()Lorg/gnit/lucenekmp/jdkport/InputStream;", "getBufIfOpen", "allocateIfEmpty", "", "bufIfOpen", "ensureOpen", "", "fill", "read", "read1", "b", "off", "len", "skip", "", "n", "available", "mark", "readlimit", "reset", "markSupported", "close", "transferTo", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedInputStream.kt\norg/gnit/lucenekmp/jdkport/BufferedInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,519:1\n1#2:520\n*E\n"})
public class BufferedInputStream
extends FilterInputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int initialSize;
    @Nullable
    private volatile byte[] buf;
    private int count;
    private int pos;
    private int markpos;
    private int marklimit;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    @NotNull
    private static final byte[] EMPTY = new byte[0];

    @JvmOverloads
    public BufferedInputStream(@NotNull InputStream in, int size2) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        super(in);
        this.markpos = -1;
        if (!(size2 > 0)) {
            boolean bl = false;
            String string = "Buffer size <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.initialSize = size2;
        this.buf = new byte[size2];
    }

    public /* synthetic */ BufferedInputStream(InputStream inputStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        this(inputStream, n);
    }

    @Nullable
    protected final byte[] getBuf() {
        return this.buf;
    }

    protected final void setBuf(@Nullable byte[] byArray) {
        this.buf = byArray;
    }

    protected final int getCount() {
        return this.count;
    }

    protected final void setCount(int n) {
        this.count = n;
    }

    protected final int getPos() {
        return this.pos;
    }

    protected final void setPos(int n) {
        this.pos = n;
    }

    protected final int getMarkpos() {
        return this.markpos;
    }

    protected final void setMarkpos(int n) {
        this.markpos = n;
    }

    protected final int getMarklimit() {
        return this.marklimit;
    }

    protected final void setMarklimit(int n) {
        this.marklimit = n;
    }

    private final InputStream getInIfOpen() {
        InputStream input = this.getIn();
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    private final byte[] getBufIfOpen(boolean allocateIfEmpty) throws IOException {
        byte[] buffer = this.buf;
        if (allocateIfEmpty && Intrinsics.areEqual((Object)buffer, (Object)EMPTY)) {
            buffer = new byte[this.initialSize];
            buffer = this.buf;
        }
        if (buffer == null) {
            throw new IOException("Stream closed");
        }
        return buffer;
    }

    private final byte[] getBufIfOpen() {
        return this.getBufIfOpen(true);
    }

    private final void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    private final void fill() throws IOException {
        byte[] buffer = this.getBufIfOpen();
        if (this.markpos == -1) {
            this.pos = 0;
        } else if (this.pos >= buffer.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.INSTANCE.arraycopy(buffer, this.markpos, buffer, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (buffer.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = ArraysSupport.INSTANCE.newLength(this.pos, 1, this.pos);
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.INSTANCE.arraycopy(buffer, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
                buffer = nbuf;
            }
        }
        this.count = this.pos;
        int n = this.getInIfOpen().read(buffer, this.pos, buffer.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        int n = this.pos;
        this.pos = n + 1;
        return this.getBufIfOpen()[n] & 0xFF;
    }

    private final int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            int size2 = java.lang.Math.max(this.getBufIfOpen(false).length, this.initialSize);
            if (len >= size2 && this.markpos == -1) {
                return this.getInIfOpen().read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.INSTANCE.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        InputStream input;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read1(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((input = this.getIn()) == null || input.available() > 0);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long availInBuf = this.count - this.pos;
        if (availInBuf > 0L) {
            long toSkipFromBuf = java.lang.Math.min(availInBuf, n);
            this.pos += (int)toSkipFromBuf;
            v0 = toSkipFromBuf;
        } else {
            v0 = skipped = 0L;
        }
        if (skipped < n) {
            skipped += this.getInIfOpen().skip(n - skipped);
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        int n = this.count - this.pos;
        int avail = this.getInIfOpen().available();
        return n > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : n + avail;
    }

    @Override
    public void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        if (this.buf != null) {
            InputStream input = this.getIn();
            this.setIn(null);
            this.buf = null;
            if (input != null) {
                input.close();
            }
            return;
        }
    }

    @Override
    public long transferTo(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (this.getClass() == BufferedInputStream.class && this.markpos == -1) {
            int avail = this.count - this.pos;
            if (avail > 0) {
                byte[] buffer = Arrays.INSTANCE.copyOfRange(this.getBufIfOpen(), this.pos, this.count);
                out.write(buffer);
                this.pos = this.count;
            }
            try {
                return Math.INSTANCE.addExact((long)avail, this.getInIfOpen().transferTo(out));
            }
            catch (ArithmeticException ignore) {
                return Long.MAX_VALUE;
            }
        }
        return super.transferTo(out);
    }

    @JvmOverloads
    public BufferedInputStream(@NotNull InputStream in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this(in, 0, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedInputStream$Companion;", "", "<init>", "()V", "DEFAULT_BUFFER_SIZE", "", "EMPTY", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

