/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.FilterOutputStream;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.System;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedOutputStream;", "Lorg/gnit/lucenekmp/jdkport/FilterOutputStream;", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "initialSize", "", "maxSize", "<init>", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;II)V", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;)V", "size", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;I)V", "buf", "", "getBuf", "()[B", "setBuf", "([B)V", "count", "getCount", "()I", "setCount", "(I)V", "maxBufSize", "flushBuffer", "", "growIfNeeded", "len", "write", "b", "off", "flush", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBufferedOutputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedOutputStream.kt\norg/gnit/lucenekmp/jdkport/BufferedOutputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public class BufferedOutputStream
extends FilterOutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] buf;
    private int count;
    private final int maxBufSize;
    private static final int DEFAULT_MAX_BUFFER_SIZE = 8192;

    private BufferedOutputStream(OutputStream out, int initialSize, int maxSize) {
        super(out);
        if (!(initialSize > 0)) {
            boolean bl = false;
            String string = "Buffer size <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.buf = new byte[initialSize];
        this.maxBufSize = maxSize;
    }

    @NotNull
    protected final byte[] getBuf() {
        return this.buf;
    }

    protected final void setBuf(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.buf = byArray;
    }

    protected final int getCount() {
        return this.count;
    }

    protected final void setCount(int n) {
        this.count = n;
    }

    public BufferedOutputStream(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, BufferedOutputStream.Companion.initialBufferSize(), 8192);
    }

    public BufferedOutputStream(@NotNull OutputStream out, int size2) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, size2, size2);
    }

    private final void flushBuffer() throws IOException {
        if (this.count > 0) {
            OutputStream outputStream = this.getOut();
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    private final void growIfNeeded(int len) {
        int bufSize;
        int neededSize = this.count + len + 1;
        if (neededSize < 0) {
            neededSize = Integer.MAX_VALUE;
        }
        if (neededSize > (bufSize = this.buf.length) && bufSize < this.maxBufSize) {
            int newSize = Math.min(neededSize, this.maxBufSize);
            byte[] byArray = Arrays.copyOf(this.buf, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            this.buf = byArray;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream closed");
        }
        this.growIfNeeded(1);
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        int n = this.count;
        this.count = n + 1;
        this.buf[n] = (byte)b;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.isClosed()) {
            throw new IOException("Stream closed");
        }
        if (len >= this.maxBufSize) {
            this.flushBuffer();
            OutputStream outputStream = this.getOut();
            Intrinsics.checkNotNull((Object)outputStream);
            outputStream.write(b, off, len);
            return;
        }
        this.growIfNeeded(len);
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.INSTANCE.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        OutputStream outputStream = this.getOut();
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.flush();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/jdkport/BufferedOutputStream$Companion;", "", "<init>", "()V", "DEFAULT_MAX_BUFFER_SIZE", "", "initialBufferSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int initialBufferSize() {
            return 8192;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

