/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.BufferOverflowException;
import org.gnit.lucenekmp.jdkport.BufferUnderflowException;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.gnit.lucenekmp.jdkport.FloatBuffer;
import org.gnit.lucenekmp.jdkport.IntBuffer;
import org.gnit.lucenekmp.jdkport.LongBuffer;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.Ported;
import org.gnit.lucenekmp.jdkport.ReadOnlyBufferException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.nio.ByteBuffer")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 T2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001TB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u0014J\b\u0010 \u001a\u00020!H\u0002J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001dJ\u0006\u0010'\u001a\u00020(J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005J(\u0010'\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0016J(\u0010-\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0002J\u000e\u0010.\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020\u0005J\u000e\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020\u0005J\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020(J\u0016\u00101\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00052\u0006\u00102\u001a\u00020(J\u000e\u00101\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0000J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\n\u001a\u000200J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0005J&\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005J\"\u0010'\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u0005J\"\u00101\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00032\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u0005J\u000e\u0010:\u001a\u00020;2\u0006\u0010)\u001a\u00020\u0005J\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020;J\u0006\u0010=\u001a\u00020\u0005J\u0006\u0010>\u001a\u00020\u0014J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010?\u001a\u00020\u0000J\u0006\u0010@\u001a\u00020\u0000J\u0006\u0010A\u001a\u00020\u0000J\u0006\u0010B\u001a\u00020\u0000J\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010D\u001a\u00020\u0000J\u0011\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010G\u001a\u00020\u0000J\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020\u0000J\b\u0010O\u001a\u00020PH\u0016J\u0013\u0010Q\u001a\u00020\u00142\b\u0010F\u001a\u0004\u0018\u00010RH\u0096\u0002J\b\u0010S\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001e\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "", "array", "", "capacity", "", "<init>", "([BI)V", "getCapacity", "()I", "value", "position", "getPosition", "setPosition", "(I)V", "limit", "getLimit", "setLimit", "mark", "bigEndian", "", "getBigEndian", "()Z", "setBigEndian", "(Z)V", "nativeByteOrder", "getNativeByteOrder", "setNativeByteOrder", "order", "Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "_readOnly", "isReadOnly", "checkWritable", "", "hasArray", "arrayOffset", "newLimit", "newPosition", "bo", "get", "", "index", "dst", "offset", "length", "getArray", "getInt", "getShort", "", "put", "b", "src", "putShort", "putInt", "putBuffer", "pos", "srcPos", "n", "getLong", "", "putLong", "remaining", "hasRemaining", "reset", "clear", "flip", "rewind", "duplicate", "slice", "compareTo", "other", "asReadOnlyBuffer", "asIntBuffer", "Lorg/gnit/lucenekmp/jdkport/IntBuffer;", "asLongBuffer", "Lorg/gnit/lucenekmp/jdkport/LongBuffer;", "asFloatBuffer", "Lorg/gnit/lucenekmp/jdkport/FloatBuffer;", "compact", "toString", "", "equals", "", "hashCode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nByteBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffer.kt\norg/gnit/lucenekmp/jdkport/ByteBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,935:1\n1#2:936\n*E\n"})
public class ByteBuffer
implements Comparable<ByteBuffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] array;
    private final int capacity;
    private int position;
    private int limit;
    private int mark;
    private boolean bigEndian;
    private boolean nativeByteOrder;
    private boolean _readOnly;

    private ByteBuffer(byte[] array, int capacity) {
        this.array = array;
        this.limit = this.capacity = capacity;
        this.mark = -1;
        this.bigEndian = true;
        this.nativeByteOrder = Intrinsics.areEqual((Object)ByteOrder.Companion.nativeOrder(), (Object)ByteOrder.Companion.getBIG_ENDIAN());
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int value) {
        if (!(0 <= value ? value <= this.limit : false)) {
            boolean bl = false;
            String string = "Position (" + value + ") out of bounds (0.." + this.limit + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.position = value;
        if (this.mark != -1 && this.mark > this.position) {
            this.mark = -1;
        }
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int value) {
        if (!(0 <= value ? value <= this.capacity : false)) {
            boolean bl = false;
            String string = "Limit (" + value + ") out of bounds (0.." + this.capacity + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.limit = value;
        if (this.position > this.limit) {
            this.setPosition(this.limit);
        }
        if (this.mark != -1 && this.mark > this.limit) {
            this.mark = -1;
        }
    }

    public final boolean getBigEndian() {
        return this.bigEndian;
    }

    public final void setBigEndian(boolean bl) {
        this.bigEndian = bl;
    }

    public final boolean getNativeByteOrder() {
        return this.nativeByteOrder;
    }

    public final void setNativeByteOrder(boolean bl) {
        this.nativeByteOrder = bl;
    }

    @NotNull
    public final ByteOrder order() {
        return this.bigEndian ? ByteOrder.Companion.getBIG_ENDIAN() : ByteOrder.Companion.getLITTLE_ENDIAN();
    }

    public final boolean isReadOnly() {
        return this._readOnly;
    }

    private final void checkWritable() {
        if (this._readOnly) {
            throw new ReadOnlyBufferException("buffer is read-only");
        }
    }

    @NotNull
    public final byte[] array() {
        return this.array;
    }

    public final boolean hasArray() {
        return true;
    }

    public final int arrayOffset() {
        if (!this.hasArray()) {
            throw new UnsupportedOperationException("Buffer does not have a backing array");
        }
        return 0;
    }

    @NotNull
    public final ByteBuffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.capacity) {
            throw new IllegalArgumentException("newLimit (" + newLimit + ") out of bounds (0.." + this.capacity + ")");
        }
        this.setLimit(newLimit);
        if (this.position > newLimit) {
            this.setPosition(newLimit);
        }
        if (this.mark > newLimit) {
            this.mark = -1;
        }
        return this;
    }

    @NotNull
    public final ByteBuffer position(int newPosition) {
        this.setPosition(newPosition);
        return this;
    }

    @NotNull
    public final ByteBuffer order(@NotNull ByteOrder bo) {
        Intrinsics.checkNotNullParameter((Object)bo, (String)"bo");
        this.bigEndian = Intrinsics.areEqual((Object)bo, (Object)ByteOrder.Companion.getBIG_ENDIAN());
        this.nativeByteOrder = this.bigEndian == Intrinsics.areEqual((Object)ByteOrder.Companion.nativeOrder(), (Object)ByteOrder.Companion.getBIG_ENDIAN());
        return this;
    }

    public final byte get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException("Not enough bytes to read at position " + this.position + " with limit " + this.limit);
        }
        byte b = this.array[this.position];
        int n = this.position;
        this.setPosition(n + 1);
        return b;
    }

    public final byte get(int index) {
        if (!(0 <= index ? index < this.limit : false)) {
            throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds (0.." + (this.limit - 1) + ")");
        }
        return this.array[index];
    }

    @NotNull
    public ByteBuffer get(int index, @NotNull byte[] dst, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Objects.INSTANCE.checkFromIndexSize(index, length, this.limit);
        Objects.INSTANCE.checkFromIndexSize(offset, length, dst.length);
        this.getArray(index, dst, offset, length);
        return this;
    }

    private final ByteBuffer getArray(int index, byte[] dst, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get(index + (i - offset));
        }
        return this;
    }

    public final int getInt(int index) {
        if (index < 0 || this.limit - index < 4) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds: need 4 bytes from index (limit: " + this.limit + ")");
        }
        return this.bigEndian ? (this.array[index] & 0xFF) << 24 | (this.array[index + 1] & 0xFF) << 16 | (this.array[index + 2] & 0xFF) << 8 | this.array[index + 3] & 0xFF : this.array[index] & 0xFF | (this.array[index + 1] & 0xFF) << 8 | (this.array[index + 2] & 0xFF) << 16 | (this.array[index + 3] & 0xFF) << 24;
    }

    public final int getInt() {
        if (this.remaining() < 4) {
            throw new BufferUnderflowException("Not enough bytes remaining to read an int (need 4, have " + this.remaining() + ")");
        }
        int value = this.getInt(this.position);
        this.setPosition(this.position + 4);
        return value;
    }

    public final short getShort(int index) {
        short s;
        if (index < 0 || this.limit - index < 2) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds: need 2 bytes from index (limit: " + this.limit + ")");
        }
        if (this.bigEndian) {
            int hi = this.array[index] & 0xFF;
            int lo = this.array[index + 1] & 0xFF;
            s = (short)(hi << 8 | lo);
        } else {
            int lo = this.array[index] & 0xFF;
            int hi = this.array[index + 1] & 0xFF;
            s = (short)(hi << 8 | lo);
        }
        return s;
    }

    public final short getShort() {
        short s;
        if (this.remaining() < 2) {
            throw new BufferUnderflowException("Not enough bytes remaining to read a short (need 2, have " + this.remaining() + ")");
        }
        if (this.bigEndian) {
            int hi = this.array[this.position] & 0xFF;
            int lo = this.array[this.position + 1] & 0xFF;
            s = (short)(hi << 8 | lo);
        } else {
            int lo = this.array[this.position] & 0xFF;
            int hi = this.array[this.position + 1] & 0xFF;
            s = (short)(hi << 8 | lo);
        }
        short value = s;
        this.setPosition(this.position + 2);
        return value;
    }

    @NotNull
    public final ByteBuffer put(byte b) {
        this.checkWritable();
        if (this.position >= this.limit) {
            throw new BufferOverflowException("Not enough space to write at position " + this.position + " with limit " + this.limit);
        }
        this.array[this.position] = b;
        int n = this.position;
        this.setPosition(n + 1);
        return this;
    }

    @NotNull
    public final ByteBuffer put(int index, byte b) {
        this.checkWritable();
        if (!(0 <= index ? index < this.limit : false)) {
            throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds (0.." + (this.limit - 1) + ")");
        }
        this.array[index] = b;
        return this;
    }

    @NotNull
    public final ByteBuffer put(@NotNull ByteBuffer src) {
        int rem;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.checkWritable();
        int srcPos = src.position;
        int srcLim = src.limit;
        int srcRem = srcPos <= srcLim ? srcLim - srcPos : 0;
        int pos = this.position;
        int lim = this.limit;
        int n = rem = pos <= lim ? lim - pos : 0;
        if (srcRem > rem) {
            throw new BufferOverflowException(null, 1, null);
        }
        this.putBuffer(pos, src, srcPos, srcRem);
        this.position(pos + srcRem);
        src.position(srcPos + srcRem);
        return this;
    }

    @NotNull
    public final ByteBuffer putShort(short value) {
        this.checkWritable();
        if (this.remaining() < 2) {
            throw new BufferOverflowException("Not enough space to write 2 bytes at position " + this.position + " with limit " + this.limit);
        }
        if (Intrinsics.areEqual((Object)this.order(), (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
            this.array[this.position] = (byte)(value >> 8);
            this.array[this.position + 1] = (byte)value;
        } else {
            this.array[this.position] = (byte)value;
            this.array[this.position + 1] = (byte)(value >> 8);
        }
        this.setPosition(this.position + 2);
        return this;
    }

    @NotNull
    public final ByteBuffer putInt(int value) {
        this.checkWritable();
        if (this.remaining() < 4) {
            throw new BufferOverflowException("Not enough space to write 4 bytes at position " + this.position + " with limit " + this.limit);
        }
        if (Intrinsics.areEqual((Object)this.order(), (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
            this.array[this.position] = (byte)(value >> 24);
            this.array[this.position + 1] = (byte)(value >> 16);
            this.array[this.position + 2] = (byte)(value >> 8);
            this.array[this.position + 3] = (byte)value;
        } else {
            this.array[this.position] = (byte)value;
            this.array[this.position + 1] = (byte)(value >> 8);
            this.array[this.position + 2] = (byte)(value >> 16);
            this.array[this.position + 3] = (byte)(value >> 24);
        }
        this.setPosition(this.position + 4);
        return this;
    }

    public final void putBuffer(int pos, @NotNull ByteBuffer src, int srcPos, int n) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.checkWritable();
        for (int i = 0; i < n; ++i) {
            byte b = src.get(srcPos + i);
            this.put(pos + i, b);
        }
    }

    @NotNull
    public final ByteBuffer get(@NotNull byte[] dst, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!(offset >= 0 && length >= 0 && offset + length <= dst.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length > this.remaining()) {
            throw new BufferUnderflowException("Not enough bytes remaining to read " + length + " bytes (only " + this.remaining() + " available)");
        }
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.get();
        }
        return this;
    }

    public static /* synthetic */ ByteBuffer get$default(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteBuffer.get(byArray, n, n2);
    }

    @NotNull
    public final ByteBuffer put(@NotNull byte[] src, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.checkWritable();
        if (!(offset >= 0 && length >= 0 && offset + length <= src.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length > this.remaining()) {
            throw new BufferOverflowException("Not enough space remaining to write " + length + " bytes (only " + this.remaining() + " available)");
        }
        for (int i = 0; i < length; ++i) {
            this.put(src[offset + i]);
        }
        return this;
    }

    public static /* synthetic */ ByteBuffer put$default(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return byteBuffer.put(byArray, n, n2);
    }

    public final long getLong(int index) {
        if (index < 0 || this.limit - index < 8) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds: need 8 bytes from index (limit: " + this.limit + ")");
        }
        return Intrinsics.areEqual((Object)this.order(), (Object)ByteOrder.Companion.getBIG_ENDIAN()) ? ((long)this.array[index] & 0xFFL) << 56 | ((long)this.array[index + 1] & 0xFFL) << 48 | ((long)this.array[index + 2] & 0xFFL) << 40 | ((long)this.array[index + 3] & 0xFFL) << 32 | ((long)this.array[index + 4] & 0xFFL) << 24 | ((long)this.array[index + 5] & 0xFFL) << 16 | ((long)this.array[index + 6] & 0xFFL) << 8 | (long)this.array[index + 7] & 0xFFL : (long)this.array[index] & 0xFFL | ((long)this.array[index + 1] & 0xFFL) << 8 | ((long)this.array[index + 2] & 0xFFL) << 16 | ((long)this.array[index + 3] & 0xFFL) << 24 | ((long)this.array[index + 4] & 0xFFL) << 32 | ((long)this.array[index + 5] & 0xFFL) << 40 | ((long)this.array[index + 6] & 0xFFL) << 48 | ((long)this.array[index + 7] & 0xFFL) << 56;
    }

    public final long getLong() {
        if (this.remaining() < 8) {
            throw new BufferUnderflowException("Not enough bytes remaining to read a long (need 8, have " + this.remaining() + ")");
        }
        long value = this.getLong(this.position);
        this.setPosition(this.position + 8);
        return value;
    }

    @NotNull
    public final ByteBuffer putLong(long value) {
        this.checkWritable();
        if (this.remaining() < 8) {
            throw new BufferOverflowException("Not enough space to write 8 bytes at position " + this.position + " with limit " + this.limit);
        }
        if (Intrinsics.areEqual((Object)this.order(), (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
            this.array[this.position] = (byte)(value >> 56);
            this.array[this.position + 1] = (byte)(value >> 48);
            this.array[this.position + 2] = (byte)(value >> 40);
            this.array[this.position + 3] = (byte)(value >> 32);
            this.array[this.position + 4] = (byte)(value >> 24);
            this.array[this.position + 5] = (byte)(value >> 16);
            this.array[this.position + 6] = (byte)(value >> 8);
            this.array[this.position + 7] = (byte)value;
        } else {
            this.array[this.position] = (byte)value;
            this.array[this.position + 1] = (byte)(value >> 8);
            this.array[this.position + 2] = (byte)(value >> 16);
            this.array[this.position + 3] = (byte)(value >> 24);
            this.array[this.position + 4] = (byte)(value >> 32);
            this.array[this.position + 5] = (byte)(value >> 40);
            this.array[this.position + 6] = (byte)(value >> 48);
            this.array[this.position + 7] = (byte)(value >> 56);
        }
        this.setPosition(this.position + 8);
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    @NotNull
    public final ByteBuffer mark() {
        this.mark = this.position;
        return this;
    }

    @NotNull
    public final ByteBuffer reset() {
        if (this.mark == -1) {
            throw new IOException("Mark has not been set");
        }
        this.setPosition(this.mark);
        return this;
    }

    @NotNull
    public final ByteBuffer clear() {
        this.setPosition(0);
        this.setLimit(this.capacity);
        this.mark = -1;
        return this;
    }

    @NotNull
    public final ByteBuffer flip() {
        this.setLimit(this.position);
        this.setPosition(0);
        this.mark = -1;
        return this;
    }

    @NotNull
    public final ByteBuffer rewind() {
        this.setPosition(0);
        this.mark = -1;
        return this;
    }

    @NotNull
    public final ByteBuffer duplicate() {
        ByteBuffer dup = new ByteBuffer(this.array, this.capacity);
        dup.setPosition(this.position);
        dup.setLimit(this.limit);
        dup.bigEndian = this.bigEndian;
        dup.nativeByteOrder = this.nativeByteOrder;
        dup._readOnly = this._readOnly;
        return dup;
    }

    @NotNull
    public final ByteBuffer slice() {
        int remaining = this.remaining();
        byte[] sliceArray = ArraysKt.copyOfRange((byte[])this.array, (int)this.position, (int)this.limit);
        ByteBuffer bb = new ByteBuffer(sliceArray, remaining);
        bb.clear();
        bb.setLimit(remaining);
        return bb;
    }

    @Override
    public int compareTo(@NotNull ByteBuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = Math.min(this.remaining(), other.remaining());
        for (int i = 0; i < n; ++i) {
            int cmp = (this.get(this.position + i) & 0xFF) - (other.get(other.position + i) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.remaining() - other.remaining();
    }

    @NotNull
    public final ByteBuffer asReadOnlyBuffer() {
        ByteBuffer dup = this.duplicate();
        dup._readOnly = true;
        dup.order(this.order());
        return dup;
    }

    @NotNull
    public final IntBuffer asIntBuffer() {
        int intCapacity = this.remaining() / 4;
        if (intCapacity <= 0) {
            IntBuffer intBuffer;
            IntBuffer $this$asIntBuffer_u24lambda_u242 = intBuffer = IntBuffer.Companion.allocate(0);
            boolean bl = false;
            $this$asIntBuffer_u24lambda_u242.setOrder(this.order());
            return intBuffer;
        }
        ByteBuffer slice = this.duplicate();
        slice.position(this.position);
        slice.limit(this.position + intCapacity * 4);
        IntBuffer intBuffer = IntBuffer.Companion.allocate(intCapacity);
        intBuffer.clear();
        intBuffer.setOrder(this.order());
        for (int i = 0; i < intCapacity; ++i) {
            int value = slice.getInt();
            intBuffer.put(value);
        }
        intBuffer.flip();
        return intBuffer;
    }

    @NotNull
    public final LongBuffer asLongBuffer() {
        int longCapacity = this.remaining() / 8;
        if (longCapacity <= 0) {
            LongBuffer longBuffer;
            LongBuffer $this$asLongBuffer_u24lambda_u243 = longBuffer = LongBuffer.Companion.allocate(0);
            boolean bl = false;
            $this$asLongBuffer_u24lambda_u243.setOrder(this.order());
            return longBuffer;
        }
        ByteBuffer slice = this.duplicate();
        slice.position(this.position);
        slice.limit(this.position + longCapacity * 8);
        LongBuffer longBuffer = LongBuffer.Companion.allocate(longCapacity);
        longBuffer.clear();
        longBuffer.setOrder(this.order());
        for (int i = 0; i < longCapacity; ++i) {
            long value = slice.getLong();
            longBuffer.put(value);
        }
        longBuffer.flip();
        return longBuffer;
    }

    @NotNull
    public final FloatBuffer asFloatBuffer() {
        int floatCapacity = this.remaining() / 4;
        if (floatCapacity <= 0) {
            FloatBuffer floatBuffer;
            FloatBuffer $this$asFloatBuffer_u24lambda_u244 = floatBuffer = FloatBuffer.Companion.allocate(0);
            boolean bl = false;
            $this$asFloatBuffer_u24lambda_u244.setOrder(this.order());
            return floatBuffer;
        }
        ByteBuffer slice = this.duplicate();
        slice.position(this.position);
        slice.limit(this.position + floatCapacity * 4);
        FloatBuffer floatBuffer = FloatBuffer.Companion.allocate(floatCapacity);
        floatBuffer.clear();
        floatBuffer.setOrder(this.order());
        float[] floatArray = new float[floatCapacity];
        for (int i = 0; i < floatCapacity; ++i) {
            int bits = Intrinsics.areEqual((Object)this.order(), (Object)ByteOrder.Companion.getBIG_ENDIAN()) ? (slice.get() & 0xFF) << 24 | (slice.get() & 0xFF) << 16 | (slice.get() & 0xFF) << 8 | slice.get() & 0xFF : slice.get() & 0xFF | (slice.get() & 0xFF) << 8 | (slice.get() & 0xFF) << 16 | (slice.get() & 0xFF) << 24;
            floatArray[i] = Float.intBitsToFloat(bits);
        }
        floatBuffer.put(floatArray);
        floatBuffer.flip();
        return floatBuffer;
    }

    @NotNull
    public final ByteBuffer compact() {
        this.checkWritable();
        int rem = this.remaining();
        if (rem > 0) {
            for (int i = 0; i < rem; ++i) {
                this.array[i] = this.array[this.position + i];
            }
        }
        this.setPosition(rem);
        this.setLimit(this.capacity);
        this.mark = -1;
        return this;
    }

    @NotNull
    public String toString() {
        return "ByteBuffer[pos=" + this.position + " lim=" + this.limit + " cap=" + this.capacity + "]";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ByteBuffer)) {
            return false;
        }
        int thisRemaining = this.remaining();
        if (thisRemaining != ((ByteBuffer)other).remaining()) {
            return false;
        }
        for (int i = 0; i < thisRemaining; ++i) {
            if (this.get(this.position + i) == ((ByteBuffer)other).get(((ByteBuffer)other).position + i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        int end = this.position + this.remaining();
        for (int i = this.position; i < end; ++i) {
            result = 31 * result + this.get(i);
        }
        return result;
    }

    public /* synthetic */ ByteBuffer(byte[] array, int capacity, DefaultConstructorMarker $constructor_marker) {
        this(array, capacity);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/ByteBuffer$Companion;", "", "<init>", "()V", "allocate", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "capacity", "", "wrap", "array", "", "offset", "length", "core"})
    @SourceDebugExtension(value={"SMAP\nByteBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteBuffer.kt\norg/gnit/lucenekmp/jdkport/ByteBuffer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,935:1\n1#2:936\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteBuffer allocate(int capacity) {
            if (!(capacity >= 0)) {
                boolean bl = false;
                String string = "Capacity must be non-negative";
                throw new IllegalArgumentException(string.toString());
            }
            byte[] backing = new byte[capacity];
            return new ByteBuffer(backing, capacity, null).clear();
        }

        @NotNull
        public final ByteBuffer wrap(@NotNull byte[] array, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (!(0 <= offset ? offset <= array.length : false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(0 <= length ? length <= array.length - offset : false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ByteBuffer bb = new ByteBuffer(array, array.length, null);
            bb.setPosition(offset);
            bb.setLimit(offset + length);
            return bb;
        }

        public static /* synthetic */ ByteBuffer wrap$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length - n;
            }
            return companion.wrap(byArray, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

