/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.BufferOverflowException;
import org.gnit.lucenekmp.jdkport.BufferUnderflowException;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.ReadOnlyBufferException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 E2\u00020\u00012\u00060\u0002j\u0002`\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0001EB+\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\bJ\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bJ\u001e\u0010\u001a\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bJ\u001e\u0010\u001c\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000J&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010$\u001a\u00020+J\u001e\u0010\u001c\u001a\u00020\u00002\u0006\u0010$\u001a\u00020+2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bJ\u0006\u0010.\u001a\u00020\bJ\u0006\u0010/\u001a\u00020\u000bJ\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u0006\u00102\u001a\u00020\u0000J\u0006\u00103\u001a\u00020\u0000J\u0006\u00104\u001a\u00020\u0000J\u0006\u00105\u001a\u00020\u0000J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\bH\u0096\u0002J\u0018\u00107\u001a\u00020\u00012\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\bH\u0016J\b\u0010:\u001a\u00020+H\u0016J\u0016\u0010;\u001a\u00060\u0002j\u0002`\u00032\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u0016J&\u0010;\u001a\u00060\u0002j\u0002`\u00032\b\u0010<\u001a\u0004\u0018\u00010\u00012\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0016J\u0014\u0010;\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\u0006\u0010=\u001a\u00020\u000bJ\u0006\u0010>\u001a\u00020\u000bJ\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010?\u001a\u00020\u0000J\u0011\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010B\u001a\u00020\u000b2\b\u0010A\u001a\u0004\u0018\u00010CH\u0096\u0002J\b\u0010D\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0013R\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u000f\u00a8\u0006F"}, d2={"Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "", "array", "", "arrayOffset", "", "capacity", "readOnly", "", "<init>", "([CIIZ)V", "getCapacity", "()I", "position", "getPosition", "setPosition", "(I)V", "limit", "getLimit", "setLimit", "value", "mark", "getMark", "get", "", "put", "c", "getAbsolute", "index", "putAbsolute", "dst", "dstOffset", "length", "src", "srcOffset", "putBuffer", "", "pos", "srcPos", "n", "", "start", "end", "remaining", "hasRemaining", "clear", "flip", "slice", "duplicate", "compact", "asReadOnlyBuffer", "getLength", "subSequence", "startIndex", "endIndex", "toString", "append", "csq", "isReadOnly", "hasArray", "reset", "compareTo", "other", "equals", "", "hashCode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharBuffer.kt\norg/gnit/lucenekmp/jdkport/CharBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,497:1\n1#2:498\n*E\n"})
public final class CharBuffer
implements CharSequence,
Appendable,
Comparable<CharBuffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final char[] array;
    private final int arrayOffset;
    private final int capacity;
    private boolean readOnly;
    private int position;
    private int limit;
    private int mark;

    private CharBuffer(char[] array, int arrayOffset, int capacity, boolean readOnly) {
        this.array = array;
        this.arrayOffset = arrayOffset;
        this.capacity = capacity;
        this.readOnly = readOnly;
        this.limit = this.capacity;
        this.mark = -1;
    }

    /* synthetic */ CharBuffer(char[] cArray, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(cArray, n, n2, bl);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public final int getMark() {
        return this.mark;
    }

    public final char get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException("No more characters");
        }
        int n = this.position;
        this.position = n + 1;
        return this.array[this.arrayOffset + n];
    }

    @NotNull
    public final CharBuffer put(char c) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException("Buffer is read-only");
        }
        if (this.position >= this.limit) {
            throw new BufferOverflowException("No space remaining");
        }
        int n = this.position;
        this.position = n + 1;
        this.array[this.arrayOffset + n] = c;
        return this;
    }

    public final char getAbsolute(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds (limit: " + this.limit + ")");
        }
        return this.array[this.arrayOffset + index];
    }

    @NotNull
    public final CharBuffer putAbsolute(int index, char c) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException("Buffer is read-only");
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds (limit: " + this.limit + ")");
        }
        this.array[this.arrayOffset + index] = c;
        return this;
    }

    @NotNull
    public final CharBuffer get(@NotNull char[] dst, int dstOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Objects.INSTANCE.checkFromIndexSize(dstOffset, length, dst.length);
        if (length == 0) {
            return this;
        }
        if (length > this.remaining()) {
            throw new BufferUnderflowException("Requested " + length + " characters, but only " + this.remaining() + " remain in the buffer.");
        }
        for (int i = 0; i < length; ++i) {
            dst[dstOffset + i] = this.get();
        }
        return this;
    }

    @NotNull
    public final CharBuffer put(@NotNull char[] src, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (this.readOnly) {
            throw new ReadOnlyBufferException("Buffer is read-only");
        }
        Objects.INSTANCE.checkFromIndexSize(srcOffset, length, src.length);
        if (length == 0) {
            return this;
        }
        if (length > this.remaining()) {
            throw new BufferOverflowException("Requested put of " + length + " characters, but only " + this.remaining() + " space remains.");
        }
        for (int i = 0; i < length; ++i) {
            this.put(src[srcOffset + i]);
        }
        return this;
    }

    @NotNull
    public final CharBuffer put(@NotNull CharBuffer src) {
        int rem;
        int srcLim;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (src == this) {
            throw new Exception("createSameBuffer");
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException(null, 1, null);
        }
        int srcPos = src.position();
        int srcRem = srcPos <= (srcLim = src.limit) ? srcLim - srcPos : 0;
        int pos = this.position();
        int lim = this.limit;
        int n = rem = pos <= lim ? lim - pos : 0;
        if (srcRem > rem) {
            throw new BufferOverflowException(null, 1, null);
        }
        this.putBuffer(pos, src, srcPos, srcRem);
        this.position = pos + srcRem;
        src.position = srcPos + srcRem;
        return this;
    }

    public final void putBuffer(int pos, @NotNull CharBuffer src, int srcPos, int n) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        for (int i = 0; i < n; ++i) {
            this.putAbsolute(pos + i, src.getAbsolute(srcPos + i));
        }
    }

    @NotNull
    public final CharBuffer put(@NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.put(src, 0, src.length());
    }

    @NotNull
    public final CharBuffer put(@NotNull String src, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Objects.INSTANCE.checkFromIndexSize(start, end - start, src.length());
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException(null, 1, null);
        }
        if (end - start > this.remaining()) {
            throw new BufferOverflowException(null, 1, null);
        }
        for (int i = start; i < end; ++i) {
            this.put(src.charAt(i));
        }
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    @NotNull
    public final CharBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @NotNull
    public final CharBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    @NotNull
    public final CharBuffer slice() {
        CharBuffer charBuffer;
        int rem = this.remaining();
        CharBuffer $this$slice_u24lambda_u240 = charBuffer = new CharBuffer(this.array, this.arrayOffset + this.position, rem, this.readOnly);
        boolean bl = false;
        $this$slice_u24lambda_u240.position = 0;
        $this$slice_u24lambda_u240.limit = rem;
        return charBuffer;
    }

    @NotNull
    public final CharBuffer duplicate() {
        CharBuffer charBuffer;
        CharBuffer $this$duplicate_u24lambda_u241 = charBuffer = new CharBuffer(this.array, this.arrayOffset, this.capacity, this.readOnly);
        boolean bl = false;
        $this$duplicate_u24lambda_u241.position = this.position;
        $this$duplicate_u24lambda_u241.limit = this.limit;
        $this$duplicate_u24lambda_u241.mark = this.mark;
        return charBuffer;
    }

    @NotNull
    public final CharBuffer compact() {
        if (this.readOnly) {
            throw new ReadOnlyBufferException("Buffer is read-only");
        }
        int rem = this.remaining();
        for (int i = 0; i < rem; ++i) {
            this.array[this.arrayOffset + i] = this.array[this.arrayOffset + this.position + i];
        }
        this.position = rem;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @NotNull
    public final CharBuffer asReadOnlyBuffer() {
        CharBuffer charBuffer;
        CharBuffer $this$asReadOnlyBuffer_u24lambda_u242 = charBuffer = this.duplicate();
        boolean bl = false;
        $this$asReadOnlyBuffer_u24lambda_u242.readOnly = true;
        return charBuffer;
    }

    public int getLength() {
        return this.remaining();
    }

    public char get(int index) {
        if (index < 0 || index >= this.remaining()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds (remaining: " + this.remaining() + ")");
        }
        return this.array[this.arrayOffset + this.position + index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > this.remaining() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("Invalid subsequence range");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            sb.append(this.charAt(i));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Object)this.subSequence(0, this.remaining())).toString();
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence csq) {
        CharSequence charSequence = csq;
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
            charSequence = "null";
        }
        CharSequence s = charSequence;
        int n = ((String)s).length();
        for (int i = 0; i < n; ++i) {
            char c = ((String)s).charAt(i);
            this.put(c);
        }
        return this;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence csq, int start, int end) {
        CharSequence charSequence = csq;
        if (charSequence == null || (charSequence = charSequence.subSequence(start, end)) == null || (charSequence = ((Object)charSequence).toString()) == null) {
            String string = "null".substring(start, end);
            charSequence = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        }
        CharSequence s = charSequence;
        return this.append(s);
    }

    @Override
    @NotNull
    public Appendable append(char c) {
        return this.put(c);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean hasArray() {
        return !(this.array.length == 0) && !this.readOnly;
    }

    public final int arrayOffset() {
        return this.arrayOffset;
    }

    @NotNull
    public final char[] array() {
        if (this.readOnly) {
            throw new ReadOnlyBufferException("Buffer is read-only");
        }
        return this.array;
    }

    public final int position() {
        return this.position;
    }

    @NotNull
    public final CharBuffer mark() {
        this.mark = this.position;
        return this;
    }

    @NotNull
    public final CharBuffer reset() {
        if (this.mark == -1) {
            throw new IllegalStateException("Mark has not been set");
        }
        this.position = this.mark;
        return this;
    }

    @Override
    public int compareTo(@NotNull CharBuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = Math.min(this.remaining(), other.remaining());
        for (int i = 0; i < n; ++i) {
            int cmp = Intrinsics.compare((int)this.getAbsolute(this.position + i), (int)other.getAbsolute(other.position + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.remaining() - other.remaining();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CharBuffer)) {
            return false;
        }
        if (this.remaining() != ((CharBuffer)other).remaining()) {
            return false;
        }
        int n = this.remaining();
        for (int i = 0; i < n; ++i) {
            if (this.getAbsolute(this.position + i) == ((CharBuffer)other).getAbsolute(((CharBuffer)other).position + i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        int rem = this.remaining();
        for (int i = 0; i < rem; ++i) {
            result = 31 * result + Character.hashCode(this.getAbsolute(this.position + i));
        }
        return result;
    }

    public /* synthetic */ CharBuffer(char[] array, int arrayOffset, int capacity, boolean readOnly, DefaultConstructorMarker $constructor_marker) {
        this(array, arrayOffset, capacity, readOnly);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/jdkport/CharBuffer$Companion;", "", "<init>", "()V", "allocate", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "capacity", "", "wrap", "array", "", "offset", "length", "csq", "", "start", "end", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CharBuffer allocate(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException("Capacity must be non-negative");
            }
            return new CharBuffer(new char[capacity], 0, capacity, false, 8, null);
        }

        @NotNull
        public final CharBuffer wrap(@NotNull char[] array, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (offset < 0 || length < 0 || offset + length > array.length) {
                throw new IndexOutOfBoundsException("Invalid offset or length");
            }
            return new CharBuffer(array, offset, length, false, 8, null);
        }

        public static /* synthetic */ CharBuffer wrap$default(Companion companion, char[] cArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = cArray.length - n;
            }
            return companion.wrap(cArray, n, n2);
        }

        @NotNull
        public final CharBuffer wrap(@NotNull CharSequence csq, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
            if (start < 0 || end < start || end > csq.length()) {
                throw new IndexOutOfBoundsException("Invalid start or end");
            }
            String s = ((Object)csq.subSequence(start, end)).toString();
            char[] cArray = s.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            return new CharBuffer(cArray, 0, s.length(), true, null);
        }

        public static /* synthetic */ CharBuffer wrap$default(Companion companion, CharSequence charSequence, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = charSequence.length();
            }
            return companion.wrap(charSequence, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

