/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CharsetEncoder;
import org.gnit.lucenekmp.jdkport.CodingErrorAction;
import org.gnit.lucenekmp.jdkport.ISO_8859_1;
import org.gnit.lucenekmp.jdkport.Ported;
import org.gnit.lucenekmp.jdkport.UTF_8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.nio.charset.Charset")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b'\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H&J\b\u0010\f\u001a\u00020\rH&J\b\u0010\u000e\u001a\u00020\u000fH&J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/jdkport/Charset;", "", "canonicalName", "", "aliases", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "name", "contains", "", "cs", "newDecoder", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "newEncoder", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "decode", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "bb", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "encode", "cb", "compareTo", "", "other", "equals", "", "hashCode", "toString", "Companion", "core"})
public abstract class Charset
implements Comparable<Charset> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String canonicalName;
    @NotNull
    private final Set<String> aliases;
    @NotNull
    private static final Charset UTF_8 = new UTF_8();
    @NotNull
    private static final Charset ISO_8859_1 = new ISO_8859_1();

    protected Charset(@NotNull String canonicalName, @NotNull Set<String> aliases) {
        Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
        Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
        this.canonicalName = canonicalName;
        this.aliases = aliases;
    }

    public /* synthetic */ Charset(String string, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, set);
    }

    @NotNull
    public final String name() {
        return this.canonicalName;
    }

    public abstract boolean contains(@NotNull Charset var1);

    @NotNull
    public abstract CharsetDecoder newDecoder();

    @NotNull
    public abstract CharsetEncoder newEncoder();

    @NotNull
    public final CharBuffer decode(@NotNull ByteBuffer bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        return this.newDecoder().onMalformedInput(CodingErrorAction.Companion.getREPLACE()).onUnmappableCharacter(CodingErrorAction.Companion.getREPLACE()).decode(bb);
    }

    @NotNull
    public final ByteBuffer encode(@NotNull CharBuffer cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        return this.newEncoder().onMalformedInput(CodingErrorAction.Companion.getREPLACE()).onUnmappableCharacter(CodingErrorAction.Companion.getREPLACE()).encode(cb);
    }

    @Override
    public int compareTo(@NotNull Charset other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return StringsKt.compareTo((String)this.canonicalName, (String)other.canonicalName, (boolean)true);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Charset && StringsKt.equals((String)this.canonicalName, (String)((Charset)other).canonicalName, (boolean)true);
    }

    public int hashCode() {
        String string = this.canonicalName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string.hashCode();
    }

    @NotNull
    public String toString() {
        return this.canonicalName;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/jdkport/Charset$Companion;", "", "<init>", "()V", "UTF_8", "Lorg/gnit/lucenekmp/jdkport/Charset;", "getUTF_8", "()Lorg/gnit/lucenekmp/jdkport/Charset;", "ISO_8859_1", "getISO_8859_1", "defaultCharset", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Charset getUTF_8() {
            return UTF_8;
        }

        @NotNull
        public final Charset getISO_8859_1() {
            return ISO_8859_1;
        }

        @NotNull
        public final Charset defaultCharset() {
            return this.getUTF_8();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

