/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.nio.charset.CharacterCodingException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.ArraysSupport;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CoderMalfunctionError;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.CodingErrorAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b&\u0018\u0000 /2\u00020\u0001:\u0001/B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000eH\u0004J\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000eH\u0004J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0006\u0010%\u001a\u00020\u0000J\b\u0010&\u001a\u00020\u0015H\u0014J\u001a\u0010'\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H$J\u000e\u0010\u001b\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010+\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011H\u0002R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010)\u00a8\u00060"}, d2={"Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "averageCharsPerByte", "", "maxCharsPerByte", "replacement", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;FFLjava/lang/String;)V", "(Lorg/gnit/lucenekmp/jdkport/Charset;FF)V", "charset", "malformedInputAction", "Lorg/gnit/lucenekmp/jdkport/CodingErrorAction;", "unmappableCharacterAction", "state", "", "replaceWith", "newReplacement", "implReplaceWith", "", "onMalformedInput", "newAction", "implOnMalformedInput", "onUnmappableCharacter", "implOnUnmappableCharacter", "decode", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "in", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "out", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "endOfInput", "", "flush", "implFlush", "reset", "implReset", "decodeLoop", "isAutoDetecting", "()Z", "isCharsetDetected", "detectedCharset", "throwIllegalStateException", "from", "to", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharsetDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharsetDecoder.kt\norg/gnit/lucenekmp/jdkport/CharsetDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,860:1\n1#2:861\n*E\n"})
public abstract class CharsetDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset charset;
    private final float averageCharsPerByte;
    private final float maxCharsPerByte;
    @NotNull
    private String replacement;
    @NotNull
    private CodingErrorAction malformedInputAction;
    @NotNull
    private CodingErrorAction unmappableCharacterAction;
    private int state;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    @NotNull
    private static final String[] stateNames;

    public CharsetDecoder(@NotNull Charset cs, float averageCharsPerByte, float maxCharsPerByte, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        this.charset = cs;
        this.malformedInputAction = CodingErrorAction.Companion.getREPORT();
        this.unmappableCharacterAction = CodingErrorAction.Companion.getREPORT();
        if (!(averageCharsPerByte > 0.0f)) {
            boolean $i$a$-require-CharsetDecoder$42 = false;
            String $i$a$-require-CharsetDecoder$42 = "Non-positive averageCharsPerByte";
            throw new IllegalArgumentException($i$a$-require-CharsetDecoder$42.toString());
        }
        if (!(maxCharsPerByte > 0.0f)) {
            boolean $i$a$-require-CharsetDecoder$52 = false;
            String $i$a$-require-CharsetDecoder$52 = "Non-positive maxCharsPerByte";
            throw new IllegalArgumentException($i$a$-require-CharsetDecoder$52.toString());
        }
        if (!(!(averageCharsPerByte > maxCharsPerByte))) {
            boolean bl = false;
            String string = "averageCharsPerByte exceeds maxCharsPerByte";
            throw new IllegalArgumentException(string.toString());
        }
        this.replacement = replacement;
        this.averageCharsPerByte = averageCharsPerByte;
        this.maxCharsPerByte = maxCharsPerByte;
        this.replaceWith(replacement);
    }

    protected CharsetDecoder(@NotNull Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this(cs, averageCharsPerByte, maxCharsPerByte, "\ufffd");
    }

    @NotNull
    public final Charset charset() {
        return this.charset;
    }

    @NotNull
    public final String replacement() {
        return this.replacement;
    }

    @NotNull
    public final CharsetDecoder replaceWith(@NotNull String newReplacement) {
        Intrinsics.checkNotNullParameter((Object)newReplacement, (String)"newReplacement");
        int len = newReplacement.length();
        if (!(len != 0)) {
            boolean $i$a$-require-CharsetDecoder$replaceWith$42 = false;
            String $i$a$-require-CharsetDecoder$replaceWith$42 = "Empty replacement";
            throw new IllegalArgumentException($i$a$-require-CharsetDecoder$replaceWith$42.toString());
        }
        if (!(!((float)len > this.maxCharsPerByte))) {
            boolean bl = false;
            String string = "Replacement too long";
            throw new IllegalArgumentException(string.toString());
        }
        this.replacement = newReplacement;
        this.implReplaceWith(this.replacement);
        return this;
    }

    protected void implReplaceWith(@NotNull String newReplacement) {
        Intrinsics.checkNotNullParameter((Object)newReplacement, (String)"newReplacement");
    }

    @NotNull
    public final CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    @NotNull
    public final CharsetDecoder onMalformedInput(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    protected final void implOnMalformedInput(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
    }

    @NotNull
    public final CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    @NotNull
    public final CharsetDecoder onUnmappableCharacter(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    protected final void implOnUnmappableCharacter(@NotNull CodingErrorAction newAction) {
        Intrinsics.checkNotNullParameter((Object)newAction, (String)"newAction");
    }

    public final float averageCharsPerByte() {
        return this.averageCharsPerByte;
    }

    public final float maxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    @NotNull
    public final CoderResult decode(@NotNull ByteBuffer in, @NotNull CharBuffer out, boolean endOfInput) {
        int newState;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = newState = endOfInput ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || endOfInput && this.state == 2)) {
            this.throwIllegalStateException(this.state, newState);
        }
        this.state = newState;
        while (true) {
            CoderResult cr = null;
            try {
                cr = this.decodeLoop(in, out);
            }
            catch (RuntimeException x) {
                throw new CoderMalfunctionError(x);
            }
            CoderResult coderResult = cr;
            Intrinsics.checkNotNull((Object)coderResult);
            if (coderResult.isOverflow()) {
                return cr;
            }
            if (cr.isUnderflow()) {
                if (endOfInput && in.hasRemaining()) {
                    cr = CoderResult.Companion.malformedForLength(in.remaining());
                } else {
                    return cr;
                }
            }
            CodingErrorAction action = null;
            CoderResult coderResult2 = cr;
            Intrinsics.checkNotNull((Object)coderResult2);
            if (coderResult2.isMalformed()) {
                action = this.malformedInputAction;
            } else if (cr.isUnmappable()) {
                action = this.unmappableCharacterAction;
            } else {
                boolean bl = false;
                String string = cr.toString();
                throw new IllegalArgumentException(string.toString());
            }
            if (action == CodingErrorAction.Companion.getREPORT()) {
                return cr;
            }
            if (action == CodingErrorAction.Companion.getREPLACE()) {
                if (out.remaining() < this.replacement.length()) {
                    return CoderResult.Companion.getOVERFLOW();
                }
                out.put(this.replacement);
            }
            if (action != CodingErrorAction.Companion.getIGNORE() && action != CodingErrorAction.Companion.getREPLACE()) break;
            in.position(in.getPosition() + cr.length());
        }
        String string = "Failed requirement.";
        throw new IllegalArgumentException(string.toString());
    }

    @NotNull
    public final CoderResult flush(@NotNull CharBuffer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (this.state == 2) {
            CoderResult cr = this.implFlush(out);
            if (cr.isUnderflow()) {
                this.state = 3;
            }
            return cr;
        }
        if (this.state != 3) {
            this.throwIllegalStateException(this.state, 3);
        }
        return CoderResult.Companion.getUNDERFLOW();
    }

    @NotNull
    protected CoderResult implFlush(@NotNull CharBuffer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return CoderResult.Companion.getUNDERFLOW();
    }

    @NotNull
    public final CharsetDecoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    @Nullable
    protected abstract CoderResult decodeLoop(@NotNull ByteBuffer var1, @NotNull CharBuffer var2);

    @NotNull
    public final CharBuffer decode(@NotNull ByteBuffer in) throws CharacterCodingException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int n = Math.min((int)((float)in.remaining() * this.averageCharsPerByte()), 0x7FFFFFF7);
        CharBuffer out = CharBuffer.Companion.allocate(n);
        if (n == 0 && in.remaining() == 0) {
            return out;
        }
        this.reset();
        while (true) {
            CoderResult cr;
            CoderResult coderResult = cr = in.hasRemaining() ? this.decode(in, out, true) : CoderResult.Companion.getUNDERFLOW();
            if (cr.isUnderflow()) {
                cr = this.flush(out);
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow()) {
                n = ArraysSupport.INSTANCE.newLength(n, Math.min(n + 1, 1024), n + 1);
                CharBuffer o = CharBuffer.Companion.allocate(n);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        out.flip();
        return out;
    }

    public boolean isAutoDetecting() {
        return false;
    }

    public boolean isCharsetDetected() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Charset detectedCharset() {
        throw new UnsupportedOperationException();
    }

    private final void throwIllegalStateException(int from, int to) {
        throw new IllegalStateException("Current state = " + stateNames[from] + ", new state = " + stateNames[to]);
    }

    static {
        String[] stringArray = new String[]{"RESET", "CODING", "CODING_END", "FLUSHED"};
        stateNames = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/CharsetDecoder$Companion;", "", "<init>", "()V", "ST_RESET", "", "ST_CODING", "ST_END", "ST_FLUSHED", "stateNames", "", "", "[Ljava/lang/String;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

