/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Checksum;
import org.gnit.lucenekmp.jdkport.FilterOutputStream;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/jdkport/CheckedOutputStream;", "Lorg/gnit/lucenekmp/jdkport/FilterOutputStream;", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "cksum", "Lorg/gnit/lucenekmp/jdkport/Checksum;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;Lorg/gnit/lucenekmp/jdkport/Checksum;)V", "write", "", "b", "", "", "off", "len", "checksum", "getChecksum", "()Lorg/gnit/lucenekmp/jdkport/Checksum;", "core"})
public class CheckedOutputStream
extends FilterOutputStream {
    @NotNull
    private final Checksum cksum;

    public CheckedOutputStream(@NotNull OutputStream out, @NotNull Checksum cksum) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)cksum, (String)"cksum");
        super(out);
        this.cksum = cksum;
    }

    @Override
    public void write(int b) {
        OutputStream outputStream = this.getOut();
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(b);
        this.cksum.update(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        OutputStream outputStream = this.getOut();
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(b, off, len);
        this.cksum.update(b, off, len);
    }

    @NotNull
    public final Checksum getChecksum() {
        return this.cksum;
    }
}

