/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.BufferOverflowException;
import org.gnit.lucenekmp.jdkport.BufferUnderflowException;
import org.gnit.lucenekmp.jdkport.MalformedInputException;
import org.gnit.lucenekmp.jdkport.UnmappableCharacterException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/jdkport/CoderResult;", "", "type", "", "length", "<init>", "(II)V", "getLength", "()I", "toString", "", "isUnderflow", "", "()Z", "isOverflow", "isError", "isMalformed", "isUnmappable", "throwException", "", "Cache", "Companion", "core"})
public final class CoderResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int type;
    private final int length;
    private static final int CR_UNDERFLOW = 0;
    private static final int CR_OVERFLOW = 1;
    private static final int CR_ERROR_MIN = 2;
    private static final int CR_MALFORMED = 2;
    private static final int CR_UNMAPPABLE = 3;
    @NotNull
    private static final String[] names;
    @NotNull
    private static final CoderResult UNDERFLOW;
    @NotNull
    private static final CoderResult OVERFLOW;
    @NotNull
    private static final CoderResult[] malformed4;
    @NotNull
    private static final CoderResult[] unmappable4;

    private CoderResult(int type, int length) {
        this.type = type;
        this.length = length;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public String toString() {
        String nm = names[this.type];
        return this.isError() ? nm + "[" + this.length + "]" : nm;
    }

    public final boolean isUnderflow() {
        return this.type == 0;
    }

    public final boolean isOverflow() {
        return this.type == 1;
    }

    public final boolean isError() {
        return this.type >= 2;
    }

    public final boolean isMalformed() {
        return this.type == 2;
    }

    public final boolean isUnmappable() {
        return this.type == 3;
    }

    public final int length() {
        if (!this.isError()) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    public final void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw new BufferUnderflowException(null, 1, null);
            }
            case 1: {
                throw new BufferOverflowException(null, 1, null);
            }
            case 2: {
                throw new MalformedInputException(this.length);
            }
            case 3: {
                throw new UnmappableCharacterException(this.length);
            }
        }
        throw new Exception();
    }

    public /* synthetic */ CoderResult(int type, int length, DefaultConstructorMarker $constructor_marker) {
        this(type, length);
    }

    static {
        Object[] objectArray = new String[]{"UNDERFLOW", "OVERFLOW", "MALFORMED", "UNMAPPABLE"};
        names = objectArray;
        UNDERFLOW = new CoderResult(0, 0);
        OVERFLOW = new CoderResult(1, 0);
        objectArray = new CoderResult[]{new CoderResult(2, 1), new CoderResult(2, 2), new CoderResult(2, 3), new CoderResult(2, 4)};
        malformed4 = objectArray;
        objectArray = new CoderResult[]{new CoderResult(3, 1), new CoderResult(3, 2), new CoderResult(3, 3), new CoderResult(3, 4)};
        unmappable4 = objectArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/CoderResult$Cache;", "", "<init>", "()V", "unmappable", "", "", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "getUnmappable", "()Ljava/util/Map;", "malformed", "getMalformed", "Companion", "core"})
    private static final class Cache {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<Integer, CoderResult> unmappable = new HashMap();
        @NotNull
        private final Map<Integer, CoderResult> malformed = new HashMap();
        @NotNull
        private static final Cache INSTANCE = new Cache();

        @NotNull
        public final Map<Integer, CoderResult> getUnmappable() {
            return this.unmappable;
        }

        @NotNull
        public final Map<Integer, CoderResult> getMalformed() {
            return this.malformed;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/jdkport/CoderResult$Cache$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/gnit/lucenekmp/jdkport/CoderResult$Cache;", "getINSTANCE", "()Lorg/gnit/lucenekmp/jdkport/CoderResult$Cache;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Cache getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/jdkport/CoderResult$Companion;", "", "<init>", "()V", "CR_UNDERFLOW", "", "CR_OVERFLOW", "CR_ERROR_MIN", "CR_MALFORMED", "CR_UNMAPPABLE", "names", "", "", "[Ljava/lang/String;", "UNDERFLOW", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "getUNDERFLOW", "()Lorg/gnit/lucenekmp/jdkport/CoderResult;", "OVERFLOW", "getOVERFLOW", "malformed4", "[Lorg/gnit/lucenekmp/jdkport/CoderResult;", "malformedForLength", "length", "unmappable4", "unmappableForLength", "core"})
    @SourceDebugExtension(value={"SMAP\nCoderResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoderResult.kt\norg/gnit/lucenekmp/jdkport/CoderResult$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoderResult getUNDERFLOW() {
            return UNDERFLOW;
        }

        @NotNull
        public final CoderResult getOVERFLOW() {
            return OVERFLOW;
        }

        @Nullable
        public final CoderResult malformedForLength(int length) {
            if (!(length > 0)) {
                boolean bl = false;
                String string = "Non-positive length";
                throw new IllegalArgumentException(string.toString());
            }
            if (length <= 4) {
                return malformed4[length - 1];
            }
            return Cache.Companion.getINSTANCE().getMalformed().computeIfAbsent(length, arg_0 -> Companion.malformedForLength$lambda$2(Companion::malformedForLength$lambda$1, arg_0));
        }

        @NotNull
        public final CoderResult unmappableForLength(int length) {
            if (!(length > 0)) {
                boolean bl = false;
                String string = "Non-positive length";
                throw new IllegalArgumentException(string.toString());
            }
            if (length <= 4) {
                return unmappable4[length - 1];
            }
            CoderResult coderResult = Cache.Companion.getINSTANCE().getUnmappable().computeIfAbsent(length, arg_0 -> Companion.unmappableForLength$lambda$5(Companion::unmappableForLength$lambda$4, arg_0));
            Intrinsics.checkNotNull((Object)coderResult);
            return coderResult;
        }

        private static final CoderResult malformedForLength$lambda$1(int n) {
            return new CoderResult(2, n, null);
        }

        private static final CoderResult malformedForLength$lambda$2(Function1 $tmp0, Object p0) {
            return (CoderResult)$tmp0.invoke(p0);
        }

        private static final CoderResult unmappableForLength$lambda$4(int n) {
            return new CoderResult(3, n, null);
        }

        private static final CoderResult unmappableForLength$lambda$5(Function1 $tmp0, Object p0) {
            return (CoderResult)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

