/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/jdkport/FileSystemException;", "Ljava/io/IOException;", "Lokio/IOException;", "file", "", "<init>", "(Ljava/lang/String;)V", "other", "reason", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFile", "()Ljava/lang/String;", "otherFile", "getOtherFile", "getReason", "message", "getMessage", "core"})
public class FileSystemException
extends IOException {
    @NotNull
    private final String file;
    @Nullable
    private final String otherFile;

    @NotNull
    public final String getFile() {
        return this.file;
    }

    @Nullable
    public final String getOtherFile() {
        return this.otherFile;
    }

    public FileSystemException(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.otherFile = null;
    }

    public FileSystemException(@NotNull String file, @NotNull String other, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super(reason);
        this.file = file;
        this.otherFile = other;
    }

    @Nullable
    public final String getReason() {
        return super.getMessage();
    }

    @Override
    @Nullable
    public String getMessage() {
        if (this.file == null && this.otherFile == null) {
            return this.getReason();
        }
        StringBuilder sb = new StringBuilder();
        if (this.file != null) {
            sb.append(this.file);
        }
        if (this.otherFile != null) {
            sb.append(" -> ");
            sb.append(this.otherFile);
        }
        if (this.getReason() != null) {
            sb.append(": ");
            sb.append(this.getReason());
        }
        return sb.toString();
    }
}

