/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.gnit.lucenekmp.jdkport.BufferedReader;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.FileAlreadyExistsException;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.jdkport.InputStreamReader;
import org.gnit.lucenekmp.jdkport.OkioSinkOutputStream;
import org.gnit.lucenekmp.jdkport.OkioSourceInputStream;
import org.gnit.lucenekmp.jdkport.OpenOption;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StandardCopyOption;
import org.gnit.lucenekmp.jdkport.StandardOpenOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rJ/\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0\u0011\"\u00020%\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/jdkport/Files;", "", "<init>", "()V", "fileSystem", "Lokio/FileSystem;", "setFileSystem", "", "getFileSystem", "resetFileSystem", "newInputStream", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "path", "Lokio/Path;", "newOutputStream", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "options", "", "Lorg/gnit/lucenekmp/jdkport/OpenOption;", "(Lokio/Path;[Lorg/gnit/lucenekmp/jdkport/OpenOption;)Lorg/gnit/lucenekmp/jdkport/OutputStream;", "newBufferedReader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "charset", "Lorg/gnit/lucenekmp/jdkport/Charset;", "createDirectories", "createFile", "readAttributes", "Lokio/FileMetadata;", "creationTime", "", "(Lokio/Path;)Ljava/lang/Long;", "isDirectory", "", "size", "move", "source", "target", "Lorg/gnit/lucenekmp/jdkport/StandardCopyOption;", "(Lokio/Path;Lokio/Path;[Lorg/gnit/lucenekmp/jdkport/StandardCopyOption;)V", "delete", "newDirectoryStream", "Lkotlin/sequences/Sequence;", "core"})
@SourceDebugExtension(value={"SMAP\nFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Files.kt\norg/gnit/lucenekmp/jdkport/Files\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n*L\n1#1,191:1\n72#2:192\n58#2,4:194\n66#2,10:199\n62#2,3:209\n77#2,3:212\n95#3:193\n96#3:198\n*S KotlinDebug\n*F\n+ 1 Files.kt\norg/gnit/lucenekmp/jdkport/Files\n*L\n125#1:192\n125#1:194,4\n125#1:199,10\n125#1:209,3\n125#1:212,3\n125#1:193\n125#1:198\n*E\n"})
public final class Files {
    @NotNull
    public static final Files INSTANCE = new Files();
    @NotNull
    private static FileSystem fileSystem = FileSystem.SYSTEM;

    private Files() {
    }

    public final void setFileSystem(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Files.fileSystem = fileSystem;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return fileSystem;
    }

    public final void resetFileSystem() {
        fileSystem = FileSystem.SYSTEM;
    }

    @NotNull
    public final InputStream newInputStream(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BufferedSource source = Okio.buffer((Source)fileSystem.source(path));
        return new OkioSourceInputStream(source);
    }

    @NotNull
    public final OutputStream newOutputStream(@NotNull Path path, OpenOption ... options) {
        boolean truncate;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Set opts = ArraysKt.toSet((Object[])options);
        boolean defaulted = opts.isEmpty();
        boolean append = opts.contains(StandardOpenOption.APPEND);
        boolean createNew = opts.contains(StandardOpenOption.CREATE_NEW);
        boolean create2 = opts.contains(StandardOpenOption.CREATE) || defaulted;
        boolean bl = truncate = opts.contains(StandardOpenOption.TRUNCATE_EXISTING) || defaulted;
        if (append && truncate) {
            throw new IllegalArgumentException("APPEND and TRUNCATE_EXISTING cannot be used together");
        }
        Path parent = path.parent();
        if ((create2 || createNew) && parent != null && !fileSystem.exists(parent)) {
            this.createDirectories(parent);
        }
        boolean exists = fileSystem.exists(path);
        if (createNew) {
            BufferedSink bufferedSink;
            if (exists) {
                throw new FileAlreadyExistsException(path.toString());
            }
            try {
                bufferedSink = Okio.buffer((Sink)fileSystem.sink(path, true));
            }
            catch (Throwable e) {
                bufferedSink = Okio.buffer((Sink)fileSystem.sink(path));
            }
            BufferedSink sink = bufferedSink;
            return new OkioSinkOutputStream(sink);
        }
        if (append) {
            BufferedSink sink = Okio.buffer((Sink)fileSystem.appendingSink(path));
            return new OkioSinkOutputStream(sink);
        }
        if (!exists && !create2) {
            throw new IOException("File does not exist: " + path);
        }
        BufferedSink sink = Okio.buffer((Sink)fileSystem.sink(path));
        return new OkioSinkOutputStream(sink);
    }

    @NotNull
    public final OutputStream newOutputStream(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OpenOption[] openOptionArray = new OpenOption[]{};
        return this.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    @NotNull
    public final Reader newBufferedReader(@NotNull Path path, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        InputStream inputStream = this.newInputStream(path);
        CharsetDecoder decoder = charset.newDecoder();
        InputStreamReader reader2 = new InputStreamReader(inputStream, decoder);
        return new BufferedReader(reader2, 0, 2, null);
    }

    public final void createDirectories(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.parent();
        if (path2 == null) {
            throw (Throwable)new IOException("Cannot create directories for root path");
        }
        Path parent = path2;
        if (!fileSystem.exists(parent)) {
            this.createDirectories(parent);
        }
        fileSystem.createDirectories(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void createFile(@NotNull Path path) {
        Unit unit;
        Throwable thrown$iv$iv;
        block16: {
            void file$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path.parent();
            if (path2 == null) {
                throw (Throwable)new IOException("Cannot create file for root path");
            }
            Path parent = path2;
            if (!fileSystem.exists(parent)) {
                this.createDirectories(parent);
            }
            FileSystem fileSystem = Files.fileSystem;
            Path path3 = path;
            boolean mustCreate$iv = true;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink((Path)file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$createFile_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    @NotNull
    public final FileMetadata readAttributes(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return fileSystem.metadata(path);
    }

    @Nullable
    public final Long creationTime(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileMetadata attributes = this.readAttributes(path);
        Long l = attributes.getCreatedAtMillis();
        if (l == null) {
            l = attributes.getLastModifiedAtMillis();
        }
        return l;
    }

    public final boolean isDirectory(@NotNull Path path) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            bl = fileSystem.metadata(path).isDirectory();
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final long size(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Long l = fileSystem.metadata(path).getSize();
        if (l == null) {
            throw new IOException("File does not exist or size is not available");
        }
        return l;
    }

    public final void move(@NotNull Path source, @NotNull Path target, StandardCopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!fileSystem.exists(source)) {
            throw new IOException("Source file does not exist: " + source);
        }
        Path path = target.parent();
        if (path == null) {
            throw (Throwable)new IOException("Cannot move to root path");
        }
        Path targetParent = path;
        if (!fileSystem.exists(targetParent)) {
            this.createDirectories(targetParent);
        }
        if (ArraysKt.contains((Object[])options, (Object)StandardCopyOption.ATOMIC_MOVE)) {
            fileSystem.atomicMove(source, target);
        } else {
            fileSystem.copy(source, target);
            fileSystem.delete(source);
        }
    }

    public final void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!fileSystem.exists(path)) {
            throw new IOException("File does not exist: " + path);
        }
        fileSystem.delete(path);
    }

    @NotNull
    public final Sequence<Path> newDirectoryStream(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!fileSystem.exists(path)) {
            throw new IOException("File does not exist: " + path);
        }
        if (!fileSystem.metadata(path).isDirectory()) {
            throw new IOException("Path is not a directory: " + path);
        }
        return fileSystem.listRecursively(path);
    }
}

