/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/jdkport/FilterOutputStream;", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "out", "<init>", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;)V", "getOut", "()Lorg/gnit/lucenekmp/jdkport/OutputStream;", "setOut", "closed", "", "isClosed", "write", "", "b", "", "", "off", "len", "flush", "close", "core"})
public class FilterOutputStream
extends OutputStream {
    @Nullable
    private OutputStream out;
    private volatile boolean closed;

    public FilterOutputStream(@Nullable OutputStream out) {
        this.out = out;
    }

    @Nullable
    protected final OutputStream getOut() {
        return this.out;
    }

    protected final void setOut(@Nullable OutputStream outputStream) {
        this.out = outputStream;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.write(b);
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.INSTANCE.checkFromIndexSize(off, len, b.length);
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream outputStream = this.out;
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OutputStream outputStream;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Throwable flushException = null;
        try {
            this.flush();
            outputStream = this.out;
        }
        catch (Throwable e) {
            try {
                flushException = e;
                throw e;
            }
            catch (Throwable throwable) {
                if (flushException == null) {
                    OutputStream outputStream2 = this.out;
                    Intrinsics.checkNotNull((Object)outputStream2);
                    outputStream2.close();
                } else {
                    try {
                        OutputStream outputStream3 = this.out;
                        Intrinsics.checkNotNull((Object)outputStream3);
                        outputStream3.close();
                    }
                    catch (Throwable closeException) {
                        if (flushException != closeException) {
                            ExceptionsKt.addSuppressed((Throwable)closeException, (Throwable)flushException);
                        }
                        throw closeException;
                    }
                }
                throw throwable;
            }
        }
        Intrinsics.checkNotNull((Object)outputStream);
        outputStream.close();
    }
}

