/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import org.gnit.lucenekmp.jdkport.BufferExtKt;
import org.gnit.lucenekmp.jdkport.BufferOverflowException;
import org.gnit.lucenekmp.jdkport.BufferUnderflowException;
import org.gnit.lucenekmp.jdkport.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00013B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020 J\u0016\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00052\u0006\u0010%\u001a\u00020 J\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u001e\u0010$\u001a\u00020\u00002\u0006\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010*\u001a\u00020'J\u0006\u0010+\u001a\u00020\u0000J\u0011\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010.\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010/H\u0096\u0002J\b\u00100\u001a\u00020\u0005H\u0016J\b\u00101\u001a\u000202H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lorg/gnit/lucenekmp/jdkport/FloatBuffer;", "", "buffer", "Lokio/Buffer;", "capacity", "", "baseOffset", "", "<init>", "(Lokio/Buffer;IJ)V", "getCapacity", "()I", "position", "getPosition", "setPosition", "(I)V", "limit", "getLimit", "setLimit", "order", "Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "getOrder", "()Lorg/gnit/lucenekmp/jdkport/ByteOrder;", "setOrder", "(Lorg/gnit/lucenekmp/jdkport/ByteOrder;)V", "remaining", "hasRemaining", "", "clear", "flip", "duplicate", "get", "", "index", "newPosition", "newLimit", "put", "value", "dst", "", "offset", "length", "src", "slice", "compareTo", "other", "equals", "", "hashCode", "toString", "", "Companion", "core"})
public final class FloatBuffer
implements Comparable<FloatBuffer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Buffer buffer;
    private final int capacity;
    private final long baseOffset;
    private int position;
    private int limit;
    @NotNull
    private ByteOrder order;
    private static final int BYTES_PER_FLOAT = 4;

    public FloatBuffer(@NotNull Buffer buffer, int capacity, long baseOffset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.capacity = capacity;
        this.baseOffset = baseOffset;
        this.limit = this.capacity;
        this.order = ByteOrder.Companion.nativeOrder();
    }

    public /* synthetic */ FloatBuffer(Buffer buffer, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = 0L;
        }
        this(buffer, n, l);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    @NotNull
    public final ByteOrder getOrder() {
        return this.order;
    }

    public final void setOrder(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"<set-?>");
        this.order = byteOrder;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    @NotNull
    public final FloatBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    @NotNull
    public final FloatBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    @NotNull
    public final FloatBuffer duplicate() {
        FloatBuffer dup = new FloatBuffer(this.buffer, this.capacity, this.baseOffset);
        dup.position = this.position;
        dup.limit = this.limit;
        dup.order = this.order;
        return dup;
    }

    public final float get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException("position=" + this.position + ", limit=" + this.limit);
        }
        float result = this.get(this.position);
        int n = this.position;
        this.position = n + 1;
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final float get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("index=" + index + ", limit=" + this.limit);
        }
        long byteOffset = this.baseOffset + (long)index * (long)4;
        int bits = 0;
        try {
            ByteOrder byteOrder = this.order;
            if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
                bits = (this.buffer.getByte(byteOffset) & 0xFF) << 24 | (this.buffer.getByte(byteOffset + 1L) & 0xFF) << 16 | (this.buffer.getByte(byteOffset + (long)2) & 0xFF) << 8 | this.buffer.getByte(byteOffset + (long)3) & 0xFF;
                return Float.intBitsToFloat(bits);
            }
            if (!Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) return Float.intBitsToFloat(bits);
            bits = this.buffer.getByte(byteOffset) & 0xFF | (this.buffer.getByte(byteOffset + 1L) & 0xFF) << 8 | (this.buffer.getByte(byteOffset + (long)2) & 0xFF) << 16 | (this.buffer.getByte(byteOffset + (long)3) & 0xFF) << 24;
            return Float.intBitsToFloat(bits);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Calculated byteOffset " + byteOffset + " or subsequent bytes out of bounds for underlying buffer. index=" + index + ", limit=" + this.limit + ", capacity=" + this.capacity + ", baseOffset=" + this.baseOffset + ", buffer.size=" + this.buffer.size());
        }
        catch (EOFException e) {
            throw new BufferUnderflowException("Read attempt failed due to EOF at byteOffset " + byteOffset + ". index=" + index + ", limit=" + this.limit + ", capacity=" + this.capacity + ", baseOffset=" + this.baseOffset + ", buffer.size=" + this.buffer.size());
        }
    }

    @NotNull
    public final FloatBuffer position(int newPosition) {
        this.position = newPosition;
        return this;
    }

    @NotNull
    public final FloatBuffer limit(int newLimit) {
        this.limit = newLimit;
        return this;
    }

    @NotNull
    public final FloatBuffer put(float value) {
        if (this.position >= this.limit) {
            throw new BufferOverflowException("position=" + this.position + ", limit=" + this.limit);
        }
        this.put(this.position, value);
        int n = this.position;
        this.position = n + 1;
        return this;
    }

    @NotNull
    public final FloatBuffer put(int index, float value) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("index=" + index + ", limit=" + this.limit);
        }
        long byteOffset = this.baseOffset + (long)index * (long)4;
        int bits = Float.floatToIntBits(value);
        try {
            ByteOrder byteOrder = this.order;
            if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
                BufferExtKt.setByteAt(this.buffer, byteOffset, (byte)(bits >> 24));
                BufferExtKt.setByteAt(this.buffer, byteOffset + 1L, (byte)(bits >> 16));
                BufferExtKt.setByteAt(this.buffer, byteOffset + (long)2, (byte)(bits >> 8));
                BufferExtKt.setByteAt(this.buffer, byteOffset + (long)3, (byte)bits);
            } else if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) {
                BufferExtKt.setByteAt(this.buffer, byteOffset, (byte)bits);
                BufferExtKt.setByteAt(this.buffer, byteOffset + 1L, (byte)(bits >> 8));
                BufferExtKt.setByteAt(this.buffer, byteOffset + (long)2, (byte)(bits >> 16));
                BufferExtKt.setByteAt(this.buffer, byteOffset + (long)3, (byte)(bits >> 24));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Calculated byteOffset " + byteOffset + " or subsequent bytes out of bounds for underlying buffer. index=" + index + ", limit=" + this.limit + ", capacity=" + this.capacity + ", baseOffset=" + this.baseOffset + ", buffer.size=" + this.buffer.size());
        }
        return this;
    }

    @NotNull
    public final FloatBuffer get(@NotNull float[] dst, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (offset < 0 || length < 0 || offset + length > dst.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", length=" + length + ", dst.size=" + dst.length);
        }
        if (length > this.remaining()) {
            throw new BufferUnderflowException("length=" + length + ", remaining=" + this.remaining());
        }
        int startPos = this.position;
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = this.get(startPos + i);
        }
        this.position = startPos + length;
        return this;
    }

    @NotNull
    public final FloatBuffer get(@NotNull float[] dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        return this.get(dst, 0, dst.length);
    }

    @NotNull
    public final FloatBuffer put(@NotNull float[] src, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (offset < 0 || length < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", length=" + length + ", src.size=" + src.length);
        }
        if (length > this.remaining()) {
            throw new BufferOverflowException("length=" + length + ", remaining=" + this.remaining());
        }
        int startPos = this.position;
        for (int i = 0; i < length; ++i) {
            this.put(startPos + i, src[offset + i]);
        }
        this.position = startPos + length;
        return this;
    }

    @NotNull
    public final FloatBuffer put(@NotNull float[] src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.put(src, 0, src.length);
    }

    @NotNull
    public final FloatBuffer slice() {
        int rem = this.remaining();
        if (rem < 0) {
            throw new IllegalStateException("position > limit");
        }
        long newBaseOffset = this.baseOffset + (long)this.position * (long)4;
        FloatBuffer slicedBuffer = new FloatBuffer(this.buffer, rem, newBaseOffset);
        slicedBuffer.position = 0;
        slicedBuffer.limit = rem;
        slicedBuffer.order = this.order;
        return slicedBuffer;
    }

    @Override
    public int compareTo(@NotNull FloatBuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int n = Math.min(this.remaining(), other.remaining());
        int thisPos = this.position;
        int otherPos = other.position;
        for (int i = 0; i < n; ++i) {
            int cmp = Float.compare(this.get(thisPos + i), other.get(otherPos + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.remaining() - other.remaining();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FloatBuffer)) {
            return false;
        }
        if (this.remaining() != ((FloatBuffer)other).remaining()) {
            return false;
        }
        int thisPos = this.position;
        int otherPos = ((FloatBuffer)other).position;
        int n = this.remaining();
        for (int i = 0; i < n; ++i) {
            if (Float.floatToIntBits(this.get(thisPos + i)) == Float.floatToIntBits(((FloatBuffer)other).get(otherPos + i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        int pos = this.position;
        int n = this.remaining();
        for (int i = 0; i < n; ++i) {
            result = 31 * result + Float.floatToIntBits(this.get(pos + i));
        }
        return result;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(pos=" + this.position + " lim=" + this.limit + " cap=" + this.capacity + " order=" + this.order + " baseOffset=" + this.baseOffset + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/jdkport/FloatBuffer$Companion;", "", "<init>", "()V", "BYTES_PER_FLOAT", "", "allocate", "Lorg/gnit/lucenekmp/jdkport/FloatBuffer;", "capacity", "wrap", "array", "", "core"})
    @SourceDebugExtension(value={"SMAP\nFloatBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatBuffer.kt\norg/gnit/lucenekmp/jdkport/FloatBuffer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,456:1\n1#2:457\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatBuffer allocate(int capacity) {
            Buffer buffer;
            if (!(capacity >= 0)) {
                boolean $i$a$-require-FloatBuffer$Companion$allocate$22 = false;
                String $i$a$-require-FloatBuffer$Companion$allocate$22 = "Capacity must be non-negative";
                throw new IllegalArgumentException($i$a$-require-FloatBuffer$Companion$allocate$22.toString());
            }
            byte[] byteArray = new byte[capacity * 4];
            Buffer $this$allocate_u24lambda_u241 = buffer = new Buffer();
            boolean bl = false;
            $this$allocate_u24lambda_u241.write(byteArray, 0, byteArray.length);
            Buffer finalBuf = buffer;
            return new FloatBuffer(finalBuf, capacity, 0L, 4, null).clear();
        }

        @NotNull
        public final FloatBuffer wrap(@NotNull float[] array) {
            FloatBuffer floatBuffer;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int byteSize = array.length * 4;
            Buffer buf = new Buffer();
            ByteOrder tempOrder = ByteOrder.Companion.nativeOrder();
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                float value = array[i];
                int bits = Float.floatToIntBits(value);
                ByteOrder byteOrder = tempOrder;
                if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getBIG_ENDIAN())) {
                    buf.writeByte(bits >> 24);
                    buf.writeByte(bits >> 16);
                    buf.writeByte(bits >> 8);
                    buf.writeByte(bits);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.Companion.getLITTLE_ENDIAN())) continue;
                buf.writeByte(bits);
                buf.writeByte(bits >> 8);
                buf.writeByte(bits >> 16);
                buf.writeByte(bits >> 24);
            }
            FloatBuffer $this$wrap_u24lambda_u242 = floatBuffer = new FloatBuffer(buf, array.length, 0L, 4, null).clear();
            boolean bl = false;
            $this$wrap_u24lambda_u242.setOrder(ByteOrder.Companion.nativeOrder());
            return floatBuffer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

