/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CharsetEncoder;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.JavaLangAccess;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.jdkport.Surrogate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/jdkport/ISO_8859_1;", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "()V", "contains", "", "cs", "newDecoder", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "newEncoder", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "Decoder", "Encoder", "core"})
public final class ISO_8859_1
extends Charset {
    public ISO_8859_1() {
        super("ISO-8859-1", StandardCharsets.Companion.aliases_ISO_8859_1());
    }

    @Override
    public boolean contains(@NotNull Charset cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return cs == this;
    }

    @Override
    @NotNull
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    @NotNull
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/jdkport/ISO_8859_1$Decoder;", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;)V", "decodeArrayLoop", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "dst", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "decodeBufferLoop", "decodeLoop", "Companion", "core"})
    public static final class Decoder
    extends CharsetDecoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final JavaLangAccess JLA = JavaLangAccess.INSTANCE;

        public Decoder(@NotNull Charset cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            super(cs, 1.0f, 1.0f);
        }

        @NotNull
        public final CoderResult decodeArrayLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            byte[] sa = src.array();
            int soff = src.arrayOffset();
            int sp = soff + src.getPosition();
            int sl = soff + src.getLimit();
            char[] da = dst.array();
            int doff = dst.arrayOffset();
            int dp = doff + dst.position();
            int dl = doff + dst.getLimit();
            int decodeLen = Math.min(sl - sp, dl - dp);
            JLA.inflateBytesToChars(sa, sp, da, dp, decodeLen);
            src.position((sp += decodeLen) - soff);
            dst.setPosition((dp += decodeLen) - doff);
            if (sl - sp > dl - dp) {
                return CoderResult.Companion.getOVERFLOW();
            }
            return CoderResult.Companion.getUNDERFLOW();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CoderResult decodeBufferLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            int mark = src.getPosition();
            try {
                while (src.hasRemaining()) {
                    byte b = src.get();
                    if (!dst.hasRemaining()) {
                        CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                        return coderResult;
                    }
                    dst.put((char)(b & 0xFF));
                    ++mark;
                }
                CoderResult coderResult = CoderResult.Companion.getUNDERFLOW();
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        @NotNull
        protected CoderResult decodeLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/jdkport/ISO_8859_1$Decoder$Companion;", "", "<init>", "()V", "JLA", "Lorg/gnit/lucenekmp/jdkport/JavaLangAccess;", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/jdkport/ISO_8859_1$Encoder;", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;)V", "canEncode", "", "c", "", "isLegalReplacement", "repl", "", "sgp", "Lorg/gnit/lucenekmp/jdkport/Surrogate$Parser;", "encodeArrayLoop", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "dst", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "encodeBufferLoop", "encodeLoop", "Companion", "core"})
    public static final class Encoder
    extends CharsetEncoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Surrogate.Parser sgp;

        public Encoder(@NotNull Charset cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            super(cs, 1.0f, 1.0f, null, 8, null);
            this.sgp = new Surrogate.Parser();
        }

        @Override
        public boolean canEncode(char c) {
            return Intrinsics.compare((int)c, (int)255) <= 0;
        }

        @Override
        public boolean isLegalReplacement(@NotNull byte[] repl) {
            Intrinsics.checkNotNullParameter((Object)repl, (String)"repl");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CoderResult encodeArrayLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
            int dl;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            char[] sa = src.array();
            int soff = src.arrayOffset();
            int sp = soff + src.position();
            int sl = soff + src.getLimit();
            if (!(sp <= sl)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            sp = sp <= sl ? sp : sl;
            byte[] da = dst.array();
            int doff = dst.arrayOffset();
            int dp = doff + dst.getPosition();
            if (!(dp <= (dl = doff + dst.getLimit()))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            dp = dp <= dl ? dp : dl;
            int dlen = dl - dp;
            int slen = sl - sp;
            int len = dlen < slen ? dlen : slen;
            try {
                int ret = Encoder.Companion.encodeISOArray(sa, sp, da, dp, len);
                sp += ret;
                dp += ret;
                if (ret != len) {
                    if (this.sgp.parse(sa[sp], sa, sp, sl) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        Intrinsics.checkNotNull((Object)coderResult);
                        CoderResult coderResult2 = coderResult;
                        return coderResult2;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (len < slen) {
                    CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.Companion.getUNDERFLOW();
                return coderResult;
            }
            finally {
                src.setPosition(sp - soff);
                dst.position(dp - doff);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CoderResult encodeBufferLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    if (Intrinsics.compare((int)c, (int)255) <= 0) {
                        if (!dst.hasRemaining()) {
                            CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                            return coderResult;
                        }
                        dst.put((byte)c);
                        ++mark;
                        continue;
                    }
                    if (this.sgp.parse(c, src) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.Companion.getUNDERFLOW();
                return coderResult;
            }
            finally {
                src.setPosition(mark);
            }
        }

        @Override
        @NotNull
        protected CoderResult encodeLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J0\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/jdkport/ISO_8859_1$Encoder$Companion;", "", "<init>", "()V", "encodeISOArray", "", "sa", "", "sp", "da", "", "dp", "len", "implEncodeISOArray", "encodeISOArrayCheck", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final int encodeISOArray(char[] sa, int sp, byte[] da, int dp, int len) {
                if (len <= 0) {
                    return 0;
                }
                this.encodeISOArrayCheck(sa, sp, da, dp, len);
                return this.implEncodeISOArray(sa, sp, da, dp, len);
            }

            private final int implEncodeISOArray(char[] sa, int sp, byte[] da, int dp, int len) {
                char c;
                int i;
                int sp2 = sp;
                int dp2 = dp;
                for (i = 0; i < len && Intrinsics.compare((int)(c = sa[sp2++]), (int)255) <= 0; ++i) {
                    da[dp2++] = (byte)c;
                }
                return i;
            }

            private final void encodeISOArrayCheck(char[] sa, int sp, byte[] da, int dp, int len) {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

