/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.InetAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001d\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0002\u0010\bB\u001b\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/jdkport/Inet4Address;", "Lorg/gnit/lucenekmp/jdkport/InetAddress;", "<init>", "()V", "hostName", "", "addr", "", "(Ljava/lang/String;[B)V", "address", "", "(Ljava/lang/String;I)V", "getHostAddress", "getAddress", "hashCode", "equals", "", "obj", "", "Companion", "core"})
public final class Inet4Address
extends InetAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int INADDRSZ = 4;

    public Inet4Address() {
        this.holder().setHostName(null);
        this.holder().setAddress(0);
        this.holder().setFamily(1);
    }

    public Inet4Address(@Nullable String hostName, @Nullable byte[] addr) {
        this.holder().setHostName(hostName);
        this.holder().setFamily(1);
        if (addr != null) {
            if (addr.length == 4) {
                int address = addr[3] & 0xFF;
                address |= addr[2] << 8 & 0xFF00;
                address |= addr[1] << 16 & 0xFF0000;
                this.holder().setAddress(address |= addr[0] << 24 & 0xFF000000);
            } else {
                throw new IllegalArgumentException("Invalid address length: " + addr.length);
            }
        }
        this.holder().setOriginalHostName(hostName);
    }

    public Inet4Address(@Nullable String hostName, int address) {
        this.holder().setHostName(hostName);
        this.holder().setFamily(1);
        this.holder().setAddress(address);
        this.holder().setOriginalHostName(hostName);
    }

    @Override
    @NotNull
    public String getHostAddress() {
        return Companion.numericToTextFormat(this.getAddress());
    }

    @Override
    @NotNull
    public byte[] getAddress() {
        int address = this.holder().getAddress();
        byte[] addr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
        return addr;
    }

    @Override
    public int hashCode() {
        return this.holder().getAddress();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj instanceof Inet4Address && ((Inet4Address)obj).holder().getAddress() == this.holder().getAddress();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/jdkport/Inet4Address$Companion;", "", "<init>", "()V", "INADDRSZ", "", "numericToTextFormat", "", "src", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String numericToTextFormat(@NotNull byte[] src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

