/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.Ported;
import org.gnit.lucenekmp.jdkport.System;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.io.InputStream")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u001c2\u00060\u0001j\u0002`\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/jdkport/InputStream;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "read", "", "b", "", "off", "len", "readAllBytes", "readNBytes", "skip", "", "n", "skipNBytes", "", "available", "close", "mark", "readlimit", "reset", "markSupported", "", "transferTo", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStream.kt\norg/gnit/lucenekmp/jdkport/InputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,835:1\n1#2:836\n*E\n"})
public abstract class InputStream
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public abstract int read() throws IOException;

    public int read(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int i;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.INSTANCE.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    @Nullable
    public byte[] readAllBytes() throws IOException {
        return this.readNBytes(Integer.MAX_VALUE);
    }

    @Nullable
    public byte[] readNBytes(int len) throws IOException {
        if (!(len >= 0)) {
            boolean $i$a$-require-InputStream$readNBytes$22 = false;
            String $i$a$-require-InputStream$readNBytes$22 = "len < 0";
            throw new IllegalArgumentException($i$a$-require-InputStream$readNBytes$22.toString());
        }
        List bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        int n = 0;
        do {
            byte[] buf = new byte[java.lang.Math.min(remaining, 16384)];
            int nread = 0;
            while (true) {
                int n2;
                int it = n2 = this.read(buf, nread, java.lang.Math.min(buf.length - nread, remaining));
                boolean bl = false;
                n = it;
                if (n2 <= 0) break;
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new Error("Required array size too large");
            }
            if (nread < buf.length) {
                buf = Arrays.INSTANCE.copyOfRange(buf, 0, nread);
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList();
                ((ArrayList)bufs).add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            byte[] byArray;
            if (result == null) {
                return new byte[0];
            }
            if (result.length == total) {
                byArray = result;
            } else {
                byte[] byArray2 = java.util.Arrays.copyOf(result, total);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            }
            return byArray;
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = java.lang.Math.min(b.length, remaining);
            System.INSTANCE.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public int readNBytes(@NotNull byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.INSTANCE.checkFromIndexSize(off, len, b.length);
        for (n = 0; n < len && (count = this.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }

    public long skip(long n) throws IOException {
        long remaining;
        int nr = 0;
        if (n <= 0L) {
            return 0L;
        }
        int size2 = (int)java.lang.Math.min(2048L, remaining);
        byte[] skipBuffer = new byte[size2];
        for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)java.lang.Math.min((long)size2, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    public void skipNBytes(long n) throws IOException {
        long n2 = n;
        while (n2 > 0L) {
            long ns = this.skip(n2);
            if (ns > 0L && ns <= n2) {
                n2 -= ns;
                continue;
            }
            if (ns == 0L) {
                if (this.read() == -1) {
                    throw new EOFException();
                }
                long l = n2;
                n2 = l + -1L;
                continue;
            }
            throw new IOException("Unable to skip exactly");
        }
    }

    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() {
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public long transferTo(@NotNull OutputStream out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        long transferred = 0L;
        byte[] buffer = new byte[16384];
        int read = 0;
        while (true) {
            int n;
            int it = n = this.read(buffer, 0, 16384);
            boolean bl = false;
            read = it;
            if (n < 0) break;
            out.write(buffer, 0, read);
            if (transferred >= Long.MAX_VALUE) continue;
            try {
                transferred = Math.INSTANCE.addExact(transferred, (long)read);
            }
            catch (ArithmeticException ignore) {
                transferred = Long.MAX_VALUE;
            }
        }
        return transferred;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/jdkport/InputStream$Companion;", "", "<init>", "()V", "MAX_SKIP_BUFFER_SIZE", "", "DEFAULT_BUFFER_SIZE", "nullInputStream", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "MAX_BUFFER_SIZE", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InputStream nullInputStream() {
            return new InputStream(){
                private volatile boolean closed;

                public final void ensureOpen() throws IOException {
                    if (this.closed) {
                        throw new IOException("Stream closed");
                    }
                }

                public int available() throws IOException {
                    this.ensureOpen();
                    return 0;
                }

                public int read() throws IOException {
                    this.ensureOpen();
                    return -1;
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    Objects.INSTANCE.checkFromIndexSize(off, len, b.length);
                    if (len == 0) {
                        return 0;
                    }
                    this.ensureOpen();
                    return -1;
                }

                public byte[] readAllBytes() throws IOException {
                    this.ensureOpen();
                    return new byte[0];
                }

                public int readNBytes(byte[] b, int off, int len) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    Objects.INSTANCE.checkFromIndexSize(off, len, b.length);
                    this.ensureOpen();
                    return 0;
                }

                public byte[] readNBytes(int len) throws IOException {
                    if (!(len >= 0)) {
                        boolean bl = false;
                        String string = "len < 0";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.ensureOpen();
                    return new byte[0];
                }

                public long skip(long n) throws IOException {
                    this.ensureOpen();
                    return 0L;
                }

                public void skipNBytes(long n) throws IOException {
                    this.ensureOpen();
                    if (n > 0L) {
                        throw new EOFException();
                    }
                }

                public long transferTo(OutputStream out) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                    this.ensureOpen();
                    return 0L;
                }

                public void close() throws IOException {
                    this.closed = true;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

