/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StreamDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\rH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/jdkport/InputStreamReader;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "in", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/InputStream;)V", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "(Lorg/gnit/lucenekmp/jdkport/InputStream;Lorg/gnit/lucenekmp/jdkport/Charset;)V", "dec", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "(Lorg/gnit/lucenekmp/jdkport/InputStream;Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;)V", "debug", "", "message", "Lkotlin/Function0;", "", "sd", "Lorg/gnit/lucenekmp/jdkport/StreamDecoder;", "encoding", "getEncoding", "()Ljava/lang/String;", "read", "", "target", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "cbuf", "", "off", "len", "ready", "", "close", "core"})
public class InputStreamReader
extends Reader {
    @NotNull
    private final StreamDecoder sd;

    private final void debug(Function0<String> message) {
        System.out.println((Object)("[DEBUG] " + message.invoke()));
    }

    public InputStreamReader(@NotNull InputStream in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Charset cs = Charset.Companion.defaultCharset();
        this.sd = StreamDecoder.Companion.forInputStreamReader(in, (Object)this, cs);
    }

    public InputStreamReader(@NotNull InputStream in, @NotNull Charset cs) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.sd = StreamDecoder.Companion.forInputStreamReader(in, (Object)this, cs);
    }

    public InputStreamReader(@NotNull InputStream in, @NotNull CharsetDecoder dec) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)dec, (String)"dec");
        this.sd = StreamDecoder.Companion.forInputStreamReader(in, (Object)this, dec);
    }

    @Nullable
    public final String getEncoding() {
        return this.sd.getEncoding();
    }

    @Override
    public int read(@NotNull CharBuffer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.sd.read(target);
    }

    @Override
    public int read() {
        this.debug((Function0<String>)((Function0)InputStreamReader::read$lambda$0));
        int result = this.sd.read();
        this.debug((Function0<String>)((Function0)() -> InputStreamReader.read$lambda$1(result)));
        return result;
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        return this.sd.read(cbuf, off, len);
    }

    @Override
    public boolean ready() throws IOException {
        boolean bl;
        try {
            bl = this.sd.ready();
        }
        catch (IOException e) {
            if (!Intrinsics.areEqual((Object)e.getMessage(), (Object)"Stream closed")) {
                throw e;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void close() {
        this.sd.close();
    }

    private static final String read$lambda$0() {
        return "InputStreamReader.read() called";
    }

    private static final String read$lambda$1(int $result) {
        return "InputStreamReader.read() returned " + $result;
    }
}

