/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0011J\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\b\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/jdkport/KIOSourceBufferedReader;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "source", "Lokio/BufferedSource;", "bufferSize", "", "<init>", "(Lokio/BufferedSource;I)V", "buf", "", "pos", "end", "markPos", "markLimit", "closed", "", "ensureOpen", "", "read", "cbuf", "off", "len", "readLine", "", "ready", "mark", "readAheadLimit", "reset", "markSupported", "skip", "", "n", "close", "fillBuffer", "Companion", "core"})
public final class KIOSourceBufferedReader
extends Reader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    private final int bufferSize;
    @NotNull
    private char[] buf;
    private int pos;
    private int end;
    private int markPos;
    private int markLimit;
    private boolean closed;
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public KIOSourceBufferedReader(@NotNull BufferedSource source, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.bufferSize = bufferSize;
        if (this.bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new char[this.bufferSize];
        this.markPos = -1;
    }

    public /* synthetic */ KIOSourceBufferedReader(BufferedSource bufferedSource, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        this(bufferedSource, n);
    }

    private final void ensureOpen() {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read() {
        this.ensureOpen();
        if (this.pos >= this.end && this.fillBuffer() == -1) {
            return -1;
        }
        int n = this.pos;
        this.pos = n + 1;
        char ch = this.buf[n];
        return ch;
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.ensureOpen();
        if (off < 0 || len < 0 || len > cbuf.length - off) {
            throw new IndexOutOfBoundsException("Offset and length out of bounds");
        }
        if (len == 0) {
            return 0;
        }
        int charsRead = 0;
        while (charsRead < len) {
            if (this.pos >= this.end && this.fillBuffer() == -1) {
                return charsRead > 0 ? charsRead : -1;
            }
            int available = this.end - this.pos;
            int toCopy = Math.min(len - charsRead, available);
            ArraysKt.copyInto((char[])this.buf, (char[])cbuf, (int)(off + charsRead), (int)this.pos, (int)(this.pos + toCopy));
            this.pos += toCopy;
            if ((charsRead += toCopy) < len) continue;
            break;
        }
        return charsRead;
    }

    @Nullable
    public final String readLine() {
        this.ensureOpen();
        StringBuilder result = null;
        while (this.pos < this.end || this.fillBuffer() != -1) {
            int n = this.end;
            for (int i = this.pos; i < n; ++i) {
                char c = this.buf[i];
                switch (c) {
                    case '\n': 
                    case '\r': {
                        String line = StringsKt.concatToString((char[])this.buf, (int)this.pos, (int)(this.pos + (i - this.pos)));
                        this.pos = i + 1;
                        if (c == '\r' && (this.pos < this.end || this.fillBuffer() != -1) && this.pos < this.end && this.buf[this.pos] == '\n') {
                            int n2 = this.pos;
                            this.pos = n2 + 1;
                        }
                        if (result != null) {
                            result.append(line);
                            return result.toString();
                        }
                        return line;
                    }
                }
            }
            String chunk = StringsKt.concatToString((char[])this.buf, (int)this.pos, (int)(this.pos + (this.end - this.pos)));
            if (result == null) {
                result = new StringBuilder(chunk);
            } else {
                result.append(chunk);
            }
            this.pos = this.end;
        }
        return result != null && ((CharSequence)result).length() > 0 ? result.toString() : null;
    }

    @Override
    public boolean ready() {
        this.ensureOpen();
        if (this.pos < this.end) {
            return true;
        }
        return !this.source.exhausted();
    }

    public final void mark(int readAheadLimit) {
        this.ensureOpen();
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markLimit = readAheadLimit;
        this.markPos = this.pos;
        if (readAheadLimit > this.buf.length) {
            char[] newBuf = new char[readAheadLimit];
            int unreadCount = this.end - this.pos;
            ArraysKt.copyInto((char[])this.buf, (char[])newBuf, (int)0, (int)this.pos, (int)this.end);
            this.markPos = 0;
            this.pos = 0;
            this.end = unreadCount;
            this.buf = newBuf;
        }
    }

    public final void reset() {
        this.ensureOpen();
        if (this.markPos < 0) {
            throw new IOException("Stream not marked");
        }
        this.pos = this.markPos;
    }

    public final boolean markSupported() {
        return true;
    }

    public final long skip(long n) {
        this.ensureOpen();
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        long remaining = n;
        long skipped = 0L;
        if (remaining <= 0L) {
            return 0L;
        }
        if (this.pos < this.end) {
            long available = this.end - this.pos;
            if (available >= remaining) {
                this.pos += (int)remaining;
                return remaining;
            }
            this.pos = this.end;
            remaining -= available;
            skipped += available;
        }
        char[] buffer = new char[8192];
        while (remaining > 0L && this.fillBuffer() != -1) {
            int toDiscard = Math.min((int)remaining, this.end - this.pos);
            this.pos += toDiscard;
            remaining -= (long)toDiscard;
            skipped += (long)toDiscard;
        }
        return skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.source.close();
            }
            finally {
                this.closed = true;
            }
        }
    }

    private final int fillBuffer() {
        if (this.markPos < 0) {
            this.pos = 0;
            this.end = 0;
        } else if (this.pos - this.markPos >= this.markLimit) {
            this.markPos = -1;
            this.markLimit = 0;
            this.pos = 0;
            this.end = 0;
        } else if (this.markPos > 0) {
            int preserved = this.end - this.markPos;
            ArraysKt.copyInto((char[])this.buf, (char[])this.buf, (int)0, (int)this.markPos, (int)this.end);
            this.pos -= this.markPos;
            this.end = preserved;
            this.markPos = 0;
        }
        int bytesCapacity = this.buf.length - this.end;
        if (bytesCapacity <= 0) {
            return 0;
        }
        byte[] byteBuf = new byte[bytesCapacity];
        int bytesRead = this.source.read(byteBuf, 0, bytesCapacity);
        if (bytesRead == -1) {
            return -1;
        }
        String chunk = StringsKt.decodeToString$default((byte[])byteBuf, (int)0, (int)bytesRead, (boolean)false, (int)4, null);
        char[] cArray = chunk.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        ArraysKt.copyInto$default((char[])cArray, (char[])this.buf, (int)this.end, (int)0, (int)0, (int)12, null);
        int charsAdded = chunk.length();
        this.end += charsAdded;
        return charsAdded;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/jdkport/KIOSourceBufferedReader$Companion;", "", "<init>", "()V", "DEFAULT_BUFFER_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

