/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.ranges.RangesKt;
import org.gnit.lucenekmp.jdkport.DoubleConsts;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005J\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/jdkport/Math;", "", "<init>", "()V", "E", "", "PI", "TAU", "getTAU", "()D", "DEGREES_TO_RADIANS", "RADIANS_TO_DEGREES", "toIntExact", "", "value", "", "addExact", "x", "y", "multiplyExact", "round", "a", "", "floorMod", "nextUp", "f", "nextDown", "powerOfTwoD", "n", "scalb", "d", "scaleFactorInput", "getExponent", "toRadians", "angdeg", "toDegrees", "angrad", "ceilDiv", "core"})
public final class Math {
    @NotNull
    public static final Math INSTANCE = new Math();
    public static final double E = java.lang.Math.E;
    public static final double PI = java.lang.Math.PI;
    private static final double TAU = java.lang.Math.PI * 2;
    private static final double DEGREES_TO_RADIANS = java.lang.Math.PI / 180;
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;

    private Math() {
    }

    public final double getTAU() {
        return TAU;
    }

    public final int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public final long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public final int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    public final int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)r;
    }

    public final int round(float a) {
        if (Float.isNaN(a)) {
            return 0;
        }
        if (Float.isInfinite(a)) {
            return a > 0.0f ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        return (int)java.lang.Math.rint(a);
    }

    public final long floorMod(long x, long y) {
        long r = x % y;
        if ((x ^ y) < 0L && r != 0L) {
            return r + y;
        }
        return r;
    }

    public final float nextUp(float f) {
        if (f < Float.POSITIVE_INFINITY) {
            int transducer;
            return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, transducer + ((transducer = FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, f + 0.0f)) >= 0 ? 1 : -1));
        }
        return f;
    }

    public final float nextDown(float f) {
        if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, f) + (f > 0.0f ? -1 : 1));
    }

    private final double powerOfTwoD(int n) {
        int exp = n + DoubleConsts.INSTANCE.getEXP_BIAS();
        return exp <= 0 ? 0.0 : (exp >= 2047 ? Double.POSITIVE_INFINITY : Double.longBitsToDouble((long)exp << 52));
    }

    public final double scalb(double d, int scaleFactorInput) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        int MAX_SCALE = DoubleExtKt.getMAX_EXPONENT(DoubleCompanionObject.INSTANCE) - DoubleExtKt.getMIN_EXPONENT(DoubleCompanionObject.INSTANCE) + DoubleConsts.INSTANCE.getSIGNIFICAND_WIDTH() + 1;
        int scaleFactor = RangesKt.coerceIn((int)scaleFactorInput, (int)(-MAX_SCALE), (int)MAX_SCALE);
        Pair pair = scaleFactor < 0 ? TuplesKt.to((Object)-512, (Object)this.powerOfTwoD(-512)) : TuplesKt.to((Object)512, (Object)this.powerOfTwoD(512));
        int scaleInc = ((Number)pair.component1()).intValue();
        double expDelta = ((Number)pair.component2()).doubleValue();
        int expAdjust = scaleFactor % 512;
        double result = d * this.powerOfTwoD(expAdjust);
        scaleFactor -= expAdjust;
        while (scaleFactor != 0) {
            result *= expDelta;
            scaleFactor -= scaleInc;
        }
        return result;
    }

    public final int getExponent(double d) {
        return (int)(((DoubleExtKt.doubleToRawLongBits(DoubleCompanionObject.INSTANCE, d) & DoubleConsts.INSTANCE.getEXP_BIT_MASK()) >> DoubleConsts.INSTANCE.getSIGNIFICAND_WIDTH() - 1) - (long)DoubleConsts.INSTANCE.getEXP_BIAS());
    }

    public final double toRadians(double angdeg) {
        return angdeg * (java.lang.Math.PI / 180);
    }

    public final double toDegrees(double angrad) {
        return angrad * 57.29577951308232;
    }

    public final int ceilDiv(int x, int y) {
        int q = x / y;
        if ((x ^ y) >= 0 && q * y != x) {
            return q + 1;
        }
        return q;
    }
}

