/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Objects;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u001a\u0010\n\u001a\u00060\u0002j\u0002`\u0003*\u00060\u0002j\u0002`\u00032\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0013\u001a\n\u0010\u0017\u001a\u00020\u0016*\u00020\u0013\u00a8\u0006\u0018"}, d2={"getChars", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "srcBegin", "", "srcEnd", "dst", "", "dstBegin", "appendCodePoint", "codePoint", "codePointAt", "", "index", "checkIndex", "length", "toCodePoint", "high", "", "low", "isHighSurrogate", "", "isLowSurrogate", "core"})
@SourceDebugExtension(value={"SMAP\nObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Objects.kt\norg/gnit/lucenekmp/jdkport/ObjectsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class ObjectsKt {
    public static final void getChars(@NotNull StringBuilder $this$getChars, int srcBegin, int srcEnd, @NotNull char[] dst, int dstBegin) {
        Intrinsics.checkNotNullParameter((Object)$this$getChars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Objects.INSTANCE.checkFromToIndex(srcBegin, srcEnd, $this$getChars.length());
        int n = srcEnd - srcBegin;
        Objects.INSTANCE.checkFromToIndex(dstBegin, dstBegin + n, dst.length);
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[dstBegin + i - srcBegin] = $this$getChars.charAt(i);
        }
    }

    @NotNull
    public static final StringBuilder appendCodePoint(@NotNull StringBuilder $this$appendCodePoint, int codePoint) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$appendCodePoint, (String)"<this>");
        if (!(0 <= codePoint ? codePoint < 0x110000 : false)) {
            boolean $i$a$-require-ObjectsKt$appendCodePoint$22 = false;
            String $i$a$-require-ObjectsKt$appendCodePoint$22 = "Invalid Unicode code point: " + codePoint;
            throw new IllegalArgumentException($i$a$-require-ObjectsKt$appendCodePoint$22.toString());
        }
        if (codePoint < 65536) {
            StringBuilder stringBuilder2 = $this$appendCodePoint.append((char)codePoint);
            Intrinsics.checkNotNull((Object)stringBuilder2);
            stringBuilder = stringBuilder2;
        } else {
            int cpPrime = codePoint - 65536;
            char high = (char)((cpPrime >> 10) + 55296);
            char low = (char)((cpPrime & 0x3FF) + 56320);
            $this$appendCodePoint.append(high);
            $this$appendCodePoint.append(low);
            stringBuilder = $this$appendCodePoint;
        }
        return stringBuilder;
    }

    public static final int codePointAt(@NotNull CharSequence $this$codePointAt, int index) {
        char second;
        Intrinsics.checkNotNullParameter((Object)$this$codePointAt, (String)"<this>");
        ObjectsKt.checkIndex(index, $this$codePointAt.length());
        char first = $this$codePointAt.charAt(index);
        if (ObjectsKt.isHighSurrogate(first) && index + 1 < $this$codePointAt.length() && ObjectsKt.isLowSurrogate(second = $this$codePointAt.charAt(index + 1))) {
            return ObjectsKt.toCodePoint(first, second);
        }
        return first;
    }

    public static final void checkIndex(int index, int length) {
        if (!(0 <= index ? index < length : false)) {
            boolean bl = false;
            String string = "Index " + index + " out of bounds for length " + length;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final int toCodePoint(char high, char low) {
        return (high - 55296 << 10) + (low - 56320) + 65536;
    }

    public static final boolean isHighSurrogate(char $this$isHighSurrogate) {
        return '\ud800' <= $this$isHighSurrogate ? $this$isHighSurrogate < '\udc00' : false;
    }

    public static final boolean isLowSurrogate(char $this$isLowSurrogate) {
        return '\udc00' <= $this$isLowSurrogate ? $this$isLowSurrogate < '\ue000' : false;
    }
}

